/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TileSelectionBBoxChooser
extends JPanel
implements BBoxChooser {
    private static final Logger logger = Logger.getLogger(TileSelectionBBoxChooser.class.getName());
    private Bounds bbox;
    private TileBoundsMapView mapViewer;
    private TileGridInputPanel pnlTileGrid;
    private TileAddressInputPanel pnlTileAddress;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 0.5;
        gc.fill = 2;
        gc.anchor = 18;
        this.pnlTileGrid = new TileGridInputPanel();
        this.add((Component)this.pnlTileGrid, gc);
        gc.gridx = 1;
        this.pnlTileAddress = new TileAddressInputPanel();
        this.add((Component)this.pnlTileAddress, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.insets = new Insets(2, 2, 2, 2);
        this.mapViewer = new TileBoundsMapView();
        this.add((Component)this.mapViewer, gc);
        this.mapViewer.setFocusable(false);
        this.mapViewer.setZoomContolsVisible(false);
        this.mapViewer.setMapMarkerVisible(false);
        this.pnlTileAddress.addPropertyChangeListener(this.pnlTileGrid);
        this.pnlTileGrid.addPropertyChangeListener(new TileBoundsChangeListener());
    }

    public TileSelectionBBoxChooser() {
        this.build();
    }

    public Bounds getBoundingBox() {
        return this.bbox;
    }

    public void setBoundingBox(Bounds bbox) {
        this.pnlTileGrid.initFromBoundingBox(bbox);
    }

    protected void refreshMapView() {
        if (this.bbox == null) {
            return;
        }
        MapMarkerDot xmin_ymin = new MapMarkerDot(this.bbox.getMin().lat(), this.bbox.getMin().lon());
        MapMarkerDot xmax_ymax = new MapMarkerDot(this.bbox.getMax().lat(), this.bbox.getMax().lon());
        Vector<MapMarker> marker = new Vector<MapMarker>(2);
        marker.add(xmin_ymin);
        marker.add(xmax_ymax);
        this.mapViewer.setBoundingBox(this.bbox);
        this.mapViewer.setMapMarkerList(marker);
        this.mapViewer.setDisplayToFitMapMarkers();
        this.mapViewer.zoomOut();
    }

    protected Bounds convertTileBoundsToBoundingBox(TileBounds tb) {
        LatLon min = this.getNorthWestLatLonOfTile(tb.min, tb.zoomLevel);
        Point p = new Point(tb.max);
        ++p.x;
        ++p.y;
        LatLon max = this.getNorthWestLatLonOfTile(p, tb.zoomLevel);
        return new Bounds(max.lat(), min.lon(), min.lat(), max.lon());
    }

    protected LatLon getNorthWestLatLonOfTile(Point tile, int zoom) {
        double lon = (double)tile.x / Math.pow(2.0, zoom) * 360.0 - 180.0;
        double lat = Math.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * (double)tile.y / Math.pow(2.0, zoom))));
        return new LatLon(lat, lon);
    }

    private static class TileBoundsMapView
    extends JMapViewer {
        private Bounds bbox;
        private Point min;
        private Point max;

        public TileBoundsMapView() {
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        }

        public void setBoundingBox(Bounds bbox) {
            this.bbox = bbox;
            if (bbox == null) {
                this.min = null;
                this.max = null;
            } else {
                int y1 = OsmMercator.LatToY(bbox.getMin().lat(), 22);
                int y2 = OsmMercator.LatToY(bbox.getMax().lat(), 22);
                int x1 = OsmMercator.LonToX(bbox.getMin().lon(), 22);
                int x2 = OsmMercator.LonToX(bbox.getMax().lon(), 22);
                this.min = new Point(Math.min(x1, x2), Math.min(y1, y2));
                this.max = new Point(Math.max(x1, x2), Math.max(y1, y2));
            }
            this.repaint();
        }

        protected Point getTopLeftCoordinates() {
            return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
        }

        public void paint(Graphics g) {
            try {
                super.paint(g);
                if (this.min == null || this.max == null) {
                    return;
                }
                int zoomDiff = 22 - this.zoom;
                Point tlc = this.getTopLeftCoordinates();
                int x_min = (this.min.x >> zoomDiff) - tlc.x;
                int y_min = (this.min.y >> zoomDiff) - tlc.y;
                int x_max = (this.max.x >> zoomDiff) - tlc.x;
                int y_max = (this.max.y >> zoomDiff) - tlc.y;
                int w = x_max - x_min;
                int h = y_max - y_min;
                g.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                g.fillRect(x_min, y_min, w, h);
                g.setColor(Color.BLACK);
                g.drawRect(x_min, y_min, w, h);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class TileBounds {
        public Point min;
        public Point max;
        public int zoomLevel;

        public TileBounds() {
            this.zoomLevel = 0;
            this.min = new Point(0, 0);
            this.max = new Point(0, 0);
        }

        public TileBounds(Point min, Point max, int zoomLevel) {
            this.min = min;
            this.max = max;
            this.zoomLevel = zoomLevel;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("min=").append(this.min.x).append(",").append(this.min.y).append(",");
            sb.append("max=").append(this.max.x).append(",").append(this.max.y).append(",");
            sb.append("zoom=").append(this.zoomLevel);
            return sb.toString();
        }
    }

    private static class TileCoordinateValidator
    extends AbstractTextComponentValidator {
        private int zoomLevel;
        private int tileIndex;

        public TileCoordinateValidator(JTextComponent tc) throws IllegalArgumentException {
            super(tc);
        }

        public void setZoomLevel(int zoomLevel) {
            this.zoomLevel = zoomLevel;
            this.validate();
        }

        public boolean isValid() {
            String value = this.getComponent().getText().trim();
            try {
                this.tileIndex = value.equals("") ? 0 : Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return this.tileIndex >= 0 && !((double)this.tileIndex >= Math.pow(2.0, this.zoomLevel));
        }

        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter a tile index"));
            } else {
                this.feedbackInvalid(I18n.tr("The current value isn''t a valid tile index for the given zoom level", this.getComponent().getText()));
            }
        }

        public int getTileIndex() {
            return this.tileIndex;
        }
    }

    private static class TileAddressValidator
    extends AbstractTextComponentValidator {
        private TileBounds tileBounds = null;

        public TileAddressValidator(JTextComponent tc) throws IllegalArgumentException {
            super(tc);
        }

        public boolean isValid() {
            int y;
            int x;
            int zoom;
            String value = this.getComponent().getText().trim();
            Matcher m = Pattern.compile("(\\d+)[^\\d]+(\\d+)[^\\d]+(\\d+)").matcher(value);
            this.tileBounds = null;
            if (!m.matches()) {
                return false;
            }
            try {
                zoom = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (zoom < 0 || zoom > 18) {
                return false;
            }
            try {
                x = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (x < 0 || (double)x >= Math.pow(2.0, zoom - 1)) {
                return false;
            }
            try {
                y = Integer.parseInt(m.group(3));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (y < 0 || (double)y >= Math.pow(2.0, zoom - 1)) {
                return false;
            }
            this.tileBounds = new TileBounds(new Point(x, y), new Point(x, y), zoom);
            return true;
        }

        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter a tile address"));
            } else {
                this.feedbackInvalid(I18n.tr("The current value isn''t a valid tile address", this.getComponent().getText()));
            }
        }

        public TileBounds getTileBounds() {
            return this.tileBounds;
        }
    }

    private static class TileAddressInputPanel
    extends JPanel {
        public static final String TILE_BOUNDS_PROP = TileAddressInputPanel.class.getName() + ".tileBounds";
        private JTextField tfTileAddress;
        private TileAddressValidator valTileAddress;

        protected JPanel buildTextPanel() {
            JPanel pnl = new JPanel(new BorderLayout());
            HtmlPanel msg = new HtmlPanel();
            msg.setText(I18n.tr("<html>Alternatively you may enter a <strong>tile address</strong> for a single tile in the format <i>zoomlevel/x/y</i>, i.e. <i>15/256/223</i>. Tile adresses in the format <i>zoom,x,y</i> or <i>zoom;x;y</i> are valid too.</html>"));
            pnl.add(msg);
            return pnl;
        }

        protected JPanel buildTileAddressInputPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 2, 2);
            pnl.add((Component)new JLabel(I18n.tr("Tile address:")), gc);
            gc.weightx = 1.0;
            gc.gridx = 1;
            this.tfTileAddress = new JTextField();
            pnl.add((Component)this.tfTileAddress, gc);
            this.valTileAddress = new TileAddressValidator(this.tfTileAddress);
            SelectAllOnFocusGainedDecorator.decorate(this.tfTileAddress);
            gc.weightx = 0.0;
            gc.gridx = 2;
            ApplyTileAddressAction applyTileAddressAction = new ApplyTileAddressAction();
            JButton btn = new JButton(applyTileAddressAction);
            btn.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            pnl.add((Component)btn, gc);
            this.tfTileAddress.addActionListener(applyTileAddressAction);
            return pnl;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.insets = new Insets(0, 0, 5, 0);
            this.add((Component)this.buildTextPanel(), gc);
            gc.gridy = 1;
            this.add((Component)this.buildTileAddressInputPanel(), gc);
            gc.gridy = 2;
            gc.fill = 1;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }

        public TileAddressInputPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.build();
        }

        protected void fireTileBoundsChanged(TileBounds tb) {
            this.firePropertyChange(TILE_BOUNDS_PROP, null, tb);
        }

        class ApplyTileAddressAction
        extends AbstractAction {
            public ApplyTileAddressAction() {
                this.putValue("SmallIcon", ImageProvider.get("apply"));
                this.putValue("ShortDescription", I18n.tr("Apply the tile address"));
            }

            public void actionPerformed(ActionEvent e) {
                TileBounds tb = TileAddressInputPanel.this.valTileAddress.getTileBounds();
                if (tb != null) {
                    TileAddressInputPanel.this.fireTileBoundsChanged(tb);
                }
            }
        }
    }

    private static class TileGridInputPanel
    extends JPanel
    implements PropertyChangeListener {
        public static final String TILE_BOUNDS_PROP = TileGridInputPanel.class.getName() + ".tileBounds";
        private JTextField tfMaxY;
        private JTextField tfMinY;
        private JTextField tfMaxX;
        private JTextField tfMinX;
        private TileCoordinateValidator valMaxY;
        private TileCoordinateValidator valMinY;
        private TileCoordinateValidator valMaxX;
        private TileCoordinateValidator valMinX;
        private JSpinner spZoomLevel;
        private TileBoundsBuilder tileBoundsBuilder = new TileBoundsBuilder();
        private boolean doFireTileBoundChanged = true;

        protected JPanel buildTextPanel() {
            JPanel pnl = new JPanel(new BorderLayout());
            HtmlPanel msg = new HtmlPanel();
            msg.setText(I18n.tr("<html>Please select a <strong>range of OSM tiles</strong> at a given zoom level.</html>"));
            pnl.add(msg);
            return pnl;
        }

        protected JPanel buildZoomLevelPanel() {
            JPanel pnl = new JPanel(new FlowLayout(0));
            pnl.add(new JLabel(I18n.tr("Zoom level:")));
            this.spZoomLevel = new JSpinner(new SpinnerNumberModel(0, 0, 18, 1));
            pnl.add(this.spZoomLevel);
            this.spZoomLevel.addChangeListener(new ZomeLevelChangeHandler());
            this.spZoomLevel.addChangeListener(this.tileBoundsBuilder);
            return pnl;
        }

        protected JPanel buildTileGridInputPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.insets = new Insets(0, 0, 2, 2);
            gc.gridwidth = 2;
            gc.gridx = 1;
            gc.fill = 2;
            pnl.add((Component)this.buildZoomLevelPanel(), gc);
            gc.gridwidth = 1;
            gc.gridy = 1;
            gc.gridx = 1;
            pnl.add((Component)new JLabel(I18n.tr("from tile")), gc);
            gc.gridx = 2;
            pnl.add((Component)new JLabel(I18n.tr("up to tile")), gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.weightx = 0.0;
            pnl.add((Component)new JLabel("X:"), gc);
            gc.gridx = 1;
            gc.weightx = 0.5;
            this.tfMinX = new JTextField();
            pnl.add((Component)this.tfMinX, gc);
            this.valMinX = new TileCoordinateValidator(this.tfMinX);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMinX);
            this.tfMinX.addActionListener(this.tileBoundsBuilder);
            this.tfMinX.addFocusListener(this.tileBoundsBuilder);
            gc.gridx = 2;
            gc.weightx = 0.5;
            this.tfMaxX = new JTextField();
            pnl.add((Component)this.tfMaxX, gc);
            this.valMaxX = new TileCoordinateValidator(this.tfMaxX);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMaxX);
            this.tfMaxX.addActionListener(this.tileBoundsBuilder);
            this.tfMaxX.addFocusListener(this.tileBoundsBuilder);
            gc.gridx = 0;
            gc.gridy = 3;
            gc.weightx = 0.0;
            pnl.add((Component)new JLabel("Y:"), gc);
            gc.gridx = 1;
            gc.weightx = 0.5;
            this.tfMinY = new JTextField();
            pnl.add((Component)this.tfMinY, gc);
            this.valMinY = new TileCoordinateValidator(this.tfMinY);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMinY);
            this.tfMinY.addActionListener(this.tileBoundsBuilder);
            this.tfMinY.addFocusListener(this.tileBoundsBuilder);
            gc.gridx = 2;
            gc.weightx = 0.5;
            this.tfMaxY = new JTextField();
            pnl.add((Component)this.tfMaxY, gc);
            this.valMaxY = new TileCoordinateValidator(this.tfMaxY);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMaxY);
            this.tfMaxY.addActionListener(this.tileBoundsBuilder);
            this.tfMaxY.addFocusListener(this.tileBoundsBuilder);
            gc.gridy = 4;
            gc.gridx = 0;
            gc.gridwidth = 3;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.fill = 1;
            pnl.add((Component)new JPanel(), gc);
            return pnl;
        }

        protected void build() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)this.buildTextPanel(), "North");
            this.add((Component)this.buildTileGridInputPanel(), "Center");
            HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
            forwardKeys.add(KeyStroke.getKeyStroke(10, 0));
            this.setFocusTraversalKeys(0, forwardKeys);
        }

        public TileGridInputPanel() {
            this.build();
        }

        public void initFromBoundingBox(Bounds bbox) {
            if (bbox == null) {
                return;
            }
            TileBounds tb = new TileBounds();
            tb.zoomLevel = (Integer)this.spZoomLevel.getValue();
            tb.min = new Point(Math.max(0, TileGridInputPanel.lonToTileX(tb.zoomLevel, bbox.getMin().lon())), Math.max(0, TileGridInputPanel.latToTileY(tb.zoomLevel, bbox.getMax().lat() - 1.0E-5)));
            tb.max = new Point(Math.max(0, TileGridInputPanel.lonToTileX(tb.zoomLevel, bbox.getMax().lon())), Math.max(0, TileGridInputPanel.latToTileY(tb.zoomLevel, bbox.getMin().lat() - 1.0E-5)));
            this.doFireTileBoundChanged = false;
            this.setTileBounds(tb);
            this.doFireTileBoundChanged = true;
        }

        public static int latToTileY(int zoom, double lat) {
            if (zoom < 3 || zoom > 18) {
                return -1;
            }
            double l = lat / 180.0 * Math.PI;
            double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
            return (int)((double)(1 << zoom - 1) * (Math.PI - pf) / Math.PI);
        }

        public static int lonToTileX(int zoom, double lon) {
            if (zoom < 3 || zoom > 18) {
                return -1;
            }
            return (int)((double)(1 << zoom - 3) * (lon + 180.0) / 45.0);
        }

        public void setTileBounds(TileBounds tileBounds) {
            this.tfMinX.setText(Integer.toString(tileBounds.min.x));
            this.tfMinY.setText(Integer.toString(tileBounds.min.y));
            this.tfMaxX.setText(Integer.toString(tileBounds.max.x));
            this.tfMaxY.setText(Integer.toString(tileBounds.max.y));
            this.spZoomLevel.setValue(tileBounds.zoomLevel);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TileAddressInputPanel.TILE_BOUNDS_PROP)) {
                TileBounds tb = (TileBounds)evt.getNewValue();
                this.setTileBounds(tb);
                this.fireTileBoundsChanged(tb);
            }
        }

        protected void fireTileBoundsChanged(TileBounds tb) {
            if (!this.doFireTileBoundChanged) {
                return;
            }
            this.firePropertyChange(TILE_BOUNDS_PROP, null, tb);
        }

        class TileBoundsBuilder
        implements ActionListener,
        FocusListener,
        ChangeListener {
            TileBoundsBuilder() {
            }

            protected void buildTileBounds() {
                if (!TileGridInputPanel.this.valMaxX.isValid()) {
                    return;
                }
                if (!TileGridInputPanel.this.valMaxY.isValid()) {
                    return;
                }
                if (!TileGridInputPanel.this.valMinX.isValid()) {
                    return;
                }
                if (!TileGridInputPanel.this.valMinY.isValid()) {
                    return;
                }
                Point min = new Point(TileGridInputPanel.this.valMinX.getTileIndex(), TileGridInputPanel.this.valMinY.getTileIndex());
                Point max = new Point(TileGridInputPanel.this.valMaxX.getTileIndex(), TileGridInputPanel.this.valMaxY.getTileIndex());
                if (min.x > max.x) {
                    // empty if block
                }
                int zoomlevel = (Integer)TileGridInputPanel.this.spZoomLevel.getValue();
                TileBounds tb = new TileBounds(min, max, zoomlevel);
                TileGridInputPanel.this.fireTileBoundsChanged(tb);
            }

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                this.buildTileBounds();
            }

            public void actionPerformed(ActionEvent e) {
                this.buildTileBounds();
            }

            public void stateChanged(ChangeEvent e) {
                this.buildTileBounds();
            }
        }

        class ZomeLevelChangeHandler
        implements ChangeListener {
            ZomeLevelChangeHandler() {
            }

            public void stateChanged(ChangeEvent e) {
                int zoomLevel = (Integer)TileGridInputPanel.this.spZoomLevel.getValue();
                TileGridInputPanel.this.valMaxX.setZoomLevel(zoomLevel);
                TileGridInputPanel.this.valMaxY.setZoomLevel(zoomLevel);
                TileGridInputPanel.this.valMinX.setZoomLevel(zoomLevel);
                TileGridInputPanel.this.valMinY.setZoomLevel(zoomLevel);
            }
        }
    }

    class TileBoundsChangeListener
    implements PropertyChangeListener {
        TileBoundsChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(TileGridInputPanel.TILE_BOUNDS_PROP)) {
                return;
            }
            TileBounds tb = (TileBounds)evt.getNewValue();
            Bounds oldValue = TileSelectionBBoxChooser.this.bbox;
            TileSelectionBBoxChooser.this.bbox = TileSelectionBBoxChooser.this.convertTileBoundsToBoundingBox(tb);
            TileSelectionBBoxChooser.this.firePropertyChange(BBoxChooser.BBOX_PROP, oldValue, TileSelectionBBoxChooser.this.bbox);
            TileSelectionBBoxChooser.this.refreshMapView();
        }
    }
}

