/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class HistoryDialog
extends ToggleDialog
implements HistoryDataSetListener {
    protected HistoryItemTableModel model;
    protected JTable historyTable;
    protected ShowHistoryAction showHistoryAction;
    protected ReloadAction reloadAction;

    public HistoryDialog() {
        super(I18n.tr("History"), "history", I18n.tr("Display the history of all selected items."), Shortcut.registerShortcut("subwindow:history", I18n.tr("Toggle: {0}", I18n.tr("History")), 72, 4, 1), 150);
        this.build();
        DataSet.selListeners.add(this.model);
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Dialog/HistoryDialog"));
    }

    protected JPanel buildButtonRow() {
        JPanel buttons = this.getButtonPanel(2);
        this.reloadAction = new ReloadAction();
        SideButton btn = new SideButton(this.reloadAction);
        btn.setName("btn.reload");
        buttons.add(btn);
        this.showHistoryAction = new ShowHistoryAction();
        btn = new SideButton(this.showHistoryAction);
        btn.setName("btn.showhistory");
        buttons.add(btn);
        return buttons;
    }

    protected void build() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new HistoryItemTableModel(selectionModel);
        this.historyTable = new JTable(this.model, new HistoryTableColumnModel(), selectionModel);
        this.historyTable.setSelectionMode(2);
        this.historyTable.setName("table.historyitems");
        final TableCellRenderer oldRenderer = this.historyTable.getTableHeader().getDefaultRenderer();
        this.historyTable.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent c = (JComponent)oldRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!value.equals("")) {
                    return c;
                }
                JLabel l = new JLabel(ImageProvider.get("misc", "showhide"));
                l.setForeground(c.getForeground());
                l.setBackground(c.getBackground());
                l.setFont(c.getFont());
                l.setBorder(c.getBorder());
                l.setOpaque(true);
                return l;
            }
        });
        this.historyTable.addMouseListener(new ShowHistoryMouseAdapter());
        JScrollPane pane = new JScrollPane(this.historyTable);
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        this.historyTable.setTableHeader(null);
        pane.setColumnHeaderView(null);
        this.add((Component)pane, "Center");
        this.add((Component)this.buildButtonRow(), "South");
        this.historyTable.getSelectionModel().addListSelectionListener(this.showHistoryAction);
        this.historyTable.getSelectionModel().addListSelectionListener(this.reloadAction);
    }

    public void showNotify() {
        HistoryDataSet.getInstance().addHistoryDataSetListener(this);
    }

    public void hideNotify() {
        HistoryDataSet.getInstance().removeHistoryDataSetListener(this);
    }

    public void historyUpdated(HistoryDataSet source, PrimitiveId primitiveId) {
        this.model.refresh();
    }

    public void historyDataSetCleared(HistoryDataSet source) {
        this.model.refresh();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener {
        public ShowHistoryAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
            this.putValue("Name", I18n.tr("Show"));
            this.putValue("ShortDescription", I18n.tr("Display the history of the selected objects."));
            this.updateEnabledState();
        }

        protected List<OsmPrimitive> filterPrimitivesWithUnloadedHistory(Collection<OsmPrimitive> primitives) {
            ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>(primitives.size());
            HistoryDataSet hds = HistoryDataSet.getInstance();
            for (OsmPrimitive p : primitives) {
                if (hds.getHistory(p.getPrimitiveId()) == null) {
                    ret.add(p);
                    continue;
                }
                if (p.isNew() || hds.getHistory(p.getPrimitiveId()).getByVersion(p.getUniqueId()) != null) continue;
                ret.add(p);
            }
            return ret;
        }

        public void showHistory(final List<OsmPrimitive> primitives) {
            List<OsmPrimitive> toLoad = this.filterPrimitivesWithUnloadedHistory(primitives);
            if (!toLoad.isEmpty()) {
                HistoryLoadTask task = new HistoryLoadTask();
                task.add(primitives);
                Main.worker.submit(task);
            }
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        for (OsmPrimitive p : primitives) {
                            History h = HistoryDataSet.getInstance().getHistory(p.getPrimitiveId());
                            if (h == null) continue;
                            HistoryBrowserDialogManager.getInstance().show(h);
                        }
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                BugReportExceptionHandler.handleException(e);
                            }
                        });
                    }
                }
            };
            Main.worker.submit(r);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = HistoryDialog.this.historyTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            this.showHistory(HistoryDialog.this.model.getPrimitives(rows));
        }

        protected void updateEnabledState() {
            this.setEnabled(HistoryDialog.this.historyTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class ShowHistoryMouseAdapter
    extends MouseAdapter {
        ShowHistoryMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                int row = HistoryDialog.this.historyTable.rowAtPoint(e.getPoint());
                new ShowHistoryAction().showHistory(Collections.singletonList(HistoryDialog.this.model.getPrimitive(row)));
            }
        }
    }

    class ReloadAction
    extends AbstractAction
    implements ListSelectionListener {
        public ReloadAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.putValue("Name", I18n.tr("Reload"));
            this.putValue("ShortDescription", I18n.tr("Reload all currently selected objects and refresh the list."));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows = HistoryDialog.this.historyTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            List<OsmPrimitive> selectedItems = HistoryDialog.this.model.getPrimitives(rows);
            HistoryLoadTask task = new HistoryLoadTask();
            task.add(selectedItems);
            Main.worker.execute(task);
        }

        protected void updateEnabledState() {
            this.setEnabled(HistoryDialog.this.historyTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class HistoryTableColumnModel
    extends DefaultTableColumnModel {
        protected void createColumns() {
            TableColumn col = null;
            OsmPrimitivRenderer renderer = new OsmPrimitivRenderer();
            col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("Object with history"));
            col.setCellRenderer(renderer);
            this.addColumn(col);
        }

        public HistoryTableColumnModel() {
            this.createColumns();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HistoryItemTableModel
    extends DefaultTableModel
    implements SelectionChangedListener {
        private ArrayList<OsmPrimitive> data = new ArrayList();
        private DefaultListSelectionModel selectionModel;

        public HistoryItemTableModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.data.get(row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        protected List<OsmPrimitive> getSelectedPrimitives() {
            ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ret.add(this.data.get(i));
            }
            return ret;
        }

        protected void selectPrimitives(Collection<OsmPrimitive> primitives) {
            for (OsmPrimitive p : primitives) {
                int idx = this.data.indexOf(p);
                if (idx < 0) continue;
                this.selectionModel.addSelectionInterval(idx, idx);
            }
        }

        public void refresh() {
            List<OsmPrimitive> selectedPrimitives = this.getSelectedPrimitives();
            this.data.clear();
            if (Main.main.getCurrentDataSet() == null) {
                return;
            }
            for (OsmPrimitive primitive : Main.main.getCurrentDataSet().getSelected()) {
                if (primitive.isNew()) continue;
                this.data.add(primitive);
            }
            this.fireTableDataChanged();
            this.selectPrimitives(selectedPrimitives);
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
            this.data.clear();
            this.selectionModel.clearSelection();
            if (newSelection != null && !newSelection.isEmpty()) {
                for (OsmPrimitive osmPrimitive : newSelection) {
                    if (osmPrimitive.isNew()) continue;
                    this.data.add(osmPrimitive);
                }
            }
            this.fireTableDataChanged();
            this.selectionModel.addSelectionInterval(0, this.data.size() - 1);
        }

        public List<OsmPrimitive> getPrimitives(int[] rows) {
            if (rows == null || rows.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>(rows.length);
            for (int row : rows) {
                ret.add(this.data.get(row));
            }
            return ret;
        }

        public OsmPrimitive getPrimitive(int row) {
            return this.data.get(row);
        }
    }
}

