/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagTable;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagEditorPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(TagEditorPanel.class.getName());
    private TagEditorModel model;
    private TagTable tagTable;
    private AutoCompletionManager autocomplete;
    private AutoCompletionList acList;

    protected JPanel buildTagTableEditorPanel() {
        JPanel pnl = new JPanel();
        this.tagTable = new TagTable(this.model);
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)new JScrollPane(this.tagTable), "Center");
        return pnl;
    }

    protected JPanel buildButtonsPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        JButton btn = new JButton(this.tagTable.getAddAction());
        pnl.add(btn);
        btn.setMargin(new Insets(0, 0, 0, 0));
        this.tagTable.addComponentNotStoppingCellEditing(btn);
        btn = new JButton(this.tagTable.getDeleteAction());
        pnl.add(btn);
        btn.setMargin(new Insets(0, 0, 0, 0));
        this.tagTable.addComponentNotStoppingCellEditing(btn);
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        JPanel tablePanel = this.buildTagTableEditorPanel();
        JPanel buttonPanel = this.buildButtonsPanel();
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.anchor = 18;
        this.add((Component)buttonPanel, gc);
        gc.gridx = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 10;
        this.add((Component)tablePanel, gc);
    }

    public TagEditorPanel() {
        this((TagEditorModel)null);
    }

    public TagEditorPanel(TagEditorModel model) {
        this.model = model;
        if (this.model == null) {
            this.model = new TagEditorModel();
        }
        this.build();
    }

    public TagEditorModel getModel() {
        return this.model;
    }

    public void initAutoCompletion(OsmDataLayer layer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.autocomplete = layer.data.getAutoCompletionManager();
        this.acList = new AutoCompletionList();
        TagCellEditor editor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(0).getCellEditor();
        editor.setAutoCompletionManager(this.autocomplete);
        editor.setAutoCompletionList(this.acList);
        editor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(1).getCellEditor();
        editor.setAutoCompletionManager(this.autocomplete);
        editor.setAutoCompletionList(this.acList);
    }

    public void setEnabled(boolean enabled) {
        this.tagTable.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

