/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.DiffResultProcessor;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmChangeBuilder;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmApi
extends OsmConnection {
    private static final Logger logger = Logger.getLogger(OsmApi.class.getName());
    public static final int DEFAULT_MAX_NUM_RETRIES = 5;
    private static HashMap<String, OsmApi> instances = new HashMap();
    private String serverUrl;
    private Changeset changeset;
    private String version = null;
    private Capabilities capabilities = new Capabilities();
    private boolean initialized = false;
    private StringWriter swriter = new StringWriter();
    private OsmWriter osmWriter = new OsmWriter(new PrintWriter(this.swriter), true, null);

    public static OsmApi getOsmApi(String serverUrl) {
        OsmApi api = instances.get(serverUrl);
        if (api == null) {
            api = new OsmApi(serverUrl);
            instances.put(serverUrl, api);
        }
        return api;
    }

    public static OsmApi getOsmApi() {
        String serverUrl = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        if (serverUrl == null) {
            throw new IllegalStateException(I18n.tr("Preference ''{0}'' missing. Cannot initialize OsmApi.", "osm-server.url"));
        }
        return OsmApi.getOsmApi(serverUrl);
    }

    protected OsmApi(String serverUrl) {
        CheckParameterUtil.ensureParameterNotNull(serverUrl, "serverUrl");
        this.serverUrl = serverUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public void initialize(ProgressMonitor monitor) throws OsmApiInitializationException, OsmTransferCancelledException {
        if (this.initialized) {
            return;
        }
        this.cancel = false;
        try {
            String s = this.sendRequest("GET", "capabilities", null, monitor, false);
            InputSource inputSource = new InputSource(new StringReader(s));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new CapabilitiesParser());
            if (this.capabilities.supportsVersion("0.6")) {
                this.version = "0.6";
            } else {
                System.err.println(I18n.tr("This version of JOSM is incompatible with the configured server."));
                System.err.println(I18n.tr("It supports protocol version 0.6, while the server says it supports {0} to {1}.", this.capabilities.get("version", "minimum"), this.capabilities.get("version", "maximum")));
                this.initialized = false;
            }
            System.out.println(I18n.tr("Communications with {0} established using protocol version {1}.", this.serverUrl, this.version));
            this.osmWriter.setVersion(this.version);
            this.initialized = true;
        }
        catch (IOException e) {
            this.initialized = false;
            throw new OsmApiInitializationException(e);
        }
        catch (SAXException e) {
            this.initialized = false;
            throw new OsmApiInitializationException(e);
        }
        catch (ParserConfigurationException e) {
            this.initialized = false;
            throw new OsmApiInitializationException(e);
        }
        catch (OsmTransferCancelledException e) {
            throw e;
        }
        catch (OsmTransferException e) {
            this.initialized = false;
            throw new OsmApiInitializationException(e);
        }
    }

    private String toXml(OsmPrimitive o, boolean addBody) {
        this.swriter.getBuffer().setLength(0);
        this.osmWriter.setWithBody(addBody);
        this.osmWriter.setChangeset(this.changeset);
        this.osmWriter.header();
        o.visit(this.osmWriter);
        this.osmWriter.footer();
        this.osmWriter.out.flush();
        return this.swriter.toString();
    }

    private String toXml(Changeset s) {
        this.swriter.getBuffer().setLength(0);
        this.osmWriter.header();
        s.visit(this.osmWriter);
        this.osmWriter.footer();
        this.osmWriter.out.flush();
        return this.swriter.toString();
    }

    public String getBaseUrl() {
        int p;
        StringBuffer rv = new StringBuffer(this.serverUrl);
        if (this.version != null) {
            rv.append("/");
            rv.append(this.version);
        }
        rv.append("/");
        while ((p = rv.indexOf("//", 6)) > -1) {
            rv.delete(p, p + 1);
        }
        return rv.toString();
    }

    public void createPrimitive(OsmPrimitive osm, ProgressMonitor monitor) throws OsmTransferException {
        String ret = "";
        try {
            this.ensureValidChangeset();
            this.initialize(monitor);
            ret = this.sendRequest("PUT", OsmPrimitiveType.from(osm).getAPIName() + "/create", this.toXml(osm, true), monitor);
            osm.setOsmId(Long.parseLong(ret.trim()), 1);
            osm.setChangesetId(this.getChangeset().getId());
        }
        catch (NumberFormatException e) {
            throw new OsmTransferException(I18n.tr("Unexpected format of ID replied by the server. Got ''{0}''.", ret));
        }
    }

    public void modifyPrimitive(OsmPrimitive osm, ProgressMonitor monitor) throws OsmTransferException {
        String ret = null;
        try {
            this.ensureValidChangeset();
            this.initialize(monitor);
            ret = this.sendRequest("PUT", OsmPrimitiveType.from(osm).getAPIName() + "/" + osm.getId(), this.toXml(osm, true), monitor);
            osm.setOsmId(osm.getId(), Integer.parseInt(ret.trim()));
            osm.setChangesetId(this.getChangeset().getId());
            osm.setVisible(true);
        }
        catch (NumberFormatException e) {
            throw new OsmTransferException(I18n.tr("Unexpected format of new version of modified primitive ''{0}''. Got ''{1}''.", osm.getId(), ret));
        }
    }

    public void deletePrimitive(OsmPrimitive osm, ProgressMonitor monitor) throws OsmTransferException {
        this.ensureValidChangeset();
        this.initialize(monitor);
        this.uploadDiff(Collections.singleton(osm), monitor.createSubTaskMonitor(-1, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openChangeset(Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        try {
            progressMonitor.beginTask(I18n.tr("Creating changeset..."));
            this.initialize(progressMonitor);
            String ret = "";
            try {
                ret = this.sendRequest("PUT", "changeset/create", this.toXml(changeset), progressMonitor);
                changeset.setId(Integer.parseInt(ret.trim()));
                changeset.setOpen(true);
            }
            catch (NumberFormatException e) {
                throw new OsmTransferException(I18n.tr("Unexpected format of ID replied by the server. Got ''{0}''.", ret));
            }
            progressMonitor.setCustomText(I18n.tr("Successfully opened changeset {0}", changeset.getId()));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void updateChangeset(Changeset changeset, ProgressMonitor monitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        try {
            monitor.beginTask(I18n.tr("Updating changeset..."));
            this.initialize(monitor);
            monitor.setCustomText(I18n.tr("Updating changeset {0}...", changeset.getId()));
            this.sendRequest("PUT", "changeset/" + changeset.getId(), this.toXml(changeset), monitor);
        }
        catch (ChangesetClosedException e) {
            e.setSource(ChangesetClosedException.Source.UPDATE_CHANGESET);
            throw e;
        }
        catch (OsmApiException e) {
            if (e.getResponseCode() == 409 && ChangesetClosedException.errorHeaderMatchesPattern(e.getErrorHeader())) {
                throw new ChangesetClosedException(e.getErrorHeader(), ChangesetClosedException.Source.UPDATE_CHANGESET);
            }
            throw e;
        }
        finally {
            monitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChangeset(Changeset changeset, ProgressMonitor monitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        try {
            monitor.beginTask(I18n.tr("Closing changeset..."));
            this.initialize(monitor);
            this.sendRequest("PUT", "changeset/" + changeset.getId() + "/close", null, monitor);
            changeset.setOpen(false);
        }
        finally {
            monitor.finishTask();
        }
    }

    public Collection<OsmPrimitive> uploadDiff(Collection<OsmPrimitive> list, ProgressMonitor monitor) throws OsmTransferException {
        try {
            monitor.beginTask("", list.size() * 2);
            if (this.changeset == null) {
                throw new OsmTransferException(I18n.tr("No changeset present for diff upload."));
            }
            this.initialize(monitor);
            OsmChangeBuilder changeBuilder = new OsmChangeBuilder(this.changeset);
            monitor.subTask(I18n.tr("Preparing upload request..."));
            changeBuilder.start();
            changeBuilder.append(list);
            changeBuilder.finish();
            String diffUploadRequest = changeBuilder.getDocument();
            monitor.indeterminateSubTask(I18n.trn("Uploading {0} object...", "Uploading {0} objects...", list.size(), list.size()));
            String diffUploadResponse = this.sendRequest("POST", "changeset/" + this.changeset.getId() + "/upload", diffUploadRequest, monitor);
            DiffResultProcessor reader = new DiffResultProcessor(list);
            reader.parse(diffUploadResponse, monitor.createSubTaskMonitor(-1, false));
            Set<OsmPrimitive> set = reader.postProcess(this.getChangeset(), monitor.createSubTaskMonitor(-1, false));
            return set;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (OsmDataParsingException e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    private void sleepAndListen(int retry, ProgressMonitor monitor) throws OsmTransferCancelledException {
        System.out.print(I18n.tr("Waiting 10 seconds ... "));
        for (int i = 0; i < 10; ++i) {
            if (monitor != null) {
                monitor.setCustomText(I18n.tr("Starting retry {0} of {1} in {2} seconds ...", this.getMaxRetries() - retry, this.getMaxRetries(), 10 - i));
            }
            if (this.cancel) {
                throw new OsmTransferCancelledException();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        System.out.println(I18n.tr("OK - trying again."));
    }

    protected int getMaxRetries() {
        int ret = Main.pref.getInteger("osm-server.max-num-retries", 5);
        return Math.max(ret, 0);
    }

    protected boolean isUsingOAuth() {
        String authMethod = Main.pref.get("osm-server.auth-method", "basic");
        return authMethod.equals("oauth");
    }

    private String sendRequest(String requestMethod, String urlSuffix, String requestBody, ProgressMonitor monitor) throws OsmTransferException {
        return this.sendRequest(requestMethod, urlSuffix, requestBody, monitor, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private String sendRequest(String requestMethod, String urlSuffix, String requestBody, ProgressMonitor monitor, boolean doAuthenticate) throws OsmTransferException {
        StringBuffer responseBody = new StringBuffer();
        int retries = this.getMaxRetries();
        while (true) {
            try {
                int retCode;
                while (true) {
                    URL url = new URL(new URL(this.getBaseUrl()), urlSuffix);
                    System.out.print(requestMethod + " " + url + "... ");
                    this.activeConnection = (HttpURLConnection)url.openConnection();
                    this.activeConnection.setConnectTimeout(15000);
                    this.activeConnection.setRequestMethod(requestMethod);
                    if (doAuthenticate) {
                        this.addAuth(this.activeConnection);
                    }
                    if (requestMethod.equals("PUT") || requestMethod.equals("POST") || requestMethod.equals("DELETE")) {
                        this.activeConnection.setDoOutput(true);
                        this.activeConnection.setRequestProperty("Content-type", "text/xml");
                        OutputStream out = this.activeConnection.getOutputStream();
                        if (requestBody != null) {
                            BufferedWriter bwr = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
                            bwr.write(requestBody);
                            bwr.flush();
                        }
                        out.close();
                    }
                    this.activeConnection.connect();
                    System.out.println(this.activeConnection.getResponseMessage());
                    retCode = this.activeConnection.getResponseCode();
                    if (retCode < 500 || retries-- <= 0) break;
                    this.sleepAndListen(retries, monitor);
                    System.out.println(I18n.tr("Starting retry {0} of {1}.", this.getMaxRetries() - retries, this.getMaxRetries()));
                }
                responseBody.setLength(0);
                InputStream i = null;
                try {
                    i = this.activeConnection.getInputStream();
                }
                catch (IOException ioe) {
                    i = this.activeConnection.getErrorStream();
                }
                if (i != null) {
                    String s;
                    BufferedReader in = new BufferedReader(new InputStreamReader(i));
                    while ((s = in.readLine()) != null) {
                        responseBody.append(s);
                        responseBody.append("\n");
                    }
                }
                String errorHeader = null;
                if (this.activeConnection.getHeaderField("Error") != null) {
                    errorHeader = this.activeConnection.getHeaderField("Error");
                    System.err.println("Error header: " + errorHeader);
                } else if (retCode != 200 && responseBody.length() > 0) {
                    System.err.println("Error body: " + responseBody);
                }
                this.activeConnection.disconnect();
                errorHeader = errorHeader == null ? null : errorHeader.trim();
                String errorBody = responseBody.length() == 0 ? null : responseBody.toString().trim();
                switch (retCode) {
                    case 200: {
                        return responseBody.toString();
                    }
                    case 410: {
                        throw new OsmApiPrimitiveGoneException(errorHeader, errorBody);
                    }
                    case 409: {
                        if (!ChangesetClosedException.errorHeaderMatchesPattern(errorHeader)) throw new OsmApiException(retCode, errorHeader, errorBody);
                        throw new ChangesetClosedException(errorBody, ChangesetClosedException.Source.UPLOAD_DATA);
                    }
                    case 403: {
                        OsmApiException e = new OsmApiException(retCode, errorHeader, errorBody);
                        e.setAccessedUrl(this.activeConnection.getURL().toString());
                        throw e;
                    }
                }
                throw new OsmApiException(retCode, errorHeader, errorBody);
            }
            catch (UnknownHostException e) {
                throw new OsmTransferException(e);
            }
            catch (SocketTimeoutException e) {
                if (retries-- <= 0) throw new OsmTransferException(e);
                continue;
            }
            catch (ConnectException e) {
                if (retries-- <= 0) throw new OsmTransferException(e);
                continue;
            }
            catch (IOException e) {
                throw new OsmTransferException(e);
            }
            catch (OsmTransferCancelledException e) {
                throw e;
            }
            break;
        }
        catch (OsmTransferException e) {
            throw e;
        }
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    protected void ensureValidChangeset() throws OsmTransferException {
        if (this.changeset == null) {
            throw new OsmTransferException(I18n.tr("Current changeset is null. Cannot upload data."));
        }
        if (this.changeset.getId() <= 0) {
            throw new OsmTransferException(I18n.tr("ID of current changeset > 0 required. Current ID is {0}.", this.changeset.getId()));
        }
    }

    public Changeset getChangeset() {
        return this.changeset;
    }

    public void setChangeset(Changeset changeset) {
        if (changeset == null) {
            this.changeset = null;
            return;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        if (!changeset.isOpen()) {
            throw new IllegalArgumentException(I18n.tr("Open changeset expected. Got closed changeset with id {0}.", changeset.getId()));
        }
        this.changeset = changeset;
    }

    private class CapabilitiesParser
    extends DefaultHandler {
        private CapabilitiesParser() {
        }

        public void startDocument() throws SAXException {
            OsmApi.this.capabilities.clear();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            for (int i = 0; i < atts.getLength(); ++i) {
                OsmApi.this.capabilities.put(qName, atts.getQName(i), atts.getValue(i));
            }
        }
    }
}

