/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.interceptor;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.interceptor.DefaultMBeanServerInterceptor;
import com.sun.jmx.interceptor.DispatchInterceptor;
import com.sun.jmx.interceptor.NamespaceDispatchInterceptor;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.namespace.DomainInterceptor;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.namespace.JMXDomain;

class DomainDispatchInterceptor
extends DispatchInterceptor<DomainInterceptor, JMXDomain> {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;
    private static final ObjectName ALL_DOMAINS = JMXDomain.getDomainObjectName("*");
    private final DefaultMBeanServerInterceptor nextInterceptor;
    private final String mbeanServerName;
    private final MBeanServerDelegate delegate;

    public DomainDispatchInterceptor(MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, MBeanInstantiator mBeanInstantiator, Repository repository, NamespaceDispatchInterceptor namespaceDispatchInterceptor) {
        this.nextInterceptor = new DefaultMBeanServerInterceptor(mBeanServer, mBeanServerDelegate, mBeanInstantiator, repository, namespaceDispatchInterceptor);
        this.mbeanServerName = Util.getMBeanServerSecurityName(mBeanServerDelegate);
        this.delegate = mBeanServerDelegate;
    }

    final boolean isLocalHandlerNameFor(String string, ObjectName objectName) {
        if (string == null) {
            return true;
        }
        return objectName.getDomain().equals(string) && "type=JMXDomain".equals(objectName.getKeyPropertyListString());
    }

    @Override
    void validateHandlerNameFor(String string, ObjectName objectName) {
        super.validateHandlerNameFor(string, objectName);
        String[] stringArray = this.nextInterceptor.getDomains();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            throw new IllegalArgumentException("domain " + string + " is not empty");
        }
    }

    @Override
    final MBeanServer getInterceptorOrNullFor(ObjectName objectName) {
        if (objectName == null) {
            return this.nextInterceptor;
        }
        String string = objectName.getDomain();
        if (string.endsWith("//")) {
            return this.nextInterceptor;
        }
        if (string.contains("//")) {
            return null;
        }
        if (this.isLocalHandlerNameFor(string, objectName)) {
            LOG.finer("dispatching to local namespace");
            return this.nextInterceptor;
        }
        DomainInterceptor domainInterceptor = (DomainInterceptor)this.getInterceptor(string);
        if (domainInterceptor == null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("dispatching to local namespace: " + string);
            }
            return this.getNextInterceptor();
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("dispatching to domain: " + string);
        }
        return domainInterceptor;
    }

    private boolean multipleQuery(ObjectName objectName) {
        if (objectName == null) {
            return true;
        }
        if (objectName.isDomainPattern()) {
            return true;
        }
        return objectName.apply(ALL_DOMAINS.withDomain(objectName.getDomain()));
    }

    @Override
    final DispatchInterceptor.QueryInterceptor getInterceptorForQuery(ObjectName objectName) {
        if (this.multipleQuery(objectName)) {
            return new AggregatingQueryInterceptor(this);
        }
        String string = objectName.getDomain();
        DomainInterceptor domainInterceptor = (DomainInterceptor)this.getInterceptor(string);
        if (domainInterceptor != null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("dispatching to domain: " + string);
            }
            return new DispatchInterceptor.QueryInterceptor(domainInterceptor);
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("dispatching to local namespace: " + string);
        }
        return new DispatchInterceptor.QueryInterceptor(this.nextInterceptor);
    }

    @Override
    final ObjectName getHandlerNameFor(String string) {
        return JMXDomain.getDomainObjectName(string);
    }

    @Override
    public final String getHandlerKey(ObjectName objectName) {
        return objectName.getDomain();
    }

    @Override
    final DomainInterceptor createInterceptorFor(String string, ObjectName objectName, JMXDomain jMXDomain, Queue<Runnable> queue) {
        DomainInterceptor domainInterceptor = new DomainInterceptor(this.mbeanServerName, jMXDomain, string);
        domainInterceptor.addPostRegisterTask(queue, this.delegate);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("DomainInterceptor created: " + domainInterceptor);
        }
        return domainInterceptor;
    }

    @Override
    final void interceptorReleased(DomainInterceptor domainInterceptor, Queue<Runnable> queue) {
        domainInterceptor.addPostDeregisterTask(queue, this.delegate);
    }

    @Override
    final DefaultMBeanServerInterceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    @Override
    public String[] getDomains() {
        return this.nextInterceptor.getDomains();
    }

    @Override
    public Integer getMBeanCount() {
        String[] stringArray;
        int n = this.getNextInterceptor().getMBeanCount();
        for (String string : stringArray = this.getKeys()) {
            Object t = this.getInterceptor(string);
            if (t == null) continue;
            n += t.getMBeanCount().intValue();
        }
        return n;
    }

    static final class AggregatingQueryInterceptor
    extends DispatchInterceptor.QueryInterceptor {
        private final DomainDispatchInterceptor parent;

        AggregatingQueryInterceptor(DomainDispatchInterceptor domainDispatchInterceptor) {
            super(domainDispatchInterceptor.nextInterceptor);
            this.parent = domainDispatchInterceptor;
        }

        <T> Set<T> query(ObjectName objectName, QueryExp queryExp, DispatchInterceptor.QueryInvoker<T> queryInvoker, MBeanServer mBeanServer) {
            String[] stringArray;
            String[] stringArray2;
            Set<T> set = queryInvoker.query(mBeanServer, objectName, queryExp);
            Set<T> set2 = Util.cloneSet(set);
            if (objectName == null) {
                objectName = ObjectName.WILDCARD;
            }
            boolean bl = objectName.getDomain().equals("*");
            String string = objectName.getDomain();
            if (objectName.isDomainPattern()) {
                stringArray2 = this.parent.getKeys();
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = string;
            }
            for (String string2 : stringArray = stringArray2) {
                if (!bl && !Util.isDomainSelected(string2, string)) continue;
                try {
                    Object t = this.parent.getInterceptor(string2);
                    if (t == null) continue;
                    ObjectName objectName2 = objectName.withDomain(string2);
                    set2.addAll(queryInvoker.query((MBeanServer)t, objectName2, queryExp));
                }
                catch (Exception exception) {
                    LOG.finest("Ignoring exception when attempting to query namespace " + string2 + ": " + exception);
                }
            }
            return set2;
        }
    }
}

