/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ExpiringCache;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class UnixFileSystem
extends FileSystem {
    private final char slash;
    private final char colon;
    private final String javaHome;
    private ExpiringCache cache = new ExpiringCache();
    private ExpiringCache javaHomePrefixCache = new ExpiringCache();

    public UnixFileSystem() {
        this.slash = AccessController.doPrivileged(new GetPropertyAction("file.separator")).charAt(0);
        this.colon = AccessController.doPrivileged(new GetPropertyAction("path.separator")).charAt(0);
        this.javaHome = AccessController.doPrivileged(new GetPropertyAction("java.home"));
    }

    @Override
    public char getSeparator() {
        return this.slash;
    }

    @Override
    public char getPathSeparator() {
        return this.colon;
    }

    private String normalize(String string, int n, int n2) {
        int n3;
        if (n == 0) {
            return string;
        }
        for (n3 = n; n3 > 0 && string.charAt(n3 - 1) == '/'; --n3) {
        }
        if (n3 == 0) {
            return "/";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (n2 > 0) {
            stringBuffer.append(string.substring(0, n2));
        }
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            char c = string.charAt(i);
            if (n4 == 47 && c == '/') continue;
            stringBuffer.append(c);
            n4 = c;
        }
        return stringBuffer.toString();
    }

    @Override
    public String normalize(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (n2 == 47 && c == '/') {
                return this.normalize(string, n, i - 1);
            }
            n2 = c;
        }
        if (n2 == 47) {
            return this.normalize(string, n, n - 1);
        }
        return string;
    }

    @Override
    public int prefixLength(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return string.charAt(0) == '/' ? 1 : 0;
    }

    @Override
    public String resolve(String string, String string2) {
        if (string2.equals("")) {
            return string;
        }
        if (string2.charAt(0) == '/') {
            if (string.equals("/")) {
                return string2;
            }
            return string + string2;
        }
        if (string.equals("/")) {
            return string + string2;
        }
        return string + '/' + string2;
    }

    @Override
    public String getDefaultParent() {
        return "/";
    }

    @Override
    public String fromURIPath(String string) {
        String string2 = string;
        if (string2.endsWith("/") && string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Override
    public boolean isAbsolute(File file) {
        return file.getPrefixLength() != 0;
    }

    @Override
    public String resolve(File file) {
        if (this.isAbsolute(file)) {
            return file.getPath();
        }
        return this.resolve(System.getProperty("user.dir"), file.getPath());
    }

    @Override
    public String canonicalize(String string) throws IOException {
        if (!useCanonCaches) {
            return this.canonicalize0(string);
        }
        String string2 = this.cache.get(string);
        if (string2 == null) {
            Object object;
            String string3 = null;
            String string4 = null;
            if (useCanonPrefixCache && (string3 = UnixFileSystem.parentOrNull(string)) != null && (string4 = this.javaHomePrefixCache.get(string3)) != null) {
                object = string.substring(1 + string3.length());
                string2 = string4 + this.slash + (String)object;
                this.cache.put(string3 + this.slash + (String)object, string2);
            }
            if (string2 == null) {
                string2 = this.canonicalize0(string);
                this.cache.put(string, string2);
                if (useCanonPrefixCache && string3 != null && string3.startsWith(this.javaHome) && (string4 = UnixFileSystem.parentOrNull(string2)) != null && string4.equals(string3) && ((File)(object = new File(string2))).exists() && !((File)object).isDirectory()) {
                    this.javaHomePrefixCache.put(string3, string4);
                }
            }
        }
        assert (this.canonicalize0(string).equals(string2) || string.startsWith(this.javaHome));
        return string2;
    }

    private native String canonicalize0(String var1) throws IOException;

    static String parentOrNull(String string) {
        int n;
        if (string == null) {
            return null;
        }
        char c = File.separatorChar;
        int n2 = 0;
        int n3 = 0;
        for (int i = n = string.length() - 1; i > 0; --i) {
            char c2 = string.charAt(i);
            if (c2 == '.') {
                if (++n2 < 2) continue;
                return null;
            }
            if (c2 == c) {
                if (n2 == 1 && n3 == 0) {
                    return null;
                }
                if (i == 0 || i >= n - 1 || string.charAt(i - 1) == c) {
                    return null;
                }
                return string.substring(0, i);
            }
            ++n3;
            n2 = 0;
        }
        return null;
    }

    public native int getBooleanAttributes0(File var1);

    @Override
    public int getBooleanAttributes(File file) {
        int n = this.getBooleanAttributes0(file);
        String string = file.getName();
        boolean bl = string.length() > 0 && string.charAt(0) == '.';
        return n | (bl ? 8 : 0);
    }

    @Override
    public native boolean checkAccess(File var1, int var2);

    @Override
    public native long getLastModifiedTime(File var1);

    @Override
    public native long getLength(File var1);

    @Override
    public native boolean setPermission(File var1, int var2, boolean var3, boolean var4);

    @Override
    public native boolean createFileExclusively(String var1) throws IOException;

    @Override
    public boolean delete(File file) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        return this.delete0(file);
    }

    private native boolean delete0(File var1);

    @Override
    public native String[] list(File var1);

    @Override
    public native boolean createDirectory(File var1);

    @Override
    public boolean rename(File file, File file2) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        return this.rename0(file, file2);
    }

    private native boolean rename0(File var1, File var2);

    @Override
    public native boolean setLastModifiedTime(File var1, long var2);

    @Override
    public native boolean setReadOnly(File var1);

    @Override
    public File[] listRoots() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead("/");
            }
            return new File[]{new File("/")};
        }
        catch (SecurityException securityException) {
            return new File[0];
        }
    }

    @Override
    public native long getSpace(File var1, int var2);

    @Override
    public int compare(File file, File file2) {
        return file.getPath().compareTo(file2.getPath());
    }

    @Override
    public int hashCode(File file) {
        return file.getPath().hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static {
        UnixFileSystem.initIDs();
    }
}

