/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _TIMER_H_
#define _TIMER_H_

#include <sigc++/signal_system.h>
#if __GNUC__ > 2
#include <ext/slist>
#else
#include <slist>
#endif

namespace uta {

///
class Timer : public SigC::Object
{
 public:
  ///
  Timer(unsigned int mseconds);
  ///
  ~Timer();

  ///
  SigC::Signal0<void> alarm;
  ///
  SigC::Signal1<void, unsigned int> alarm1;

  ///
  void update(unsigned int now);

  ///
  void setInterval(unsigned int delta);

  ///
  void run();
  ///
  void halt();

  ///
  static void processAllTimers();
  
 protected:
  ///
  bool running_;
  ///
  unsigned int deltaT_;
  ///
  unsigned int theTime;
//#ifdef HAVE_GNU_CXX_SLIST
  ///
  //static __gnu_cxx::slist<Timer*> systemTimers;
//#else // HAVE_GNU_CXX_SLIST
  ///
  //static std::slist<Timer*> systemTimers;
//#endif // HAVE_GNU_CXX_SLIST

};

}

#endif
