/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.xml;

import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.Namespace;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementIterator
implements Iterator {
    private static Logger log = LoggerFactory.getLogger(ElementIterator.class);
    private final Namespace namespace;
    private final String localName;
    private Element next;

    public ElementIterator(Element parent, String localName, Namespace namespace) {
        this.localName = localName;
        this.namespace = namespace;
        this.seek(parent);
    }

    public ElementIterator(Element parent) {
        this(parent, null, null);
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove not implemented.");
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        return this.nextElement();
    }

    public Element nextElement() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Element ret = this.next;
        this.seek();
        return ret;
    }

    private void seek(Element parent) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!DomUtil.isElement(n) || !DomUtil.matches(n, this.localName, this.namespace)) continue;
            this.next = (Element)n;
            return;
        }
    }

    private void seek() {
        for (Node n = this.next.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (!DomUtil.isElement(n) || !DomUtil.matches(n, this.localName, this.namespace)) continue;
            this.next = (Element)n;
            return;
        }
        this.next = null;
    }
}

