/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : Point.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef POINT_H
#define POINT_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <cstdio>
#include <cstring>
#include <stdint.h>
#include <string>

using std::string;

namespace mhgui {

/*! 
 * Trivial class which stores a point in integer notation. 
 * This is supposed to be used by the GUI.
 */
 
class Point
{
public:
     Point (int32_t inX, int32_t inY);
     Point (const Point& inPoint);
    ~Point ();

    Point& operator= (const Point& inPoint) 
        { x = inPoint.x; y = inPoint.y; return *this;}

    bool operator== (const Point& inPoint) const;

    int32_t getX () const {return x;}
    int32_t getY () const {return y;}

    void moveBy (const Point& inPoint);

    const string dump() const;

/* ==========================================================================
 * Members
 * ========================================================================== */
private:
    int32_t    x, y;
/* ==========================================================================
 * Static Methods
 * ========================================================================== */
public:

/* ==========================================================================
 * Static Members
 * ========================================================================== */
public:
}; // class Point

/* ==========================================================================
 * Inlines & Templates
 * ========================================================================== */
/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline Point::Point (int32_t inX, int32_t inY)
: x(inX), y(inY) 
{
}

/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline Point::Point (const Point& inPoint)
: x(inPoint.x), y(inPoint.y) 
{
}

/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline Point::~Point ()
{
}

/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline bool Point::operator== (const Point& inPoint) const
{ 
    if (this == &inPoint)  // The same object?
        return true;

    return (x == inPoint.x && y == inPoint.y);
}

/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline void Point::moveBy (const Point& inPoint)
{
    x += inPoint.x; y += inPoint.y;
}

} //namespace mhgui

#endif // POINT_H
