/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml.editor;

import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.netbeans.editor.BaseDocument;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

public class RhtmlBracesMatcher
implements BracesMatcher {
    private final MatcherContext context;
    private final BracesMatcher delegate;

    RhtmlBracesMatcher(MatcherContext context) {
        this.context = context;
        this.delegate = BracesMatcherSupport.defaultMatcher((MatcherContext)context, (int)-1, (int)-1);
    }

    public int[] findOrigin() throws InterruptedException, BadLocationException {
        return this.delegate.findOrigin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            int limit;
            int matching;
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            int offset = this.context.getSearchOffset();
            char[] origin = doc.getChars(offset, 1);
            if (this.isRhtmlStartTag(doc, offset, origin)) {
                int limit2 = doc.getText().length();
                int matching2 = RhtmlBracesMatcher.matchChar((Document)doc, offset, limit2, '>');
                while (matching2 != -1 && doc.getChars(matching2 - 1, 1)[0] == '=') {
                    matching2 = RhtmlBracesMatcher.matchChar((Document)doc, matching2 + 1, limit2, '>');
                }
                int[] nArray = new int[]{matching2, matching2 + 1};
                return nArray;
            }
            if (this.isRhtmlEndTag(doc, offset, origin) && (matching = RhtmlBracesMatcher.matchChar((Document)doc, offset, limit = 0, '<')) != -1) {
                int[] nArray = new int[]{matching, matching + 1};
                return nArray;
            }
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
        return this.delegate.findMatches();
    }

    private boolean isRhtmlEndTag(BaseDocument doc, int offset, char[] origin) throws BadLocationException {
        char[] chars;
        if (offset == 0) {
            return false;
        }
        int length = doc.getText().length();
        if (length <= 1) {
            return false;
        }
        if (origin[0] == '%' && length >= offset + 1 && doc.getChars(offset + 1, 1)[0] == '>') {
            return true;
        }
        if (origin[0] == '>') {
            return doc.getChars(offset - 1, 1)[0] != '=';
        }
        if (length >= 3 && offset - 2 > 0 && (chars = doc.getChars(offset - 2, 3))[1] == '>') {
            return chars[0] == '%';
        }
        return false;
    }

    private boolean isRhtmlStartTag(BaseDocument doc, int offset, char[] origin) throws BadLocationException {
        int length = doc.getText().length();
        if (length < offset + 1) {
            return false;
        }
        if (origin[0] == '<' && length >= offset + 1 && doc.getChars(offset + 1, 1)[0] == '%') {
            return true;
        }
        if (origin[0] == '%' && offset - 1 > 0) {
            return doc.getChars(offset - 1, 1)[0] == '<';
        }
        return false;
    }

    private static int matchChar(Document document, int offset, int limit, char matching) throws BadLocationException {
        int lookahead;
        boolean backward = limit < offset;
        int n = lookahead = backward ? offset - limit : limit - offset;
        if (backward) {
            Segment text = new Segment();
            document.getText(offset - lookahead, lookahead, text);
            for (int i = lookahead - 1; i >= 0; --i) {
                if (MatcherContext.isTaskCanceled()) {
                    return -1;
                }
                if (matching != text.array[text.offset + i]) continue;
                return offset - (lookahead - i);
            }
        } else {
            Segment text = new Segment();
            document.getText(offset, lookahead, text);
            for (int i = 0; i < lookahead; ++i) {
                if (MatcherContext.isTaskCanceled()) {
                    return -1;
                }
                if (matching != text.array[text.offset + i]) continue;
                return offset + i;
            }
        }
        return -1;
    }
}

