/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTaskReader;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.InstalledFileLocator;
import org.openide.nodes.FilterNode;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public final class RakeSupport {
    private static final Logger LOGGER = Logger.getLogger(RakeSupport.class.getName());
    static final String RAKE_D_OUTPUT = "nbproject/private/rake-d.txt";
    static final String[] RAKEFILE_NAMES = new String[]{"rakefile", "Rakefile", "rakefile.rb", "Rakefile.rb"};
    private final Project project;

    public RakeSupport(Project project) {
        this.project = project;
    }

    public static FileObject findRakeFile(Project project) {
        FileObject pwd = project.getProjectDirectory();
        for (String s : RAKEFILE_NAMES) {
            FileObject f = pwd.getFileObject(s);
            if (f == null) continue;
            return f;
        }
        Sources src = ProjectUtils.getSources((Project)project);
        SourceGroup[] rubygroups = src.getSourceGroups("ruby");
        if (rubygroups != null && rubygroups.length > 0) {
            for (SourceGroup group : rubygroups) {
                FileObject f = group.getRootFolder();
                for (String s : RAKEFILE_NAMES) {
                    FileObject r = f.getFileObject(s);
                    if (r == null) continue;
                    return r;
                }
            }
        }
        return null;
    }

    public static boolean isMainRakeFile(FileObject fo) {
        for (String s : RAKEFILE_NAMES) {
            if (!s.equals(fo.getNameExt())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRakeFile(FileObject fo) {
        if (!fo.getMIMEType().equals("text/x-ruby")) {
            return false;
        }
        if (RakeSupport.isMainRakeFile(fo)) {
            return true;
        }
        return fo.getExt().equalsIgnoreCase("rake");
    }

    public static boolean isRakeFileSelected(Lookup context) {
        FileObject f;
        Collection lookupAll = context.lookupAll(DataObject.class);
        return lookupAll.size() == 1 && RakeSupport.isRakeFile(f = ((DataObject)lookupAll.iterator().next()).getPrimaryFile());
    }

    public static void refreshTasks(Project project) {
        RakeSupport.refreshTasks(project, true);
    }

    public static void refreshTasks(final Project project, boolean warn) {
        FileObject projectDir = project.getProjectDirectory();
        try {
            projectDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject rakeD = project.getProjectDirectory().getFileObject(RakeSupport.RAKE_D_OUTPUT);
                    if (rakeD != null && rakeD.isValid() && rakeD.isData()) {
                        rakeD.delete();
                    }
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        if (!RubyPlatform.hasValidRake((Project)project, (boolean)true)) {
            return;
        }
        String rakeOutput = RakeSupport.readRakeTasksOutput(project, warn);
        if (rakeOutput != null) {
            RakeSupport.writeRakeTasks(project, rakeOutput);
        }
    }

    private static String readRakeTasksOutput(Project project, boolean warn) {
        FileObject rakeFile = RakeSupport.findRakeFile(project);
        File pwd = rakeFile == null ? FileUtil.toFile((FileObject)project.getProjectDirectory()) : FileUtil.toFile((FileObject)rakeFile.getParent());
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        return RakeSupport.dumpRakeTasksInfo(platform, pwd, warn);
    }

    public static Set<RakeTask> getRakeTaskTree(Project project) {
        return RakeSupport.getRakeTaskTree(project, true);
    }

    public static Set<RakeTask> getRakeTaskTree(Project project, boolean withDescriptionOnly) {
        RakeTaskReader rtreader = new RakeTaskReader(project);
        return rtreader.getRakeTaskTree(withDescriptionOnly);
    }

    static Set<RakeTask> getRakeTasks(Project project) {
        return RakeSupport.getRakeTasks(project, true);
    }

    static Set<RakeTask> getRakeTasks(Project project, boolean withDescriptionOnly) {
        Set<RakeTask> taskTree = RakeSupport.getRakeTaskTree(project, withDescriptionOnly);
        TreeSet<RakeTask> tasks = new TreeSet<RakeTask>();
        RakeSupport.addTasks(tasks, taskTree);
        return tasks;
    }

    private static void addTasks(Set<RakeTask> flatAccumulator, Set<RakeTask> taskTree) {
        for (RakeTask task : taskTree) {
            if (task.isNameSpace()) {
                RakeSupport.addTasks(flatAccumulator, task.getChildren());
                continue;
            }
            flatAccumulator.add(task);
        }
    }

    public static RakeTask getRakeTask(Project project, String task) {
        Set<RakeTask> tasks = RakeSupport.getRakeTasks(project, false);
        for (RakeTask rakeTask : tasks) {
            if (!rakeTask.getTask().equals(task)) continue;
            return rakeTask;
        }
        return null;
    }

    private static String dumpRakeTasksInfo(RubyPlatform platform, File pwd, boolean warn) {
        ArrayList<String> argList = new ArrayList<String>();
        File cmd = platform.getInterpreterFile();
        if (!cmd.getName().startsWith("jruby") || ExecutionUtils.launchJRubyScript()) {
            argList.add(cmd.getPath());
        }
        argList.addAll(ExecutionUtils.getRubyArgs((RubyPlatform)platform));
        File rakeTaskInfoScript = InstalledFileLocator.getDefault().locate("rake_tasks_info.rb", "org.netbeans.modules.ruby.project", false);
        if (rakeTaskInfoScript == null) {
            throw new IllegalStateException("Cannot locate rake_tasks_info.rb script");
        }
        argList.add(rakeTaskInfoScript.getAbsolutePath());
        String[] args = argList.toArray(new String[argList.size()]);
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(pwd);
        pb.redirectErrorStream(false);
        ExecutionUtils.setupProcessEnvironment(pb.environment(), (String)cmd.getParent(), (boolean)false);
        GemManager.adjustEnvironment((RubyPlatform)platform, pb.environment());
        int exitCode = -1;
        String stdout = null;
        try {
            ExecutionUtils.logProcess((ProcessBuilder)pb);
            Process process = pb.start();
            stdout = RakeSupport.readInputStream(process.getInputStream(), false);
            String stderr = RakeSupport.readInputStream(process.getErrorStream(), true);
            exitCode = process.waitFor();
            if (warn && exitCode != 0) {
                LOGGER.severe("rake process failed (workdir: " + pwd + "):\nstdout:\n\n" + stdout + "stderr:\n" + stderr);
                Util.notifyLocalized(RakeSupport.class, (String)"RakeSupport.rake.task.fetching.fails", (int)0, (Object[])new Object[]{pwd, stderr});
                return null;
            }
            if (stderr.length() > 0) {
                LOGGER.warning("rake process warnings:\n\n" + stderr);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        catch (InterruptedException ie) {
            Exceptions.printStackTrace((Throwable)ie);
        }
        return stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInputStream(InputStream is, boolean readingErrors) {
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (!readingErrors && !line.contains("=")) continue;
                sb.append(line);
                sb.append('\n');
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return sb.toString();
    }

    static void writeRakeTasks(Project project, final String rakeDOutput) {
        final FileObject projectDir = project.getProjectDirectory();
        try {
            projectDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject rakeTasksFile = projectDir.getFileObject(RakeSupport.RAKE_D_OUTPUT);
                    if (rakeTasksFile != null) {
                        rakeTasksFile.delete();
                    }
                    rakeTasksFile = FileUtil.createData((FileObject)projectDir, (String)RakeSupport.RAKE_D_OUTPUT);
                    OutputStream os = rakeTasksFile.getOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
                    try {
                        writer.write(rakeDOutput);
                    }
                    finally {
                        ((Writer)writer).close();
                    }
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public static final class RakeNode
    extends FilterNode {
        private Action[] actions;

        public RakeNode(FileObject rakeFO) throws DataObjectNotFoundException {
            super(DataObject.find((FileObject)rakeFO).getNodeDelegate());
        }

        public Action[] getActions(boolean context) {
            if (this.actions == null) {
                this.actions = new Action[]{SystemAction.get(OpenAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return this.actions;
        }
    }
}

