/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class DVarNode
extends Node
implements INameNode {
    private String name;
    private int location;

    public DVarNode(ISourcePosition position, int location, String name) {
        super(position, NodeType.DVARNODE);
        this.location = location;
        this.name = name;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDVarNode(this);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject obj = context.getCurrentScope().getValue(this.getIndex(), this.getDepth());
        return obj == null ? runtime.getNil() : obj;
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return "local-variable(in-block)";
    }
}

