/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.socket;

import com.sun.jna.ptr.IntByReference;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.socket.RubyUNIXSocket;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"UNIXServer"}, parent="UNIXSocket")
public class RubyUNIXServer
extends RubyUNIXSocket {
    private static ObjectAllocator UNIXSERVER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUNIXServer(runtime, klass);
        }
    };

    static void createUNIXServer(Ruby runtime) {
        RubyClass rb_cUNIXServer = runtime.defineClass("UNIXServer", runtime.fastGetClass("UNIXSocket"), UNIXSERVER_ALLOCATOR);
        runtime.getObject().fastSetConstant("UNIXserver", rb_cUNIXServer);
        rb_cUNIXServer.defineAnnotatedMethods(RubyUNIXServer.class);
    }

    public RubyUNIXServer(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject path) throws Exception {
        this.init_unixsock(path, true);
        return this;
    }

    @JRubyMethod
    public IRubyObject accept() throws Exception {
        RubyUNIXSocket.LibCSocket.sockaddr_un from = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        int fd2 = INSTANCE.accept(this.fd, from, new IntByReference(106));
        if (fd2 < 0) {
            this.rb_sys_fail(null);
        }
        Ruby runtime = this.getRuntime();
        RubyUNIXSocket sock = (RubyUNIXSocket)RuntimeHelpers.invoke(runtime.getCurrentContext(), runtime.fastGetClass("UNIXSocket"), "allocate");
        sock.fd = fd2;
        sock.fpath = new String(from.sun_path);
        sock.init_sock();
        return sock;
    }

    @JRubyMethod
    public IRubyObject accept_nonblock() throws Exception {
        RubyUNIXSocket.LibCSocket.sockaddr_un from = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        IntByReference fromlen = new IntByReference(106);
        int flags = INSTANCE.fcntl(this.fd, 3, 0);
        INSTANCE.fcntl(this.fd, 4, flags | 4);
        int fd2 = INSTANCE.accept(this.fd, from, new IntByReference(106));
        if (fd2 < 0) {
            this.rb_sys_fail(null);
        }
        Ruby runtime = this.getRuntime();
        RubyUNIXSocket sock = (RubyUNIXSocket)RuntimeHelpers.invoke(runtime.getCurrentContext(), runtime.fastGetClass("UNIXSocket"), "allocate");
        sock.fd = fd2;
        sock.fpath = new String(from.sun_path);
        sock.init_sock();
        return sock;
    }

    @JRubyMethod
    public IRubyObject sysaccept() throws Exception {
        return this.accept();
    }

    @JRubyMethod
    public IRubyObject listen(IRubyObject log) {
        if (INSTANCE.listen(this.fd, RubyNumeric.fix2int(log)) < 0) {
            this.rb_sys_fail("listen(2)");
        }
        return this.getRuntime().newFixnum(0);
    }
}

