/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modeldiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.PkgConfigManager;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.modeldiscovery.provider.ModelSource;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AnalyzeModel
implements DiscoveryProvider {
    private Map<String, ProviderProperty> myProperties = new HashMap<String, ProviderProperty>();
    public static final String MODEL_FOLDER_KEY = "folder";
    public static final String PREFER_LOCAL_FILES = "prefer-local";
    protected boolean isStoped = false;

    public AnalyzeModel() {
        this.clean();
    }

    public void clean() {
        this.myProperties.clear();
        this.myProperties.put(MODEL_FOLDER_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeModel.i18n("Model_Files_Name");
            }

            public String getDescription() {
                return AnalyzeModel.i18n("Model_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.Folder;
            }
        });
        this.myProperties.put(PREFER_LOCAL_FILES, new ProviderProperty(){
            private Boolean myValue = Boolean.FALSE;

            public String getName() {
                return AnalyzeModel.i18n("Prefer_Local_Files");
            }

            public String getDescription() {
                return AnalyzeModel.i18n("Prefer_Local_Files_Description");
            }

            public Object getValue() {
                return this.myValue;
            }

            public void setValue(Object object) {
                if (object instanceof Boolean) {
                    this.myValue = (Boolean)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.Boolean;
            }
        });
    }

    public String getID() {
        return "model-folder";
    }

    public String getName() {
        return AnalyzeModel.i18n("Model_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeModel.i18n("Model_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String string) {
        return this.myProperties.get(string);
    }

    public void stop() {
        this.isStoped = true;
    }

    public List<org.netbeans.modules.cnd.discovery.api.Configuration> analyze(ProjectProxy projectProxy, Progress progress) {
        this.isStoped = false;
        MyConfiguration myConfiguration = new MyConfiguration(projectProxy, progress);
        ArrayList<org.netbeans.modules.cnd.discovery.api.Configuration> arrayList = new ArrayList<org.netbeans.modules.cnd.discovery.api.Configuration>();
        arrayList.add(myConfiguration);
        return arrayList;
    }

    private Map<String, List<String>> search(String string) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        Object object2 = arrayList.iterator();
        while (object2.hasNext() && !this.isStoped) {
            object = new File((String)object2.next());
            this.gatherSubFolders((File)object, hashSet);
        }
        object2 = new HashMap();
        object = hashSet.iterator();
        while (object.hasNext() && !this.isStoped) {
            File file = new File((String)object.next());
            if (!file.exists() || !file.isDirectory() || !file.canRead()) continue;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                ArrayList<String> arrayList2 = (ArrayList<String>)((HashMap)object2).get(fileArray[i].getName());
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<String>();
                    ((HashMap)object2).put(fileArray[i].getName(), arrayList2);
                }
                String string2 = fileArray[i].getAbsolutePath();
                if (Utilities.isWindows()) {
                    string2 = string2.replace('\\', '/');
                }
                arrayList2.add(string2);
            }
        }
        return object2;
    }

    private void gatherSubFolders(File file, HashSet<String> hashSet) {
        if (this.isStoped) {
            return;
        }
        if (file.exists() && file.isDirectory() && file.canRead()) {
            if (DiscoveryUtils.ignoreFolder((File)file)) {
                return;
            }
            String string = file.getAbsolutePath();
            if (Utilities.isWindows()) {
                string = string.replace('\\', '/');
            }
            if (!hashSet.contains(string)) {
                hashSet.add(string);
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.gatherSubFolders(fileArray[i], hashSet);
                }
            }
        }
    }

    private static String i18n(String string) {
        return NbBundle.getMessage(AnalyzeModel.class, (String)string);
    }

    public boolean isApplicable(ProjectProxy projectProxy) {
        CsmProject csmProject;
        Project project;
        ConfigurationDescriptorProvider configurationDescriptorProvider;
        return projectProxy.getProject() != null && (configurationDescriptorProvider = (ConfigurationDescriptorProvider)(project = projectProxy.getProject()).getLookup().lookup(ConfigurationDescriptorProvider.class)).gotDescriptor() && (csmProject = CsmModelAccessor.getModel().getProject((Object)project)) != null;
    }

    public int canAnalyze(ProjectProxy projectProxy) {
        return 40;
    }

    private class MyConfiguration
    implements org.netbeans.modules.cnd.discovery.api.Configuration {
        private List<SourceFileProperties> myFileProperties;
        private List<String> myIncludedFiles;
        private MakeConfigurationDescriptor makeConfigurationDescriptor;
        private CsmProject langProject;
        private Progress progress;

        private MyConfiguration(ProjectProxy projectProxy, Progress progress) {
            Project project = projectProxy.getProject();
            this.progress = progress;
            this.langProject = CsmModelAccessor.getModel().getProject((Object)project);
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            this.makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        }

        public List<ProjectProperties> getProjectConfiguration() {
            return ProjectImpl.divideByLanguage(this.getSourcesConfiguration());
        }

        public List<org.netbeans.modules.cnd.discovery.api.Configuration> getDependencies() {
            return null;
        }

        public boolean isExcluded(Item item) {
            MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
            ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
            if (itemConfiguration == null) {
                return true;
            }
            BooleanConfiguration booleanConfiguration = itemConfiguration.getExcluded();
            return booleanConfiguration.getValue();
        }

        private List<SourceFileProperties> getSourceFileProperties(String string) {
            String string2;
            Item item;
            int n;
            ArrayList<SourceFileProperties> arrayList = new ArrayList<SourceFileProperties>();
            Map map = AnalyzeModel.this.search(string);
            PkgConfigManager.PkgConfig pkgConfig = PkgConfigManager.getDefault().getPkgConfig(this.makeConfigurationDescriptor.getActiveConfiguration());
            boolean bl = (Boolean)AnalyzeModel.this.getProperty(AnalyzeModel.PREFER_LOCAL_FILES).getValue();
            Item[] itemArray = this.makeConfigurationDescriptor.getProjectItems();
            HashMap<String, Item> hashMap = new HashMap<String, Item>();
            for (n = 0; n < itemArray.length && !AnalyzeModel.this.isStoped; ++n) {
                item = itemArray[n];
                string2 = item.getNormalizedFile().getAbsolutePath();
                hashMap.put(string2, item);
            }
            for (n = 0; n < itemArray.length && !AnalyzeModel.this.isStoped; ++n) {
                item = itemArray[n];
                if (this.isExcluded(item) || (string2 = item.getLanguage()) != NativeFileItem.Language.C && string2 != NativeFileItem.Language.CPP) continue;
                CsmFile csmFile = this.langProject.findFile((Object)item, false);
                ModelSource modelSource = new ModelSource(item, csmFile, map, hashMap, pkgConfig, bl);
                arrayList.add(modelSource);
            }
            return arrayList;
        }

        public List<SourceFileProperties> getSourcesConfiguration() {
            if (this.myFileProperties == null) {
                this.myFileProperties = this.getSourceFileProperties((String)AnalyzeModel.this.getProperty(AnalyzeModel.MODEL_FOLDER_KEY).getValue());
            }
            return this.myFileProperties;
        }

        public List<String> getIncludedFiles() {
            if (this.myIncludedFiles == null) {
                File file;
                HashSet<String> hashSet = new HashSet<String>();
                Item[] itemArray = this.makeConfigurationDescriptor.getProjectItems();
                if (this.progress != null) {
                    this.progress.start(itemArray.length);
                }
                for (int i = 0; i < itemArray.length && !AnalyzeModel.this.isStoped; ++i) {
                    String string;
                    Item item = itemArray[i];
                    if (this.isExcluded(item) || !CndFileUtils.exists((File)(file = new File(string = item.getAbsPath())))) continue;
                    hashSet.add(CndFileUtils.normalizeAbsolutePath((String)file.getAbsolutePath()));
                }
                HashSet<String> hashSet2 = new HashSet<String>();
                for (SourceFileProperties sourceFileProperties : this.getSourcesConfiguration()) {
                    if (sourceFileProperties instanceof ModelSource) {
                        hashSet2.addAll(((ModelSource)sourceFileProperties).getIncludedFiles());
                    }
                    if (this.progress == null) continue;
                    this.progress.increment();
                }
                for (String string : hashSet2) {
                    file = new File(string);
                    if (!CndFileUtils.exists((File)file)) continue;
                    hashSet.add(CndFileUtils.normalizeAbsolutePath((String)file.getAbsolutePath()));
                }
                this.myIncludedFiles = new ArrayList<String>(hashSet);
                if (this.progress != null) {
                    this.progress.done();
                }
            }
            return this.myIncludedFiles;
        }
    }
}

