/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws.glassfish.v2;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

public class GlassFishV2JaxWsStack
implements WSStackImplementation<JaxWs> {
    private static final String WEBSERVICES_TOOLS_JAR = "lib/webservices-tools.jar";
    private static final String WEBSERVICES_RT_JAR = "lib/webservices-rt.jar";
    private static final String TOOLS_JAR = "lib/tools.jar";
    private static final String JSTL_JAR = "lib/appserv-jstl.jar";
    private static final String JAVA_EE_JAR = "lib/javaee.jar";
    private static final String APPSERV_WS_JAR = "lib/appserv-ws.jar";
    private static final String MAIL_JAR = "lib/mail.jar";
    private static final String ACTIVATION_JAR = "lib/activation.jar";
    private File root;
    private String version;
    private JaxWs jaxWs;

    public GlassFishV2JaxWsStack(File root) {
        this.root = root;
        try {
            this.version = this.resolveImplementationVersion();
            if (this.version == null) {
                this.version = "2.1.3";
            }
        }
        catch (IOException ex) {
            this.version = "2.1.3";
        }
        this.jaxWs = new JaxWs(this.getUriDescriptor());
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        return WSStackFactory.createWSStackVersion((String)this.version);
    }

    public WSTool getWSTool(WSStack.Tool toolId) {
        if (toolId == JaxWs.Tool.WSIMPORT) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (toolId == JaxWs.Tool.WSGEN) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    private JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            @Override
            public String getServiceUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                if (isEjb) {
                    return serviceName + "/" + portName;
                }
                return applicationRoot + "/" + serviceName;
            }

            @Override
            public String getDescriptorUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return this.getServiceUri(applicationRoot, serviceName, portName, isEjb) + "?wsdl";
            }

            @Override
            public String getTesterPageUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return this.getServiceUri(applicationRoot, serviceName, portName, isEjb) + "?Tester";
            }
        };
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        return feature == JaxWs.Feature.JSR109 || feature == JaxWs.Feature.SERVICE_REF_INJECTION || feature == JaxWs.Feature.TESTER_PAGE || feature == JaxWs.Feature.WSIT;
    }

    private String resolveImplementationVersion() throws IOException {
        JarFile jarFile;
        JarEntry entry;
        File wsToolsJar = new File(this.root, WEBSERVICES_TOOLS_JAR);
        if (!wsToolsJar.exists()) {
            wsToolsJar = new File(this.root, APPSERV_WS_JAR);
        }
        if (wsToolsJar.exists() && (entry = (jarFile = new JarFile(wsToolsJar)).getJarEntry("com/sun/tools/ws/version.properties")) != null) {
            InputStream is = jarFile.getInputStream(entry);
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            String ln = null;
            String ver = null;
            while ((ln = r.readLine()) != null) {
                String line = ln.trim();
                if (!line.startsWith("major-version=")) continue;
                ver = line.substring(14);
            }
            r.close();
            return ver;
        }
        return null;
    }

    private class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            File wsToolsJar = new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.WEBSERVICES_TOOLS_JAR);
            try {
                if (wsToolsJar.exists()) {
                    return new URL[]{wsToolsJar.toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.WEBSERVICES_RT_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.TOOLS_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.JSTL_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.JAVA_EE_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.APPSERV_WS_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.MAIL_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.ACTIVATION_JAR).toURI().toURL()};
                }
                return new URL[]{new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.TOOLS_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.JSTL_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.JAVA_EE_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.APPSERV_WS_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.MAIL_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.ACTIVATION_JAR).toURI().toURL()};
            }
            catch (MalformedURLException ex) {
                return new URL[0];
            }
        }
    }
}

