/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws.tomcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

public class TomcatJaxWsStack
implements WSStackImplementation<JaxWs> {
    private static final String[] SHARED_METRO_LIBS = new String[]{"shared/lib/webservices-rt.jar", "shared/lib/webservices-tools.jar"};
    private static final String[] GLOBAL_METRO_LIBS = new String[]{"lib/webservices-rt.jar", "lib/webservices-tools.jar"};
    private int TOOLS_JAR_INDEX = 1;
    private static final String KEYSTORE_LOCATION = "certs/server-keystore.jks";
    private static final String TRUSTSTORE_LOCATION = "certs/server-truststore.jks";
    private static final String KEYSTORE_CLIENT_LOCATION = "certs/client-keystore.jks";
    private static final String TRUSTSTORE_CLIENT_LOCATION = "certs/client-truststore.jks";
    private File catalinaHome;
    private String version;
    private JaxWs jaxWs;

    public TomcatJaxWsStack(File catalinaHome) {
        this.catalinaHome = catalinaHome;
        try {
            this.version = this.resolveImplementationVersion();
            if (this.version == null) {
                this.version = "2.1.4";
            }
        }
        catch (IOException ex) {
            this.version = "2.1.4";
        }
        this.jaxWs = new JaxWs(this.getUriDescriptor());
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        return WSStackFactory.createWSStackVersion((String)this.version);
    }

    public WSTool getWSTool(WSStack.Tool toolId) {
        if (toolId == JaxWs.Tool.WSIMPORT && this.isWsit()) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (toolId == JaxWs.Tool.WSGEN && this.isWsit()) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        if (feature == JaxWs.Feature.TESTER_PAGE) {
            return true;
        }
        if (feature == JaxWs.Feature.WSIT) {
            return this.isWsit();
        }
        return false;
    }

    private boolean isWsit() {
        return this.isWsit(true) || this.isWsit(false);
    }

    private boolean isWsit(boolean shared) {
        String[] libList = shared ? SHARED_METRO_LIBS : GLOBAL_METRO_LIBS;
        boolean wsit = true;
        for (int i = 0; i < libList.length; ++i) {
            if (new File(this.catalinaHome, libList[i]).exists()) continue;
            wsit = false;
        }
        return wsit;
    }

    private String[] getDetectedMetroLibs() {
        return this.isWsit(false) ? GLOBAL_METRO_LIBS : SHARED_METRO_LIBS;
    }

    private boolean isKeystore() {
        return new File(this.catalinaHome, KEYSTORE_LOCATION).exists();
    }

    private boolean isKeystoreClient() {
        return new File(this.catalinaHome, KEYSTORE_CLIENT_LOCATION).exists();
    }

    private boolean isTruststore() {
        return new File(this.catalinaHome, TRUSTSTORE_LOCATION).exists();
    }

    private boolean isTruststoreClient() {
        return new File(this.catalinaHome, TRUSTSTORE_CLIENT_LOCATION).exists();
    }

    private String resolveImplementationVersion() throws IOException {
        JarFile jarFile;
        JarEntry entry;
        String[] metroLibs = this.getDetectedMetroLibs();
        File wsToolsJar = new File(this.catalinaHome, metroLibs[this.TOOLS_JAR_INDEX]);
        if (wsToolsJar.exists() && (entry = (jarFile = new JarFile(wsToolsJar)).getJarEntry("com/sun/tools/ws/version.properties")) != null) {
            InputStream is = jarFile.getInputStream(entry);
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            String ln = null;
            String ver = null;
            while ((ln = r.readLine()) != null) {
                String line = ln.trim();
                if (!line.startsWith("major-version=")) continue;
                ver = line.substring(14);
            }
            r.close();
            return ver;
        }
        return null;
    }

    private JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            @Override
            public String getServiceUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return applicationRoot + "/" + serviceName;
            }

            @Override
            public String getDescriptorUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return this.getServiceUri(applicationRoot, serviceName, portName, isEjb) + "?wsdl";
            }

            @Override
            public String getTesterPageUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return applicationRoot + "/" + serviceName;
            }
        };
    }

    private class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            String[] metroLibs = TomcatJaxWsStack.this.getDetectedMetroLibs();
            URL[] retValue = new URL[metroLibs.length];
            try {
                for (int i = 0; i < metroLibs.length; ++i) {
                    retValue[i] = new File(TomcatJaxWsStack.this.catalinaHome, metroLibs[i]).toURI().toURL();
                }
                return retValue;
            }
            catch (MalformedURLException ex) {
                return new URL[0];
            }
        }
    }
}

