/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.SelectAction;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGLocatableElement;

public final class SelectActionFactory
extends AbstractComposerActionFactory
implements SceneManager.SelectionListener {
    private final AbstractSVGAction m_navigateBackAction = new AbstractSVGAction("svg_prev_sel", false){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SelectActionFactory.this.m_selectionHistoryIndex > 0) {
                String[] selection = (String[])SelectActionFactory.this.m_selectionHistory.get(--SelectActionFactory.this.m_selectionHistoryIndex);
                SelectActionFactory.this.m_sceneMgr.setSelection(selection[0], false);
                SelectActionFactory.this.updateSelectionHistoryButtons();
            }
        }
    };
    private final AbstractSVGAction m_navigateForwardAction = new AbstractSVGAction("svg_next_sel", false, 1){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SelectActionFactory.this.m_selectionHistoryIndex < SelectActionFactory.this.m_selectionHistory.size() - 1) {
                String[] selection = (String[])SelectActionFactory.this.m_selectionHistory.get(++SelectActionFactory.this.m_selectionHistoryIndex);
                SelectActionFactory.this.m_sceneMgr.setSelection(selection[0], false);
                SelectActionFactory.this.updateSelectionHistoryButtons();
            }
        }
    };
    private final AbstractSVGAction m_navigateUpAction = new AbstractSVGAction("svg_parent_sel", false, 2){

        @Override
        public void actionPerformed(ActionEvent e) {
            SVGObject[] selected = SelectActionFactory.this.m_sceneMgr.getSelected();
            if (selected != null && selected.length > 0) {
                Node parent;
                assert (selected[0] != null);
                SVGLocatableElement elem = selected[0].getSVGElement();
                assert (elem != null);
                for (parent = elem.getParentNode(); parent != null && !(parent instanceof SVGLocatableElement); parent = parent.getParentNode()) {
                }
                if (parent != null) {
                    String elemId = ((SVGLocatableElement)parent).getId();
                    SelectActionFactory.this.m_sceneMgr.setSelection(elemId, false);
                    SelectActionFactory.this.updateSelectionHistory(elemId);
                }
            }
        }
    };
    private final List<String[]> m_selectionHistory = new ArrayList<String[]>();
    private int m_selectionHistoryIndex = -1;
    private SelectAction m_activeAction;

    public SelectActionFactory(SceneManager sceneMgr) {
        super(sceneMgr);
    }

    public static MouseEvent getSelectionEvent(AWTEvent evt) {
        MouseEvent me;
        if (evt.getID() == 500 && (me = (MouseEvent)evt).getButton() == 1 && me.getClickCount() > 0) {
            return me;
        }
        return null;
    }

    public synchronized ComposerAction startAction(SVGObject selected) {
        return this.setActiveAction(new SelectAction(this, selected));
    }

    @Override
    public synchronized ComposerAction startAction(AWTEvent e, boolean isOutsideEvent) {
        SVGObject[] objects;
        MouseEvent me;
        if (!isOutsideEvent && (me = SelectActionFactory.getSelectionEvent(e)) != null && (objects = this.m_sceneMgr.getPerseusController().getObjectsAt(me.getX(), me.getY())) != null && objects.length > 0) {
            SVGDataObject dObj;
            DocumentElement delem;
            String id = objects[0].getElementId();
            if (me.getClickCount() > 1 && (delem = (dObj = this.m_sceneMgr.getDataObject()).getModel().getElementById(id)) != null) {
                SVGSourceMultiViewElement.selectElement(dObj, delem.getStartOffset(), true);
            }
            this.updateSelectionHistory(id);
            return this.setActiveAction(new SelectAction(this, objects[0]));
        }
        return null;
    }

    public SelectAction getActiveAction() {
        if (this.m_activeAction != null && !this.m_activeAction.isCompleted()) {
            return this.m_activeAction;
        }
        return null;
    }

    @Override
    public Action[] getMenuActions() {
        return new Action[]{this.m_navigateBackAction, this.m_navigateForwardAction, this.m_navigateUpAction};
    }

    @Override
    public void selectionChanged(SVGObject[] newSelection, SVGObject[] oldSelection, boolean isReadOnly) {
        Node parent;
        boolean navigationUpEnabled = false;
        if (!this.m_sceneMgr.isReadOnly() && newSelection != null && newSelection.length > 0 && (parent = newSelection[0].getSVGElement().getParentNode()) != null) {
            navigationUpEnabled = true;
        }
        this.m_navigateUpAction.setEnabled(navigationUpEnabled);
        this.updateSelectionHistoryButtons();
    }

    private SelectAction setActiveAction(SelectAction active) {
        if (this.m_activeAction != null) {
            this.m_activeAction.actionCompleted();
        }
        this.m_activeAction = active;
        return active;
    }

    private void updateSelectionHistory(String elemId) {
        String[] selectedIds = new String[]{elemId};
        for (int i = this.m_selectionHistory.size() - 1; i > this.m_selectionHistoryIndex; --i) {
            this.m_selectionHistory.remove(i);
        }
        this.m_selectionHistoryIndex = this.m_selectionHistory.size();
        this.m_selectionHistory.add(selectedIds);
        this.updateSelectionHistoryButtons();
    }

    private void updateSelectionHistoryButtons() {
        this.m_navigateBackAction.setEnabled(!this.m_sceneMgr.isReadOnly() && this.m_selectionHistoryIndex > 0);
        this.m_navigateForwardAction.setEnabled(!this.m_sceneMgr.isReadOnly() && this.m_selectionHistoryIndex < this.m_selectionHistory.size() - 1);
    }
}

