/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.ReorderableTreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class WatchesTreeModel
implements ReorderableTreeModel {
    private Listener listener;
    private Vector listeners = new Vector();
    private final EmptyWatch EMPTY_WATCH = new EmptyWatch();

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Watch[] wsTemp = DebuggerManager.getDebuggerManager().getWatches();
            Object[] ws = new Object[wsTemp.length + 1];
            System.arraycopy(wsTemp, 0, ws, 0, wsTemp.length);
            ws[ws.length - 1] = this.EMPTY_WATCH;
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            to = Math.min(ws.length, to);
            from = Math.min(ws.length, from);
            Object[] fws = new Object[to - from];
            System.arraycopy(ws, from, fws, 0, to - from);
            return fws;
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Watch) {
            return true;
        }
        if (node instanceof EmptyWatch) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public boolean canReorder(Object parent) throws UnknownTypeException {
        return parent == "Root";
    }

    public void reorder(Object parent, int[] perm) throws UnknownTypeException {
        if (parent != "Root") {
            throw new UnknownTypeException(parent);
        }
        int numWatches = DebuggerManager.getDebuggerManager().getWatches().length;
        perm = WatchesTreeModel.resizePermutation(perm, numWatches);
        DebuggerManager.getDebuggerManager().reorderWatches(perm);
    }

    private static int[] resizePermutation(int[] perm, int size) {
        if (size == perm.length) {
            return perm;
        }
        int[] nperm = new int[size];
        if (size < perm.length) {
            int j = 0;
            for (int i = 0; i < perm.length; ++i) {
                int p = perm[i];
                if (p >= size) continue;
                nperm[j++] = p;
            }
        } else {
            System.arraycopy(perm, 0, nperm, 0, perm.length);
            for (int i = perm.length; i < size; ++i) {
                nperm[i] = i;
            }
        }
        return nperm;
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8));
        }
    }

    void fireWatchPropertyChanged(Watch b, String propertyName) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)b));
        }
    }

    class EmptyWatch {
        EmptyWatch() {
        }

        public void setExpression(String expr) {
            String infoStr = NbBundle.getBundle(WatchesTreeModel.class).getString("CTL_WatchesModel_Empty_Watch_Hint");
            infoStr = "<" + infoStr + ">";
            if (expr == null || expr.trim().length() == 0 || infoStr.equals(expr)) {
                return;
            }
            DebuggerManager.getDebuggerManager().createWatch(expr);
            Vector v = (Vector)WatchesTreeModel.this.listeners.clone();
            int k = v.size();
            for (int i = 0; i < k; ++i) {
                ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)WatchesTreeModel.this, (Object)this));
            }
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference model;

        public Listener(WatchesTreeModel tm) {
            this.model = new WeakReference<WatchesTreeModel>(tm);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesTreeModel getModel() {
            WatchesTreeModel m = (WatchesTreeModel)this.model.get();
            if (m == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
                Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
                int k = ws.length;
                for (int i = 0; i < k; ++i) {
                    ws[i].removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return m;
        }

        public void watchAdded(Watch watch) {
            WatchesTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            WatchesTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            if (!(evt.getSource() instanceof Watch)) {
                return;
            }
            Watch w = (Watch)evt.getSource();
            m.fireWatchPropertyChanged(w, evt.getPropertyName());
        }
    }
}

