/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.Message;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;
import org.rubyforge.debugcommons.reader.BreakpointAddedReader;
import org.rubyforge.debugcommons.reader.BreakpointDeletedReader;
import org.rubyforge.debugcommons.reader.CatchpointSetReader;
import org.rubyforge.debugcommons.reader.ConditionSetReader;
import org.rubyforge.debugcommons.reader.ErrorReader;
import org.rubyforge.debugcommons.reader.FramesReader;
import org.rubyforge.debugcommons.reader.SuspensionReader;
import org.rubyforge.debugcommons.reader.ThreadInfoReader;
import org.rubyforge.debugcommons.reader.VariablesReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReadersSupport {
    private static final Logger LOGGER = Logger.getLogger(ReadersSupport.class.getName());
    private static final String BREAKPOINT_ELEMENT = "breakpoint";
    private static final String SUSPENDED_ELEMENT = "suspended";
    private static final String EXCEPTION_ELEMENT = "exception";
    private static final String BREAKPOINT_ADDED_ELEMENT = "breakpointAdded";
    private static final String BREAKPOINT_DELETED_ELEMENT = "breakpointDeleted";
    private static final String CONDITION_SET_ELEMENT = "conditionSet";
    private static final String CATCHPOINT_SET_ELEMENT = "catchpointSet";
    private static final String THREADS_ELEMENT = "threads";
    private static final String FRAMES_ELEMENT = "frames";
    private static final String VARIABLES_ELEMENT = "variables";
    private static final String PROCESSING_EXCEPTION_ELEMENT = "processingException";
    private static final String RUBY_DEBUG_PROMPT = "PROMPT";
    private static final String FINISHED = "finished";
    private final long timeout;
    private final BlockingQueue<RubyThreadInfo[]> threads;
    private final BlockingQueue<RubyFrameInfo[]> frames;
    private final BlockingQueue<RubyVariableInfo[]> variables;
    private final BlockingQueue<SuspensionPoint> suspensions;
    private final BlockingQueue<Integer> addedBreakpoints;
    private final BlockingQueue<Integer> removedBreakpoints;
    private final BlockingQueue<Integer> conditionSets;
    private final BlockingQueue<String> catchpointSets;
    private boolean finished;
    private boolean unexpectedFail;

    ReadersSupport(long timeout) {
        this.timeout = timeout;
        this.threads = new LinkedBlockingQueue<RubyThreadInfo[]>();
        this.frames = new LinkedBlockingQueue<RubyFrameInfo[]>();
        this.variables = new LinkedBlockingQueue<RubyVariableInfo[]>();
        this.suspensions = new LinkedBlockingQueue<SuspensionPoint>();
        this.addedBreakpoints = new LinkedBlockingQueue<Integer>();
        this.removedBreakpoints = new LinkedBlockingQueue<Integer>();
        this.conditionSets = new LinkedBlockingQueue<Integer>();
        this.catchpointSets = new LinkedBlockingQueue<String>();
    }

    void startCommandLoop(InputStream is) throws RubyDebuggerException {
        try {
            new XPPLoop(is, ReadersSupport.class + " command loop").start();
        }
        catch (IOException e) {
            throw new RubyDebuggerException(e);
        }
        catch (XmlPullParserException e) {
            throw new RubyDebuggerException(e);
        }
    }

    private void startXPPLoop(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        do {
            if (eventType == 2) {
                this.processElement(xpp);
            } else if (eventType == 3) {
                assert (false) : "Unexpected state: end tag " + xpp.getName();
            } else if (eventType == 4) {
                if (xpp.getText().contains(RUBY_DEBUG_PROMPT)) {
                    LOGGER.finest("got ruby-debug prompt message");
                } else assert (false) : "Unexpected state: got text \"" + xpp.getText() + '\"';
            } else if (eventType != 0) assert (false) : "Unexpected state: " + eventType;
            if (this.finished) break;
            eventType = xpp.next();
            Util.logEvent(xpp);
        } while (eventType != 1);
    }

    private void processElement(XmlPullParser xpp) throws IOException, XmlPullParserException {
        String element = xpp.getName();
        if (BREAKPOINT_ADDED_ELEMENT.equals(element)) {
            this.addedBreakpoints.add(BreakpointAddedReader.readBreakpointNo(xpp));
        } else if (BREAKPOINT_DELETED_ELEMENT.equals(element)) {
            this.removedBreakpoints.add(BreakpointDeletedReader.readBreakpointNo(xpp));
        } else if (BREAKPOINT_ELEMENT.equals(element) || SUSPENDED_ELEMENT.equals(element) || EXCEPTION_ELEMENT.equals(element)) {
            SuspensionPoint sp = SuspensionReader.readSuspension(xpp);
            this.suspensions.add(sp);
        } else if (CONDITION_SET_ELEMENT.equals(element)) {
            this.conditionSets.add(ConditionSetReader.readBreakpointNo(xpp));
        } else if (CATCHPOINT_SET_ELEMENT.equals(element)) {
            this.catchpointSets.add(CatchpointSetReader.readExceptionClassName(xpp));
        } else if (THREADS_ELEMENT.equals(element)) {
            this.threads.add(ThreadInfoReader.readThreads(xpp));
        } else if (FRAMES_ELEMENT.equals(element)) {
            this.frames.add(FramesReader.readFrames(xpp));
        } else if (VARIABLES_ELEMENT.equals(element)) {
            this.variables.add(VariablesReader.readVariables(xpp));
        } else if (PROCESSING_EXCEPTION_ELEMENT.equals(element)) {
            VariablesReader.logProcessingException(xpp);
            this.variables.add(new RubyVariableInfo[0]);
        } else {
            Message message = ErrorReader.tryToReadMessageOrError(xpp, element);
            if (message != null) {
                if (message.getText().equals(FINISHED)) {
                    LOGGER.fine("Got 'finished' <message>, text == finished");
                    this.finished = true;
                }
            } else assert (false) : "Unexpected element: " + element;
        }
    }

    private <T> T[] readInfo(BlockingQueue<T[]> queue) throws RubyDebuggerException {
        try {
            T[] result = queue.poll(this.timeout, TimeUnit.SECONDS);
            if (result == null) {
                throw new RubyDebuggerException("Unable to read information in the specified timeout [" + this.timeout + "s]");
            }
            return result;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RubyDebuggerException("Interruped during reading information " + queue.getClass(), ex);
        }
    }

    RubyThreadInfo[] readThreads() throws RubyDebuggerException {
        return (RubyThreadInfo[])this.readInfo(this.threads);
    }

    RubyFrameInfo[] readFrames() throws RubyDebuggerException {
        return (RubyFrameInfo[])this.readInfo(this.frames);
    }

    RubyVariableInfo[] readVariables() throws RubyDebuggerException {
        return (RubyVariableInfo[])this.readInfo(this.variables);
    }

    int readAddedBreakpointNo() throws RubyDebuggerException {
        return this.poll(this.addedBreakpoints, "added breakpoint number");
    }

    int readConditionSet() throws RubyDebuggerException {
        return this.poll(this.conditionSets, "breakpoint number of the set condition");
    }

    String readCatchpointSet() throws RubyDebuggerException {
        return this.poll(this.catchpointSets, "catchpoint set");
    }

    int waitForRemovedBreakpoint(int breakpointID) throws RubyDebuggerException {
        int removedID = this.poll(this.removedBreakpoints, "breakpoint number of the removed breakpoint (" + breakpointID + ")");
        if (removedID != breakpointID) {
            throw new RubyDebuggerException("Unexpected breakpoint removed. Received id: " + removedID + ", expected: " + breakpointID);
        }
        return removedID;
    }

    private <T> T poll(BlockingQueue<T> queue, String toRead) throws RubyDebuggerException {
        try {
            T t = queue.poll(this.timeout, TimeUnit.SECONDS);
            if (t == null) {
                throw new RubyDebuggerException("Unable to read " + toRead + " in the specified timeout [" + this.timeout + "s]");
            }
            return t;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RubyDebuggerException("Interruped during reading " + toRead + " (timeout: " + this.timeout + ')', ex);
        }
    }

    SuspensionPoint readSuspension() {
        try {
            return this.suspensions.take();
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, "Interruped during reading suspension point", ex);
            return null;
        }
    }

    boolean isUnexpectedFail() {
        return this.unexpectedFail;
    }

    private static XmlPullParser getXpp(InputStream is) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)"org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer", null);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput((Reader)new BufferedReader(new InputStreamReader(is)));
        return xpp;
    }

    private class XPPLoop
    extends Thread {
        private final XmlPullParser xpp;
        private final InputStream is;

        XPPLoop(InputStream is, String loopName) throws XmlPullParserException, IOException {
            super(loopName);
            this.is = is;
            this.xpp = ReadersSupport.getXpp(is);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LOGGER.fine("Starting ReadersSupport readloop: " + this.getName());
                ReadersSupport.this.startXPPLoop(this.xpp);
                LOGGER.fine("ReadersSupport readloop [" + this.getName() + "] successfully finished.");
            }
            catch (IOException e) {
                LOGGER.fine("SocketException. Loop [" + this.getName() + "]: " + e.getMessage());
                LOGGER.log(Level.FINE, e.getMessage(), e);
                ReadersSupport.this.unexpectedFail = true;
            }
            catch (XmlPullParserException e) {
                LOGGER.log(Level.SEVERE, "Exception during ReadersSupport loop [" + this.getName() + ']', e);
                ReadersSupport.this.unexpectedFail = true;
            }
            finally {
                ReadersSupport.this.suspensions.add(SuspensionPoint.END);
                try {
                    this.is.close();
                    Thread.sleep(1000L);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Cannot close socket's input stream", e);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "Readers loop interrupted", e);
                }
            }
        }
    }
}

