/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;
import org.netbeans.nbbuild.JarWithModuleAttributes;
import org.netbeans.nbbuild.ModuleListParser;
import org.netbeans.nbbuild.ModuleType;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ParseProjectXml
extends Task {
    static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    static final String NBM_NS2 = "http://www.netbeans.org/ns/nb-module-project/2";
    static final String NBM_NS3 = "http://www.netbeans.org/ns/nb-module-project/3";
    private File moduleProject;
    private File projectFile;
    private String publicPackagesProperty;
    private String friendsProperty;
    private String javadocPackagesProperty;
    private String moduleDependenciesProperty;
    private String codeNameBaseProperty;
    private String codeNameBaseDashesProperty;
    private String codeNameBaseSlashesProperty;
    private String commitMailProperty;
    private String moduleClassPathProperty;
    private String moduleRunClassPathProperty;
    private File publicPackageJarDir;
    private String classPathExtensionsProperty;
    private static String cachedTestDistLocation;
    List<TestType> testTypes = new LinkedList<TestType>();
    static final String DO_NOT_RECURSE = "do.not.recurse";
    private static String NBM_NS_CACHE;

    public void setProject(File f) {
        this.moduleProject = f;
    }

    public void setProjectFile(File f) {
        this.projectFile = f;
    }

    private File getProjectFile() {
        if (this.projectFile != null) {
            return this.projectFile;
        }
        return new File(new File(this.moduleProject, "nbproject"), "project.xml");
    }

    public void setPublicPackagesProperty(String s) {
        this.publicPackagesProperty = s;
    }

    public void setFriendsProperty(String s) {
        this.friendsProperty = s;
    }

    public void setJavadocPackagesProperty(String s) {
        this.javadocPackagesProperty = s;
    }

    public void setModuleDependenciesProperty(String s) {
        this.moduleDependenciesProperty = s;
    }

    public void setCodeNameBaseProperty(String s) {
        this.codeNameBaseProperty = s;
    }

    public void setCodeNameBaseDashesProperty(String s) {
        this.codeNameBaseDashesProperty = s;
    }

    public void setCodeNameBaseSlashesProperty(String s) {
        this.codeNameBaseSlashesProperty = s;
    }

    public void setCommitMailProperty(String s) {
        this.commitMailProperty = s;
    }

    public void setModuleClassPathProperty(String s) {
        this.moduleClassPathProperty = s;
    }

    public void setModuleRunClassPathProperty(String s) {
        this.moduleRunClassPathProperty = s;
    }

    public void setPublicPackageJarDir(File d) {
        this.publicPackageJarDir = d;
    }

    public void setClassPathExtensionsProperty(String s) {
        this.classPathExtensionsProperty = s;
    }

    public void addTestType(TestType testType) {
        this.testTypes.add(testType);
    }

    public void add(TestType testType) {
        this.testTypes.add(testType);
    }

    private TestType getTestType(String name) {
        for (TestType testType : this.testTypes) {
            if (!testType.getName().equals(name)) continue;
            return testType;
        }
        return null;
    }

    private void define(String prop, String val) {
        this.log("Setting " + prop + "=" + val, 3);
        String old = this.getProject().getProperty(prop);
        if (old != null && !old.equals(val)) {
            this.getProject().log("Warning: " + prop + " was already set to " + old, 1);
        }
        this.getProject().setNewProperty(prop, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            String val;
            String[] friends;
            Document pDoc;
            block55: {
                block54: {
                    if (this.getProjectFile() == null) {
                        throw new BuildException("You must set 'project' or 'projectfile'", this.getLocation());
                    }
                    pDoc = XMLUtil.parse(new InputSource(this.getProjectFile().toURI().toString()), false, true, null, null);
                    if (this.getModuleType(pDoc) == ModuleType.NB_ORG) {
                        File nball = new File(this.getProject().getProperty("nb_all"));
                        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
                        String[] xsds = new String[]{"project.ant/src/org/netbeans/modules/project/ant/project.xsd", "apisupport.project/src/org/netbeans/modules/apisupport/project/resources/nb-module-project2.xsd", "apisupport.project/src/org/netbeans/modules/apisupport/project/resources/nb-module-project3.xsd"};
                        for (String xsd : xsds) {
                            File file = new File(nball, xsd);
                            if (file.isFile()) {
                                sources.add(new StreamSource(file));
                                continue;
                            }
                            break block54;
                        }
                        Schema schema = schemaFactory.newSchema(sources.toArray(new Source[0]));
                        Validator validator = schema.newValidator();
                        validator.setErrorHandler(new ErrorHandler(){

                            @Override
                            public void warning(SAXParseException x) throws SAXException {
                                throw x;
                            }

                            @Override
                            public void error(SAXParseException x) throws SAXException {
                                throw x;
                            }

                            @Override
                            public void fatalError(SAXParseException x) throws SAXException {
                                throw x;
                            }
                        });
                        validator.validate(new DOMSource(pDoc));
                    }
                }
                if (this.publicPackagesProperty != null || this.javadocPackagesProperty != null) {
                    PublicPackage[] pkgs = this.getPublicPackages(pDoc);
                    if (this.publicPackagesProperty != null) {
                        String val2;
                        if (pkgs.length > 0) {
                            String sep = "";
                            StringBuffer b = new StringBuffer();
                            for (PublicPackage p : pkgs) {
                                b.append(sep);
                                String string = p.name;
                                if (string.indexOf(44) >= 0) {
                                    throw new BuildException("Package name cannot contain ',' as " + p, this.getLocation());
                                }
                                if (string.indexOf(42) >= 0) {
                                    throw new BuildException("Package name cannot contain '*' as " + p, this.getLocation());
                                }
                                b.append(string);
                                if (p.subpackages) {
                                    b.append(".**");
                                } else {
                                    b.append(".*");
                                }
                                sep = ", ";
                            }
                            String val3 = b.toString();
                        } else {
                            val2 = "-";
                        }
                        this.define(this.publicPackagesProperty, val2);
                    }
                    if (this.javadocPackagesProperty != null && pkgs.length > 0) {
                        String sep = "";
                        StringBuffer b = new StringBuffer();
                        for (PublicPackage p : pkgs) {
                            b.append(sep);
                            if (p.subpackages) {
                                if (this.getProject().getProperty(this.javadocPackagesProperty) == null) {
                                    String msg = this.javadocPackagesProperty + " cannot be set as <subpackages> does not work for Javadoc (see <subpackages>" + p.name + "</subpackages> tag in " + this.getProjectFile() + "). Set the property in project.properties if you want to build Javadoc.";
                                    this.getProject().log("Warning: " + msg, 1);
                                }
                                break block55;
                            }
                            b.append(p.name);
                            sep = ", ";
                        }
                        this.define(this.javadocPackagesProperty, b.toString());
                    }
                }
            }
            if (this.friendsProperty != null && (friends = this.getFriends(pDoc)) != null) {
                StringBuffer b = new StringBuffer();
                for (String f : friends) {
                    if (b.length() > 0) {
                        b.append(", ");
                    }
                    b.append(f);
                }
                this.define(this.friendsProperty, b.toString());
            }
            ModuleListParser modules = null;
            Dep[] rawDeps = null;
            Dep[] translatedDeps = null;
            String cnb = this.getCodeNameBase(pDoc);
            if (this.moduleDependenciesProperty != null || this.moduleClassPathProperty != null || this.moduleRunClassPathProperty != null || this.testTypes.size() > 0) {
                Hashtable properties = this.getProject().getProperties();
                properties.put("project", this.moduleProject.getAbsolutePath());
                modules = new ModuleListParser(properties, this.getModuleType(pDoc), this.getProject());
                ModuleListParser.Entry myself = modules.findByCodeNameBase(cnb);
                if (myself == null) {
                    ModuleListParser.resetCaches();
                    modules = new ModuleListParser(properties, this.getModuleType(pDoc), this.getProject());
                    myself = modules.findByCodeNameBase(cnb);
                    assert (myself != null) : "Cannot find myself as " + cnb;
                }
                Dep[][] deps = this.getDeps(cnb, pDoc, modules);
                rawDeps = deps[0];
                translatedDeps = deps[1];
            }
            if (this.moduleDependenciesProperty != null) {
                StringBuffer b = new StringBuffer();
                for (void var10_41 : rawDeps) {
                    if (!var10_41.run) continue;
                    if (b.length() > 0) {
                        b.append(", ");
                    }
                    b.append(var10_41);
                }
                if (b.length() > 0) {
                    this.define(this.moduleDependenciesProperty, b.toString());
                }
            }
            if (this.codeNameBaseProperty != null) {
                this.define(this.codeNameBaseProperty, cnb);
            }
            if (this.codeNameBaseDashesProperty != null) {
                this.define(this.codeNameBaseDashesProperty, cnb.replace('.', '-'));
            }
            if (this.codeNameBaseSlashesProperty != null) {
                this.define(this.codeNameBaseSlashesProperty, cnb.replace('.', '/'));
            }
            if (this.moduleClassPathProperty != null) {
                String cp = this.computeClasspath(cnb, pDoc, modules, translatedDeps, false);
                this.define(this.moduleClassPathProperty, cp);
            }
            if (this.moduleRunClassPathProperty != null) {
                String cp = this.computeClasspath(cnb, pDoc, modules, translatedDeps, true);
                this.define(this.moduleRunClassPathProperty, cp);
            }
            if (this.commitMailProperty != null) {
                if (this.getModuleType(pDoc) != ModuleType.NB_ORG) {
                    throw new BuildException("Cannot set " + this.commitMailProperty + " for a non-netbeans.org module", this.getLocation());
                }
                String name = this.getProject().getBaseDir().getName() + "/";
                StringBuilder aliases = null;
                File hgmail = new File(this.getProject().getProperty("nb_all"), ".hgmail");
                if (hgmail.canRead()) {
                    FileReader r = new FileReader(hgmail);
                    try {
                        String line;
                        BufferedReader bufferedReader = new BufferedReader(r);
                        while ((line = bufferedReader.readLine()) != null) {
                            int equals = line.indexOf(61);
                            if (equals == -1) continue;
                            for (String piece : line.substring(equals + 1).split(",")) {
                                if (!name.matches(piece.replace(".", "[.]").replace("*", ".*"))) continue;
                                if (aliases == null) {
                                    aliases = new StringBuilder();
                                } else {
                                    aliases.append(' ');
                                }
                                aliases.append(line.substring(0, equals));
                            }
                        }
                    }
                    finally {
                        ((Reader)r).close();
                    }
                } else {
                    this.log("Cannot find " + hgmail + " to read addresses from", 3);
                }
                if (aliases != null) {
                    this.define(this.commitMailProperty, aliases.toString());
                }
            }
            if (this.classPathExtensionsProperty != null && (val = this.computeClassPathExtensions(pDoc)) != null) {
                this.define(this.classPathExtensionsProperty, val);
            }
            if (modules != null) {
                String testDistLocation = this.getProject().getProperty("test.dist.dir");
                if (testDistLocation == null) {
                    testDistLocation = "${test.dist.dir}";
                }
                cachedTestDistLocation = testDistLocation;
                for (TestDeps testDeps : this.getTestDeps(pDoc, modules, cnb)) {
                    String cp;
                    TestType testType = this.getTestType(testDeps.testtype);
                    if (testType == null) continue;
                    if (testType.getFolder() != null) {
                        this.define(testType.getFolder(), testDeps.getTestFolder());
                    }
                    if (testType.getCompileCP() != null && (cp = testDeps.getCompileClassPath()) != null && cp.trim().length() > 0) {
                        this.define(testType.getCompileCP(), cp);
                    }
                    if (testType.getRuntimeCP() != null && (cp = testDeps.getRuntimeClassPath()) != null && cp.trim().length() > 0) {
                        this.define(testType.getRuntimeCP(), cp);
                    }
                    String testCompileDep = testDeps.getTestCompileDep();
                    if (testType.getCompileDep() == null || testCompileDep == null) continue;
                    this.define(testType.getCompileDep(), testCompileDep);
                }
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private Element getConfig(Document pDoc) throws BuildException {
        Element e = pDoc.getDocumentElement();
        Element c = XMLUtil.findElement(e, "configuration", PROJECT_NS);
        if (c == null) {
            throw new BuildException("No <configuration>", this.getLocation());
        }
        Element d = ParseProjectXml.findNBMElement(c, "data");
        if (d == null) {
            throw new BuildException("No <data> in " + this.getProjectFile(), this.getLocation());
        }
        return d;
    }

    private PublicPackage[] getPublicPackages(Document d) throws BuildException {
        Element cfg = this.getConfig(d);
        Element pp = ParseProjectXml.findNBMElement(cfg, "public-packages");
        if (pp == null) {
            pp = ParseProjectXml.findNBMElement(cfg, "friend-packages");
        }
        if (pp == null) {
            throw new BuildException("No <public-packages>", this.getLocation());
        }
        ArrayList<PublicPackage> pkgs = new ArrayList<PublicPackage>();
        for (Element p : XMLUtil.findSubElements(pp)) {
            String t;
            boolean sub = false;
            if ("friend".equals(p.getNodeName())) continue;
            if (!"package".equals(p.getNodeName())) {
                if (!"subpackages".equals(p.getNodeName())) {
                    throw new BuildException("Strange element name, should be package or subpackages: " + p.getNodeName(), this.getLocation());
                }
                sub = true;
            }
            if ((t = XMLUtil.findText(p)) == null) {
                throw new BuildException("No text in <package>", this.getLocation());
            }
            pkgs.add(new PublicPackage(t, sub));
        }
        return pkgs.toArray(new PublicPackage[pkgs.size()]);
    }

    private String[] getFriends(Document d) throws BuildException {
        Element cfg = this.getConfig(d);
        Element pp = ParseProjectXml.findNBMElement(cfg, "friend-packages");
        if (pp == null) {
            return null;
        }
        ArrayList<String> friends = new ArrayList<String>();
        boolean other = false;
        for (Element p : XMLUtil.findSubElements(pp)) {
            if ("friend".equals(p.getNodeName())) {
                String t = XMLUtil.findText(p);
                if (t == null) {
                    throw new BuildException("No text in <friend>", this.getLocation());
                }
                friends.add(t);
                continue;
            }
            other = true;
        }
        if (friends.isEmpty()) {
            throw new BuildException("Must have at least one <friend> in <friend-packages>", this.getLocation());
        }
        if (!other) {
            throw new BuildException("Must have at least one <package> in <friend-packages>", this.getLocation());
        }
        return friends.toArray(new String[friends.size()]);
    }

    private Dep[][] getDeps(String myCNB, Document pDoc, ModuleListParser modules) throws Exception {
        Element cfg = this.getConfig(pDoc);
        Element md = ParseProjectXml.findNBMElement(cfg, "module-dependencies");
        if (md == null) {
            throw new BuildException("No <module-dependencies>", this.getLocation());
        }
        ArrayList<Dep> deps = new ArrayList<Dep>();
        ArrayList<URL> moduleAutoDeps = new ArrayList<URL>();
        for (Element dep : XMLUtil.findSubElements(md)) {
            File autodeps;
            Element cnb = ParseProjectXml.findNBMElement(dep, "code-name-base");
            if (cnb == null) {
                throw new BuildException("No <code-name-base>", this.getLocation());
            }
            String t = XMLUtil.findText(cnb);
            if (t == null) {
                throw new BuildException("No text in <code-name-base>", this.getLocation());
            }
            ModuleListParser.Entry other = modules.findByCodeNameBase(t);
            if (other != null && (autodeps = other.getModuleAutoDeps()).exists()) {
                moduleAutoDeps.add(autodeps.toURI().toURL());
            }
            Dep d = new Dep(modules);
            d.codenamebase = t;
            Element rd = ParseProjectXml.findNBMElement(dep, "run-dependency");
            if (rd != null) {
                Element iv;
                Element sv;
                d.run = true;
                Element rv = ParseProjectXml.findNBMElement(rd, "release-version");
                if (rv != null) {
                    t = XMLUtil.findText(rv);
                    if (t == null) {
                        throw new BuildException("No text in <release-version>", this.getLocation());
                    }
                    d.release = t;
                }
                if ((sv = ParseProjectXml.findNBMElement(rd, "specification-version")) != null) {
                    t = XMLUtil.findText(sv);
                    if (t == null) {
                        throw new BuildException("No text in <specification-version>", this.getLocation());
                    }
                    d.spec = t;
                }
                if ((iv = ParseProjectXml.findNBMElement(rd, "implementation-version")) != null) {
                    d.impl = true;
                }
            }
            d.compile = ParseProjectXml.findNBMElement(dep, "compile-dependency") != null;
            deps.add(d);
        }
        Dep[] rawDeps = deps.toArray(new Dep[deps.size()]);
        this.translateModuleAutoDeps(myCNB, deps, moduleAutoDeps, modules);
        Dep[] translatedDeps = deps.toArray(new Dep[deps.size()]);
        return new Dep[][]{rawDeps, translatedDeps};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateModuleAutoDeps(String myCNB, List<Dep> deps, List<URL> moduleAutoDeps, ModuleListParser modules) throws Exception {
        String result;
        if (moduleAutoDeps.isEmpty()) {
            return;
        }
        HashSet<String> depsS = new HashSet<String>();
        AntClassLoader loader = new AntClassLoader();
        try {
            Method refineDependenciesSimple;
            for (String coreModule : new String[]{"org.openide.util", "org.openide.modules", "org.netbeans.bootstrap", "org.netbeans.core.startup"}) {
                ModuleListParser.Entry entry = modules.findByCodeNameBase(coreModule);
                if (entry == null) {
                    this.log("Cannot translate according to " + moduleAutoDeps + " because could not find " + coreModule, 1);
                    return;
                }
                File jar = entry.getJar();
                if (!jar.isFile()) {
                    this.log("Cannot translate according to " + moduleAutoDeps + " because could not find " + jar, 1);
                    return;
                }
                loader.addPathComponent(jar);
            }
            Class automaticDependenciesClazz = loader.loadClass("org.netbeans.core.startup.AutomaticDependencies");
            try {
                refineDependenciesSimple = automaticDependenciesClazz.getMethod("refineDependenciesSimple", String.class, Set.class);
            }
            catch (NoSuchMethodException x) {
                this.log("Cannot translate according to " + moduleAutoDeps + " because AutomaticDependencies is too old", 1);
                loader.cleanup();
                return;
            }
            for (Dep d : deps) {
                if (!d.run) continue;
                depsS.add(d.toString());
            }
            Object automaticDependencies = automaticDependenciesClazz.getMethod("parse", URL[].class).invoke(null, new Object[]{moduleAutoDeps.toArray(new URL[moduleAutoDeps.size()])});
            try {
                result = (String)refineDependenciesSimple.invoke(automaticDependencies, myCNB, depsS);
            }
            catch (InvocationTargetException x) {
                this.log("Cannot translate according to " + moduleAutoDeps + " due to " + x.getCause(), 1);
                loader.cleanup();
                return;
            }
        }
        finally {
            loader.cleanup();
        }
        if (result == null) {
            return;
        }
        this.log("warning: " + result, 1);
        HashSet<String> noCompileDeps = new HashSet<String>();
        Iterator<Dep> it = deps.iterator();
        while (it.hasNext()) {
            Dep d = it.next();
            if (!d.run) continue;
            it.remove();
            if (d.compile) continue;
            noCompileDeps.add(d.codenamebase);
        }
        for (String dS : depsS) {
            Dep d = new Dep(dS, modules);
            d.run = true;
            if (!noCompileDeps.contains(d.codenamebase)) {
                d.compile = true;
            }
            deps.add(d);
        }
    }

    private String getCodeNameBase(Document d) throws BuildException {
        Element data = this.getConfig(d);
        Element name = ParseProjectXml.findNBMElement(data, "code-name-base");
        if (name == null) {
            throw new BuildException("No <code-name-base>", this.getLocation());
        }
        String t = XMLUtil.findText(name);
        if (t == null) {
            throw new BuildException("No text in <code-name-base>", this.getLocation());
        }
        return t;
    }

    private ModuleType getModuleType(Document d) throws BuildException {
        Element data = this.getConfig(d);
        if (ParseProjectXml.findNBMElement(data, "suite-component") != null) {
            return ModuleType.SUITE;
        }
        if (ParseProjectXml.findNBMElement(data, "standalone") != null) {
            return ModuleType.STANDALONE;
        }
        return ModuleType.NB_ORG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeClasspath(String myCNB, Document pDoc, ModuleListParser modules, Dep[] deps, boolean runtime) throws BuildException, IOException, SAXException {
        String excludedModulesProp;
        StringBuffer cp = new StringBuffer();
        Path clusterPathS = (Path)this.getProject().getReference("cluster.path.id");
        HashSet<File> clusterPath = null;
        if (clusterPathS != null) {
            clusterPath = new HashSet<File>();
            Iterator it = clusterPathS.iterator();
            while (it.hasNext()) {
                File oneCluster = ((FileResource)it.next()).getFile();
                clusterPath.add(oneCluster);
            }
        }
        HashSet<String> excludedModules = (excludedModulesProp = this.getProject().getProperty("disabled.modules")) != null ? new HashSet<String>(Arrays.asList(excludedModulesProp.split(" *, *"))) : null;
        for (Dep dep : deps) {
            ModuleListParser.Entry entry;
            if (!runtime && !dep.compile) continue;
            String cnb = dep.codenamebase;
            File depJar = this.computeClasspathModuleLocation(modules, cnb, clusterPath, excludedModules, runtime);
            ArrayList<File> additions = new ArrayList<File>();
            additions.add(depJar);
            if (runtime) {
                HashSet<String> skipCnb = new HashSet<String>();
                this.addRecursiveDeps(additions, modules, cnb, clusterPath, excludedModules, skipCnb);
            }
            if ((entry = modules.findByCodeNameBase(cnb)) != null) {
                additions.addAll(Arrays.asList(entry.getClassPathExtensions()));
            }
            if (depJar.isFile()) {
                Attributes attr;
                try {
                    JarFile jarFile = new JarFile(depJar, false);
                    try {
                        attr = jarFile.getManifest().getMainAttributes();
                    }
                    finally {
                        jarFile.close();
                    }
                }
                catch (ZipException x) {
                    throw new BuildException("Could not open " + depJar + ": " + x, (Throwable)x, this.getLocation());
                }
                if (!dep.matches(attr)) {
                    throw new BuildException("Cannot compile against a module: " + depJar + " because of dependency: " + dep, this.getLocation());
                }
                if (!runtime && Boolean.parseBoolean(attr.getValue("OpenIDE-Module-Deprecated"))) {
                    this.log("The module " + cnb + " has been deprecated", 1);
                }
                if (!dep.impl && dep.run && !runtime) {
                    String friends = attr.getValue("OpenIDE-Module-Friends");
                    if (friends != null && !Arrays.asList(friends.split(" *, *")).contains(myCNB)) {
                        throw new BuildException("The module " + myCNB + " is not a friend of " + depJar, this.getLocation());
                    }
                    String pubpkgs = attr.getValue("OpenIDE-Module-Public-Packages");
                    if ("-".equals(pubpkgs)) {
                        throw new BuildException("The module " + depJar + " has no public packages and so cannot be compiled against", this.getLocation());
                    }
                    if (pubpkgs != null && this.publicPackageJarDir != null) {
                        File splitJar = this.createPublicPackageJar(additions, pubpkgs, this.publicPackageJarDir, cnb);
                        additions.clear();
                        additions.add(splitJar);
                    }
                }
            }
            for (File f : additions) {
                if (cp.length() > 0) {
                    cp.append(':');
                }
                cp.append(f.getAbsolutePath());
            }
        }
        ModuleListParser.Entry entry = modules.findByCodeNameBase(myCNB);
        if (entry == null) {
            throw new IllegalStateException("Cannot find myself as " + myCNB);
        }
        for (File f : entry.getClassPathExtensions()) {
            cp.append(':');
            cp.append(f.getAbsolutePath());
        }
        return cp.toString();
    }

    private void addRecursiveDeps(List<File> additions, ModuleListParser modules, String cnb, Set<File> clusterPath, Set<String> excludedModules, Set<String> skipCnb) {
        if (!skipCnb.add(cnb)) {
            return;
        }
        this.log("Processing for recursive deps: " + cnb, 4);
        for (String nextModule : modules.findByCodeNameBase(cnb).getRuntimeDependencies()) {
            ModuleListParser.Entry entry;
            this.log("  Added dep: " + nextModule, 4);
            File depJar = this.computeClasspathModuleLocation(modules, nextModule, clusterPath, excludedModules, true);
            if (!additions.contains(depJar)) {
                additions.add(depJar);
            }
            if ((entry = modules.findByCodeNameBase(cnb)) != null) {
                for (File f : entry.getClassPathExtensions()) {
                    if (additions.contains(f)) continue;
                    additions.add(f);
                }
            }
            this.addRecursiveDeps(additions, modules, nextModule, clusterPath, excludedModules, skipCnb);
        }
    }

    private File computeClasspathModuleLocation(ModuleListParser modules, String cnb, Set<File> clusterPath, Set<String> excludedModules, boolean runtime) throws BuildException {
        File jar;
        ModuleListParser.Entry module;
        block10: {
            module = modules.findByCodeNameBase(cnb);
            if (module == null) {
                throw new BuildException("No dependent module " + cnb, this.getLocation());
            }
            jar = module.getJar();
            if (jar == null) {
                return null;
            }
            if (module.getClusterName() != null && clusterPath != null) {
                File clusterF;
                for (clusterF = jar.getParentFile(); clusterF != null; clusterF = clusterF.getParentFile()) {
                    if (!clusterPath.contains(clusterF)) {
                        continue;
                    }
                    break block10;
                }
                String msg = "The module " + cnb + " cannot be " + (runtime ? "run" : "compiled") + " against because it is part of the cluster " + clusterF + " which is not part of cluster.path in your suite configuration.\n\n" + "Cluster.path is: " + clusterPath;
                throw new BuildException(msg, this.getLocation());
            }
        }
        if (excludedModules != null && excludedModules.contains(cnb)) {
            throw new BuildException("Module " + cnb + " excluded from the target platform", this.getLocation());
        }
        if (!jar.isFile()) {
            File srcdir = module.getSourceLocation();
            if (Project.toBoolean((String)this.getProject().getProperty(DO_NOT_RECURSE))) {
                this.log(jar + " missing for " + this.moduleProject + " but will not first try to build " + srcdir, 3);
                return jar;
            }
            if (srcdir != null && srcdir.isDirectory()) {
                this.log(jar + " missing for " + this.moduleProject + "; will first try to build " + srcdir, 1);
                Ant ant = new Ant();
                ant.setProject(this.getProject());
                ant.setOwningTarget(this.getOwningTarget());
                ant.setLocation(this.getLocation());
                ant.setInheritAll(false);
                ant.setDir(srcdir);
                ant.execute();
            }
        }
        if (!jar.isFile()) {
            throw new BuildException("No such classpath entry: " + jar, this.getLocation());
        }
        return jar;
    }

    private static String testJarPath(ModuleListParser.Entry entry, String testType) {
        String sep = File.separator;
        String cluster = entry.getClusterName();
        if (cluster == null) {
            cluster = "cluster";
        }
        return cachedTestDistLocation + sep + testType + sep + cluster + sep + entry.getCnb().replace('.', '-') + sep + "tests.jar";
    }

    private String computeClassPathExtensions(Document pDoc) {
        Element data = this.getConfig(pDoc);
        StringBuffer list = null;
        for (Element ext : XMLUtil.findSubElements(data)) {
            if (!ext.getLocalName().equals("class-path-extension")) continue;
            Element runtimeRelativePath = ParseProjectXml.findNBMElement(ext, "runtime-relative-path");
            if (runtimeRelativePath == null) {
                throw new BuildException("Have malformed <class-path-extension> in " + this.getProjectFile(), this.getLocation());
            }
            String reltext = XMLUtil.findText(runtimeRelativePath);
            if (list == null) {
                list = new StringBuffer();
            } else {
                list.append(' ');
            }
            list.append(reltext);
        }
        return list != null ? list.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPublicPackageJar(List<File> jars, String pubpkgs, File dir, String cnb) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("No such directory " + dir);
        }
        File ppjar = new File(dir, cnb.replace('.', '-') + ".jar");
        if (ppjar.exists()) {
            boolean uptodate = true;
            long stamp = ppjar.lastModified();
            for (File jar : jars) {
                if (jar.lastModified() <= stamp) continue;
                uptodate = false;
                break;
            }
            if (uptodate) {
                this.log("Distilled " + ppjar + " was already up to date", 3);
                return ppjar;
            }
        }
        this.log("Distilling " + ppjar + " from " + jars);
        String corePattern = pubpkgs.replaceAll(" +", "").replaceAll("\\.", "/").replaceAll(",", "|").replaceAll("\\*\\*", "(.+/)?").replaceAll("\\*", "");
        Pattern p = Pattern.compile("(" + corePattern + ")[^/]+\\.class");
        boolean foundAtLeastOneEntry = false;
        FileOutputStream os = new FileOutputStream(ppjar);
        try {
            ZipOutputStream zos = new ZipOutputStream(os);
            HashSet<String> addedPaths = new HashSet<String>();
            for (File jar : jars) {
                if (!jar.isFile()) {
                    this.log("Classpath entry " + jar + " does not exist; skipping", 1);
                    continue;
                }
                FileInputStream is = new FileInputStream(jar);
                try {
                    ZipEntry inEntry;
                    ZipInputStream zis = new ZipInputStream(is);
                    while ((inEntry = zis.getNextEntry()) != null) {
                        int read;
                        String path = inEntry.getName();
                        if (!addedPaths.add(path)) continue;
                        long size = inEntry.getSize();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(size == -1L ? 4096 : (int)size);
                        byte[] buf = new byte[4096];
                        while ((read = zis.read(buf)) != -1) {
                            baos.write(buf, 0, read);
                        }
                        byte[] data = baos.toByteArray();
                        boolean isEnum = this.isEnum(path, data);
                        if (!isEnum && !p.matcher(path).matches()) continue;
                        foundAtLeastOneEntry = true;
                        ZipEntry outEntry = new ZipEntry(path);
                        outEntry.setSize(data.length);
                        CRC32 crc = new CRC32();
                        crc.update(data);
                        outEntry.setCrc(crc.getValue());
                        zos.putNextEntry(outEntry);
                        zos.write(data);
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            zos.close();
        }
        finally {
            ((OutputStream)os).close();
        }
        if (!foundAtLeastOneEntry) {
            ppjar.delete();
            throw new BuildException("The JARs " + jars + " contain no classes in the supposed public packages " + pubpkgs + " and so cannot be compiled against", this.getLocation());
        }
        return ppjar;
    }

    private boolean isEnum(String path, byte[] data) throws UnsupportedEncodingException {
        if (!path.endsWith(".class")) {
            return false;
        }
        String jvmName = path.substring(0, path.length() - ".class".length());
        String bytecode = new String(data, "ISO-8859-1");
        if (!bytecode.contains("$VALUES")) {
            return false;
        }
        return bytecode.contains("java/lang/Enum<L" + new String(jvmName.getBytes("UTF-8"), "ISO-8859-1") + ";>;");
    }

    private TestDeps[] getTestDeps(Document pDoc, ModuleListParser modules, String testCnb) {
        assert (modules != null);
        Element cfg = this.getConfig(pDoc);
        ArrayList<TestDeps> testDepsList = new ArrayList<TestDeps>();
        Element pp = ParseProjectXml.findNBMElement(cfg, "test-dependencies");
        boolean existsUnitTests = false;
        boolean existsQaFunctionalTests = false;
        if (pp != null) {
            for (Element depssEl : XMLUtil.findSubElements(pp)) {
                String testType = ParseProjectXml.findTextOrNull(depssEl, "name");
                if (testType == null) {
                    testType = "unit";
                    existsUnitTests = true;
                } else if (testType.equals("unit")) {
                    existsUnitTests = true;
                } else if (testType.equals("qa-functional")) {
                    existsQaFunctionalTests = true;
                }
                TestDeps testDeps = new TestDeps(testType, testCnb, modules);
                testDepsList.add(testDeps);
                for (Element el : XMLUtil.findSubElements(depssEl)) {
                    if (!el.getTagName().equals("test-dependency")) continue;
                    boolean test = ParseProjectXml.findNBMElement(el, "test") != null;
                    String cnb = ParseProjectXml.findTextOrNull(el, "code-name-base");
                    boolean recursive = ParseProjectXml.findNBMElement(el, "recursive") != null;
                    boolean compile = ParseProjectXml.findNBMElement(el, "compile-dependency") != null;
                    testDeps.addDependency(new TestDep(cnb, modules, recursive, test, compile, testDeps));
                }
            }
        }
        for (TestDeps testDeps : testDepsList) {
            File testSrcDir = new File(this.moduleProject, "test/" + testDeps.testtype + "/src");
            if (testSrcDir.isDirectory()) continue;
            String error = "No such dir " + testSrcDir + "; should not define test deps";
            if (this.getModuleType(pDoc) == ModuleType.NB_ORG) {
                throw new BuildException(error, this.getLocation());
            }
            this.log(error, 1);
        }
        if (!existsUnitTests) {
            this.log("Default TestDeps for unit", 3);
            testDepsList.add(new TestDeps("unit", testCnb, modules));
        }
        if (!existsQaFunctionalTests) {
            this.log("Default TestDeps for qa-functional", 3);
            testDepsList.add(new TestDeps("qa-functional", testCnb, modules));
        }
        for (TestDeps testDeps : testDepsList) {
            if (testDeps.fullySpecified) continue;
            if (new File(this.moduleProject, "test/" + testDeps.testtype + "/src").isDirectory()) {
                this.log("Warning: " + testCnb + " lacks a " + testDeps.testtype + " test dependency on org.netbeans.libs.junit4; using default dependencies for compatibility", 1);
            }
            for (String library : new String[]{"org.netbeans.libs.junit4", "org.netbeans.modules.nbjunit", "org.netbeans.insane"}) {
                testDeps.addOptionalDependency(new TestDep(library, modules, false, false, true, testDeps));
            }
            if (!testDeps.testtype.startsWith("qa-")) continue;
            testDeps.addOptionalDependency(new TestDep("org.netbeans.modules.java.j2seproject", modules, false, true, true, testDeps));
            testDeps.addOptionalDependency(new TestDep("org.netbeans.modules.java.j2seproject", modules, true, false, false, testDeps));
            for (String library : new String[]{"org.netbeans.modules.jemmy"}) {
                testDeps.addOptionalDependency(new TestDep(library, modules, false, false, true, testDeps));
            }
            testDeps.addOptionalDependency(new TestDep("org.openide.util", modules, false, false, false, testDeps));
        }
        return testDepsList.toArray(new TestDeps[testDepsList.size()]);
    }

    static String findTextOrNull(Element parentElement, String elementName) {
        Element el = ParseProjectXml.findNBMElement(parentElement, elementName);
        return el == null ? null : XMLUtil.findText(el);
    }

    static Element findNBMElement(Element el, String name) {
        Element retEl = XMLUtil.findElement(el, name, NBM_NS_CACHE);
        if (retEl == null) {
            NBM_NS_CACHE = NBM_NS_CACHE.equals(NBM_NS3) ? NBM_NS2 : NBM_NS3;
            retEl = XMLUtil.findElement(el, name, NBM_NS_CACHE);
        }
        return retEl;
    }

    static {
        NBM_NS_CACHE = NBM_NS3;
    }

    final class TestDep {
        final ModuleListParser modulesParser;
        final String cnb;
        final boolean recursive;
        final boolean test;
        final boolean compile;
        TestDeps testDeps;

        TestDep(String cnb, ModuleListParser modules, boolean recursive, boolean test, boolean compile, TestDeps testDeps) {
            this.modulesParser = modules;
            this.cnb = cnb;
            this.recursive = recursive;
            this.test = test;
            this.testDeps = testDeps;
            this.compile = compile;
        }

        public String toString() {
            return this.cnb + (this.recursive ? "/recursive" : "") + (this.test ? "/test" : "") + (this.compile ? "/compile" : "");
        }

        List<ModuleListParser.Entry> getModules() {
            ArrayList<ModuleListParser.Entry> entries = new ArrayList<ModuleListParser.Entry>();
            if (this.recursive) {
                HashMap<String, ModuleListParser.Entry> entriesMap = new HashMap<String, ModuleListParser.Entry>();
                this.addRecursiveModules(this.cnb, entriesMap);
                entries.addAll(entriesMap.values());
            } else {
                ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(this.cnb);
                if (entry == null) {
                    this.testDeps.addMissingEntry(this.cnb);
                } else {
                    entries.add(this.modulesParser.findByCodeNameBase(this.cnb));
                }
            }
            return entries;
        }

        private void addRecursiveModules(String cnb, Map<String, ModuleListParser.Entry> entriesMap) {
            if (!entriesMap.containsKey(cnb)) {
                ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(cnb);
                if (entry == null) {
                    this.testDeps.addMissingEntry(cnb);
                } else {
                    entriesMap.put(cnb, entry);
                    String[] cnbs = entry.getRuntimeDependencies();
                    if (cnbs != null) {
                        for (String c : cnbs) {
                            this.addRecursiveModules(c, entriesMap);
                        }
                    }
                }
            }
        }

        List<String> getFiles(boolean compile) {
            ArrayList<String> files = new ArrayList<String>();
            if (!compile || compile && this.compile) {
                List<ModuleListParser.Entry> modules = this.getModules();
                for (ModuleListParser.Entry entry : this.getModules()) {
                    if (entry != null) {
                        files.add(entry.getJar().getAbsolutePath());
                        continue;
                    }
                    ParseProjectXml.this.log("Entry doesn't exist.");
                }
                if (this.test) {
                    String jarPath = this.getTestJarPath(false);
                    if (jarPath != null) {
                        files.add(jarPath);
                    }
                    if ((jarPath = this.getTestJarPath(true)) != null) {
                        files.add(jarPath);
                    }
                }
            }
            return files;
        }

        public String getTestJarPath(boolean useUnit) {
            ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(this.cnb);
            if (entry == null) {
                this.testDeps.addMissingEntry(this.cnb);
                return null;
            }
            String type = this.testDeps.testtype;
            if (useUnit) {
                if (type.equals("unit")) {
                    return null;
                }
                type = "unit";
            }
            return ParseProjectXml.testJarPath(entry, type);
        }
    }

    final class TestDeps {
        public static final String UNIT = "unit";
        public static final String QA_FUNCTIONAL = "qa-functional";
        final String testtype;
        final List<TestDep> dependencies = new ArrayList<TestDep>();
        final String cnb;
        final ModuleListParser modulesParser;
        boolean fullySpecified;
        private Set<String> missingEntries;
        public static final String TEST_DIST_VAR = "test.dist.dir";

        public TestDeps(String testtype, String cnb, ModuleListParser modulesParser) {
            assert (modulesParser != null);
            this.testtype = testtype;
            this.cnb = cnb;
            this.modulesParser = modulesParser;
        }

        public String toString() {
            return this.cnb + "/" + this.testtype + ":" + this.dependencies;
        }

        public List<String> getFiles(boolean compile) {
            ArrayList<String> files = new ArrayList<String>();
            for (TestDep d : this.dependencies) {
                files.addAll(d.getFiles(compile));
            }
            return files;
        }

        public void addDependency(TestDep dep) {
            this.dependencies.add(dep);
            this.fullySpecified |= dep.cnb.equals("org.netbeans.libs.junit4");
        }

        public void addOptionalDependency(TestDep dep) {
            if (dep.modulesParser.findByCodeNameBase(dep.cnb) != null) {
                this.dependencies.add(dep);
            }
        }

        private String getTestFolder() {
            ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(this.cnb);
            String sep = "/";
            String cluster = entry.getClusterName();
            if (cluster == null) {
                cluster = "cluster";
            }
            return cachedTestDistLocation + sep + this.testtype + sep + cluster + sep + this.cnb.replace('.', '-');
        }

        String getCompileClassPath() {
            return this.getPath(this.getFiles(true)) + this.getMissingEntries();
        }

        private String getPath(List<String> files) {
            StringBuffer path = new StringBuffer();
            HashSet<String> filesSet = new HashSet<String>();
            for (String filePath : files) {
                if (filesSet.contains(filePath)) continue;
                if (path.length() > 0) {
                    path.append(File.pathSeparatorChar);
                }
                filesSet.add(filePath);
                path.append(filePath);
            }
            return path.toString().replace(File.separatorChar, '/');
        }

        String getRuntimeClassPath() {
            return this.getPath(this.getFiles(false)) + this.getMissingEntries();
        }

        public String getTestCompileDep() {
            HashSet<String> cnbs = new HashSet<String>();
            StringBuilder builder = new StringBuilder();
            this.computeCompileDep(this.cnb, cnbs, builder);
            return builder.length() > 0 ? builder.toString() : null;
        }

        private void computeCompileDep(String cnb, Set<String> cnbs, StringBuilder sb) {
            if (cnbs.contains(cnb)) {
                return;
            }
            ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(cnb);
            if (!cnbs.isEmpty() && entry != null) {
                File srcPath;
                for (String othertesttype : new String[]{UNIT, QA_FUNCTIONAL}) {
                    String p = ParseProjectXml.testJarPath(entry, othertesttype);
                    if (p == null || !new File(p).exists()) continue;
                    return;
                }
                if (sb.length() > 0) {
                    sb.append(File.pathSeparator);
                }
                if ((srcPath = entry.getSourceLocation()) != null) {
                    sb.append(srcPath.getAbsolutePath());
                }
            }
            cnbs.add(cnb);
            if (entry != null) {
                for (String othertesttype : new String[]{UNIT, QA_FUNCTIONAL}) {
                    String[] testDeps = entry.getTestDependencies().get(othertesttype);
                    if (testDeps == null) continue;
                    for (String cnb2 : testDeps) {
                        this.computeCompileDep(cnb2, cnbs, sb);
                    }
                }
            }
        }

        private void addMissingEntry(String cnb) {
            if (this.missingEntries == null) {
                this.missingEntries = new HashSet<String>();
            }
            this.missingEntries.add(cnb);
        }

        private String getMissingEntries() {
            if (this.missingEntries != null) {
                StringBuilder builder = new StringBuilder();
                builder.append("\n-missing-Module-Entries-: ");
                for (String cnd : this.missingEntries) {
                    builder.append(cnd);
                    builder.append("\n");
                }
                return builder.toString();
            }
            return "";
        }
    }

    private final class Dep {
        private final ModuleListParser modules;
        public String codenamebase;
        public String release = null;
        public String spec = null;
        public boolean impl = false;
        public boolean compile = false;
        public boolean run = false;

        public Dep(ModuleListParser modules) {
            this.modules = modules;
        }

        public Dep(String parse, ModuleListParser modules) {
            this(modules);
            Matcher m = Pattern.compile("([^=>/ ]+)(?:/([\\d-]+))?(?: > (.+)| = (.+))?").matcher(parse);
            if (!m.matches()) {
                throw new BuildException("Malformed dep: " + parse);
            }
            this.codenamebase = m.group(1);
            this.release = m.group(2);
            this.spec = m.group(3);
            this.impl = m.group(4) != null;
        }

        public String toString() throws BuildException {
            StringBuffer b = new StringBuffer(this.codenamebase);
            if (this.release != null) {
                b.append('/');
                b.append(this.release);
            }
            if (this.spec != null) {
                b.append(" > ");
                b.append(this.spec);
                assert (!this.impl);
            }
            if (this.impl) {
                b.append(" = ");
                String implVers = this.implementationVersionOf(this.modules, this.codenamebase);
                if (implVers == null) {
                    throw new BuildException("No OpenIDE-Module-Implementation-Version found in " + this.codenamebase);
                }
                if (implVers.equals(ParseProjectXml.this.getProject().getProperty("buildnumber"))) {
                    throw new BuildException("Cannot depend on module " + this.codenamebase + " using build number as an implementation version");
                }
                b.append(implVers);
            }
            return b.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String implementationVersionOf(ModuleListParser modules, String cnb) throws BuildException {
            String string;
            File jar = ParseProjectXml.this.computeClasspathModuleLocation(modules, cnb, null, null, false);
            JarFile jarFile = new JarFile(jar, false);
            try {
                string = jarFile.getManifest().getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
            }
            catch (Throwable throwable) {
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e, ParseProjectXml.this.getLocation());
                }
            }
            jarFile.close();
            return string;
        }

        private boolean matches(Attributes attr) {
            boolean[] osgi = new boolean[1];
            String givenCodeName = JarWithModuleAttributes.extractCodeName(attr, osgi);
            int slash = givenCodeName.indexOf(47);
            int givenRelease = -1;
            if (slash != -1) {
                assert (this.codenamebase.equals(givenCodeName.substring(0, slash)));
                givenRelease = Integer.parseInt(givenCodeName.substring(slash + 1));
            }
            if (this.release != null) {
                int dash = this.release.indexOf(45);
                if (dash == -1) {
                    if (Integer.parseInt(this.release) != givenRelease) {
                        return false;
                    }
                } else {
                    int lower = Integer.parseInt(this.release.substring(0, dash));
                    int upper = Integer.parseInt(this.release.substring(dash + 1));
                    if (givenRelease < lower || givenRelease > upper) {
                        return false;
                    }
                }
            } else if (this.run && givenRelease != -1) {
                return false;
            }
            if (this.spec != null) {
                String givenSpec = attr.getValue(osgi[0] ? "Bundle-Version" : "OpenIDE-Module-Specification-Version");
                if (givenSpec == null) {
                    return false;
                }
                int[] specVals = this.digitize(this.spec, osgi[0]);
                int[] givenSpecVals = this.digitize(givenSpec, osgi[0]);
                int len1 = specVals.length;
                int len2 = givenSpecVals.length;
                int max = Math.max(len1, len2);
                for (int i = 0; i < max; ++i) {
                    int d2;
                    int d1 = i < len1 ? specVals[i] : 0;
                    int n = d2 = i < len2 ? givenSpecVals[i] : 0;
                    if (d1 < d2) break;
                    if (d1 <= d2) continue;
                    return false;
                }
            }
            return !this.impl || attr.getValue("OpenIDE-Module-Implementation-Version") != null;
        }

        private int[] digitize(String spec, boolean osgi) throws NumberFormatException {
            StringTokenizer tok = new StringTokenizer(spec, ".");
            int len = tok.countTokens();
            if (osgi && len > 3) {
                len = 3;
            }
            int[] digits = new int[len];
            for (int i = 0; i < len; ++i) {
                digits[i] = Integer.parseInt(tok.nextToken());
            }
            return digits;
        }
    }

    private static final class PublicPackage {
        public final String name;
        public boolean subpackages;

        public PublicPackage(String name, boolean subpackages) {
            this.name = name;
            this.subpackages = subpackages;
        }
    }

    public static class TestType {
        private String name;
        private String folder;
        private String runtimeCP;
        private String compileCP;
        private String compileDep;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFolder() {
            return this.folder;
        }

        public void setFolder(String folder) {
            this.folder = folder;
        }

        public String getRuntimeCP() {
            return this.runtimeCP;
        }

        public void setRuntimeCP(String runtimeCP) {
            this.runtimeCP = runtimeCP;
        }

        public String getCompileCP() {
            return this.compileCP;
        }

        public void setCompileCP(String compileCP) {
            this.compileCP = compileCP;
        }

        public String getCompileDep() {
            return this.compileDep;
        }

        public void setCompileDep(String compileDep) {
            this.compileDep = compileDep;
        }
    }
}

