/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.AutomaticDependencies;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ManifestSection;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.SharedClassObject;
import org.openide.util.lookup.InstanceContent;
import org.xml.sax.SAXException;

final class NbInstaller
extends ModuleInstaller {
    private static final Logger LOG = Logger.getLogger(NbInstaller.class.getName());
    private final Map<Module, Set<ManifestSection>> sections = new HashMap<Module, Set<ManifestSection>>(100);
    private final Map<Module, Class<? extends ModuleInstall>> installs = new HashMap<Module, Class<? extends ModuleInstall>>(100);
    private final Map<Module, String> layers = new HashMap<Module, String>(100);
    private boolean initializedFolderLookup = false;
    private final Events ev;
    private ModuleList moduleList;
    private ModuleManager mgr;
    private final Map<Module, Set<String>> kosherPackages = new HashMap<Module, Set<String>>(100);
    private final Map<Module, List<Module.PackageExport>> hiddenClasspathPackages = new HashMap<Module, List<Module.PackageExport>>();
    private final Map<Module.PackageExport, List<Module>> hiddenClasspathPackagesReverse = new HashMap<Module.PackageExport, List<Module>>();
    private final InstanceContent.Convertor<ManifestSection, Object> convertor = new Convertor();
    private static String cacheCnb;
    private static Set<Dependency> cacheDeps;
    private AutomaticDependencies autoDepsHandler = null;
    private static final String[] CLASSPATH_PACKAGES;
    private static final String[][] CLASSPATH_JARS;
    private static final Logger MANIFEST_LOG;
    private boolean usingManifestCache;
    private final Object MANIFEST_CACHE = new Object();
    private Map<File, DateAndManifest> manifestCache;
    CacheFlusher updater;

    public NbInstaller(Events ev) {
        this.usingManifestCache = Boolean.valueOf(System.getProperty("netbeans.cache.manifests", "true"));
        if (!this.usingManifestCache) {
            MANIFEST_LOG.fine("Manifest cache disabled");
        }
        this.updater = new CacheFlusher();
        this.ev = ev;
    }

    void registerList(ModuleList list) {
        if (this.moduleList != null) {
            throw new IllegalStateException();
        }
        this.moduleList = list;
    }

    void registerManager(ModuleManager manager) {
        if (this.mgr != null) {
            throw new IllegalStateException();
        }
        this.mgr = manager;
    }

    public void prepare(Module m) throws InvalidException {
        URL layer;
        this.ev.log("prepare", new Object[]{m});
        this.checkForHiddenPackages(m);
        HashSet<ManifestSection> mysections = null;
        Class<?> clazz = null;
        for (Map.Entry<String, Attributes> entry : m.getManifest().getEntries().entrySet()) {
            ManifestSection section = ManifestSection.create(entry.getKey(), entry.getValue(), m);
            if (section == null) continue;
            if (mysections == null) {
                mysections = new HashSet<ManifestSection>(25);
            }
            mysections.add(section);
        }
        String installClass = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Install");
        if (installClass != null) {
            String installClassName;
            try {
                installClassName = Util.createPackageName((String)installClass);
            }
            catch (IllegalArgumentException iae) {
                InvalidException ie = new InvalidException(m, iae.toString());
                ie.initCause((Throwable)iae);
                throw ie;
            }
            if (installClass.endsWith(".ser")) {
                throw new InvalidException(m, "Serialized module installs not supported: " + installClass);
            }
            try {
                Class<?> c;
                clazz = Class.forName(installClassName, false, m.getClassLoader());
                if (clazz.getClassLoader() != m.getClassLoader()) {
                    this.ev.log("wrongClassLoader", new Object[]{m, clazz, m.getClassLoader()});
                }
                for (c = clazz; c != ModuleInstall.class && c != Object.class; c = c.getSuperclass()) {
                    try {
                        c.getDeclaredMethod("validate", new Class[0]);
                        ModuleInstall install = (ModuleInstall)SharedClassObject.findObject(clazz.asSubclass(ModuleInstall.class), (boolean)true);
                        install.validate();
                        continue;
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                }
                if (c == Object.class) {
                    throw new ClassCastException("Should extend ModuleInstall: " + clazz.getName());
                }
            }
            catch (Exception t) {
                InvalidException ie = new InvalidException(m, t.toString());
                ie.initCause((Throwable)t);
                throw ie;
            }
            catch (LinkageError t) {
                InvalidException ie = new InvalidException(m, t.toString());
                ie.initCause((Throwable)t);
                throw ie;
            }
        }
        String layerResource = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Layer");
        String osgi = m.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
        if (layerResource != null && osgi == null && (layer = m.getClassLoader().getResource(layerResource)) == null) {
            throw new InvalidException(m, "Layer not found: " + layerResource);
        }
        String helpSetName = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Description");
        if (helpSetName != null) {
            Util.err.warning("Use of OpenIDE-Module-Description in " + m.getCodeNameBase() + " is deprecated.");
            Util.err.warning("(Please install help using an XML layer instead.)");
        }
        if (mysections != null) {
            this.sections.put(m, mysections);
        }
        if (clazz != null) {
            this.installs.put(m, clazz.asSubclass(ModuleInstall.class));
        }
        if (layerResource != null) {
            this.layers.put(m, layerResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForHiddenPackages(Module m) throws InvalidException {
        ArrayList<Module.PackageExport> hiddenPackages = new ArrayList<Module.PackageExport>();
        LinkedList<Module> mWithDeps = new LinkedList<Module>();
        mWithDeps.add(m);
        for (Dependency d : m.getDependencies()) {
            if (d.getType() != 1) continue;
            Module _m = this.mgr.get((String)Util.parseCodeName((String)d.getName())[0]);
            assert (_m != null) : d;
            mWithDeps.add(_m);
        }
        for (Module _m : mWithDeps) {
            String hidden = (String)_m.getAttribute("OpenIDE-Module-Hide-Classpath-Packages");
            if (hidden == null) continue;
            for (String piece : hidden.trim().split("[ ,]+")) {
                try {
                    String pkg;
                    if (piece.endsWith(".*")) {
                        pkg = piece.substring(0, piece.length() - 2);
                        Dependency.create((int)1, (String)pkg);
                        if (pkg.lastIndexOf(47) != -1) {
                            throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + hidden);
                        }
                        hiddenPackages.add(new Module.PackageExport(pkg.replace('.', '/') + '/', false));
                        continue;
                    }
                    if (piece.endsWith(".**")) {
                        pkg = piece.substring(0, piece.length() - 3);
                        Dependency.create((int)1, (String)pkg);
                        if (pkg.lastIndexOf(47) != -1) {
                            throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + hidden);
                        }
                        hiddenPackages.add(new Module.PackageExport(pkg.replace('.', '/') + '/', true));
                        continue;
                    }
                    throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + hidden);
                }
                catch (IllegalArgumentException x) {
                    throw new InvalidException(_m, x.getMessage());
                }
            }
        }
        if (!hiddenPackages.isEmpty()) {
            Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
            synchronized (map) {
                this.hiddenClasspathPackages.put(m, hiddenPackages);
                for (Module.PackageExport pkg : hiddenPackages) {
                    List<Module> ms = this.hiddenClasspathPackagesReverse.get(pkg);
                    if (ms == null) {
                        ms = new LinkedList<Module>();
                        this.hiddenClasspathPackagesReverse.put(pkg, ms);
                    }
                    ms.add(m);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Module m) {
        Util.err.fine("dispose: " + m);
        Set<ManifestSection> s = this.sections.remove(m);
        if (s != null) {
            for (ManifestSection sect : s) {
                sect.dispose();
            }
        }
        this.installs.remove(m);
        this.layers.remove(m);
        this.kosherPackages.remove(m);
        Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
        synchronized (map) {
            this.hiddenClasspathPackages.remove(m);
            for (List<Module> ms : this.hiddenClasspathPackagesReverse.values()) {
                ms.remove(m);
            }
        }
    }

    protected void classLoaderUp(ClassLoader cl) {
        MainLookup.systemClassLoaderChanged(cl);
        this.ev.log("perfTick", new Object[]{"META-INF/services/ additions registered"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(List<Module> modules) {
        this.ev.log("startLoad", new Object[]{modules});
        this.checkForDeprecations(modules);
        this.loadLayers(modules, true);
        this.ev.log("perfTick", new Object[]{"layers loaded"});
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - sections"});
        this.ev.log("loadSection", new Object[0]);
        CoreBridge.getDefault().loaderPoolTransaction(true);
        try {
            for (Module m : modules) {
                try {
                    this.loadSections(m, true);
                }
                catch (Exception t) {
                    Util.err.log(Level.SEVERE, null, t);
                }
                catch (LinkageError le) {
                    Util.err.log(Level.SEVERE, null, le);
                }
                this.ev.log("perfTick", new Object[]{"sections for " + m.getCodeName() + " loaded"});
            }
        }
        finally {
            CoreBridge.getDefault().loaderPoolTransaction(false);
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - sections"});
        if (!this.initializedFolderLookup) {
            Util.err.fine("modulesClassPathInitialized");
            MainLookup.modulesClassPathInitialized();
            this.initializedFolderLookup = true;
        }
        Main.initUICustomizations();
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - ModuleInstalls"});
        for (Module m : modules) {
            try {
                this.loadCode(m, true);
            }
            catch (Exception t) {
                Util.err.log(Level.SEVERE, null, t);
            }
            catch (LinkageError le) {
                Util.err.log(Level.SEVERE, null, le);
            }
            catch (AssertionError e) {
                Util.err.log(Level.SEVERE, null, (Throwable)((Object)e));
            }
            this.ev.log("perfTick", new Object[]{"ModuleInstall for " + m.getCodeName() + " called"});
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - ModuleInstalls"});
        this.ev.log("finishLoad", new Object[]{modules});
        if (Boolean.getBoolean("netbeans.preresolve.classes")) {
            this.preresolveClasses(modules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(List<Module> modules) {
        this.ev.log("startUnload", new Object[]{modules});
        for (Module m : modules) {
            try {
                this.loadCode(m, false);
            }
            catch (Exception t) {
                Util.err.log(Level.SEVERE, null, t);
            }
            catch (LinkageError le) {
                Util.err.log(Level.SEVERE, null, le);
            }
        }
        CoreBridge.getDefault().loaderPoolTransaction(true);
        try {
            for (Module m : modules) {
                try {
                    this.loadSections(m, false);
                }
                catch (Exception t) {
                    Util.err.log(Level.SEVERE, null, t);
                }
                catch (LinkageError le) {
                    Util.err.log(Level.SEVERE, null, le);
                }
            }
        }
        finally {
            try {
                CoreBridge.getDefault().loaderPoolTransaction(false);
            }
            catch (RuntimeException e) {
                Util.err.log(Level.SEVERE, null, e);
            }
        }
        this.loadLayers(modules, false);
        this.ev.log("finishUnload", new Object[]{modules});
    }

    private void loadCode(Module m, boolean load) throws Exception {
        Class<? extends ModuleInstall> instClazz = this.installs.get(m);
        if (instClazz != null) {
            ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject(instClazz, (boolean)true);
            if (load) {
                this.ev.log("restore", new Object[]{m});
                inst.restored();
            } else {
                this.ev.log("uninstall", new Object[]{m});
                inst.uninstalled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSections(Module m, boolean load) throws Exception {
        Set<ManifestSection> s = this.sections.get(m);
        if (s == null) {
            return;
        }
        boolean attachedToMA = false;
        try {
            this.ev.log("loadSection", new Object[0]);
            for (ManifestSection sect : s) {
                if (sect instanceof ManifestSection.ActionSection) {
                    if (!attachedToMA) {
                        Object category = m.getLocalizedAttribute("OpenIDE-Module-Display-Category");
                        if (category == null) {
                            category = m.getCodeNameBase();
                        }
                        CoreBridge.getDefault().attachToCategory(category);
                        attachedToMA = true;
                    }
                    CoreBridge.getDefault().loadActionSection((ManifestSection.ActionSection)sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.ClipboardConvertorSection) {
                    this.loadGenericSection(sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.DebuggerSection) {
                    this.loadGenericSection(sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.LoaderSection) {
                    CoreBridge.getDefault().loadLoaderSection((ManifestSection.LoaderSection)sect, load);
                    continue;
                }
                assert (false) : sect;
            }
        }
        finally {
            if (attachedToMA) {
                CoreBridge.getDefault().attachToCategory(null);
            }
        }
    }

    private void loadGenericSection(ManifestSection s, boolean load) {
        CoreBridge.getDefault().loadDefaultSection(s, this.convertor, load);
    }

    private void loadLayers(List<Module> modules, boolean load) {
        LinkedHashSet<URL> theseurls;
        ModuleLayeredFileSystem host;
        this.ev.log(load ? "loadLayers" : "unloadLayers", new Object[]{modules});
        modules = new ArrayList<Module>(modules);
        Collections.reverse(modules);
        HashMap urls = new HashMap(5);
        ModuleLayeredFileSystem userModuleLayer = ModuleLayeredFileSystem.getUserModuleLayer();
        ModuleLayeredFileSystem installationModuleLayer = ModuleLayeredFileSystem.getInstallationModuleLayer();
        urls.put(userModuleLayer, new LinkedHashSet(1000));
        urls.put(installationModuleLayer, new LinkedHashSet(1000));
        for (Module module : modules) {
            host = module.isReloadable() ? userModuleLayer : installationModuleLayer;
            theseurls = (LinkedHashSet<URL>)urls.get((Object)host);
            if (theseurls == null) {
                theseurls = new LinkedHashSet<URL>(1000);
                urls.put(host, theseurls);
            }
            ClassLoader cl = module.getClassLoader();
            String s = this.layers.get(module);
            if (s != null) {
                String ext;
                String base;
                Util.err.log(Level.FINE, "loadLayer: {0} load={1}", new Object[]{s, load});
                int idx = s.lastIndexOf(46);
                if (idx == -1) {
                    base = s;
                    ext = "";
                } else {
                    base = s.substring(0, idx);
                    ext = s.substring(idx);
                }
                boolean foundSomething = false;
                for (String suffix : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
                    String resource = base + suffix + ext;
                    URL u = cl instanceof ProxyClassLoader ? ((ProxyClassLoader)cl).findResource(resource) : cl.getResource(resource);
                    if (u == null) continue;
                    theseurls.add(u);
                    foundSomething = true;
                }
                if (!foundSomething) {
                    Util.err.fine("Module layer not found: " + s);
                    continue;
                }
            }
            try {
                Method findResources = ClassLoader.class.getDeclaredMethod("findResources", String.class);
                findResources.setAccessible(true);
                Enumeration e = (Enumeration)findResources.invoke((Object)cl, "META-INF/generated-layer.xml");
                while (e.hasMoreElements()) {
                    URL u = (URL)e.nextElement();
                    theseurls.add(u);
                }
            }
            catch (Exception x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        for (Map.Entry entry : urls.entrySet()) {
            host = (ModuleLayeredFileSystem)((Object)entry.getKey());
            theseurls = (Collection)entry.getValue();
            Util.err.log(Level.FINE, "Adding/removing layer URLs: host={0} urls={1}", new Object[]{host, theseurls});
            try {
                if (load) {
                    host.addURLs(theseurls);
                    continue;
                }
                userModuleLayer.removeURLs(theseurls);
                installationModuleLayer.removeURLs(theseurls);
            }
            catch (Exception e) {
                Util.err.log(Level.WARNING, null, e);
            }
        }
    }

    private void checkForDeprecations(List<Module> modules) {
        TreeSet<String> users;
        TreeMap<String, TreeSet<String>> depToUsers = new TreeMap<String, TreeSet<String>>();
        for (Module module : modules) {
            if (Boolean.parseBoolean((String)module.getAttribute("OpenIDE-Module-Deprecated"))) continue;
            for (Dependency dep : module.getDependencies()) {
                if (dep.getType() != 1) continue;
                String cnb = (String)Util.parseCodeName((String)dep.getName())[0];
                users = (TreeSet<String>)depToUsers.get(cnb);
                if (users == null) {
                    users = new TreeSet<String>();
                    depToUsers.put(cnb, users);
                }
                users.add(module.getCodeNameBase());
            }
        }
        for (Map.Entry entry : depToUsers.entrySet()) {
            String dep = (String)entry.getKey();
            Module o = this.mgr.get(dep);
            assert (o != null) : "No such module: " + dep;
            if (!Boolean.parseBoolean((String)o.getAttribute("OpenIDE-Module-Deprecated"))) continue;
            String message = (String)o.getLocalizedAttribute("OpenIDE-Module-Deprecation-Message");
            users = (Set)entry.getValue();
            if (message != null) {
                Util.err.log(Level.WARNING, "the modules {0} use {1} which is deprecated: {2}", new Object[]{users, dep, message});
                continue;
            }
            Util.err.log(Level.WARNING, "the modules {0} use {1} which is deprecated.", new Object[]{users, dep});
        }
    }

    public boolean closing(List<Module> modules) {
        Util.err.fine("closing: " + modules);
        for (Module m : modules) {
            Class<? extends ModuleInstall> instClazz = this.installs.get(m);
            if (instClazz == null) continue;
            try {
                ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject(instClazz, (boolean)true);
                if (inst.closing()) continue;
                Util.err.fine("Module " + m + " refused to close");
                return false;
            }
            catch (RuntimeException re) {
                Util.err.log(Level.SEVERE, null, re);
            }
            catch (LinkageError le) {
                Util.err.log(Level.SEVERE, null, le);
            }
        }
        return true;
    }

    public void close(List<Module> modules) {
        Util.err.fine("close: " + modules);
        this.ev.log("close", new Object[0]);
        this.moduleList.shutDown();
        for (Module m : modules) {
            Class<? extends ModuleInstall> instClazz = this.installs.get(m);
            if (instClazz == null) continue;
            try {
                ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject(instClazz, (boolean)true);
                if (inst == null) {
                    throw new IllegalStateException("Inconsistent state: " + instClazz);
                }
                inst.close();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Util.err.log(Level.SEVERE, null, t);
            }
        }
    }

    protected Set<Dependency> loadDependencies(String cnb) {
        return cnb.equals(cacheCnb) ? cacheDeps : null;
    }

    static void register(String name, Object obj) {
        cacheCnb = name;
        cacheDeps = (Set)obj;
    }

    public void refineDependencies(Module m, Set<Dependency> dependencies) {
        AutomaticDependencies.Report rep;
        if (Boolean.getBoolean("org.netbeans.core.modules.NbInstaller.noAutoDeps")) {
            return;
        }
        if (this.autoDepsHandler == null) {
            FileObject depsFolder = FileUtil.getConfigFile((String)"ModuleAutoDeps");
            if (depsFolder != null) {
                FileObject[] kids = depsFolder.getChildren();
                ArrayList<URL> urls = new ArrayList<URL>(Math.max(kids.length, 1));
                for (FileObject kid : kids) {
                    if (!kid.hasExt("xml")) continue;
                    try {
                        urls.add(kid.getURL());
                    }
                    catch (FileStateInvalidException e) {
                        Util.err.log(Level.WARNING, null, e);
                    }
                }
                try {
                    this.autoDepsHandler = AutomaticDependencies.parse(urls.toArray(new URL[urls.size()]));
                }
                catch (IOException e) {
                    Util.err.log(Level.WARNING, null, e);
                }
                catch (SAXException e) {
                    Util.err.log(Level.WARNING, null, e);
                }
            }
            if (this.autoDepsHandler == null) {
                this.autoDepsHandler = AutomaticDependencies.empty();
            }
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("Auto deps: " + this.autoDepsHandler);
            }
        }
        if ((rep = this.autoDepsHandler.refineDependenciesAndReport(m.getCodeNameBase(), dependencies)).isModified()) {
            Util.err.warning(rep.toString());
        }
    }

    public String[] refineProvides(Module m) {
        if (m.getCodeNameBase().equals("org.openide.modules")) {
            ArrayList<String> arr = new ArrayList<String>(4);
            CoreBridge.defineOsTokens(arr);
            arr.add("org.openide.modules.ModuleFormat1");
            arr.add("org.openide.modules.ModuleFormat2");
            return arr.toArray(new String[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDelegateResource(Module m, Module parent, String pkg) {
        if (parent == null) {
            List<Module.PackageExport> hiddenPackages;
            for (String cppkg : CLASSPATH_PACKAGES) {
                if (!pkg.startsWith(cppkg) || this.findKosher(m).contains(cppkg)) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Refusing to load classpath package " + pkg + " for " + m.getCodeNameBase() + " without a proper dependency");
                }
                return false;
            }
            Map<Module, List<Module.PackageExport>> len$ = this.hiddenClasspathPackages;
            synchronized (len$) {
                hiddenPackages = this.hiddenClasspathPackages.get(m);
            }
            if (hiddenPackages != null) {
                for (Module.PackageExport hidden : hiddenPackages) {
                    if (!(hidden.recursive ? pkg.startsWith(hidden.pkg) : pkg.equals(hidden.pkg))) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Refusing to load classpath package " + pkg + " for " + m.getCodeNameBase());
                    }
                    return false;
                }
            }
        }
        if (LOG.isLoggable(Level.FINER) && !pkg.equals("java/util/logging/")) {
            LOG.finer("Delegating resource " + pkg + " from " + parent + " for " + m.getCodeNameBase());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDelegateClasspathResource(String pkg) {
        Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
        synchronized (map) {
            for (Map.Entry<Module.PackageExport, List<Module>> entry : this.hiddenClasspathPackagesReverse.entrySet()) {
                Module.PackageExport hidden = entry.getKey();
                if (!(hidden.recursive ? pkg.startsWith(hidden.pkg) : pkg.equals(hidden.pkg))) continue;
                for (Module m : entry.getValue()) {
                    if (!m.isEnabled()) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Refusing to load classpath package " + pkg + " because of " + m.getCodeNameBase());
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private Set<String> findKosher(Module m) {
        Set<String> s = this.kosherPackages.get(m);
        if (s == null) {
            s = new HashSet<String>();
            Set deps = m.getDependencies();
            SpecificationVersion openide = Util.getModuleDep((Set)deps, (String)"org.openide");
            boolean pre27853 = openide == null || openide.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
            for (Dependency dep : deps) {
                String req;
                if (dep.getType() == 1 && dep.getName().equals("org.netbeans.core.startup/1")) {
                    s.add("org/netbeans/core/startup/");
                    continue;
                }
                if (pre27853 && dep.getType() == 1) {
                    Module other;
                    String name = dep.getName();
                    int idx = name.indexOf(47);
                    if (idx != -1) {
                        name = name.substring(0, idx);
                    }
                    if ((other = this.mgr.get(name)) == null) {
                        throw new IllegalStateException("Should have found dep " + dep + " from " + m);
                    }
                    s.addAll(this.findKosher(other));
                    continue;
                }
                if (dep.getType() != 2) continue;
                String depname = dep.getName();
                int idx = depname.indexOf(91);
                if (idx == -1) {
                    req = depname.replace('.', '/').concat("/");
                } else if (idx == 0) {
                    int idx2 = depname.lastIndexOf(46);
                    req = depname.substring(1, idx2).replace('.', '/').concat("/");
                } else {
                    req = depname.substring(0, idx).replace('.', '/').concat("/");
                }
                for (String cppkg : CLASSPATH_PACKAGES) {
                    if (!req.startsWith(cppkg)) continue;
                    s.add(cppkg);
                }
            }
            if (s.isEmpty()) {
                s = Collections.emptySet();
            }
            this.kosherPackages.put(m, s);
        }
        return s;
    }

    String getEffectiveClasspath(Module m) {
        if (!m.isEnabled()) {
            return "";
        }
        ArrayList<String> l = new ArrayList<String>(100);
        NbInstaller.createBootClassPath(l);
        Set<String> kosher = m.isFixed() ? null : this.findKosher(m);
        StringTokenizer tok = new StringTokenizer(System.getProperty("java.class.path", ""), File.pathSeparator);
        while (tok.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(tok.nextToken()), l, kosher);
        }
        tok = new StringTokenizer(System.getProperty("netbeans.dynamic.classpath", ""), File.pathSeparator);
        while (tok.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(tok.nextToken()), l, kosher);
        }
        HashSet<Module> modulesConsidered = new HashSet<Module>(50);
        HashSet<String> implDeps = new HashSet<String>(10);
        for (Dependency dep : m.getDependencies()) {
            if (dep.getType() != 1 || dep.getComparison() != 2) continue;
            implDeps.add(dep.getName());
        }
        SpecificationVersion openide = Util.getModuleDep((Set)m.getDependencies(), (String)"org.openide");
        boolean pre27853 = openide == null || openide.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
        this.addModuleClasspathEntries(m, m, modulesConsidered, implDeps, l, pre27853 ? Integer.MAX_VALUE : 1);
        StringBuilder buf = new StringBuilder(l.size() * 100 + 1);
        for (String s : l) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private static void createBootClassPath(List<String> l) {
        String extensions;
        String boot = System.getProperty("sun.boot.class.path");
        if (boot != null) {
            StringTokenizer tok = new StringTokenizer(boot, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                l.add(tok.nextToken());
            }
        }
        if ((extensions = System.getProperty("java.ext.dirs")) != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                for (File f : entries) {
                    String name = f.getName().toLowerCase(Locale.US);
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                    l.add(f.getAbsolutePath());
                }
            }
        }
    }

    private static void addStartupClasspathEntry(File cpEntry, List<String> cp, Set<String> kosher) {
        if (cpEntry.isDirectory()) {
            cp.add(cpEntry.getAbsolutePath());
            return;
        }
        String name = cpEntry.getName();
        for (String[] cpjar : CLASSPATH_JARS) {
            if (kosher == null || !name.startsWith(cpjar[0])) continue;
            StringBuilder entry = null;
            for (int k = 1; k < cpjar.length; ++k) {
                String pkg = cpjar[k];
                if (!kosher.contains(pkg)) continue;
                if (entry == null) {
                    entry = new StringBuilder(100);
                    entry.append(cpEntry.getAbsolutePath());
                    entry.append('[');
                } else {
                    entry.append(',');
                }
                entry.append(pkg.replace('/', '.'));
                entry.append("**");
            }
            if (entry != null) {
                entry.append(']');
                cp.add(entry.toString());
            }
            return;
        }
        cp.add(cpEntry.getAbsolutePath());
    }

    private void addModuleClasspathEntries(Module m, Module orig, Set<Module> considered, Set<String> implDeps, List<String> cp, int depth) {
        if (!considered.add(m)) {
            return;
        }
        for (Dependency dep : m.getDependencies()) {
            if (dep.getType() != 1) continue;
            String cnb = (String)Util.parseCodeName((String)dep.getName())[0];
            Module next = this.mgr.get(cnb);
            if (next == null) {
                throw new IllegalStateException("No such module: " + cnb);
            }
            if (depth <= 0) continue;
            this.addModuleClasspathEntries(next, orig, considered, implDeps, cp, depth - 1);
        }
        boolean friend = m == orig || implDeps.contains(m.getCodeName());
        Module.PackageExport[] exports = friend ? null : m.getPublicPackages();
        String qualification = "";
        if (exports != null) {
            if (exports.length == 0) {
                return;
            }
            StringBuilder b = new StringBuilder(100);
            b.append('[');
            for (int i = 0; i < exports.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(exports[i].pkg.replace('/', '.'));
                b.append(exports[i].recursive ? "**" : "*");
            }
            b.append(']');
            qualification = b.toString();
        }
        for (File jar : m.getAllJars()) {
            cp.add(jar.getAbsolutePath() + qualification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest loadManifest(File jar) throws IOException {
        Map<File, DateAndManifest> cache;
        if (!this.usingManifestCache) {
            return super.loadManifest(jar);
        }
        Object object = this.MANIFEST_CACHE;
        synchronized (object) {
            if (this.manifestCache == null) {
                this.manifestCache = Collections.synchronizedMap(this.loadManifestCache());
            }
            cache = this.manifestCache;
        }
        DateAndManifest entry = cache.get(jar);
        if (entry != null) {
            MANIFEST_LOG.fine("Found manifest for " + jar + " in cache");
            return entry.manifest;
        }
        MANIFEST_LOG.fine("No entry for " + jar + " in manifest cache");
        Manifest m = super.loadManifest(jar);
        cache.put(jar, new DateAndManifest(jar.lastModified(), m));
        this.saveManifestCache();
        return m;
    }

    private void saveManifestCache() throws IOException {
        MANIFEST_LOG.fine("Schedule saving manifest cache");
        Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this.updater, "all-manifest.dat", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, DateAndManifest> loadManifestCache() {
        this.ev.log("perfStart", new Object[]{"NbInstaller - loadManifestCache"});
        ByteBuffer bis = Stamps.getModulesJARs().asByteBuffer("all-manifest.dat");
        HashMap<File, DateAndManifest> m = new HashMap<File, DateAndManifest>(200);
        try {
            NbInstaller.readManifestCacheEntries(bis, m);
        }
        catch (IOException ex) {
            try {
                MANIFEST_LOG.log(Level.WARNING, "Cannot read cache", ex);
            }
            catch (Throwable throwable) {
                this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
                throw throwable;
            }
            this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
        return m;
    }

    private static int findNullByte(ByteBuffer data, int start) {
        int len = data.limit();
        for (int i = start; i < len; ++i) {
            if (data.get(i) != 0) continue;
            return i;
        }
        return -1;
    }

    private static void readManifestCacheEntries(ByteBuffer data, Map<File, DateAndManifest> m) throws IOException {
        if (data == null) {
            return;
        }
        int pos = 0;
        while (pos != data.limit()) {
            Manifest mani;
            int end = NbInstaller.findNullByte(data, pos);
            if (end == -1) {
                throw new IOException("Could not find next manifest JAR name from " + pos);
            }
            File jar = new File(new String(NbInstaller.toArray(data, pos, end - pos), "UTF-8"));
            long time = 0L;
            if (end + 8 >= data.limit()) {
                throw new IOException("Ran out of space for timestamp for " + jar);
            }
            for (int i = 0; i < 8; ++i) {
                long b = data.get(end + i + 1);
                if (b < 0L) {
                    b += 256L;
                }
                int exponent = 7 - i;
                long addin = b << exponent * 8;
                time |= addin;
            }
            pos = end + 9;
            if ((end = NbInstaller.findNullByte(data, pos)) == -1) {
                throw new IOException("Could not find manifest body for " + jar);
            }
            try {
                mani = new Manifest(new ByteArrayInputStream(NbInstaller.toArray(data, pos, end - pos)));
            }
            catch (IOException ioe) {
                Exceptions.attachMessage((Throwable)ioe, (String)("While in entry for " + jar));
                throw ioe;
            }
            m.put(jar, new DateAndManifest(time, mani));
            if (MANIFEST_LOG.isLoggable(Level.FINE)) {
                MANIFEST_LOG.fine("Manifest cache entry: jar=" + jar + " date=" + new Date(time) + " codename=" + mani.getMainAttributes().getValue("OpenIDE-Module"));
            }
            pos = end + 1;
        }
        return;
    }

    private static byte[] toArray(ByteBuffer bb, int pos, int len) {
        byte[] manarr = new byte[len];
        bb.position(pos);
        bb.get(manarr, 0, len);
        return manarr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preresolveClasses(List<Module> modules) {
        Util.err.info("Pre-resolving classes for all loaded modules...be sure you have not specified -J-Xverify:none in ide.cfg");
        for (Module m : modules) {
            if (m.isFixed() || m.getJarFile() == null) continue;
            File jar = m.getJarFile();
            try {
                JarFile j = new JarFile(jar, true);
                try {
                    for (JarEntry entry : NbCollections.iterable(j.entries())) {
                        String name = entry.getName();
                        if (!name.endsWith(".class")) continue;
                        String clazz = name.substring(0, name.length() - 6).replace('/', '.');
                        Throwable t = null;
                        try {
                            Class.forName(clazz, false, m.getClassLoader());
                        }
                        catch (ClassNotFoundException cnfe) {
                            t = cnfe;
                        }
                        catch (LinkageError le) {
                            t = le;
                        }
                        catch (RuntimeException re) {
                            t = re;
                        }
                        if (t == null) continue;
                        Util.err.log(Level.WARNING, "From " + clazz + " in " + m.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(m), t);
                    }
                }
                finally {
                    j.close();
                }
            }
            catch (IOException ioe) {
                Util.err.log(Level.WARNING, null, ioe);
            }
        }
    }

    static {
        CLASSPATH_PACKAGES = new String[]{"org/netbeans/core/startup/"};
        CLASSPATH_JARS = new String[][]{{"core", "org/netbeans/core/", "org/netbeans/beaninfo/"}, {"boot"}};
        MANIFEST_LOG = Logger.getLogger(NbInstaller.class.getName() + ".manifestCache");
    }

    class CacheFlusher
    implements Stamps.Updater {
        CacheFlusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCaches(DataOutputStream os) throws IOException {
            HashMap m;
            NbInstaller.this.updater = new CacheFlusher();
            MANIFEST_LOG.fine("Saving manifest cache");
            Object object = NbInstaller.this.MANIFEST_CACHE;
            synchronized (object) {
                m = new HashMap(NbInstaller.this.manifestCache);
            }
            for (Map.Entry entry : m.entrySet()) {
                File jar = (File)entry.getKey();
                os.write(jar.getAbsolutePath().getBytes("UTF-8"));
                os.write(0);
                long time = ((DateAndManifest)entry.getValue()).date;
                for (int i = 7; i >= 0; --i) {
                    os.write((int)(time >> i * 8 & 0xFFL));
                }
                ((DateAndManifest)entry.getValue()).manifest.write(os);
                os.write(0);
            }
            os.close();
            MANIFEST_LOG.fine("Saving manifest cache - done");
        }

        public void cacheReady() {
        }
    }

    private static final class DateAndManifest {
        public final long date;
        public final Manifest manifest;

        public DateAndManifest(long date, Manifest manifest) {
            this.date = date;
            this.manifest = manifest;
        }
    }

    private final class Convertor
    implements InstanceContent.Convertor<ManifestSection, Object> {
        Convertor() {
        }

        public Object convert(ManifestSection s) {
            try {
                return s.getInstance();
            }
            catch (Exception e) {
                Util.err.log(Level.WARNING, null, e);
                NbInstaller.this.loadGenericSection(s, false);
                return null;
            }
        }

        public Class<?> type(ManifestSection s) {
            return s.getSuperclass();
        }

        public String id(ManifestSection obj) {
            return obj.toString();
        }

        public String displayName(ManifestSection obj) {
            return obj.toString();
        }
    }
}

