/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AddOverrideAnnotation
extends AbstractHint {
    public AddOverrideAnnotation() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Override");
        if (typeElement == null || !GeneratorUtils.supportsOverride((CompilationInfo)compilationInfo)) {
            return null;
        }
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element != null && element.getKind() == ElementKind.METHOD) {
            ExecutableElement executableElement = (ExecutableElement)element;
            ArrayList arrayList = new ArrayList();
            AnnotationType annotationType = ComputeOverriding.detectOverrides((CompilationInfo)compilationInfo, (TypeElement)((TypeElement)executableElement.getEnclosingElement()), (ExecutableElement)executableElement, arrayList);
            boolean bl = false;
            for (AnnotationMirror object : executableElement.getAnnotationMirrors()) {
                if (!compilationInfo.getTypes().isSameType(object.getAnnotationType(), typeElement.asType())) continue;
                bl = true;
                break;
            }
            if (bl) {
                return null;
            }
            boolean bl2 = false;
            if (annotationType == AnnotationType.OVERRIDES) {
                bl2 = true;
            } else if (annotationType == AnnotationType.IMPLEMENTS) {
                boolean bl3 = bl2 = compilationInfo.getSourceVersion() != SourceVersion.RELEASE_5;
            }
            if (bl2) {
                List<FixImpl> list = Collections.singletonList(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
                int[] nArray = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)treePath.getLeaf());
                if (nArray != null) {
                    String string = NbBundle.getMessage(AddOverrideAnnotation.class, (String)"HINT_AddOverrideAnnotation");
                    ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string, list, (FileObject)compilationInfo.getFileObject(), (int)nArray[0], (int)nArray[1]);
                    return Collections.singletonList(errorDescription);
                }
            }
        }
        return null;
    }

    @Override
    public String getId() {
        return AddOverrideAnnotation.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AddOverrideAnnotation.class, (String)"DN_AddOverrideAnnotation");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AddOverrideAnnotation.class, (String)"DESC_AddOverrideAnnotation");
    }

    @Override
    public void cancel() {
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static final class FixImpl
    implements Fix {
        private TreePathHandle handle;
        private FileObject file;
        private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.VARIABLE);

        public FixImpl(TreePathHandle treePathHandle, FileObject fileObject) {
            this.handle = treePathHandle;
            this.file = fileObject;
        }

        public String getText() {
            return NbBundle.getMessage(AddOverrideAnnotation.class, (String)"FIX_AddOverrideAnnotation");
        }

        public ChangeInfo implement() throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = FixImpl.this.handle.resolve((CompilationInfo)workingCopy);
                    if (treePath == null) {
                        Logger.getLogger(AddOverrideAnnotation.class.getName()).log(Level.FINE, "Cannot resolve TreePathHandle in the fix.");
                        return;
                    }
                    while (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)treePath.getLeaf().getKind())) {
                        treePath = treePath.getParentPath();
                    }
                    if (treePath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                        return;
                    }
                    Tree tree2 = treePath.getLeaf();
                    ModifiersTree modifiersTree = null;
                    switch (tree2.getKind()) {
                        case METHOD: {
                            modifiersTree = ((MethodTree)tree2).getModifiers();
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled Tree.Kind";
                            break;
                        }
                    }
                    if (modifiersTree == null) {
                        return;
                    }
                    TypeElement typeElement = workingCopy.getElements().getTypeElement("java.lang.Override");
                    if (typeElement == null) {
                        return;
                    }
                    for (AnnotationTree tree3 : modifiersTree.getAnnotations()) {
                        TreePath treePath2 = new TreePath(new TreePath(treePath, tree3), tree3.getAnnotationType());
                        Element element = workingCopy.getTrees().getElement(treePath2);
                        if (!typeElement.equals(element)) continue;
                        return;
                    }
                    ArrayList<? extends AnnotationTree> arrayList = new ArrayList<AnnotationTree>(modifiersTree.getAnnotations());
                    arrayList.add(workingCopy.getTreeMaker().Annotation((Tree)workingCopy.getTreeMaker().QualIdent((Element)typeElement), Collections.emptyList()));
                    ModifiersTree modifiersTree2 = workingCopy.getTreeMaker().Modifiers(modifiersTree, (List)arrayList);
                    workingCopy.rewrite((Tree)modifiersTree, (Tree)modifiersTree2);
                }
            }).commit();
            return null;
        }
    }
}

