/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import org.netbeans.modules.cnd.repository.queue.StopWatch;

public class BaseQueue {
    protected final Object lock = new Lock();
    protected StopWatch stopWatch = this.needsTiming() ? new StopWatch(false) : null;
    protected final Queue queue;

    public BaseQueue(Queue queue) {
        this.queue = queue;
    }

    protected boolean needsTiming() {
        return false;
    }

    protected boolean needsTrace() {
        return false;
    }

    protected String getTraceName() {
        return this.getClass().getName() + '@' + this.hashCode();
    }

    private static final class Lock {
        private Lock() {
        }
    }

    protected static class Queue {
        private AbstractEntry head;
        private AbstractEntry tail;

        protected Queue() {
        }

        private void link(AbstractEntry e1, AbstractEntry e2) {
            if (e1 != null) {
                e1.next = e2;
            }
            if (e2 != null) {
                e2.prev = e1;
            }
        }

        public void addFirst(AbstractEntry e) {
            this.link(e, this.head);
            this.head = e;
            if (this.tail == null) {
                this.tail = this.head;
            }
            e.prev = null;
        }

        public void addLast(AbstractEntry e) {
            if (this.tail == null) {
                assert (this.head == null);
                this.addFirst(e);
            } else {
                this.link(this.tail, e);
                this.tail = e;
            }
            e.next = null;
        }

        public void remove(AbstractEntry e) {
            this.link(e.prev, e.next);
            if (this.head == e) {
                this.head = e.next;
            }
            if (this.tail == e) {
                this.tail = e.prev;
            }
        }

        public void clear() {
            this.tail = null;
            this.head = null;
        }

        public AbstractEntry peek() {
            return this.head;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public AbstractEntry poll() {
            AbstractEntry ret = this.head;
            if (this.head != null) {
                this.remove(this.head);
            }
            return ret;
        }
    }

    protected static abstract class AbstractEntry {
        private AbstractEntry prev;
        private AbstractEntry next;

        protected AbstractEntry() {
        }
    }
}

