/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.spi;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.collab.chat.PresenceIndicator;
import org.netbeans.modules.kenai.ui.KenaiLoginTask;
import org.netbeans.modules.kenai.ui.LoginPanel;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.dashboard.UserNode;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.netbeans.modules.kenai.ui.spi.Scrambler;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class UIUtils {
    public static final String ONLINE_ON_CHAT_PREF = ".online_chat";
    private static final String KENAI_PASSWORD_PREF = ".password";
    private static final String KENAI_USERNAME_PREF = ".username";
    public static final String ONLINE_STATUS_PREF = ".online";
    public static final String LOGIN_STATUS_PREF = ".login";
    private static Logger metricsLogger;
    private static final String USG_KENAI = "USG_KENAI";
    private static Set<String> loggedParams;

    public static String getPrefName(Kenai kenai, String name) {
        return kenai.getUrl().getHost() + name;
    }

    public static void waitStartupFinished() {
        KenaiLoginTask.waitStartupFinished();
    }

    private UIUtils() {
    }

    @Deprecated
    public static synchronized boolean tryLogin(Kenai kenai, boolean force) {
        String online;
        if (kenai.getStatus() != Kenai.Status.OFFLINE) {
            return true;
        }
        Preferences preferences = NbPreferences.forModule(LoginPanel.class);
        if (!force && !Boolean.parseBoolean(online = preferences.get(UIUtils.getPrefName(kenai, LOGIN_STATUS_PREF), "false"))) {
            return false;
        }
        String uname = preferences.get(UIUtils.getPrefName(kenai, KENAI_USERNAME_PREF), null);
        if (uname == null) {
            return false;
        }
        boolean goOnline = Boolean.parseBoolean(preferences.get(UIUtils.getPrefName(kenai, ONLINE_STATUS_PREF), "false")) && Utilities.isChatSupported(kenai);
        PresenceIndicator.getDefault().init();
        try {
            KenaiConnection.getDefault(kenai);
            char[] password = UIUtils.loadPassword(kenai, preferences);
            if (password == null) {
                return false;
            }
            kenai.login(uname, password, force ? true : goOnline);
        }
        catch (KenaiException ex) {
            return false;
        }
        return true;
    }

    public static boolean showLogin() {
        return UIUtils.showKenaiLogin() != null;
    }

    public static Kenai showKenaiLogin() {
        for (Kenai k : KenaiManager.getDefault().getKenais()) {
            if (k.getStatus() != Kenai.Status.OFFLINE) continue;
            return UIUtils.showKenaiLogin(k);
        }
        return UIUtils.showKenaiLogin(null);
    }

    private static char[] loadPassword(Kenai kenai, Preferences preferences) {
        String passwordPref = UIUtils.getPrefName(kenai, KENAI_PASSWORD_PREF);
        String scrambledPassword = preferences.get(passwordPref, null);
        char[] newPassword = Keyring.read((String)passwordPref);
        if (scrambledPassword != null) {
            preferences.remove(passwordPref);
            if (newPassword == null) {
                return Scrambler.getInstance().descramble(scrambledPassword).toCharArray();
            }
        }
        return newPassword;
    }

    public static boolean showLogin(Kenai kenai) {
        return UIUtils.showKenaiLogin(kenai) != null;
    }

    public static Kenai showKenaiLogin(Kenai kenai) {
        PresenceIndicator.getDefault().init();
        final LoginPanel loginPanel = new LoginPanel(kenai, new CredentialsImpl());
        final Preferences preferences = NbPreferences.forModule(LoginPanel.class);
        final String ctlLogin = NbBundle.getMessage(Utilities.class, (String)"CTL_Login");
        String ctlCancel = NbBundle.getMessage(Utilities.class, (String)"CTL_Cancel");
        DialogDescriptor login = new DialogDescriptor((Object)loginPanel, NbBundle.getMessage(Utilities.class, (String)"CTL_LoginToKenai"), true, new Object[]{ctlLogin, ctlCancel}, (Object)ctlLogin, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final Kenai k = loginPanel.getKenai();
                if (event.getSource().equals(ctlLogin)) {
                    UIUtils.logKenaiUsage("LOGIN");
                    loginPanel.showProgress();
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                KenaiConnection.getDefault(k);
                                PasswordAuthentication current = k.getPasswordAuthentication();
                                if (!(current == null || loginPanel.getUsername().equals(current.getUserName()) && Arrays.equals(loginPanel.getPassword(), current.getPassword()))) {
                                    k.logout();
                                }
                                k.login(loginPanel.getUsername(), loginPanel.getPassword(), loginPanel.isOnline());
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JDialog parent;
                                        JRootPane rootPane = loginPanel.getRootPane();
                                        if (rootPane != null && (parent = (JDialog)rootPane.getParent()) != null) {
                                            parent.setVisible(false);
                                            parent.dispose();
                                        }
                                    }
                                });
                            }
                            catch (KenaiException ex) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        loginPanel.showError(ex);
                                    }
                                });
                            }
                        }
                    });
                    String passwordPref = UIUtils.getPrefName(k, UIUtils.KENAI_PASSWORD_PREF);
                    if (loginPanel.isStorePassword()) {
                        preferences.put(UIUtils.getPrefName(k, UIUtils.KENAI_USERNAME_PREF), loginPanel.getUsername());
                        Keyring.save((String)passwordPref, (char[])loginPanel.getPassword(), (String)NbBundle.getMessage(UIUtils.class, (String)"UIUtils.password_keyring_description", (Object)k.getUrl().getHost()));
                    } else {
                        preferences.remove(UIUtils.getPrefName(k, UIUtils.KENAI_USERNAME_PREF));
                        Keyring.delete((String)passwordPref);
                    }
                    preferences.remove(passwordPref);
                } else {
                    loginPanel.putClientProperty("cancel", "true");
                    JDialog parent = (JDialog)loginPanel.getRootPane().getParent();
                    parent.setVisible(false);
                    parent.dispose();
                }
            }
        });
        login.setClosingOptions(new Object[]{ctlCancel});
        Dialog d = DialogDisplayer.getDefault().createDialog(login);
        d.pack();
        d.setResizable(false);
        loginPanel.clearStatus();
        d.setVisible(true);
        if (loginPanel.getClientProperty("cancel") == null) {
            return loginPanel.getKenai();
        }
        return null;
    }

    public static JLabel createUserWidget(String user) {
        return UIUtils.createUserWidget(new KenaiUserUI(user));
    }

    static JLabel createUserWidget(final KenaiUserUI u) {
        final JLabel result = new JLabel(u.getUserName());
        result.setIcon(u.getIcon());
        final String name = u.getKenaiUser().getFirstName() + " " + u.getKenaiUser().getLastName();
        result.setToolTipText(NbBundle.getMessage(UserNode.class, (String)(u.getKenaiUser().isOnline() ? "LBL_ONLINE_MEMBER_TOOLTIP" : "LBL_OFFLINE_MEMBER_TOOLTIP"), (Object)u.getUserName(), (Object)name));
        u.user.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("Presence".equals(evt.getPropertyName())) {
                    result.firePropertyChange("Presence", (Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
                    result.setToolTipText(NbBundle.getMessage(UserNode.class, (String)(u.getKenaiUser().isOnline() ? "LBL_ONLINE_MEMBER_TOOLTIP" : "LBL_OFFLINE_MEMBER_TOOLTIP"), (Object)u.getUserName(), (Object)name));
                    result.repaint();
                }
            }
        });
        result.addMouseListener(new MouseAdapter(){
            private Cursor oldCursor;

            @Override
            public void mouseEntered(MouseEvent e) {
                this.oldCursor = result.getCursor();
                result.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                result.setCursor(this.oldCursor);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    u.startChat();
                }
            }
        });
        return result;
    }

    public static void logKenaiUsage(Object ... parameters) {
        String paramStr = UIUtils.getParamString(parameters);
        if (loggedParams.add(paramStr)) {
            if (metricsLogger == null) {
                metricsLogger = Logger.getLogger("org.netbeans.ui.metrics.kenai");
            }
            LogRecord rec = new LogRecord(Level.INFO, USG_KENAI);
            rec.setParameters(parameters);
            rec.setLoggerName(metricsLogger.getName());
            metricsLogger.log(rec);
        }
    }

    private static String getParamString(Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        if (parameters.length == 1) {
            return parameters[0].toString();
        }
        StringBuilder buf = new StringBuilder();
        for (Object p : parameters) {
            buf.append(p.toString());
        }
        return buf.toString();
    }

    static {
        loggedParams = Collections.synchronizedSet(new HashSet());
    }

    private static class CredentialsImpl
    implements LoginPanel.Credentials {
        private CredentialsImpl() {
        }

        @Override
        public String getUsername(Kenai kenai) {
            Preferences preferences = NbPreferences.forModule(LoginPanel.class);
            String uname = preferences.get(UIUtils.getPrefName(kenai, UIUtils.KENAI_USERNAME_PREF), "");
            if (uname == null) {
                return "";
            }
            return uname;
        }

        @Override
        public char[] getPassword(Kenai kenai) {
            Preferences preferences = NbPreferences.forModule(LoginPanel.class);
            char[] password = UIUtils.loadPassword(kenai, preferences);
            if (password == null) {
                return new char[0];
            }
            return password;
        }
    }
}

