/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.ruby.platform.Util;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class RubyInstallation {
    private static final Logger LOGGER = Logger.getLogger(RubyInstallation.class.getName());
    private static final String JRUBY_RELEASE = "1.5.0";
    private static final String JRUBY_RELEASEDIR = "jruby-1.5.0";
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    public static final String RHTML_MIME_TYPE = "application/x-httpd-eruby";
    public static final String YAML_MIME_TYPE = "text/x-yaml";
    private static final RubyInstallation INSTANCE = new RubyInstallation();
    private String jrubyHome;

    private RubyInstallation() {
    }

    public static RubyInstallation getInstance() {
        return INSTANCE;
    }

    public void setJRubyLoadPaths() {
        String jh = this.getJRubyHome();
        if (jh != null) {
            System.setProperty("jruby.home", jh);
        }
    }

    public String getJRuby() {
        String binDir = this.getJRubyBin();
        if (binDir == null) {
            return null;
        }
        String binary = Utilities.isWindows() ? "jruby.bat" : "jruby";
        String jruby = binDir + File.separator + binary;
        try {
            jruby = new File(jruby).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        if (!new File(jruby).isFile()) {
            return null;
        }
        return jruby;
    }

    static void displayRubyOptions() {
        OptionsDisplayer.getDefault().open("RubyOptions");
    }

    public String getJRubyHome() {
        if (this.jrubyHome == null) {
            File jrubyDir = InstalledFileLocator.getDefault().locate(JRUBY_RELEASEDIR, "org.netbeans.modules.ruby.project", false);
            if (jrubyDir == null || !jrubyDir.isDirectory()) {
                return null;
            }
            this.jrubyHome = jrubyDir.getPath();
        }
        return this.jrubyHome;
    }

    private String getJRubyBin() {
        String jh = this.getJRubyHome();
        if (jh != null) {
            return jh + File.separator + "bin";
        }
        return null;
    }

    public void ensureExecutable() {
        if (Utilities.isWindows()) {
            return;
        }
        String binDirPath = this.getJRubyBin();
        if (binDirPath == null) {
            return;
        }
        File binDir = new File(binDirPath);
        if (!binDir.exists()) {
            return;
        }
        File chmod = new File("/bin/chmod");
        if (!chmod.isFile()) {
            chmod = new File("/usr/bin/chmod");
        }
        if (chmod.isFile()) {
            try {
                String[] files;
                ArrayList<String> argv = new ArrayList<String>();
                argv.add(chmod.getAbsolutePath());
                argv.add("u+rx");
                for (String file : files = binDir.list()) {
                    argv.add(file);
                }
                ProcessBuilder pb = new ProcessBuilder(argv);
                pb.directory(binDir);
                Util.adjustProxy(pb);
                Process process = pb.start();
                int chmoded = process.waitFor();
                if (chmoded != 0) {
                    throw new IOException("could not run " + argv + " : Exit value=" + chmoded);
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.INFO, "Can't chmod+x JRuby bits", e);
            }
        }
    }
}

