/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.PkgConfigManager;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class LogReader {
    private static boolean TRACE = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.log");
    private String workingDir;
    private String guessWorkingDir;
    private String baseWorkingDir;
    private final String root;
    private final String fileName;
    private List<SourceFileProperties> result;
    private final PathMap pathMapper;
    private final ProjectProxy project;
    private final ArrayList<List<String>> makeStack = new ArrayList();
    private static final String CURRENT_DIRECTORY = "Current working directory";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LEAVING_DIRECTORY = "Leaving directory";
    private static final String LABEL_CD = "cd ";
    private static final String INVOKE_GNU_C = "gcc ";
    private static final String INVOKE_GNU_C2 = "gcc.exe ";
    private static final String INVOKE_SUN_C = "cc ";
    private static final String INVOKE_GNU_Cpp = "g++ ";
    private static final String INVOKE_GNU_Cpp2 = "g++.exe ";
    private static final String INVOKE_GNU_Cpp3 = "c++ ";
    private static final String INVOKE_GNU_Cpp4 = "c++.exe ";
    private static final String INVOKE_SUN_Cpp = "CC ";
    private static final String INVOKE_MSVC_Cpp = "cl ";
    private static final String MAKE_DELIMITER = ";";
    private static final String PKG_CONFIG_PATTERN = "pkg-config ";
    private static final String ECHO_PATTERN = "echo ";
    private static final FileFilter dirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !DiscoveryUtils.ignoreFolder((File)file);
        }
    };

    public LogReader(String string, String string2, ProjectProxy projectProxy) {
        this.root = string2.length() > 0 ? CndFileUtils.normalizeFile((File)new File(string2)).getAbsolutePath() : string2;
        this.fileName = string;
        this.project = projectProxy;
        this.pathMapper = this.getPathMapper(projectProxy);
        this.setWorkingDir(string2);
    }

    private String convertPath(String string) {
        String string2;
        if (this.pathMapper != null && (string2 = this.pathMapper.getLocalPath(string)) != null) {
            return string2;
        }
        return string;
    }

    private PathMap getPathMapper(ProjectProxy projectProxy) {
        ExecutionEnvironment executionEnvironment;
        RemoteProject remoteProject;
        Project project = projectProxy.getProject();
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && (executionEnvironment = remoteProject.getDevelopmentHost()) != null && executionEnvironment.isRemote()) {
            return HostInfoProvider.getMapper((ExecutionEnvironment)executionEnvironment);
        }
        return null;
    }

    private MakeConfiguration getConfiguration(ProjectProxy projectProxy) {
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        ConfigurationDescriptorProvider configurationDescriptorProvider;
        if (projectProxy != null && projectProxy.getProject() != null && (configurationDescriptorProvider = (ConfigurationDescriptorProvider)projectProxy.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && configurationDescriptorProvider.gotDescriptor() && (makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor()) != null) {
            return makeConfigurationDescriptor.getActiveConfiguration();
        }
        return null;
    }

    private void run(Progress progress, AtomicBoolean atomicBoolean) {
        if (TRACE) {
            System.out.println("LogReader is run for " + this.fileName);
        }
        Pattern pattern = Pattern.compile(";|\\|\\||&&");
        this.result = new ArrayList<SourceFileProperties>();
        File file = new File(this.fileName);
        if (file.exists() && file.canRead()) {
            try {
                String string;
                MakeConfiguration makeConfiguration = this.getConfiguration(this.project);
                PkgConfigManager.PkgConfig pkgConfig = PkgConfigManager.getDefault().getPkgConfig(makeConfiguration);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                long l = file.length();
                long l2 = 0L;
                int n = 0;
                if (l <= 0L) {
                    progress = null;
                }
                if (progress != null) {
                    progress.start(100);
                }
                int n2 = 0;
                while (!atomicBoolean.get() && (string = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    l2 += (long)(string.length() + 1);
                    string = string.trim();
                    while (string.endsWith("\\") && (stringArray = bufferedReader.readLine()) != null) {
                        string = string.substring(0, string.length() - 1) + " " + stringArray.trim();
                    }
                    string = LogReader.trimBackApostropheCalls(string, pkgConfig);
                    stringArray = pattern.split(string);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!this.parseLine(stringArray[i])) continue;
                        ++n2;
                    }
                    if (l2 * 100L / l <= (long)n || n >= 100) continue;
                    ++n;
                    if (progress == null) continue;
                    progress.increment();
                }
                if (progress != null) {
                    progress.done();
                }
                if (TRACE) {
                    System.out.println("Files found: " + n2);
                    System.out.println("Files included in result: " + this.result.size());
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public List<SourceFileProperties> getResults(Progress progress, AtomicBoolean atomicBoolean) {
        if (this.result == null) {
            this.run(progress, atomicBoolean);
        }
        return this.result;
    }

    private int getMakeLevel(String string) {
        int n;
        int n2 = string.indexOf(91);
        if (n2 > 0 && (n = string.indexOf(93)) > n2) {
            String string2 = string.substring(n2 + 1, n);
            try {
                int n3 = Integer.parseInt(string2);
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private void enterMakeStack(String string, int n) {
        if (n < 0) {
            return;
        }
        for (int i = this.makeStack.size(); i <= n; ++i) {
            this.makeStack.add(new ArrayList());
        }
        List<String> list = this.makeStack.get(n);
        list.add(string);
    }

    private boolean leaveMakeStack(String string, int n) {
        if (n < 0) {
            return false;
        }
        if (this.makeStack.size() <= n) {
            return false;
        }
        List<String> list = this.makeStack.get(n);
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            list.remove(string2);
            return true;
        }
        return false;
    }

    private List<String> getMakeTop(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = Math.min(this.makeStack.size(), n - 1); i >= 0; --i) {
            List<String> list = this.makeStack.get(i);
            if (list.size() <= 0) continue;
            if (arrayList.size() == 0) {
                arrayList.addAll(list);
                continue;
            }
            if (list.size() <= 1) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private boolean checkDirectoryChange(String string) {
        String string2;
        String string3 = null;
        String string4 = null;
        if (string.startsWith(CURRENT_DIRECTORY)) {
            string3 = this.convertPath(string.substring(CURRENT_DIRECTORY.length() + 1).trim());
            if (TRACE) {
                string4 = "**>> by [Current working directory] ";
            }
        } else if (string.indexOf(ENTERING_DIRECTORY) >= 0) {
            String string5 = string.substring(string.indexOf(ENTERING_DIRECTORY) + ENTERING_DIRECTORY.length() + 1).trim();
            string3 = this.convertPath(string5.replaceAll("`|'|\"", ""));
            if (TRACE) {
                string4 = "**>> by [Entering directory] ";
            }
            this.baseWorkingDir = string3;
            this.enterMakeStack(string3, this.getMakeLevel(string));
        } else if (string.indexOf(LEAVING_DIRECTORY) >= 0) {
            List<String> list;
            int n;
            String string6 = string.substring(string.indexOf(LEAVING_DIRECTORY) + LEAVING_DIRECTORY.length() + 1).trim();
            string3 = this.convertPath(string6.replaceAll("`|'|\"", ""));
            if (TRACE) {
                string4 = "**>> by [Leaving directory] ";
            }
            if (this.leaveMakeStack(string3, n = this.getMakeLevel(string)) && (list = this.getMakeTop(n)).size() == 1) {
                this.baseWorkingDir = list.get(0);
            }
        } else if (string.startsWith(LABEL_CD)) {
            int n = string.indexOf(MAKE_DELIMITER);
            string3 = this.convertPath((n == -1 ? string : string.substring(0, n)).substring(LABEL_CD.length()).trim());
            if (TRACE) {
                string4 = "**>> by [ cd ] ";
            }
            if (string3.startsWith("/")) {
                this.baseWorkingDir = string3;
            }
        } else if (string.startsWith("/") && string.indexOf(" ") < 0) {
            string3 = this.convertPath(string.trim());
            if (TRACE) {
                string4 = "**>> by [just path string] ";
            }
        }
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        if (Utilities.isWindows() && string3.startsWith("/cygdrive/") && string3.length() > 11) {
            string3 = "" + string3.charAt(10) + ":" + string3.substring(11);
        }
        if ((string3.charAt(0) == '/' || string3.charAt(0) == '\\' || string3.length() > 1 && string3.charAt(1) == ':') && new File(string3).exists()) {
            if (TRACE) {
                System.err.print(string4);
            }
            this.setWorkingDir(string3);
            return true;
        }
        String string7 = this.workingDir + File.separator + string3;
        if (new File(string7).exists()) {
            if (TRACE) {
                System.err.print(string4);
            }
            this.setWorkingDir(string7);
            return true;
        }
        if (Utilities.isWindows() && string3.length() > 3 && string3.charAt(0) == '/' && string3.charAt(2) == '/' && new File(string2 = "" + string3.charAt(1) + ":" + string3.substring(2)).exists()) {
            if (TRACE) {
                System.err.print(string4);
            }
            this.setWorkingDir(string2);
            return true;
        }
        if (this.baseWorkingDir != null && new File(string7 = this.baseWorkingDir + File.separator + string3).exists()) {
            if (TRACE) {
                System.err.print(string4);
            }
            this.setWorkingDir(string7);
            return true;
        }
        return false;
    }

    private static int[] foundCompiler(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            int n = string.indexOf(string2);
            if (n < 0) continue;
            int n2 = n + string2.length();
            return new int[]{n, n2};
        }
        return null;
    }

    static LineInfo testCompilerInvocation(String string) {
        int[] nArray;
        LineInfo lineInfo = new LineInfo(string);
        int n = 0;
        int n2 = -1;
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_GNU_C, INVOKE_GNU_C2)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.C;
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_GNU_Cpp, INVOKE_GNU_Cpp2, INVOKE_GNU_Cpp3, INVOKE_GNU_Cpp4)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.CPP;
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_SUN_C)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.C;
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_SUN_Cpp, INVOKE_MSVC_Cpp)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.CPP;
        }
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            lineInfo.compileLine = string.substring(n);
            while (n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t')) {
                ++n2;
            }
            if (n2 >= string.length() || string.charAt(n2) != '-') {
                lineInfo.compilerType = CompilerType.UNKNOWN;
            }
        }
        return lineInfo;
    }

    private void setWorkingDir(String string) {
        if (TRACE) {
            System.err.println("**>> new working dir: " + string);
        }
        this.workingDir = CndFileUtils.normalizeFile((File)new File(string)).getAbsolutePath();
    }

    private void setGuessWorkingDir(String string) {
        if (TRACE) {
            System.err.println("**>> alternative guess working dir: " + string);
        }
        this.guessWorkingDir = CndFileUtils.normalizeFile((File)new File(string)).getAbsolutePath();
    }

    private boolean parseLine(String string) {
        if (this.checkDirectoryChange(string)) {
            return false;
        }
        if (this.workingDir == null) {
            return false;
        }
        if (!this.workingDir.startsWith(this.root)) {
            return false;
        }
        LineInfo lineInfo = LogReader.testCompilerInvocation(string);
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            this.gatherLine(lineInfo.compileLine, string.startsWith("+"), lineInfo.compilerType == CompilerType.CPP);
            return true;
        }
        return false;
    }

    static String trimBackApostropheCalls(String string, PkgConfigManager.PkgConfig pkgConfig) {
        int n;
        int n2 = string.indexOf(96);
        if (string.lastIndexOf(96) == n2) {
            return string;
        }
        if (n2 < 0 || n2 == string.length() - 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0) {
            stringBuilder.append(string.substring(0, n2));
        }
        if ((n = (string = string.substring(n2 + 1)).indexOf(96)) < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        if (string2.startsWith(PKG_CONFIG_PATTERN)) {
            String string3;
            string2 = string2.substring(PKG_CONFIG_PATTERN.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            boolean bl = false;
            String string4 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3.equals("--cflags")) {
                    bl = true;
                    continue;
                }
                if (string3.startsWith("-")) {
                    bl = false;
                    continue;
                }
                string4 = string3;
            }
            if (bl && pkgConfig != null && string4 != null && (string3 = pkgConfig.getPkgConfig(string4)) != null) {
                for (String string5 : string3.getIncludePaths()) {
                    stringBuilder.append(" -I" + string5);
                }
                for (String string5 : string3.getMacros()) {
                    stringBuilder.append(" -D" + string5);
                }
                stringBuilder.append(" ");
            }
        } else if (string2.startsWith(ECHO_PATTERN)) {
            if ((string2 = string2.substring(ECHO_PATTERN.length())).startsWith("'") && string2.endsWith("'")) {
                stringBuilder.append(string2.substring(1, string2.length() - 1));
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                boolean bl = true;
                if (stringTokenizer.hasMoreTokens()) {
                    if (!bl) {
                        stringBuilder.append(" ");
                    }
                    bl = false;
                    stringBuilder.append(stringTokenizer.nextToken());
                }
            }
        } else if (string2.contains(ECHO_PATTERN)) {
            if ((string2 = string2.substring(string2.indexOf(ECHO_PATTERN) + ECHO_PATTERN.length())).startsWith("'") && string2.endsWith("'")) {
                stringBuilder.append(string2.substring(1, string2.length() - 1));
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                boolean bl = true;
                if (stringTokenizer.hasMoreTokens()) {
                    if (!bl) {
                        stringBuilder.append(" ");
                    }
                    bl = false;
                    stringBuilder.append(stringTokenizer.nextToken());
                }
            }
        }
        stringBuilder.append(string.substring(n + 1));
        return LogReader.trimBackApostropheCalls(stringBuilder.toString(), pkgConfig);
    }

    private boolean gatherLine(String string, boolean bl, boolean bl2) {
        Object object22;
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        String string2 = DiscoveryUtils.gatherCompilerLine((String)string, (boolean)true, arrayList, hashMap, null);
        if (string2 == null) {
            return false;
        }
        if (string2.endsWith(".s") || string2.endsWith(".S")) {
            return false;
        }
        String string3 = null;
        string3 = string2.startsWith("/") ? string2 : this.workingDir + "/" + string2;
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        for (Object object22 : arrayList) {
            arrayList2.add(PathCache.getString((String)object22));
        }
        HashMap hashMap2 = new HashMap(hashMap.size());
        for (Map.Entry stringArray : hashMap.entrySet()) {
            if (stringArray.getValue() == null) {
                hashMap2.put(PathCache.getString((String)stringArray.getKey()), null);
                continue;
            }
            hashMap2.put(PathCache.getString((String)stringArray.getKey()), PathCache.getString((String)stringArray.getValue()));
        }
        object22 = new File(string3);
        if (((File)object22).exists() && ((File)object22).isFile()) {
            if (TRACE) {
                System.err.println("**** Gotcha: " + string3);
            }
            this.result.add(new CommandLineSource(bl2, this.workingDir, string2, arrayList2, hashMap2));
            return true;
        }
        if (this.guessWorkingDir != null && !string2.startsWith("/") && ((File)(object22 = new File(this.guessWorkingDir + "/" + string2))).exists() && ((File)object22).isFile()) {
            if (TRACE) {
                System.err.println("**** Gotcha guess: " + string3);
            }
            this.result.add(new CommandLineSource(bl2, this.guessWorkingDir, string2, arrayList2, hashMap2));
            return true;
        }
        if (TRACE) {
            System.err.println("**** Not found " + string3);
        }
        if (!string2.startsWith("/") && arrayList.size() + hashMap.size() > 0) {
            block20: {
                try {
                    String[] iOException = new String[1];
                    boolean bl3 = LogReader.findFiles(new File(this.root), string2, iOException);
                    if (iOException[0] == null) {
                        if (TRACE) {
                            System.err.println("** And there is no such file under root");
                        }
                    } else {
                        if (bl3) {
                            this.result.add(new CommandLineSource(bl2, iOException[0], string2, arrayList, hashMap));
                            if (TRACE) {
                                System.err.println("** Gotcha: " + iOException[0] + File.separator + string2);
                            }
                            this.setGuessWorkingDir(iOException[0]);
                            return true;
                        }
                        if (TRACE) {
                            System.err.println("**There are several candidates and I'm not clever enough yet to find correct one.");
                        }
                    }
                }
                catch (IOException iOException) {
                    if (!TRACE) break block20;
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (TRACE) {
                System.err.println("" + (string.length() > 120 ? string.substring(0, 117) + ">>>" : string) + " [" + string2 + "]");
            }
            return false;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Not enough parameters. Format: bla-bla-bla filename root");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        TRACE = true;
        LogReader logReader = new LogReader(string, string2, null);
        List<SourceFileProperties> list = logReader.getResults(null, new AtomicBoolean(false));
        System.err.print("\n*** Results: ");
        for (SourceFileProperties sourceFileProperties : list) {
            String string3 = sourceFileProperties.getItemName();
            while (string3.indexOf("../") == 0) {
                string3 = string3.substring(3);
            }
            System.err.print(string3 + " ");
        }
        System.err.println();
    }

    private static boolean findFiles(File file, String string, String[] stringArray) throws IOException {
        File[] fileArray;
        File file2 = new File(file.getAbsolutePath() + File.separator + string);
        if (file2.exists() && file2.isFile()) {
            if (stringArray[0] != null && !new File(stringArray[0] + File.separator + string).getCanonicalPath().equals(file2.getCanonicalPath())) {
                return false;
            }
            stringArray[0] = file.getAbsolutePath();
        }
        if ((fileArray = file.listFiles(dirFilter)) != null) {
            for (File file3 : fileArray) {
                if (LogReader.findFiles(file3, string, stringArray)) continue;
                return false;
            }
        }
        return true;
    }

    private static class CommandLineSource
    implements SourceFileProperties {
        private String compilePath;
        private String sourceName;
        private String fullName;
        private ItemProperties.LanguageKind language;
        private List<String> userIncludes;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private Set<String> includedFiles = Collections.emptySet();

        private CommandLineSource(boolean bl, String string, String string2, List<String> list, Map<String, String> map) {
            this.language = bl ? ItemProperties.LanguageKind.CPP : ItemProperties.LanguageKind.C;
            this.compilePath = string;
            this.sourceName = string2;
            if (this.sourceName.startsWith("/")) {
                this.fullName = this.sourceName;
                this.sourceName = DiscoveryUtils.getRelativePath((String)string, (String)this.sourceName);
            } else {
                this.fullName = string + "/" + this.sourceName;
            }
            File file = new File(this.fullName);
            this.fullName = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
            this.fullName = PathCache.getString(this.fullName);
            this.userIncludes = list;
            this.userMacros = map;
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }
    }

    static class LineInfo {
        public String compileLine;
        public CompilerType compilerType = CompilerType.UNKNOWN;

        LineInfo(String string) {
            this.compileLine = string;
        }
    }

    static enum CompilerType {
        CPP,
        C,
        UNKNOWN;

    }
}

