/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class HtmlPanel
extends JPanel {
    private JScrollPane jScrollPane1;
    private JLabel label;
    private JTextPane pane;

    public HtmlPanel() {
        this.initComponents();
    }

    void setHtml(final String baseUrl, String html, String label) {
        this.pane.setText(html);
        this.pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String desc = e.getDescription();
                URL url = null;
                try {
                    url = new URL(baseUrl + "/" + desc);
                }
                catch (MalformedURLException mue) {
                    Bugzilla.LOG.log(Level.WARNING, null, mue);
                    return;
                }
                HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                assert (displayer != null) : NbBundle.getMessage(HtmlPanel.class, (String)"HTMLBROWSER.URLDISPLAYER_FOUND.");
                if (displayer != null) {
                    displayer.showURL(url);
                } else {
                    Bugzilla.LOG.info(NbBundle.getMessage(HtmlPanel.class, (String)"NO_URLDISPLAYER_FOUND."));
                }
            }
        });
        this.label.setText(label);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pane = new JTextPane();
        this.label = new JLabel();
        this.pane.setContentType("text/html");
        this.pane.setEditable(false);
        this.jScrollPane1.setViewportView(this.pane);
        this.label.setText(NbBundle.getMessage(HtmlPanel.class, (String)"MSG_ServerResponse"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 575, Short.MAX_VALUE).add((Component)this.label)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.label).addPreferredGap(0, 15, Short.MAX_VALUE).add((Component)this.jScrollPane1, -2, 374, -2)));
    }
}

