/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.points;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class PointSupport {
    static InfoPresenter.Resolver createInfoResolver(final Image icon, final String propertyName, final String typeName) {
        return new InfoPresenter.Resolver(){

            public DesignEventFilter getEventFilter(DesignComponent component) {
                return new DesignEventFilter(new DesignEventFilter[0]).addComponentFilter(component, false);
            }

            public String getDisplayName(DesignComponent component, InfoPresenter.NameType nameType) {
                switch (nameType) {
                    case PRIMARY: {
                        return this.getEditableName(component);
                    }
                    case SECONDARY: {
                        return typeName;
                    }
                    case TERTIARY: {
                        return null;
                    }
                }
                throw new IllegalStateException();
            }

            public boolean isEditable(DesignComponent component) {
                return true;
            }

            public String getEditableName(DesignComponent component) {
                return MidpTypes.getString(component.readProperty(propertyName));
            }

            public void setEditableName(DesignComponent component, String enteredName) {
                component.writeProperty(propertyName, InstanceNameResolver.createFromSuggested(component, enteredName));
            }

            public Image getIcon(DesignComponent component, InfoPresenter.IconType iconType) {
                return icon;
            }
        };
    }

    static InfoPresenter.Resolver createCallPointInfoResolver() {
        return new InfoPresenter.Resolver(){

            public DesignEventFilter getEventFilter(DesignComponent component) {
                return new DesignEventFilter(new DesignEventFilter[0]).addComponentFilter(component, false);
            }

            public String getDisplayName(DesignComponent component, InfoPresenter.NameType nameType) {
                switch (nameType) {
                    case PRIMARY: {
                        String code = MidpTypes.getJavaCode(component.readProperty("accessCode"));
                        if (code.length() >= 7) {
                            code = code.substring(0, 7) + "...";
                        }
                        return code;
                    }
                    case SECONDARY: {
                        return NbBundle.getMessage(PointSupport.class, (String)"TYPE_Call");
                    }
                    case TERTIARY: {
                        return null;
                    }
                }
                throw new IllegalStateException();
            }

            public boolean isEditable(DesignComponent component) {
                return false;
            }

            public String getEditableName(DesignComponent component) {
                throw Debug.illegalState((Object[])new Object[0]);
            }

            public void setEditableName(DesignComponent component, String enteredName) {
                throw Debug.illegalState((Object[])new Object[0]);
            }

            public Image getIcon(DesignComponent component, InfoPresenter.IconType iconType) {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/components/call_point_16.png");
            }
        };
    }
}

