/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class CommandUtils {
    private static final String HTML_MIME_TYPE = "text/html";

    private CommandUtils() {
    }

    public static boolean isPhpOrHtmlFile(FileObject file) {
        assert (file != null);
        String mimeType = FileUtil.getMIMEType((FileObject)file, (String[])new String[]{"text/x-php5", HTML_MIME_TYPE});
        return "text/x-php5".equals(mimeType) || HTML_MIME_TYPE.equals(mimeType);
    }

    public static boolean warnNoMoreDebugSession() {
        String message = NbBundle.getMessage(CommandUtils.class, (String)"MSG_NoMoreDebugSession");
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)message, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION;
    }

    public static PhpUnit getPhpUnit(boolean showCustomizer) {
        try {
            return PhpUnit.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            if (showCustomizer) {
                UiUtils.invalidScriptProvided((String)ex.getLocalizedMessage(), (String)"PhpUnit");
            }
            return null;
        }
    }

    public static List<FileObject> getFileObjects(Node[] nodes) {
        if (nodes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileObject> files = new ArrayList<FileObject>(nodes.length);
        for (Node node : nodes) {
            FileObject fo = CommandUtils.getFileObject(node);
            if (fo == null) continue;
            files.add(fo);
        }
        return files;
    }

    public static FileObject getFileObject(Node node) {
        assert (node != null);
        FileObject fileObj = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObj != null && fileObj.isValid()) {
            return fileObj;
        }
        DataObject dataObj = (DataObject)node.getCookie(DataObject.class);
        if (dataObj == null) {
            return null;
        }
        fileObj = dataObj.getPrimaryFile();
        if (fileObj != null && fileObj.isValid()) {
            return fileObj;
        }
        return null;
    }

    public static boolean isUnderSources(PhpProject project, FileObject fileObj) {
        assert (project != null);
        assert (fileObj != null);
        FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(project);
        return sources.equals(fileObj) || FileUtil.isParentOf((FileObject)sources, (FileObject)fileObj);
    }

    public static boolean isUnderTests(PhpProject project, FileObject fileObj, boolean showFileChooser) {
        assert (project != null);
        assert (fileObj != null);
        FileObject tests = ProjectPropertiesSupport.getTestDirectory(project, showFileChooser);
        return tests != null && (tests.equals(fileObj) || FileUtil.isParentOf((FileObject)tests, (FileObject)fileObj));
    }

    public static boolean isUnderSelenium(PhpProject project, FileObject fileObj, boolean showFileChooser) {
        assert (project != null);
        assert (fileObj != null);
        FileObject selenium = ProjectPropertiesSupport.getSeleniumDirectory(project, showFileChooser);
        return selenium != null && (selenium.equals(fileObj) || FileUtil.isParentOf((FileObject)selenium, (FileObject)fileObj));
    }

    public static boolean isUnderAnySourceGroup(PhpProject project, FileObject fileObj, boolean showFileChooser) {
        return CommandUtils.isUnderSources(project, fileObj) || CommandUtils.isUnderTests(project, fileObj, showFileChooser) || CommandUtils.isUnderSelenium(project, fileObj, showFileChooser);
    }

    public static FileObject[] filesForContext(Lookup context) {
        assert (context != null);
        Collection files = context.lookupAll(FileObject.class);
        return files.toArray(new FileObject[files.size()]);
    }

    public static FileObject[] filesForContext(Lookup context, FileObject baseDirectory) {
        return CommandUtils.filterValidFiles(CommandUtils.filesForContext(context), baseDirectory);
    }

    public static FileObject[] filesForSelectedNodes() {
        Node[] nodes = CommandUtils.getSelectedNodes();
        if (nodes == null) {
            return new FileObject[0];
        }
        List<FileObject> fileObjects = CommandUtils.getFileObjects(nodes);
        return fileObjects.toArray(new FileObject[fileObjects.size()]);
    }

    public static FileObject[] filesForSelectedNodes(FileObject baseDirectory) {
        return CommandUtils.filterValidFiles(Arrays.asList(CommandUtils.filesForSelectedNodes()), baseDirectory);
    }

    public static FileObject fileForContextOrSelectedNodes(Lookup context, FileObject baseDirectory) {
        assert (baseDirectory != null);
        assert (baseDirectory.isFolder()) : "Folder must be given: " + baseDirectory;
        FileObject[] files = CommandUtils.filesForContext(context, baseDirectory);
        if (files == null || files.length == 0) {
            files = CommandUtils.filesForSelectedNodes(baseDirectory);
        }
        return files != null && files.length > 0 ? files[0] : null;
    }

    public static FileObject[] filesForContextOrSelectedNodes(Lookup context) {
        FileObject[] files = CommandUtils.filesForContext(context);
        if (files.length == 0) {
            files = CommandUtils.filesForSelectedNodes();
        }
        return files;
    }

    public static FileObject fileForContextOrSelectedNodes(Lookup context) {
        FileObject[] files = CommandUtils.filesForContextOrSelectedNodes(context);
        return files.length > 0 ? files[0] : null;
    }

    public static URL urlForProject(PhpProject project) throws MalformedURLException {
        FileObject webRoot = ProjectPropertiesSupport.getWebRootDirectory(project);
        FileObject indexFile = CommandUtils.fileForProject(project, webRoot);
        return CommandUtils.urlForFile(project, webRoot, indexFile);
    }

    public static URL urlForDebugProject(PhpProject project) throws MalformedURLException {
        return CommandUtils.urlForDebugProject(project, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_START);
    }

    public static URL urlForDebugProject(PhpProject project, PhpProjectProperties.XDebugUrlArguments xDebugArgument) throws MalformedURLException {
        DebugInfo debugInfo = CommandUtils.getDebugInfo(project);
        URL debugUrl = CommandUtils.urlForProject(project);
        if (debugInfo.debugServer) {
            debugUrl = CommandUtils.appendQuery(debugUrl, CommandUtils.getDebugArguments(xDebugArgument));
        }
        return debugUrl;
    }

    public static URL createDebugUrl(URL url) throws MalformedURLException {
        return CommandUtils.appendQuery(url, CommandUtils.getDebugArguments(PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_START));
    }

    public static URL urlForContext(PhpProject project, Lookup context) throws MalformedURLException {
        FileObject webRoot = ProjectPropertiesSupport.getWebRootDirectory(project);
        FileObject selectedFile = CommandUtils.fileForContextOrSelectedNodes(context, webRoot);
        return CommandUtils.urlForFile(project, webRoot, selectedFile);
    }

    public static URL urlForDebugContext(PhpProject project, Lookup context) throws MalformedURLException {
        return CommandUtils.urlForDebugContext(project, context, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_START);
    }

    public static URL urlForDebugContext(PhpProject project, Lookup context, PhpProjectProperties.XDebugUrlArguments xDebugArgument) throws MalformedURLException {
        DebugInfo debugInfo = CommandUtils.getDebugInfo(project);
        URL debugUrl = CommandUtils.urlForContext(project, context);
        if (debugInfo.debugServer) {
            debugUrl = CommandUtils.appendQuery(debugUrl, CommandUtils.getDebugArguments(xDebugArgument));
        }
        return debugUrl;
    }

    public static FileObject fileForProject(PhpProject project, FileObject baseDirectory) {
        assert (baseDirectory != null);
        assert (baseDirectory.isFolder()) : "Folder must be given: " + baseDirectory;
        String indexFile = ProjectPropertiesSupport.getIndexFile(project);
        if (indexFile != null) {
            return baseDirectory.getFileObject(indexFile);
        }
        return baseDirectory;
    }

    public static DebugInfo getDebugInfo(PhpProject project) {
        boolean debugServer = WebClientToolsProjectUtils.getServerDebugProperty((Project)project);
        boolean debugClient = WebClientToolsProjectUtils.getClientDebugProperty((Project)project);
        if (!WebClientToolsSessionStarterService.isAvailable()) {
            debugServer = true;
            debugClient = false;
        }
        assert (debugServer || debugClient);
        return new DebugInfo(debugClient, debugServer);
    }

    public static URL getBaseURL(PhpProject project) throws MalformedURLException {
        String baseURLPath = ProjectPropertiesSupport.getUrl(project);
        if (baseURLPath == null) {
            throw new MalformedURLException();
        }
        return new URL(baseURLPath);
    }

    public static Command getCommand(PhpProject project, String commandName) {
        PhpActionProvider provider = (PhpActionProvider)project.getLookup().lookup(PhpActionProvider.class);
        assert (provider != null);
        return provider.getCommand(commandName);
    }

    private static Node[] getSelectedNodes() {
        return TopComponent.getRegistry().getCurrentNodes();
    }

    private static URL urlForFile(PhpProject project, FileObject webRoot, FileObject file) throws MalformedURLException {
        String relativePath = null;
        if (file == null) {
            relativePath = "";
        } else {
            relativePath = FileUtil.getRelativePath((FileObject)webRoot, (FileObject)file);
            assert (relativePath != null) : String.format("WebRoot %s must be parent of file %s", webRoot, file);
        }
        URL retval = new URL(CommandUtils.getBaseURL(project), relativePath);
        String arguments = ProjectPropertiesSupport.getArguments(project);
        return arguments != null ? CommandUtils.appendQuery(retval, arguments) : retval;
    }

    private static URL appendQuery(URL originalURL, String queryWithoutQMark) throws MalformedURLException {
        assert (StringUtils.hasText((String)queryWithoutQMark));
        assert (!queryWithoutQMark.startsWith("&"));
        assert (!queryWithoutQMark.startsWith("?"));
        String urlExternalForm = originalURL.toExternalForm();
        urlExternalForm = StringUtils.hasText((String)originalURL.getQuery()) ? urlExternalForm + "&" + queryWithoutQMark : urlExternalForm + "?" + queryWithoutQMark;
        return new URL(urlExternalForm);
    }

    private static String getDebugArguments(PhpProjectProperties.XDebugUrlArguments xDebugArgument) {
        return xDebugArgument.toString() + "=" + PhpOptions.getInstance().getDebuggerSessionId();
    }

    private static FileObject[] filterValidFiles(FileObject[] files, FileObject dir) {
        return CommandUtils.filterValidFiles(Arrays.asList(files), dir);
    }

    private static FileObject[] filterValidFiles(Collection<? extends FileObject> files, FileObject dir) {
        LinkedHashSet<FileObject> retval = new LinkedHashSet<FileObject>();
        for (FileObject fileObject : files) {
            if (!FileUtil.isParentOf((FileObject)dir, (FileObject)fileObject) || FileUtil.toFile((FileObject)fileObject) == null) {
                return null;
            }
            retval.add(fileObject);
        }
        return !retval.isEmpty() ? retval.toArray(new FileObject[retval.size()]) : null;
    }

    public static final class DebugInfo {
        public final boolean debugClient;
        public final boolean debugServer;

        public DebugInfo(boolean debugClient, boolean debugServer) {
            this.debugClient = debugClient;
            this.debugServer = debugServer;
        }
    }
}

