/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeBase;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Iterator;
import java.util.TreeSet;

public class StaticFieldComponent
extends Safeptr {
    private Safeptr endInitArray;
    private TreeSet<OffsetAndLength> allStaticFields;

    StaticFieldComponent(byte[] byArray) {
        super(byArray, "StaticField");
    }

    public int imageSize() {
        return this.u2(0);
    }

    public int referenceCount() {
        return this.u2(2);
    }

    public int arrayInitCount() {
        return this.u2(4);
    }

    InitializedArray arrayInit() {
        return new InitializedArray(this.offset(6));
    }

    public int defaultValueCount() {
        return this.endInitArray.u2(0);
    }

    public int nonDefaultValueCount() {
        return this.endInitArray.u2(2);
    }

    public Safeptr nonDefaultValuesStaticfield() {
        return this.endInitArray.offset(4);
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("StaticFieldComponent.100");
        }
        this.allStaticFields = new TreeSet();
        InitializedArray initializedArray = this.arrayInit();
        for (int i = this.arrayInitCount(); i > 0; --i) {
            initializedArray.next();
        }
        this.endInitArray = initializedArray;
        if (this.arrayInitCount() > this.referenceCount()) {
            throw new VerifierError("StaticFieldComponent.1");
        }
        if (this.imageSize() != this.referenceCount() * 2 + this.defaultValueCount() + this.nonDefaultValueCount()) {
            throw new VerifierError("StaticFieldComponent.2");
        }
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        for (int i = Cap.Descriptor.classCount(); i > 0; --i) {
            if ((classDescriptor.flags() & 0x40) == 0) {
                for (int j = 0; j < classDescriptor.fieldCount(); ++j) {
                    FieldDescriptor fieldDescriptor = classDescriptor.fieldDescr(j);
                    this.verifyField(fieldDescriptor);
                }
            }
            classDescriptor.next();
        }
        this.verifyOverlap();
        this.allStaticFields = null;
        if (this.size() != this.endInitArray.ofs + 4 + this.nonDefaultValueCount()) {
            throw new VerifierError("StaticFieldComponent.17");
        }
    }

    private void verifyField(FieldDescriptor fieldDescriptor) {
        int n;
        if ((fieldDescriptor.flags() & 8) == 0) {
            return;
        }
        int n2 = fieldDescriptor.staticRef();
        Type type = Type.parseField(fieldDescriptor.type());
        if (n2 < this.referenceCount() * 2) {
            n = 2;
            if ((n2 & 1) != 0) {
                throw new VerifierError("StaticFieldComponent.3");
            }
            if (n2 < this.arrayInitCount()) {
                int n3;
                Type type2;
                InitializedArray initializedArray = this.arrayInit();
                for (int i = 0; i < n2; i += 2) {
                    initializedArray.next();
                }
                switch (initializedArray.type()) {
                    case 2: {
                        type2 = Type.BooleanArray;
                        n3 = 1;
                        break;
                    }
                    case 3: {
                        type2 = Type.ByteArray;
                        n3 = 1;
                        break;
                    }
                    case 4: {
                        type2 = Type.ShortArray;
                        n3 = 2;
                        break;
                    }
                    case 5: {
                        type2 = Type.IntArray;
                        n3 = 4;
                        Cap.Header.useInts();
                        break;
                    }
                    default: {
                        throw new VerifierError("StaticFieldComponent.4", initializedArray.type());
                    }
                }
                if (!type.equals(type2)) {
                    if ((fieldDescriptor.type() & 0x8000) == 0) {
                        TypeClass typeClass = (TypeClass)type;
                        if (typeClass.classref != Classref.Object) {
                            throw new VerifierError("StaticFieldComponent.5", (Object)type, (Object)type2);
                        }
                    } else {
                        throw new VerifierError("StaticFieldComponent.5", (Object)type, (Object)type2);
                    }
                }
                if (initializedArray.count() % n3 != 0) {
                    throw new VerifierError("StaticFieldComponent.13", initializedArray.count(), n3);
                }
                if (initializedArray.count() / n3 > Short.MAX_VALUE) {
                    throw new VerifierError("StaticFieldComponent.16", initializedArray.count() / n3);
                }
                if (initializedArray.type() == 2) {
                    for (int i = 0; i < initializedArray.count(); ++i) {
                        int n4 = initializedArray.values().u1(i);
                        if (n4 == 0 || n4 == 1) continue;
                        throw new VerifierError("StaticFieldComponent.14", n4);
                    }
                }
            } else if (!(type instanceof TypeClass) && !(type instanceof TypeArray)) {
                throw new VerifierError("StaticFieldComponent.6", (Object)type, n2);
            }
        } else {
            if (!(type instanceof TypeBase)) {
                throw new VerifierError("StaticFieldComponent.7", (Object)type, n2);
            }
            switch (((TypeBase)type).kind) {
                case 2: 
                case 3: {
                    n = 1;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 5: {
                    n = 4;
                    break;
                }
                default: {
                    throw new VerifierError("StaticFieldComponent.8", (Object)type, n2);
                }
            }
            if (((TypeBase)type).kind == 2 && n2 >= this.imageSize() - this.nonDefaultValueCount()) {
                int n5 = n2 - (this.imageSize() - this.nonDefaultValueCount());
                int n6 = this.nonDefaultValuesStaticfield().u1(n5);
                if (n6 != 0 && n6 != 1) {
                    throw new VerifierError("StaticFieldComponent.15", n6);
                }
            }
        }
        this.allStaticFields.add(new OffsetAndLength(n2, n));
    }

    public boolean isPrimitiveFieldInitialized(FieldDescriptor fieldDescriptor) {
        int n = fieldDescriptor.staticRef();
        return n >= this.imageSize() - this.nonDefaultValueCount();
    }

    public int getPrimitiveFieldValue(FieldDescriptor fieldDescriptor) {
        int n = fieldDescriptor.staticRef();
        Type type = Type.parseField(fieldDescriptor.type());
        int n2 = n - (this.imageSize() - this.nonDefaultValueCount());
        switch (((TypeBase)type).kind) {
            case 2: 
            case 3: {
                return this.nonDefaultValuesStaticfield().u1(n2);
            }
            case 4: {
                return this.nonDefaultValuesStaticfield().u2(n2);
            }
            case 5: {
                return this.nonDefaultValuesStaticfield().s4(n2);
            }
        }
        return 0;
    }

    public boolean isArrayInitialized(FieldDescriptor fieldDescriptor) {
        int n = fieldDescriptor.staticRef();
        return n < this.arrayInitCount();
    }

    public boolean isStaticFieldInitialized(FieldDescriptor fieldDescriptor) {
        int n = fieldDescriptor.staticRef();
        if ((fieldDescriptor.type() & 0x8000) == 32768) {
            return n >= this.imageSize() - this.nonDefaultValueCount();
        }
        return n < this.arrayInitCount() * 2;
    }

    public InitializedArray getArrayInitValues(int n) {
        if (n < this.arrayInitCount() * 2) {
            InitializedArray initializedArray = this.arrayInit();
            for (int i = 0; i < n; i += 2) {
                initializedArray.next();
            }
            return initializedArray;
        }
        return null;
    }

    private void verifyOverlap() {
        int n = 0;
        Iterator<OffsetAndLength> iterator = this.allStaticFields.iterator();
        while (iterator.hasNext()) {
            OffsetAndLength offsetAndLength;
            OffsetAndLength offsetAndLength2 = offsetAndLength = iterator.next();
            if (offsetAndLength2.offset < n) {
                throw new VerifierError("StaticFieldComponent.9", n);
            }
            if (offsetAndLength2.offset > n) {
                throw new VerifierError("StaticFieldComponent.10", n);
            }
            n += offsetAndLength2.length;
        }
        if (n > this.imageSize()) {
            throw new VerifierError("StaticFieldComponent.11");
        }
        if (n < this.imageSize()) {
            throw new VerifierError("StaticFieldComponent.12");
        }
    }
}

