/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.project.PathCache;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class SolarisLogReader {
    private static boolean TRACE = false;
    private static final String ENV_ROOT = "ROOT=";
    private static final String ENV_SRC = "SRC=";
    private String workingDir;
    private String prevWorkingDir;
    private final String root;
    private final String fileName;
    private List<SourceFileProperties> result;
    private List<InstallLine> copyHeader;
    private Map<String, List<String>> findBase;
    private TreeMap<String, Set<String>> libraries;
    private String buidMashinePrototype;
    private String buidMashineSources;
    private static final String CURRENT_DIRECTORY = "Current working directory";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LABEL_CD = "cd ";
    private static final String INVOKE_SUN_C = "cc ";
    private static final String INVOKE_SUN_CC = "CC ";
    private static final String INVOKE_GNU_C = "gcc ";
    private static final String INVOKE_GNU_CC = "g++ ";
    private static final String MAKE_DELIMITER = ";";
    private static final String PATTERN_1 = File.separator + "." + File.separator;
    private static final String PATTERN_2 = File.separator + ".";
    private static final String PATTERN_3 = File.separator + ".." + File.separator;
    private static final String PATTERN_4 = File.separator + "..";

    public SolarisLogReader(String fileName, String root) {
        this.root = root;
        this.fileName = fileName;
        this.setWorkingDir(root);
    }

    private void run() {
        if (TRACE) {
            System.out.println("LogReader is run for " + this.fileName);
        }
        Pattern pattern = Pattern.compile(";|\\|\\||&&");
        this.result = new ArrayList<SourceFileProperties>();
        this.copyHeader = new ArrayList<InstallLine>();
        this.libraries = new TreeMap();
        File file = new File(this.fileName);
        if (file.exists() && file.canRead()) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(file));
                int nFoundFiles = 0;
                while ((line = in.readLine()) != null) {
                    String oneMoreLine;
                    line = line.trim();
                    if (this.buidMashinePrototype == null || this.buidMashineSources == null) {
                        if (line.startsWith(ENV_ROOT)) {
                            this.buidMashinePrototype = line.substring(ENV_ROOT.length());
                            if (!TRACE) continue;
                            System.out.println("Environment variable path to prototype: " + this.buidMashinePrototype);
                            continue;
                        }
                        if (line.startsWith(ENV_SRC)) {
                            this.buidMashineSources = line.substring(ENV_SRC.length());
                            if (!TRACE) continue;
                            System.out.println("Environment variable path to sources: " + this.buidMashineSources);
                            continue;
                        }
                    }
                    while (line.endsWith("\\") && (oneMoreLine = in.readLine()) != null) {
                        line = line.substring(0, line.length() - 1) + " " + oneMoreLine.trim();
                    }
                    line = SolarisLogReader.trimBackApostropheCalls(line);
                    String[] cmds = pattern.split(line);
                    for (int i = 0; i < cmds.length; ++i) {
                        if (this.parseLine(cmds[i])) {
                            ++nFoundFiles;
                            continue;
                        }
                        InstallLine copy = this.testInstall(cmds[i]);
                        if (copy == null) continue;
                        copy.destination = this.relocate(copy.destination);
                        copy.source = this.relocate(copy.source);
                        File source = new File(copy.source);
                        if (!source.exists() || source.isDirectory()) continue;
                        this.copyHeader.add(copy);
                    }
                }
                if (TRACE) {
                    System.out.println("Files found: " + nFoundFiles);
                    System.out.println("Files included in result: " + this.result.size());
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public List<SourceFileProperties> getResults() {
        if (this.result == null) {
            this.run();
            this.findBase.clear();
            this.findBase = null;
        }
        return this.result;
    }

    List<InstallLine> getInstalls() {
        return this.copyHeader;
    }

    private boolean checkDirectoryChange(String line) {
        String workDir = null;
        String message = null;
        if (line.startsWith(CURRENT_DIRECTORY)) {
            workDir = line.substring(CURRENT_DIRECTORY.length() + 1).trim();
            if (TRACE) {
                message = "**>> by [Current working directory] ";
            }
        } else if (line.indexOf(ENTERING_DIRECTORY) >= 0) {
            String dirMessage = line.substring(line.indexOf(ENTERING_DIRECTORY) + ENTERING_DIRECTORY.length() + 1).trim();
            workDir = dirMessage.replaceAll("`|'|\"", "");
            if (TRACE) {
                message = "**>> by [Entering directory] ";
            }
        } else if (line.startsWith(LABEL_CD)) {
            int end = line.indexOf(MAKE_DELIMITER);
            workDir = (end == -1 ? line : line.substring(0, end)).substring(LABEL_CD.length()).trim();
            if (TRACE) {
                message = "**>> by [ cd ] ";
            }
        } else if (line.startsWith("/") && line.indexOf(" ") < 0) {
            workDir = line.trim();
            if (TRACE) {
                message = "**>> by [just path string] ";
            }
        }
        if (workDir == null) {
            return false;
        }
        if (new File(workDir = this.relocate(workDir)).exists()) {
            if (TRACE) {
                System.err.print(message);
            }
            this.setWorkingDir(workDir);
            return true;
        }
        workDir = this.getWorkingDir() + File.separator + workDir;
        if (new File(workDir = SolarisLogReader.cutLocalRelative(workDir)).exists()) {
            if (TRACE) {
                System.err.print(message);
            }
            this.setWorkingDir(workDir);
            return true;
        }
        return false;
    }

    private String relocate(String path) {
        int i;
        String res = path;
        if (this.buidMashineSources != null && this.root.length() > 0 && res.startsWith(this.buidMashineSources)) {
            int i2 = this.buidMashineSources.lastIndexOf("/usr/src");
            if (i2 > 0) {
                res = this.root + path.substring(i2);
            }
        } else if (this.buidMashinePrototype != null && this.root.length() > 0 && res.startsWith(this.buidMashinePrototype) && (i = this.buidMashinePrototype.lastIndexOf("/proto/")) > 0) {
            res = this.root + path.substring(i);
        }
        if (TRACE && !path.equals(res)) {
            System.out.println("Relocate path from: " + path + " to " + res);
        }
        return res;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    private InstallLine testInstall(String line) {
        if ((line = line.trim()).startsWith("install ") && line.indexOf("/proto/") > 0 && (line.indexOf("/usr/include") > 0 || line.indexOf("/usr/ucbinclude") > 0 || line.indexOf("/usr/sfw/include") > 0)) {
            return this.parseInstall(line.substring(line.indexOf(32) + 1));
        }
        return null;
    }

    private InstallLine parseInstall(String line) {
        Iterator<String> st = DiscoveryUtils.scanCommandLine(line).iterator();
        String path = "";
        String name = null;
        while (st.hasNext()) {
            String option = st.next();
            if (option.equals("-c")) {
                if (path.length() != 0 || !st.hasNext()) continue;
                path = st.next();
                continue;
            }
            if (option.equals("-f")) {
                if (path.length() != 0 || !st.hasNext()) continue;
                path = st.next();
                continue;
            }
            if (option.equals("-n")) {
                if (path.length() != 0 || !st.hasNext()) continue;
                path = st.next();
                continue;
            }
            if (option.equals("-m")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-u")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-g")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.startsWith("-d") || option.startsWith("-i") || option.startsWith("-d") || option.startsWith("-o") || option.startsWith("-s")) continue;
            if (name == null) {
                name = option;
                if (!name.startsWith("\"") || !name.endsWith("\"")) continue;
                name = name.substring(1, name.length() - 1);
                continue;
            }
            if (!TRACE) continue;
            System.err.println("What is " + option + " in line " + line);
        }
        if (path.length() > 0 && name != null && this.getWorkingDir() != null) {
            String source = this.getWorkingDir();
            if (this.getWorkingDir().endsWith("/usr/src/uts/common/sys/lvm")) {
                source = source.substring(0, source.lastIndexOf("/lvm"));
            }
            source = name.startsWith("/") ? name : source + "/" + name;
            int j = name.lastIndexOf(47);
            if (j > 0) {
                name = name.substring(j + 1);
            }
            String destination = path + "/" + name;
            if (TRACE) {
                File fileTo = new File(destination);
                if (fileTo.exists() && !fileTo.isDirectory()) {
                    File fileFrom = new File(source);
                    if (fileFrom.exists() && !fileFrom.isDirectory()) {
                        System.err.println("Ok " + source + "->" + destination);
                    } else {
                        System.err.println("No source " + source + "->" + destination);
                    }
                } else {
                    System.err.println("No destination " + source + "->" + destination);
                }
            }
            return new InstallLine(source, destination);
        }
        return null;
    }

    private LineInfo testCompilerInvocation(String line) {
        LineInfo li = new LineInfo(line);
        int start = 0;
        int end = -1;
        if (li.compilerType == CompilerType.UNKNOWN && (start = line.indexOf(INVOKE_GNU_C)) >= 0) {
            li.compilerType = CompilerType.C;
            li.compilerFamily = CompilerFamily.GNU;
            end = start + INVOKE_GNU_C.length();
        }
        if (li.compilerType == CompilerType.UNKNOWN && (start = line.indexOf(INVOKE_GNU_CC)) >= 0) {
            li.compilerType = CompilerType.CPP;
            li.compilerFamily = CompilerFamily.GNU;
            end = start + INVOKE_GNU_CC.length();
        }
        if (li.compilerType == CompilerType.UNKNOWN && (start = line.indexOf(INVOKE_SUN_C)) >= 0) {
            li.compilerType = CompilerType.C;
            li.compilerFamily = CompilerFamily.SUN;
            end = start + INVOKE_SUN_C.length();
        }
        if (li.compilerType == CompilerType.UNKNOWN && (start = line.indexOf(INVOKE_SUN_CC)) >= 0) {
            li.compilerType = CompilerType.CPP;
            li.compilerFamily = CompilerFamily.SUN;
            end = start + INVOKE_SUN_CC.length();
        }
        if (li.compilerType != CompilerType.UNKNOWN) {
            li.compileLine = line.substring(start);
            while (end < line.length() && (line.charAt(end) == ' ' || line.charAt(end) == '\t')) {
                ++end;
            }
            if (end >= line.length() || line.charAt(end) != '-') {
                li.compilerType = CompilerType.UNKNOWN;
            } else if (start > 0 && line.charAt(start - 1) != '/') {
                int ltStart;
                String prefix = line.substring(0, start - 1).trim();
                if (!(line.charAt(start - 1) == ' ' && (prefix.equals("if") || prefix.equals("then") || prefix.equals("else")) || (ltStart = line.substring(0, start).indexOf("libtool")) >= 0 && line.substring(ltStart, start).indexOf("compile") >= 0)) {
                    li.compilerType = CompilerType.UNKNOWN;
                    if (TRACE) {
                        System.err.println("Suspicious line: " + line);
                    }
                }
            }
        }
        return li;
    }

    private void setWorkingDir(String workingDir) {
        if (TRACE) {
            System.err.println("**>> new working dir: " + workingDir);
        }
        if (!workingDir.equals(this.workingDir)) {
            this.prevWorkingDir = this.workingDir;
            this.workingDir = workingDir;
        }
    }

    private boolean parseLine(String line) {
        if (this.checkDirectoryChange(line)) {
            return false;
        }
        if (this.getWorkingDir() == null) {
            return false;
        }
        if (!this.getWorkingDir().startsWith(this.root)) {
            return false;
        }
        LineInfo li = this.testCompilerInvocation(line);
        if (li.compilerType != CompilerType.UNKNOWN) {
            return this.gatherLine(li.compileLine, line.startsWith("+"), li.compilerType == CompilerType.CPP, li.compilerFamily);
        }
        return false;
    }

    private static String trimBackApostropheCalls(String line) {
        int i = line.indexOf(96);
        if (line.lastIndexOf(96) == i) {
            return line;
        }
        if (i < 0 || i == line.length() - 1) {
            return line;
        }
        String out = line.substring(0, i);
        int j = (line = line.substring(i + 1)).indexOf(96);
        if (j < 0) {
            return line;
        }
        out = out + line.substring(j + 1);
        return SolarisLogReader.trimBackApostropheCalls(out);
    }

    private boolean gatherLine(String line, boolean isScriptOutput, boolean isCPP, CompilerFamily compiler) {
        ArrayList<String> userIncludes = new ArrayList<String>();
        HashMap<String, String> userMacros = new HashMap<String, String>();
        HashSet<String> libs = new HashSet<String>();
        String what = DiscoveryUtils.gatherCompilerLine(line, isScriptOutput, userIncludes, userMacros, libs);
        if (libs.size() > 0) {
            Set<String> l = this.libraries.get(this.getWorkingDir());
            if (l == null) {
                this.libraries.put(this.getWorkingDir(), libs);
            } else {
                l.addAll(libs);
            }
        }
        if (what == null) {
            return false;
        }
        String file = null;
        if (what.startsWith("/")) {
            what = file = this.relocate(what);
        } else {
            file = this.getWorkingDir() + "/" + what;
            File f = new File(file);
            if (!(f.exists() && f.isFile() || this.prevWorkingDir == null)) {
                String file2 = null;
                file2 = this.prevWorkingDir + "/" + what;
                f = new File(file2);
                if (f.exists() && f.isFile()) {
                    if (TRACE) {
                        System.out.println("restore path " + this.getWorkingDir() + "->" + this.prevWorkingDir);
                    }
                    this.setWorkingDir(this.prevWorkingDir);
                    file = file2;
                }
            }
        }
        ArrayList<String> userIncludesCached = new ArrayList<String>(userIncludes.size());
        for (String s : userIncludes) {
            s = this.relocate(s);
            userIncludesCached.add(PathCache.getString(s));
        }
        HashMap<String, String> userMacrosCached = new HashMap<String, String>(userMacros.size());
        for (Map.Entry e : userMacros.entrySet()) {
            if (e.getValue() == null) {
                userMacrosCached.put(PathCache.getString((String)e.getKey()), null);
                continue;
            }
            userMacrosCached.put(PathCache.getString((String)e.getKey()), PathCache.getString((String)e.getValue()));
        }
        File f = new File(file);
        if (!f.exists() || !f.isFile()) {
            if (TRACE) {
                System.err.println("**** Not found " + file);
            }
            String relative = "";
            if (!what.startsWith("/")) {
                String search;
                int i = what.lastIndexOf(47);
                if (i > 0) {
                    relative = what.substring(0, i);
                    what = what.substring(i + 1);
                    file = this.getWorkingDir() + "/" + what;
                    f = new File(file);
                    if (f.exists() && f.isFile()) {
                        this.addToResult(new CommandLineSource(isCPP, compiler == CompilerFamily.SUN, this.getWorkingDir(), what, userIncludesCached, userMacrosCached));
                        return true;
                    }
                }
                if ((search = this.findFiles(what, this.getWorkingDir(), relative)) != null) {
                    this.setWorkingDir(search);
                    this.addToResult(new CommandLineSource(isCPP, compiler == CompilerFamily.SUN, this.getWorkingDir(), what, userIncludesCached, userMacrosCached));
                    if (TRACE) {
                        System.err.println("** Gotcha: " + search + File.separator + what);
                    }
                    return true;
                }
            }
            if (TRACE) {
                System.err.println("" + (line.length() > 120 ? line.substring(0, 117) + ">>>" : line) + " [" + what + "]");
            }
            return false;
        }
        if (TRACE) {
            System.err.println("**** Gotcha: " + file);
        }
        this.addToResult(new CommandLineSource(isCPP, compiler == CompilerFamily.SUN, this.getWorkingDir(), what, userIncludesCached, userMacrosCached));
        return true;
    }

    private void addToResult(CommandLineSource source) {
        CommandLineSource prev;
        if (this.result.size() > 0 && (prev = (CommandLineSource)this.result.get(this.result.size() - 1)).getItemPath().equals(source.getItemPath())) {
            if (Utilities.getOperatingSystem() == 8) {
                if (!prev.isSunCompiler && source.isSunCompiler) {
                    this.result.set(this.result.size() - 1, source);
                    return;
                }
            } else if (!prev.isSunCompiler && source.isSunCompiler) {
                return;
            }
        }
        this.result.add(source);
    }

    private String findFiles(String name, String wd, String relative) {
        List<String> res = this.getFiles(name);
        if (res != null && res.size() == 1) {
            return res.get(0);
        }
        if (res != null) {
            Iterator<String> i$;
            if (TRACE) {
                System.out.println("More then one " + name);
            }
            if ((i$ = res.iterator()).hasNext()) {
                String r = i$.next();
                if (r.startsWith(wd)) {
                    return r;
                }
                return null;
            }
        } else if (TRACE) {
            System.out.println("Not found " + name);
        }
        return null;
    }

    private List<String> getFiles(String name) {
        if (this.findBase == null) {
            this.findBase = this.initSearchMap();
        }
        return this.findBase.get(name);
    }

    private Map<String, List<String>> initSearchMap() {
        HashSet<String> set = new HashSet<String>();
        File f = new File(this.root);
        this.gatherSubFolders(f, set);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            File d = new File(it.next());
            if (!d.exists() || !d.isDirectory() || !d.canRead()) continue;
            File[] ff = d.listFiles();
            for (int i = 0; i < ff.length; ++i) {
                if (!ff[i].isFile()) continue;
                List<String> l = map.get(ff[i].getName());
                if (l == null) {
                    l = new ArrayList<String>();
                    map.put(ff[i].getName(), l);
                }
                l.add(d.getAbsolutePath());
            }
        }
        return map;
    }

    private void gatherSubFolders(File d, HashSet<String> set) {
        if (d.exists() && d.isDirectory() && d.canRead()) {
            if (DiscoveryUtils.ignoreFolder(d)) {
                return;
            }
            String path = d.getAbsolutePath();
            if (!set.contains(path)) {
                set.add(d.getAbsolutePath());
                File[] ff = d.listFiles();
                for (int i = 0; i < ff.length; ++i) {
                    this.gatherSubFolders(ff[i], set);
                }
            }
        }
    }

    TreeMap<String, Set<String>> getLibraries() {
        return this.libraries;
    }

    TreeMap<String, Set<String>> readMapFile() {
        List<String> mapfile = this.getFiles("mapfile-vers");
        if (mapfile != null) {
            TreeMap<String, Set<String>> res = new TreeMap<String, Set<String>>();
            Collections.sort(mapfile);
            for (String name : mapfile) {
                Set<String> set = this.readMapFile(name + "/mapfile-vers");
                if (set == null) continue;
                res.put(name, set);
            }
            return res;
        }
        return null;
    }

    private Set<String> readMapFile(String name) {
        File file = new File(name);
        if (file.exists() && file.canRead()) {
            try {
                String line;
                HashSet<String> set = new HashSet<String>();
                BufferedReader in = new BufferedReader(new FileReader(file));
                boolean inBlock = false;
                boolean inGlobal = false;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (line.endsWith("{")) {
                        inGlobal = false;
                        inBlock = true;
                        continue;
                    }
                    if (line.startsWith("}")) {
                        inGlobal = false;
                        inBlock = false;
                        continue;
                    }
                    if (inBlock && line.endsWith("global:")) {
                        inGlobal = true;
                        continue;
                    }
                    if (inBlock && line.endsWith("local:")) {
                        inGlobal = false;
                        continue;
                    }
                    if (!inBlock || !inGlobal || line.indexOf(MAKE_DELIMITER) <= 0 || line.indexOf("FILTER") >= 0) continue;
                    String res = line.substring(0, line.indexOf(MAKE_DELIMITER));
                    if (res.indexOf("=") > 0) {
                        res = res.substring(0, res.indexOf("="));
                    }
                    if (res.indexOf(".") >= 0) continue;
                    res = res.trim();
                    set.add(res);
                }
                in.close();
                if (set.size() > 0) {
                    return set;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static String cutLocalRelative(String path) {
        int i;
        String pattern = PATTERN_1;
        while ((i = path.indexOf(pattern)) >= 0) {
            path = path.substring(0, i + 1) + path.substring(i + pattern.length());
        }
        pattern = PATTERN_2;
        if (path.endsWith(pattern)) {
            path = path.substring(0, path.length() - pattern.length());
        }
        pattern = PATTERN_3;
        while ((i = path.indexOf(pattern)) >= 0) {
            int k = -1;
            for (int j = i - 1; j >= 0; --j) {
                if (path.charAt(j) != File.separatorChar) continue;
                k = j;
                break;
            }
            if (k < 0) break;
            path = path.substring(0, k + 1) + path.substring(i + pattern.length());
        }
        pattern = PATTERN_4;
        if (path.endsWith(pattern)) {
            int k = -1;
            for (int j = path.length() - pattern.length() - 1; j >= 0; --j) {
                if (path.charAt(j) != File.separatorChar) continue;
                k = j;
                break;
            }
            if (k > 0) {
                path = path.substring(0, k);
            }
        }
        return path;
    }

    static class InstallLine {
        private String source;
        private String destination;

        private InstallLine(String source, String destination) {
            this.source = source;
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void install() {
            File from = new File(this.source);
            if (from.exists() && from.canRead() && !from.isDirectory()) {
                File to = new File(this.destination);
                if (to.exists()) {
                    return;
                }
                FileOutputStream out = null;
                FileInputStream in = null;
                try {
                    FileUtil.createFolder((File)to.getParentFile());
                    out = new FileOutputStream(to);
                    in = new FileInputStream(from);
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                    if (TRACE) {
                        System.err.println("Installed " + this.source + "->" + this.destination);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    private static class CommandLineSource
    implements SourceFileProperties {
        private String compilePath;
        private String sourceName;
        private String fullName;
        private ItemProperties.LanguageKind language;
        private List<String> userIncludes;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private Set<String> includedFiles = Collections.emptySet();
        private boolean isSunCompiler;

        private CommandLineSource(boolean isCPP, boolean isSunCompiler, String compilePath, String sourcePath, List<String> userIncludes, Map<String, String> userMacros) {
            this.language = isCPP ? ItemProperties.LanguageKind.CPP : ItemProperties.LanguageKind.C;
            this.isSunCompiler = isSunCompiler;
            this.compilePath = compilePath;
            this.sourceName = sourcePath;
            if (this.sourceName.startsWith("/")) {
                this.fullName = this.sourceName;
                this.sourceName = DiscoveryUtils.getRelativePath(compilePath, this.sourceName);
            } else {
                this.fullName = compilePath + "/" + this.sourceName;
            }
            this.fullName = CndFileUtils.normalizeAbsolutePath((String)this.fullName);
            this.fullName = PathCache.getString(this.fullName);
            this.userIncludes = userIncludes;
            this.userMacros = userMacros;
        }

        @Override
        public String getCompilePath() {
            return this.compilePath;
        }

        @Override
        public String getItemPath() {
            return this.fullName;
        }

        @Override
        public String getItemName() {
            return this.sourceName;
        }

        @Override
        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        @Override
        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        @Override
        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        @Override
        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        @Override
        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }
    }

    private static class LineInfo {
        public String compileLine;
        public CompilerType compilerType = CompilerType.UNKNOWN;
        public CompilerFamily compilerFamily = CompilerFamily.UNKNOWN;

        LineInfo(String line) {
            this.compileLine = line;
        }
    }

    private static enum CompilerFamily {
        SUN,
        GNU,
        UNKNOWN;

    }

    private static enum CompilerType {
        CPP,
        C,
        UNKNOWN;

    }
}

