/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import com.sun.source.util.TreePath;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.ModelUnit;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModelFactory;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.InjectablesPopup;
import org.netbeans.modules.web.beans.navigation.PopupUtil;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class GoToInjectableAtCaretAction
extends BaseAction {
    private static final long serialVersionUID = 1857528107859448216L;
    private static final String GOTO_INJACTABLE_AT_CARET = "go-to-injactable-at-caret";
    private static final String GOTO_INJACTABLE_AT_CARET_POPUP = "go-to-injactable-at-caret-popup";

    public GoToInjectableAtCaretAction() {
        super(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)GOTO_INJACTABLE_AT_CARET), 0);
        this.putValue("ActionCommandKey", GOTO_INJACTABLE_AT_CARET);
        this.putValue("ShortDescription", this.getValue("Name"));
        this.putValue("trimmed-text", this.getValue("Name"));
        this.putValue("PopupMenuText", NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)GOTO_INJACTABLE_AT_CARET_POPUP));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final FileObject fileObject = NbEditorUtilities.getFileObject((Document)jTextComponent.getDocument());
        if (fileObject == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        ClassPath classPath = this.getClassPath(project, "classpath/boot");
        ClassPath classPath2 = this.getClassPath(project, "classpath/compile");
        ClassPath classPath3 = this.getClassPath(project, "classpath/source");
        if (classPath == null || classPath2 == null || classPath3 == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        ModelUnit modelUnit = ModelUnit.create(classPath, classPath2, classPath3);
        final MetadataModel<WebBeansModel> metadataModel = WebBeansModelFactory.getMetaModel(modelUnit);
        final Object[] objectArray = new Object[2];
        if (!this.getVariableElementAtDot(jTextComponent, objectArray)) {
            return;
        }
        try {
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                public Void run(WebBeansModel webBeansModel) throws Exception {
                    GoToInjectableAtCaretAction.this.inspectInjectables(jTextComponent, fileObject, webBeansModel, (MetadataModel<WebBeansModel>)metadataModel, objectArray);
                    return null;
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Logger.getLogger(GoToInjectableAtCaretAction.class.getName()).log(Level.WARNING, metadataModelException.getMessage(), metadataModelException);
        }
        catch (IOException iOException) {
            Logger.getLogger(GoToInjectableAtCaretAction.class.getName()).log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }

    public boolean isEnabled() {
        if (EditorRegistry.lastFocusedComponent() == null || !EditorRegistry.lastFocusedComponent().isShowing()) {
            return false;
        }
        if (OpenProjects.getDefault().getOpenProjects().length == 0) {
            return false;
        }
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)EditorRegistry.lastFocusedComponent().getDocument());
        if (fileObject == null) {
            return false;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return profile.equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB);
    }

    protected boolean asynchonous() {
        return true;
    }

    private ClassPath getClassPath(Project project, String string) {
        FileObject fileObject;
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (classPathProvider == null) {
            return null;
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        SourceGroup[] sourceGroupArray2 = sources.getSourceGroups("web_inf");
        ClassPath[] classPathArray = new ClassPath[sourceGroupArray.length + sourceGroupArray2.length];
        int n = 0;
        for (SourceGroup sourceGroup : sourceGroupArray) {
            fileObject = sourceGroup.getRootFolder();
            classPathArray[n] = classPathProvider.findClassPath(fileObject, string);
            ++n;
        }
        for (SourceGroup sourceGroup : sourceGroupArray2) {
            fileObject = sourceGroup.getRootFolder();
            classPathArray[n] = classPathProvider.findClassPath(fileObject, string);
            ++n;
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])classPathArray);
    }

    private void inspectInjectables(final JTextComponent jTextComponent, FileObject fileObject, WebBeansModel webBeansModel, final MetadataModel<WebBeansModel> metadataModel, Object[] objectArray) {
        VariableElement variableElement = this.findVariable(webBeansModel, objectArray);
        if (variableElement == null) {
            return;
        }
        try {
            if (!webBeansModel.isInjectionPoint(variableElement)) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_NotInjectionPoint"), 700);
                return;
            }
        }
        catch (InjectionPointDefinitionError injectionPointDefinitionError) {
            StatusDisplayer.getDefault().setStatusText(injectionPointDefinitionError.getMessage(), 700);
        }
        final Result result = webBeansModel.getInjectable(variableElement, null);
        if (result == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_InjectableNotFound"), 700);
            return;
        }
        if (result instanceof Result.Error) {
            StatusDisplayer.getDefault().setStatusText(((Result.Error)result).getMessage(), 700);
        }
        if (result.getKind() == Result.ResultKind.DEFINITION_ERROR) {
            return;
        }
        if (result.getKind() == Result.ResultKind.INJECTABLE_RESOLVED) {
            Element element = ((Result.InjectableResult)result).getElement();
            final ElementHandle elementHandle = ElementHandle.create((Element)element);
            final ClasspathInfo classpathInfo = webBeansModel.getCompilationController().getClasspathInfo();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ElementOpen.open((ClasspathInfo)classpathInfo, (ElementHandle)elementHandle);
                }
            });
        } else if (result.getKind() == Result.ResultKind.RESOLUTION_ERROR) {
            final CompilationController compilationController = webBeansModel.getCompilationController();
            if (SwingUtilities.isEventDispatchThread()) {
                this.showPopup(result, compilationController, metadataModel, jTextComponent);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GoToInjectableAtCaretAction.this.showPopup(result, compilationController, (MetadataModel<WebBeansModel>)metadataModel, jTextComponent);
                    }
                });
            }
        }
    }

    private VariableElement findVariable(WebBeansModel webBeansModel, Object[] objectArray) {
        if (objectArray[0] == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_VariableNotFound", (Object)objectArray[1]));
            return null;
        }
        Element element = ((ElementHandle)objectArray[0]).resolve((CompilationInfo)webBeansModel.getCompilationController());
        if (element == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_VariableNotFound", (Object)objectArray[1]));
            return null;
        }
        VariableElement variableElement = null;
        ExecutableElement executableElement = null;
        if (element.getKind() == ElementKind.FIELD) {
            variableElement = (VariableElement)element;
        } else {
            executableElement = (ExecutableElement)element;
            List<? extends VariableElement> list = executableElement.getParameters();
            for (VariableElement variableElement2 : list) {
                if (!variableElement2.getSimpleName().contentEquals(objectArray[1].toString())) continue;
                variableElement = variableElement2;
            }
        }
        if (variableElement == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_VariableNotFound", (Object)objectArray[1]));
        }
        return variableElement;
    }

    private boolean getVariableElementAtDot(final JTextComponent jTextComponent, final Object[] objectArray) {
        JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    int n = jTextComponent.getCaret().getDot();
                    TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                    Element element = compilationController.getTrees().getElement(treePath);
                    if (element == null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_ElementNotFound"));
                        return;
                    }
                    if (!(element instanceof VariableElement)) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_NotVariableElement"));
                        return;
                    }
                    if (element.getKind() == ElementKind.FIELD) {
                        ElementHandle elementHandle = ElementHandle.create((Element)((VariableElement)element));
                        objectArray[0] = elementHandle;
                        objectArray[1] = element.getSimpleName().toString();
                    } else {
                        GoToInjectableAtCaretAction.this.setVariablePath(objectArray, compilationController, element);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Logger.getLogger(GoToInjectableAtCaretAction.class.getName()).log(Level.WARNING, iOException.getMessage(), iOException);
        }
        return objectArray[1] != null;
    }

    private void showPopup(Result result, CompilationController compilationController, MetadataModel<WebBeansModel> metadataModel, JTextComponent jTextComponent) {
        if (!(result instanceof Result.ApplicableResult)) {
            return;
        }
        Set<TypeElement> set = ((Result.ApplicableResult)((Object)result)).getTypeElements();
        Set<Element> set2 = ((Result.ApplicableResult)((Object)result)).getProductions();
        if (set.size() + set2.size() == 0) {
            return;
        }
        ArrayList<ElementHandle<Element>> arrayList = new ArrayList<ElementHandle<Element>>(set.size() + set2.size());
        for (TypeElement object : set) {
            if (((Result.ApplicableResult)((Object)result)).isDisabled(object)) continue;
            arrayList.add(ElementHandle.create((Element)object));
        }
        for (Element element : set2) {
            if (((Result.ApplicableResult)((Object)result)).isDisabled(element)) continue;
            arrayList.add(ElementHandle.create((Element)element));
        }
        if (arrayList.size() == 0) {
            return;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)"LBL_WaitNode"));
        try {
            Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaret().getDot());
            Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            SwingUtilities.convertPointToScreen(point, jTextComponent);
            String string = NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_ChooseInjectable");
            PopupUtil.showPopup(new InjectablesPopup(string, arrayList, compilationController), string, point.x, point.y);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private void setVariablePath(Object[] objectArray, CompilationController compilationController, Element element) {
        Element element2 = element.getEnclosingElement();
        if (element2 instanceof ExecutableElement) {
            ElementHandle elementHandle = ElementHandle.create((Element)((ExecutableElement)element2));
            objectArray[0] = elementHandle;
            objectArray[1] = element.getSimpleName().toString();
        }
    }
}

