/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.net.URL;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FileDeletePlugin
implements RefactoringPlugin {
    private SafeDeleteRefactoring refactoring;

    public FileDeletePlugin(SafeDeleteRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    public Problem preCheck() {
        return null;
    }

    @Override
    public Problem prepare(RefactoringElementsBag elements) {
        for (FileObject fo : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
            elements.addFileChange(this.refactoring, new DeleteFile(fo, elements));
        }
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public void cancelRequest() {
    }

    static class DeleteFile
    extends SimpleRefactoringElementImplementation {
        private final URL res;
        private String filename;
        private RefactoringElementsBag session;
        BackupFacility.Handle id;

        public DeleteFile(FileObject fo, RefactoringElementsBag session) {
            try {
                this.res = fo.getURL();
            }
            catch (FileStateInvalidException ex) {
                throw new IllegalStateException(ex);
            }
            this.filename = fo.getNameExt();
            this.session = session;
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(FileDeletePlugin.class, (String)"TXT_DeleteFile", (Object)this.filename);
        }

        @Override
        public String getDisplayText() {
            return this.getText();
        }

        @Override
        public void performChange() {
            try {
                FileObject fo = URLMapper.findFileObject((URL)this.res);
                if (fo == null) {
                    throw new IOException(this.res.toString());
                }
                this.id = BackupFacility.getDefault().backup(fo);
                DataObject.find((FileObject)fo).delete();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public void undoChange() {
            try {
                this.id.restore();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        @Override
        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.res);
        }

        @Override
        public PositionBounds getPosition() {
            return null;
        }
    }
}

