/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.javacard.common.ListenerProxy;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

final class ProcessorClasspathImpl
implements ClassPathImplementation {
    private final JCProject project;
    private final PlatformResource pformResource;
    private final PropertyResource propResource;

    ProcessorClasspathImpl(JCProject project) {
        this.project = project;
        this.pformResource = new PlatformResource(project);
        this.propResource = new PropertyResource();
    }

    public List<? extends PathResourceImplementation> getResources() {
        return Arrays.asList(this.propResource, this.pformResource);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    void processorPathChanged() {
        this.propResource.change();
    }

    private static URL[] getURLs(String[] entries) {
        ArrayList<URL> urls = new ArrayList<URL>(entries.length);
        for (String s : entries) {
            File f = new File(s);
            try {
                URL url = f.toURI().toURL();
                if (f.getName().endsWith(".jar")) {
                    String jarURL = "jar:" + url + "!/";
                    url = new URL(jarURL);
                } else if (!url.toString().endsWith("/")) {
                    url = new URL(url.toString() + "/");
                }
                urls.add(url);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        URL[] results = urls.toArray(new URL[urls.size()]);
        return results;
    }

    private class PropertyResource
    implements PathResourceImplementation {
        private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

        private PropertyResource() {
        }

        void change() {
            this.supp.firePropertyChange("roots", null, null);
        }

        public URL[] getRoots() {
            ArrayList<URL> result = new ArrayList<URL>();
            String paths = ProcessorClasspathImpl.this.project.evaluator().getProperty("javac.processorpath");
            if (paths != null) {
                String[] abs;
                Pattern p = Pattern.compile(File.pathSeparator, 16);
                if (p.matcher(paths).matches()) {
                    String[] each = p.split(paths);
                    abs = new String[each.length];
                    for (int i = 0; i < abs.length; ++i) {
                        String path = each[i];
                        abs[i] = this.absolutePath(path);
                    }
                } else {
                    abs = new String[]{this.absolutePath(paths)};
                }
                URL[] urls = ProcessorClasspathImpl.getURLs(abs);
                result.addAll(Arrays.asList(urls));
            }
            URL[] urls = result.toArray(new URL[result.size()]);
            return urls;
        }

        public ClassPathImplementation getContent() {
            return ProcessorClasspathImpl.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.supp.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.supp.removePropertyChangeListener(listener);
        }

        private String absolutePath(String possiblyRelativePath) {
            File nue;
            File f = new File(possiblyRelativePath);
            if (!f.exists() && (nue = new File(FileUtil.toFile((FileObject)ProcessorClasspathImpl.this.project.getProjectDirectory()), possiblyRelativePath)).exists()) {
                f = nue;
            }
            return f.getAbsolutePath();
        }
    }

    private class PlatformResource
    extends ListenerProxy<JCProject>
    implements PathResourceImplementation,
    ChangeListener {
        private ClassPath listeningTo;

        PlatformResource(JCProject project) {
            super((Object)project);
        }

        public URL[] getRoots() {
            ArrayList<URL> l = new ArrayList<URL>();
            for (ClassPath.Entry e : ProcessorClasspathImpl.this.project.getPlatform().getProcessorClasspath(((JCProject)this.get()).kind()).entries()) {
                URL url = e.getURL();
                l.add(url);
            }
            URL[] urls = l.toArray(new URL[l.size()]);
            return urls;
        }

        public ClassPathImplementation getContent() {
            return ProcessorClasspathImpl.this;
        }

        protected void attach(JCProject obj, PropertyChangeListener precreatedListener) {
            this.setListeningTo(ProcessorClasspathImpl.this.project.getPlatform().getProcessorClasspath(((JCProject)this.get()).kind()), precreatedListener);
            obj.addChangeListener(this);
        }

        protected void detach(JCProject obj, PropertyChangeListener precreatedListener) {
            this.setListeningTo(null, precreatedListener);
        }

        protected void onChange(String prop, Object old, Object nue) {
            if ("roots".equals(prop) || "entries".equals(prop)) {
                this.fire("roots", null, this.getRoots());
            }
        }

        private synchronized void setListeningTo(ClassPath cp, PropertyChangeListener precreatedListener) {
            if (this.listeningTo == cp) {
                return;
            }
            if (this.listeningTo != null) {
                this.listeningTo.removePropertyChangeListener(precreatedListener);
            }
            this.listeningTo = cp;
            if (cp != null) {
                cp.addPropertyChangeListener(precreatedListener);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fire("roots", null, null);
        }
    }
}

