/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassPrepareEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassUnloadEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadDeathEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadStartEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;

public class Operator {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    public static final String SILENT_EVENT_PROPERTY = "silent";
    private Thread thread;
    private boolean breakpointsDisabled;
    private List<EventSet> staledEvents = new ArrayList<EventSet>();
    private List<EventRequest> staledRequests = new ArrayList<EventRequest>();
    private boolean stop;
    private boolean canInterrupt;
    private JPDADebuggerImpl debugger;

    public Operator(VirtualMachine virtualMachine, final JPDADebuggerImpl jPDADebuggerImpl, Executor executor, Runnable runnable, ReadWriteLock readWriteLock) {
        EventQueue eventQueue;
        try {
            eventQueue = VirtualMachineWrapper.eventQueue(virtualMachine);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            eventQueue = null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            eventQueue = null;
        }
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        this.debugger = jPDADebuggerImpl;
        final Object[] objectArray = new Object[]{eventQueue, executor, runnable};
        this.thread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK]], but top level block is 9[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, "Debugger operator thread");
    }

    private static final ThreadReference getEventThread(Event event) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        ThreadReference threadReference = null;
        if (event instanceof LocatableEvent) {
            threadReference = LocatableEventWrapper.thread((LocatableEvent)event);
        } else if (event instanceof ClassPrepareEvent) {
            threadReference = ClassPrepareEventWrapper.thread((ClassPrepareEvent)event);
        } else if (event instanceof ThreadStartEvent) {
            threadReference = ThreadStartEventWrapper.thread((ThreadStartEvent)event);
        } else if (event instanceof ThreadDeathEvent) {
            threadReference = ThreadDeathEventWrapper.thread((ThreadDeathEvent)event);
        }
        return threadReference;
    }

    public void start() {
        this.thread.start();
    }

    public synchronized void register(EventRequest eventRequest, Executor executor) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        EventRequestWrapper.putProperty(eventRequest, "executor", executor);
        if (this.staledEvents.size() > 0 && eventRequest instanceof StepRequest) {
            boolean bl = false;
            for (EventSet eventSet : this.staledEvents) {
                for (Event event : eventSet) {
                    try {
                        EventRequest eventRequest2 = EventWrapper.request(event);
                        if (!(eventRequest2 instanceof StepRequest)) {
                            bl = true;
                            break;
                        }
                        ThreadReference threadReference = StepRequestWrapper.thread((StepRequest)eventRequest2);
                        ThreadReference threadReference2 = StepRequestWrapper.thread((StepRequest)eventRequest);
                        if (!threadReference2.equals(threadReference)) continue;
                        bl = true;
                        break;
                    }
                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                        return;
                    }
                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                    }
                }
                if (!bl) continue;
                break;
            }
            if (bl) {
                this.staledRequests.add(eventRequest);
            }
        }
    }

    public synchronized void unregister(EventRequest eventRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        Executor executor = (Executor)EventRequestWrapper.getProperty(eventRequest, "executor");
        EventRequestWrapper.putProperty(eventRequest, "executor", null);
        if (executor != null) {
            executor.removed(eventRequest);
        }
        this.staledRequests.remove(eventRequest);
        if (eventRequest instanceof StepRequest) {
            ThreadReference threadReference = StepRequestWrapper.thread((StepRequest)eventRequest);
            this.debugger.getThread(threadReference).setInStep(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Operator operator = this;
        synchronized (operator) {
            this.staledRequests.clear();
            this.staledEvents.clear();
            if (this.stop) {
                return;
            }
            this.stop = true;
            if (this.canInterrupt) {
                this.thread.interrupt();
            }
        }
    }

    public synchronized void breakpointsDisabled() {
        this.breakpointsDisabled = true;
    }

    public synchronized void breakpointsEnabled() {
        this.breakpointsDisabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushStaledEvents() {
        boolean bl;
        Operator operator = this;
        synchronized (operator) {
            boolean bl2 = bl = this.staledEvents.size() > 0;
            if (bl) {
                this.thread.interrupt();
            }
        }
        return bl;
    }

    private void printEvent(Event event, Executor executor) {
        try {
            if (event instanceof ClassPrepareEvent) {
                logger.fine("JDI EVENT: ClassPrepareEvent " + ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)event));
            } else if (event instanceof ClassUnloadEvent) {
                logger.fine("JDI EVENT: ClassUnloadEvent " + ClassUnloadEventWrapper.className((ClassUnloadEvent)event));
            } else if (event instanceof ThreadStartEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadStartEvent " + ThreadStartEventWrapper.thread((ThreadStartEvent)event));
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: ThreadStartEvent1 " + event);
                }
            } else if (event instanceof ThreadDeathEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadDeathEvent " + ThreadDeathEventWrapper.thread((ThreadDeathEvent)event));
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: ThreadDeathEvent1 " + event);
                }
            } else if (event instanceof MethodEntryEvent) {
                try {
                    logger.fine("JDI EVENT: MethodEntryEvent " + event);
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: MethodEntryEvent " + event);
                }
            } else if (event instanceof BreakpointEvent) {
                logger.fine("JDI EVENT: BreakpointEvent " + LocatableEventWrapper.thread((BreakpointEvent)event) + " : " + LocatableWrapper.location((BreakpointEvent)event));
            } else if (event instanceof StepEvent) {
                logger.fine("JDI EVENT: StepEvent " + LocatableEventWrapper.thread((StepEvent)event) + " : " + LocatableWrapper.location((StepEvent)event));
            } else {
                logger.fine("JDI EVENT: " + event + " : " + executor);
            }
        }
        catch (Exception exception) {
            logger.fine(exception.getLocalizedMessage());
        }
    }

    static /* synthetic */ List access$000(Operator operator) {
        return operator.staledEvents;
    }

    static /* synthetic */ List access$100(Operator operator) {
        return operator.staledRequests;
    }

    static /* synthetic */ boolean access$200(Operator operator) {
        return operator.stop;
    }

    static /* synthetic */ boolean access$302(Operator operator, boolean bl) {
        operator.canInterrupt = bl;
        return operator.canInterrupt;
    }

    static /* synthetic */ Logger access$400() {
        return logger;
    }

    static /* synthetic */ boolean access$500(Operator operator) {
        return operator.breakpointsDisabled;
    }

    static /* synthetic */ ThreadReference access$600(Event event) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        return Operator.getEventThread(event);
    }

    static /* synthetic */ void access$700(Operator operator, Event event, Executor executor) {
        operator.printEvent(event, executor);
    }

    static /* synthetic */ boolean access$202(Operator operator, boolean bl) {
        operator.stop = bl;
        return operator.stop;
    }
}

