/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.TableColumnSelector;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.netbeans.swing.outline.TreePathSupport;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.NodePopupFactory;
import org.openide.explorer.view.NodeRenderDataProvider;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.OutlineViewDragSupport;
import org.openide.explorer.view.OutlineViewDropSupport;
import org.openide.explorer.view.PropertiesRowModel;
import org.openide.explorer.view.SheetCell;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.ViewUtil;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class OutlineView
extends JScrollPane {
    private OutlineViewOutline outline;
    ExplorerManager manager;
    private PopupAdapter popupListener;
    private TableSelectionListener managerListener = null;
    private PropertyChangeListener wlpc;
    private VetoableChangeListener wlvc;
    private OutlineModel model;
    private NodeTreeModel treeModel = new NodeTreeModel();
    private PropertiesRowModel rowModel = new PropertiesRowModel();
    private NodePopupFactory popupFactory;
    private transient boolean dragActive = true;
    private transient boolean dropActive = true;
    transient OutlineViewDragSupport dragSupport;
    transient OutlineViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    private transient int allowedDragActions = 0x40000003;
    private transient int allowedDropActions = 0x40000003;
    private ActionListener defaultTreeActionListener;

    public OutlineView() {
        this((String)null);
    }

    public OutlineView(String nodesColumnLabel) {
        this.model = this.createOutlineModel(this.treeModel, this.rowModel, nodesColumnLabel);
        this.outline = new OutlineViewOutline(this.model, this.rowModel);
        this.rowModel.setOutline(this.outline);
        this.outline.setRenderDataProvider((RenderDataProvider)new NodeRenderDataProvider(this.outline));
        SheetCell.OutlineSheetCell tableCell = new SheetCell.OutlineSheetCell(this.outline);
        this.outline.setDefaultRenderer(Node.Property.class, tableCell);
        this.outline.setDefaultEditor(Node.Property.class, tableCell);
        this.setViewportView((Component)((Object)this.outline));
        this.setPopupAllowed(true);
        this.setRequestFocusEnabled(false);
        this.outline.setRequestFocusEnabled(true);
        Color c = UIManager.getColor("Table.background1");
        if (c == null) {
            c = UIManager.getColor("Table.background");
        }
        if (c != null) {
            this.getViewport().setBackground(c);
        }
        this.getActionMap().put("org.openide.actions.PopupAction", new PopupAction());
        this.popupFactory = new OutlinePopupFactory();
        this.setDropTarget(DragDropUtilities.dragAndDropEnabled);
        this.defaultTreeActionListener = new DefaultTreeAction(this.outline);
        this.outline.registerKeyboardAction(this.defaultTreeActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        final Color focusSelectionBackground = this.outline.getSelectionBackground();
        final Color focusSelectionForeground = this.outline.getSelectionForeground();
        this.outline.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent ev) {
                OutlineView.this.outline.setSelectionBackground(focusSelectionBackground);
                OutlineView.this.outline.setSelectionForeground(focusSelectionForeground);
            }

            @Override
            public void focusLost(FocusEvent ev) {
                OutlineView.this.outline.setSelectionBackground(SheetCell.getNoFocusSelectionBackground());
                OutlineView.this.outline.setSelectionForeground(SheetCell.getNoFocusSelectionForeground());
            }
        });
        TableColumnSelector tcs = (TableColumnSelector)Lookup.getDefault().lookup(TableColumnSelector.class);
        if (tcs != null) {
            this.outline.setColumnSelector(tcs);
        }
        if (UIManager.getColor("control") != null) {
            this.getOutline().setGridColor(UIManager.getColor("control"));
        }
        if (DragDropUtilities.dragAndDropEnabled) {
            this.setDragSource(true);
        }
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    protected OutlineModel createOutlineModel(NodeTreeModel treeModel, RowModel rowModel, String label) {
        if (label == null) {
            label = NbBundle.getMessage(OutlineView.class, (String)"NodeOutlineModel_NodesColumnLabel");
        }
        return new NodeOutlineModel(treeModel, rowModel, false, label);
    }

    @Override
    public void requestFocus() {
        this.outline.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.outline.requestFocusInWindow();
    }

    public Outline getOutline() {
        return this.outline;
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    @Deprecated
    public void setProperties(Node.Property[] newProperties) {
        this.rowModel.setProperties(newProperties);
        this.outline.tableChanged(null);
    }

    public final void addPropertyColumn(String name, String displayName) {
        this.addPropertyColumn(name, displayName, null);
    }

    public final void addPropertyColumn(String name, String displayName, String description) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"displayName", (Object)displayName);
        Node.Property[] p = this.rowModel.getProperties();
        Node.Property[] nue = new Node.Property[p.length + 1];
        System.arraycopy(p, 0, nue, 0, p.length);
        nue[p.length] = new PrototypeProperty(name, displayName, description);
        this.setProperties(nue);
    }

    public final boolean removePropertyColumn(String name) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Node.Property[] props = this.rowModel.getProperties();
        LinkedList<Node.Property> nue = new LinkedList<Node.Property>(Arrays.asList(props));
        boolean found = false;
        Iterator i = nue.iterator();
        while (i.hasNext()) {
            Node.Property p = (Node.Property)i.next();
            if (!name.equals(p.getName())) continue;
            found = true;
            i.remove();
            break;
        }
        if (found) {
            props = nue.toArray(new Node.Property[props.length - 1]);
            this.setProperties(props);
        }
        return found;
    }

    public final void setPropertyColumnDescription(String columnName, String description) {
        Node.Property[] props;
        Parameters.notNull((CharSequence)"columnName", (Object)columnName);
        for (Node.Property p : props = this.rowModel.getProperties()) {
            if (!columnName.equals(p.getName())) continue;
            p.setShortDescription(description);
        }
    }

    public final void setPropertyColumns(String ... namesAndDisplayNames) {
        if (namesAndDisplayNames.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of names and display names: " + Arrays.asList(namesAndDisplayNames));
        }
        Node.Property[] props = new Node.Property[namesAndDisplayNames.length / 2];
        for (int i = 0; i < namesAndDisplayNames.length; i += 2) {
            props[i / 2] = new PrototypeProperty(namesAndDisplayNames[i], namesAndDisplayNames[i + 1]);
        }
        this.setProperties(props);
    }

    public void setPopupAllowed(boolean value) {
        if (this.popupListener == null && value) {
            this.popupListener = new PopupAdapter();
            this.outline.addMouseListener((MouseListener)((Object)this.popupListener));
            this.addMouseListener((MouseListener)((Object)this.popupListener));
            return;
        }
        if (this.popupListener != null && !value) {
            this.outline.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
            return;
        }
    }

    public void setTreeSortable(boolean treeSortable) {
        this.outline.setTreeSortable(treeSortable);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
        ViewUtil.adjustBackground((JComponent)((Object)this.outline));
        ViewUtil.adjustBackground(this.getViewport());
    }

    public void readSettings(Properties p, String propertyPrefix) {
        this.outline.readSettings(p, propertyPrefix);
    }

    public void writeSettings(Properties p, String propertyPrefix) {
        this.outline.writeSettings(p, propertyPrefix);
    }

    public void setNodePopupFactory(NodePopupFactory newFactory) {
        this.popupFactory = newFactory;
    }

    public NodePopupFactory getNodePopupFactory() {
        return this.popupFactory;
    }

    private void lookupExplorerManager() {
        ExplorerManager newManager;
        if (this.managerListener == null) {
            this.managerListener = new TableSelectionListener();
        }
        if ((newManager = ExplorerManager.find(this)) != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = newManager;
            this.wlvc = WeakListeners.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
        }
        this.synchronizeRootContext();
        this.synchronizeSelectedNodes(true, new Node[0]);
        this.outline.getSelectionModel().removeListSelectionListener(this.managerListener);
        this.outline.getSelectionModel().addListSelectionListener(this.managerListener);
    }

    final void synchronizeRootContext() {
        if (null != this.treeModel) {
            this.treeModel.setNode(this.manager.getRootContext());
        }
    }

    final void synchronizeSelectedNodes(boolean scroll, Node ... nodes) {
        JViewport v;
        if (!this.needToSynchronize()) {
            return;
        }
        this.expandSelection();
        this.outline.invalidate();
        this.invalidate();
        this.validate();
        Node[] arr = this.manager.getSelectedNodes();
        this.outline.getSelectionModel().clearSelection();
        int size = this.outline.getRowCount();
        int firstSelection = -1;
        for (int i = 0; i < size; ++i) {
            Node n = this.getNodeFromRow(i);
            for (int j = 0; j < arr.length; ++j) {
                if (n == null || !n.equals((Object)arr[j])) continue;
                this.outline.getSelectionModel().addSelectionInterval(i, i);
                if (firstSelection != -1) continue;
                firstSelection = i;
            }
        }
        if (scroll && firstSelection >= 0 && (v = this.getViewport()) != null) {
            int ho;
            Rectangle rect = this.outline.getCellRect(firstSelection, 0, true);
            if (v.getExtentSize().height > rect.height) {
                rect.height = v.getExtentSize().height;
            }
            if ((ho = this.outline.getSize().height) > 0 && rect.y + rect.height > ho) {
                rect.height = ho - rect.y;
                if (rect.height <= 0) {
                    rect.height = 40;
                }
            }
            v.setViewPosition(new Point());
            this.outline.scrollRectToVisible(rect);
        }
    }

    private boolean needToSynchronize() {
        boolean doSync = false;
        Node[] arr = this.manager.getSelectedNodes();
        if (this.outline.getSelectedRows().length != arr.length) {
            doSync = true;
        } else if (arr.length > 0) {
            List<Node> nodes = Arrays.asList(arr);
            for (int idx : this.outline.getSelectedRows()) {
                Node n = this.getNodeFromRow(idx);
                if (n != null && nodes.contains(n)) continue;
                doSync = true;
                break;
            }
        }
        return doSync;
    }

    private void expandSelection() {
        Node[] arr = this.manager.getSelectedNodes();
        for (int i = 0; i < arr.length; ++i) {
            TreeNode tn;
            if (arr[i].getParentNode() == null && !this.outline.isRootVisible() || (tn = Visualizer.findVisualizer(arr[i])) == null) continue;
            ArrayList<TreeNode> al = new ArrayList<TreeNode>();
            while (tn != null) {
                al.add(tn);
                tn = tn.getParent();
            }
            Collections.reverse(al);
            TreePath tp = new TreePath(al.toArray());
            while (tp != null && tp.getPathCount() > 0) {
                if ((tp = tp.getParentPath()) == null) continue;
                this.outline.expandPath(tp);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.outline.getSelectionModel().clearSelection();
        this.outline.getSelectionModel().removeListSelectionListener(this.managerListener);
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        this.manager = null;
    }

    void showPopup(int xpos, int ypos, final JPopupMenu popup) {
        if (popup != null && popup.getSubElements().length > 0) {
            PopupMenuListener p = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    popup.removePopupMenuListener(this);
                    OutlineView.this.outline.requestFocus();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
            popup.addPopupMenuListener(p);
            popup.show(this, xpos, ypos);
        }
    }

    private JPopupMenu createPopup(Point p) {
        int[] selRows = this.outline.getSelectedRows();
        ArrayList<Node> al = new ArrayList<Node>(selRows.length);
        for (int i = 0; i < selRows.length; ++i) {
            Node n = this.getNodeFromRow(selRows[i]);
            if (n == null) continue;
            al.add(n);
        }
        Node[] arr = al.toArray(new Node[al.size()]);
        if (arr.length == 0) {
            arr = new Node[]{this.manager.getRootContext()};
        }
        p = SwingUtilities.convertPoint(this, p, (Component)((Object)this.outline));
        int column = this.outline.columnAtPoint(p);
        int row = this.outline.rowAtPoint(p);
        return this.popupFactory.createPopupMenu(row, column, arr, (Component)((Object)this.outline));
    }

    Node getNodeFromRow(int rowIndex) {
        int row = this.outline.convertRowIndexToModel(rowIndex);
        TreePath tp = this.outline.getLayoutCache().getPathForRow(row);
        if (tp == null) {
            return null;
        }
        return Visualizer.findNode(tp.getLastPathComponent());
    }

    private Point getPositionForPopup() {
        Rectangle rect;
        int i = this.outline.getSelectionModel().getLeadSelectionIndex();
        if (i < 0) {
            return null;
        }
        int j = this.outline.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (j < 0) {
            j = 0;
        }
        if ((rect = this.outline.getCellRect(i, j, true)) == null) {
            return null;
        }
        Point p = new Point(rect.x + rect.width / 3, rect.y + rect.height / 2);
        p = SwingUtilities.convertPoint((Component)((Object)this.outline), p, this);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callSelectionChanged(Node[] nodes) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            this.manager.setSelectedNodes(nodes);
        }
        catch (PropertyVetoException e) {
            this.synchronizeSelectedNodes(false, new Node[0]);
        }
        finally {
            this.manager.removePropertyChangeListener(this.wlpc);
            this.manager.removeVetoableChangeListener(this.wlvc);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
    }

    private boolean isSelectionModeBroken(Node[] nodes) {
        if (nodes.length <= 1 || this.outline.getSelectionModel().getSelectionMode() == 2) {
            return false;
        }
        return this.outline.getSelectionModel().getSelectionMode() == 0;
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean state) {
        if (state && this.dragSupport == null) {
            this.dragSupport = new OutlineViewDragSupport(this, (JComponent)this.getOutline());
        }
        this.dragActive = state;
        if (this.dragSupport != null) {
            this.dragSupport.activate(this.dragActive);
        }
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean state) {
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new OutlineViewDropSupport(this, (JTable)((Object)this.outline), this.dropTargetPopupAllowed);
        }
        this.dropActive = state;
        if (this.dropSupport != null) {
            this.dropSupport.activate(this.dropActive);
        }
    }

    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    public void setAllowedDragActions(int actions) {
        this.allowedDragActions = actions;
    }

    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    protected int getAllowedDropActions(Transferable t) {
        return this.getAllowedDropActions();
    }

    public void setAllowedDropActions(int actions) {
        this.allowedDropActions = actions;
    }

    public void addTreeExpansionListener(TreeExpansionListener l) {
        TreePathSupport tps = this.getOutline().getOutlineModel().getTreePathSupport();
        if (tps != null) {
            tps.addTreeExpansionListener(l);
        }
    }

    public void removeTreeExpansionListener(TreeExpansionListener l) {
        TreePathSupport tps = this.getOutline().getOutlineModel().getTreePathSupport();
        if (tps != null) {
            tps.removeTreeExpansionListener(l);
        }
    }

    public void collapseNode(Node n) {
        if (n == null) {
            throw new IllegalArgumentException();
        }
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        this.getOutline().collapsePath(treePath);
    }

    public void expandNode(Node n) {
        if (n == null) {
            throw new IllegalArgumentException();
        }
        this.lookupExplorerManager();
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        this.getOutline().expandPath(treePath);
    }

    public boolean isExpanded(Node n) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        return this.getOutline().isExpanded(treePath);
    }

    static final class PrototypeProperty
    extends PropertySupport.ReadWrite<Object> {
        PrototypeProperty(String name, String displayName) {
            this(name, displayName, null);
        }

        PrototypeProperty(String name, String displayName, String description) {
            super(name, Object.class, displayName, description);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            throw new AssertionError();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new AssertionError();
        }

        public boolean equals(Object o) {
            return o != null && o instanceof Node.Property && this.getName().equals(((Node.Property)o).getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }

    private static class NodeOutlineModel
    extends DefaultOutlineModel {
        public NodeOutlineModel(NodeTreeModel treeModel, RowModel rowModel, boolean largeModel, String nodesColumnLabel) {
            super((TreeModel)treeModel, rowModel, largeModel, nodesColumnLabel);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                Node treeNode = this.getNodeAt(rowIndex);
                return null != treeNode && treeNode.canRename();
            }
            return super.isCellEditable(rowIndex, columnIndex);
        }

        protected void setTreeValueAt(Object aValue, int rowIndex) {
            Node n = this.getNodeAt(rowIndex);
            if (null != n) {
                n.setName(aValue == null ? "" : aValue.toString());
            }
        }

        protected final Node getNodeAt(int rowIndex) {
            Node result = null;
            TreePath path = this.getLayout().getPathForRow(rowIndex);
            if (path != null) {
                result = Visualizer.findNode(path.getLastPathComponent());
            }
            return result;
        }
    }

    private static class OutlinePopupFactory
    extends NodePopupFactory {
        @Override
        public JPopupMenu createPopupMenu(int row, int column, Node[] selectedNodes, Component component) {
            if (component instanceof ETable) {
                ETable et = (ETable)component;
                int modelRowIndex = et.convertColumnIndexToModel(column);
                this.setShowQuickFilter(modelRowIndex != 0);
            }
            return super.createPopupMenu(row, column, selectedNodes, component);
        }
    }

    private static class OutlineViewOutline
    extends Outline {
        private final PropertiesRowModel rowModel;
        private static final String COLUMNS_SELECTOR_HINT = "ColumnsSelectorHint";
        private boolean treeSortable = true;

        public OutlineViewOutline(OutlineModel mdl, PropertiesRowModel rowModel) {
            super(mdl);
            this.rowModel = rowModel;
            this.setSelectVisibleColumnsLabel(NbBundle.getMessage(OutlineView.class, (String)"CTL_ColumnsSelector"));
        }

        public Object transformValue(Object value) {
            if (value instanceof OutlineViewOutlineColumn) {
                String desc;
                OutlineViewOutlineColumn c = (OutlineViewOutlineColumn)((Object)value);
                String dn = c.getRawColumnName();
                if (dn == null) {
                    dn = c.getHeaderValue().toString();
                }
                if ((desc = c.getShortDescription(null)) == null) {
                    return dn;
                }
                return NbBundle.getMessage(OutlineView.class, (String)"OutlineViewOutline_NameAndDesc", (Object)dn, (Object)desc);
            }
            if (COLUMNS_SELECTOR_HINT.equals(value)) {
                return NbBundle.getMessage(OutlineView.class, (String)COLUMNS_SELECTOR_HINT);
            }
            if (value instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)value;
                Mnemonics.setLocalizedText((AbstractButton)b, (String)b.getText());
                return b;
            }
            if (value instanceof VisualizerNode) {
                return Visualizer.findNode(value);
            }
            return PropertiesRowModel.getValueFromProperty(value);
        }

        public boolean editCellAt(int row, int column, EventObject e) {
            Action a;
            Node node;
            int clickCount;
            boolean isTreeColumn;
            Node.Property p;
            Object o = this.getValueAt(row, column);
            if (o instanceof Node.Property && ((p = (Node.Property)o).getValueType() == Boolean.class || p.getValueType() == Boolean.TYPE)) {
                PropertiesRowModel.toggleBooleanProperty((Node.Property<Boolean>)p);
                Rectangle r = this.getCellRect(row, column, true);
                this.repaint(r.x, r.y, r.width, r.height);
                return false;
            }
            boolean res = false;
            boolean actionPerformed = false;
            boolean bl = isTreeColumn = this.convertColumnIndexToModel(column) == 0;
            if (isTreeColumn && row != -1 && e instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)e) && (clickCount = ((MouseEvent)e).getClickCount()) > 1 && (node = Visualizer.findNode(o)) != null && node.isLeaf() && !node.canRename() && (a = TreeView.takeAction(node.getPreferredAction(), node)) != null) {
                if (a.isEnabled()) {
                    a.actionPerformed(new ActionEvent(node, 1001, ""));
                    return false;
                }
                Logger.getLogger(OutlineView.class.getName()).info("Action " + a + " on node " + node + " is disabled");
            }
            if (e instanceof MouseEvent) {
                Action act;
                PropertyPanel panel;
                PropertyEditor ed;
                Node.Property p2;
                final Rectangle r = this.getCellRect(row, column, true);
                if (((MouseEvent)e).getX() > r.x + r.width - 24 && ((MouseEvent)e).getX() < r.x + r.width && o instanceof Node.Property && !isTreeColumn && !Boolean.TRUE.equals((p2 = (Node.Property)o).getValue("suppressCustomEditor")) && (ed = (panel = new PropertyPanel(p2)).getPropertyEditor()) != null && ed.supportsCustomEditor() && (act = panel.getActionMap().get("invokeCustomEditor")) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            r.x = 0;
                            r.width = OutlineViewOutline.this.getWidth();
                            OutlineViewOutline.this.repaint(r);
                        }
                    });
                    act.actionPerformed(null);
                    return false;
                }
            }
            return super.editCellAt(row, column, e);
        }

        protected TableColumn createColumn(int modelIndex) {
            return new OutlineViewOutlineColumn(modelIndex);
        }

        boolean isTreeSortable() {
            return this.treeSortable;
        }

        void setTreeSortable(boolean treeSortable) {
            this.treeSortable = treeSortable;
        }

        private class OutlineViewOutlineColumn
        extends Outline.OutlineColumn {
            private String tooltip;
            private final Comparator originalNodeComparator;

            public OutlineViewOutlineColumn(int index) {
                super((Outline)OutlineViewOutline.this, index);
                this.originalNodeComparator = new NodeNestedComparator();
            }

            public boolean isSortingAllowed() {
                int index = this.getModelIndex();
                if (index <= 0) {
                    return OutlineViewOutline.this.isTreeSortable();
                }
                Object sortable = OutlineViewOutline.this.rowModel.getPropertyValue("SortableColumn", index - 1);
                if (sortable != null) {
                    return Boolean.TRUE.equals(sortable);
                }
                return super.isSortingAllowed();
            }

            public Comparator getNestedComparator() {
                if (this.getModelIndex() == 0 && super.getNestedComparator() == null) {
                    return this.originalNodeComparator;
                }
                return super.getNestedComparator();
            }

            protected TableCellRenderer createDefaultHeaderRenderer() {
                TableCellRenderer orig = super.createDefaultHeaderRenderer();
                OutlineViewOutlineHeaderRenderer ovohr = new OutlineViewOutlineHeaderRenderer(orig);
                return ovohr;
            }

            public String getShortDescription(String defaultValue) {
                TableModel model = OutlineViewOutline.this.getModel();
                if (model.getRowCount() <= 0) {
                    return null;
                }
                if (this.getModelIndex() == 0) {
                    return defaultValue;
                }
                return OutlineViewOutline.this.rowModel.getShortDescription(this.getModelIndex() - 1);
            }

            public String getRawColumnName() {
                TableModel model = OutlineViewOutline.this.getModel();
                if (model.getRowCount() <= 0) {
                    return null;
                }
                if (this.getModelIndex() == 0) {
                    return null;
                }
                return OutlineViewOutline.this.rowModel.getRawColumnName(this.getModelIndex() - 1);
            }

            private class NodeNestedComparator
            implements Comparator {
                private NodeNestedComparator() {
                }

                public int compare(Object o1, Object o2) {
                    assert (o1 instanceof Node) : o1 + " is instanceof Node";
                    assert (o2 instanceof Node) : o2 + " is instanceof Node";
                    return ((Node)o1).getDisplayName().compareTo(((Node)o2).getDisplayName());
                }
            }

            class OutlineViewOutlineHeaderRenderer
            implements TableCellRenderer {
                private TableCellRenderer orig;

                public OutlineViewOutlineHeaderRenderer(TableCellRenderer delegate) {
                    this.orig = delegate;
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component oc = this.orig.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (OutlineViewOutlineColumn.this.tooltip == null) {
                        OutlineViewOutlineColumn.this.tooltip = OutlineViewOutlineColumn.this.getShortDescription(value.toString());
                    }
                    if (OutlineViewOutlineColumn.this.tooltip != null && oc instanceof JComponent) {
                        JComponent jc = (JComponent)oc;
                        jc.setToolTipText(OutlineViewOutlineColumn.this.tooltip);
                    }
                    return oc;
                }
            }
        }
    }

    private class DefaultTreeAction
    implements ActionListener {
        private Outline outline;

        DefaultTreeAction(Outline outline) {
            this.outline = outline;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action a;
            if (this.outline.getSelectedColumn() != 0) {
                return;
            }
            Node[] nodes = OutlineView.this.manager.getSelectedNodes();
            if (nodes.length == 1 && (a = nodes[0].getPreferredAction()) != null) {
                if (a.isEnabled()) {
                    a.actionPerformed(new ActionEvent(nodes[0], 1001, ""));
                } else {
                    Logger.getLogger(OutlineView.class.getName()).info("Action " + a + " on node " + nodes[0] + " is disabled");
                }
            }
        }
    }

    private class TableSelectionListener
    implements VetoableChangeListener,
    ListSelectionListener,
    PropertyChangeListener {
        private TableSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (OutlineView.this.manager == null) {
                return;
            }
            if (evt.getPropertyName().equals("rootContext")) {
                OutlineView.this.synchronizeRootContext();
            }
            if (evt.getPropertyName().equals("selectedNodes")) {
                OutlineView.this.synchronizeSelectedNodes(true, new Node[0]);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] selectedRows = OutlineView.this.outline.getSelectedRows();
            ArrayList<Node> selectedNodes = new ArrayList<Node>(selectedRows.length);
            for (int i = 0; i < selectedRows.length; ++i) {
                Node n = OutlineView.this.getNodeFromRow(selectedRows[i]);
                if (n == null) continue;
                selectedNodes.add(n);
            }
            OutlineView.this.callSelectionChanged(selectedNodes.toArray(new Node[selectedNodes.size()]));
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Node[] nodes;
            if (evt.getPropertyName().equals("selectedNodes") && OutlineView.this.isSelectionModeBroken(nodes = (Node[])evt.getNewValue())) {
                throw new PropertyVetoException("selection mode  broken by " + Arrays.asList(nodes), evt);
            }
        }
    }

    private class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            int selRow = OutlineView.this.outline.rowAtPoint(e.getPoint());
            if (selRow != -1) {
                if (!OutlineView.this.outline.getSelectionModel().isSelectedIndex(selRow)) {
                    OutlineView.this.outline.getSelectionModel().clearSelection();
                    OutlineView.this.outline.getSelectionModel().setSelectionInterval(selRow, selRow);
                }
            } else {
                OutlineView.this.outline.getSelectionModel().clearSelection();
            }
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), OutlineView.this);
            if (OutlineView.this.isPopupAllowed()) {
                JPopupMenu pop = OutlineView.this.createPopup(p);
                OutlineView.this.showPopup(p.x, p.y, pop);
                e.consume();
            }
        }
    }

    private class PopupAction
    extends AbstractAction
    implements Runnable {
        private PopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            Point p = OutlineView.this.getPositionForPopup();
            if (p == null) {
                return;
            }
            if (OutlineView.this.isPopupAllowed()) {
                JPopupMenu pop = OutlineView.this.createPopup(p);
                OutlineView.this.showPopup(p.x, p.y, pop);
            }
        }
    }
}

