'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.11.1/tcllib-1.11.1/modules/control/control.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "control" n 0.1.3 control "Tcl Control Flow Commands"
.BS
.SH NAME
control \- Procedures for control flow structures.
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBcontrol  ?0.1.3?\fR
.sp
\fBcontrol::control\fR \fIcommand\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fBcontrol::assert\fR \fIexpr\fR ?\fIarg arg ...\fR?
.sp
\fBcontrol::do\fR \fIbody\fR ?\fIoption test\fR?
.sp
\fBcontrol::no-op\fR ?\fIarg arg ...\fR?
.sp
.BE
.SH DESCRIPTION
.PP
The \fBcontrol\fR package provides a variety of commands that provide
additional flow of control structures beyond the built-in ones
provided by Tcl.  These are commands that in many programming
languages might be considered \fIkeywords\fR, or a part of the
language itself.  In Tcl, control flow structures are just commands
like everything else.
.SH COMMANDS
.TP
\fBcontrol::control\fR \fIcommand\fR \fIoption\fR ?\fIarg arg ...\fR?
The \fBcontrol\fR command is used as a configuration command for
customizing the other public commands of the control package.  The
\fIcommand\fR argument names the command to be customized.  The set of
valid \fIoption\fR and subsequent arguments are determined by the
command being customized, and are documented with the command.
.TP
\fBcontrol::assert\fR \fIexpr\fR ?\fIarg arg ...\fR?
When disabled, the \fBassert\fR command behaves exactly like the
\fBno-op\fR command.
.sp
When enabled, the \fBassert\fR command evaluates \fIexpr\fR as an
expression (in the same way that \fBexpr\fR evaluates its argument).
If evaluation reveals that \fIexpr\fR is not a valid boolean
expression (according to [\fBstring is boolean -strict\fR]),
an error is raised.  If \fIexpr\fR evaluates to a true boolean value
(as recognized by \fBif\fR), then \fBassert\fR returns an empty
string.  Otherwise, the remaining arguments to \fBassert\fR are used
to construct a message string.  If there are no arguments, the message
string is "assertion failed: $expr".  If there are arguments, they are
joined by \fBjoin\fR to form the message string.  The message string
is then appended as an argument to a callback command, and the
completed callback command is evaluated in the global namespace.
.sp
The \fBassert\fR command can be customized by the \fBcontrol\fR
command in two ways:
.sp
[\fBcontrol::control assert enabled\fR ?\fIboolean\fR?]
queries or sets whether \fBcontrol::assert\fR is enabled.  When called
without a \fIboolean\fR argument, a boolean value is returned
indicating whether the \fBcontrol::assert\fR command is enabled.  When
called with a valid boolean value as the \fIboolean\fR argument, the
\fBcontrol::assert\fR command is enabled or disabled to match the
argument, and an empty string is returned.
.sp
[\fBcontrol::control assert callback\fR ?\fIcommand\fR?]
queries or sets the callback command that will be called by an enabled
\fBassert\fR on assertion failure.  When called without a
\fIcommand\fR argument, the current callback command is returned.
When called with a \fIcommand\fR argument, that argument becomes the
new assertion failure callback command.  Note that an assertion
failure callback command is always defined, even when \fBassert\fR
is disabled.  The default callback command is
[\fBreturn -code error\fR].
.sp
Note that \fBcontrol::assert\fR has been written so that in
combination with [\fBnamespace import\fR], it is possible to
use enabled \fBassert\fR commands in some namespaces and disabled
\fBassert\fR commands in other namespaces at the same time.  This
capability is useful so that debugging efforts can be independently
controlled module by module.
.sp
.nf

% package require control
% control::control assert enabled 1
% namespace eval one namespace import ::control::assert
% control::control assert enabled 0
% namespace eval two namespace import ::control::assert
% one::assert {1 == 0}
assertion failed: 1 == 0
% two::assert {1 == 0}

.fi
.TP
\fBcontrol::do\fR \fIbody\fR ?\fIoption test\fR?
The \fBdo\fR command evaluates the script \fIbody\fR repeatedly
\fIuntil\fR the expression \fItest\fR becomes true or as long as
(\fIwhile\fR) \fItest\fR is true, depending on the value of
\fIoption\fR being \fBuntil\fR or \fBwhile\fR. If
\fIoption\fR and \fItest\fR are omitted the body is evaluated exactly
once. After normal completion, \fBdo\fR returns an empty string.
Exceptional return codes (\fBbreak\fR, \fBcontinue\fR, \fBerror\fR,
etc.) during the evaluation of \fIbody\fR are handled in the same way
the \fBwhile\fR command handles them, except as noted in
\fBLIMITATIONS\fR, below.
.TP
\fBcontrol::no-op\fR ?\fIarg arg ...\fR?
The \fBno-op\fR command takes any number of arguments and does
nothing.  It returns an empty string.
.PP
.SH LIMITATIONS
Several of the commands provided by the \fBcontrol\fR package accept
arguments that are scripts to be evaluated.  Due to fundamental
limitations of Tcl's \fBcatch\fR and \fBreturn\fR commands, it is not
possible for these commands to properly evaluate the command
[\fBreturn -code $code\fR] within one of those script
arguments for any value of \fI$code\fR other than \fIok\fR.  In this
way, the commands of the \fBcontrol\fR package are limited as compared
to Tcl's built-in control flow commands (such as \fBif\fR,
\fBwhile\fR, etc.) and those control flow commands that can be
provided by packages coded in C.  An example of this difference:
.PP
.nf

% package require control
% proc a {} {while 1 {return -code error a}}
% proc b {} {control::do {return -code error b} while 1}
% catch a
1
% catch b
0

.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIcontrol\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
break, continue, expr, if, join, namespace, return, string, while
.SH KEYWORDS
assert, control, do, flow, no-op, structure