/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.Util;
import gnu.java.security.x509.ext.AuthorityKeyIdentifier;
import gnu.java.security.x509.ext.BasicConstraints;
import gnu.java.security.x509.ext.CRLNumber;
import gnu.java.security.x509.ext.CertificatePolicies;
import gnu.java.security.x509.ext.ExtendedKeyUsage;
import gnu.java.security.x509.ext.IssuerAlternativeNames;
import gnu.java.security.x509.ext.KeyUsage;
import gnu.java.security.x509.ext.PolicyConstraint;
import gnu.java.security.x509.ext.PolicyMappings;
import gnu.java.security.x509.ext.PrivateKeyUsagePeriod;
import gnu.java.security.x509.ext.ReasonCode;
import gnu.java.security.x509.ext.SubjectAlternativeNames;
import gnu.java.security.x509.ext.SubjectKeyIdentifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class Extension {
    private static final Logger log = Logger.getLogger(Extension.class$("gnu.java.security.x509.ext.Extension").getName());
    protected final OID oid;
    protected final boolean critical;
    protected boolean isSupported;
    protected final Value value;
    protected byte[] encoded;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Extension(byte[] byArray) throws IOException {
        this.encoded = (byte[])byArray.clone();
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed Extension");
        }
        dERValue = dERReader.read();
        if (dERValue.getTag() != 6) {
            throw new IOException("expecting OBJECT IDENTIFIER");
        }
        this.oid = (OID)dERValue.getValue();
        dERValue = dERReader.read();
        if (dERValue.getTag() == 1) {
            this.critical = (Boolean)dERValue.getValue();
            dERValue = dERReader.read();
        } else {
            this.critical = false;
        }
        if (dERValue.getTag() != 4) {
            throw new IOException("expecting OCTET STRING");
        }
        byte[] byArray2 = (byte[])dERValue.getValue();
        this.isSupported = true;
        if (this.oid.equals(AuthorityKeyIdentifier.ID)) {
            this.value = new AuthorityKeyIdentifier(byArray2);
        } else if (this.oid.equals(SubjectKeyIdentifier.ID)) {
            this.value = new SubjectKeyIdentifier(byArray2);
        } else if (this.oid.equals(KeyUsage.ID)) {
            this.value = new KeyUsage(byArray2);
        } else if (this.oid.equals(PrivateKeyUsagePeriod.ID)) {
            this.value = new PrivateKeyUsagePeriod(byArray2);
        } else if (this.oid.equals(CertificatePolicies.ID)) {
            this.value = new CertificatePolicies(byArray2);
        } else if (this.oid.equals(PolicyConstraint.ID)) {
            this.value = new PolicyConstraint(byArray2);
        } else if (this.oid.equals(PolicyMappings.ID)) {
            this.value = new PolicyMappings(byArray2);
        } else if (this.oid.equals(SubjectAlternativeNames.ID)) {
            this.value = new SubjectAlternativeNames(byArray2);
        } else if (this.oid.equals(IssuerAlternativeNames.ID)) {
            this.value = new IssuerAlternativeNames(byArray2);
        } else if (this.oid.equals(BasicConstraints.ID)) {
            this.value = new BasicConstraints(byArray2);
        } else if (this.oid.equals(ExtendedKeyUsage.ID)) {
            this.value = new ExtendedKeyUsage(byArray2);
        } else if (this.oid.equals(CRLNumber.ID)) {
            this.value = new CRLNumber(byArray2);
        } else if (this.oid.equals(ReasonCode.ID)) {
            this.value = new ReasonCode(byArray2);
        } else {
            this.value = new Value(byArray2);
            this.isSupported = false;
        }
    }

    public Extension(OID oID, Value value, boolean bl) {
        this.oid = oID;
        this.value = value;
        this.critical = bl;
        this.isSupported = true;
    }

    public OID getOid() {
        return this.oid;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public Value getValue() {
        return this.value;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encode();
        }
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        return Extension.class$("gnu.java.security.x509.ext.Extension").getName() + " [ id=" + this.oid + " critical=" + this.critical + " value=" + this.value + " ]";
    }

    public DERValue getDerValue() {
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(new DERValue(6, this.oid));
        arrayList.add(new DERValue(1, this.critical));
        arrayList.add(new DERValue(4, this.value.getEncoded()));
        return new DERValue(48, arrayList);
    }

    private void encode() {
        this.encoded = this.getDerValue().getEncoded();
    }

    public static class Value {
        protected byte[] encoded;

        public Value(byte[] byArray) {
            this.encoded = (byte[])byArray.clone();
        }

        protected Value() {
        }

        public byte[] getEncoded() {
            return this.encoded;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.encoded.length; ++i) {
                n = n * 31 + this.encoded[i];
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Value)) {
                return false;
            }
            return Arrays.equals(this.encoded, ((Value)object).encoded);
        }

        public String toString() {
            return Util.toHexString(this.encoded, ':');
        }
    }
}

