/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.java.security.Properties;
import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.BaseCipher;
import gnu.javax.crypto.cipher.WeakKeyException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public class DES
extends BaseCipher {
    public static final int BLOCK_SIZE = 8;
    public static final int KEY_SIZE = 8;
    private static final int[] SP1 = new int[]{0x1010400, 0, 65536, 0x1010404, 0x1010004, 66564, 4, 65536, 1024, 0x1010400, 0x1010404, 1024, 0x1000404, 0x1010004, 0x1000000, 4, 1028, 0x1000400, 0x1000400, 66560, 66560, 0x1010000, 0x1010000, 0x1000404, 65540, 0x1000004, 0x1000004, 65540, 0, 1028, 66564, 0x1000000, 65536, 0x1010404, 4, 0x1010000, 0x1010400, 0x1000000, 0x1000000, 1024, 0x1010004, 65536, 66560, 0x1000004, 1024, 4, 0x1000404, 66564, 0x1010404, 65540, 0x1010000, 0x1000404, 0x1000004, 1028, 66564, 0x1010400, 1028, 0x1000400, 0x1000400, 0, 65540, 66560, 0, 0x1010004};
    private static final int[] SP2 = new int[]{-2146402272, -2147450880, 32768, 1081376, 0x100000, 32, -2146435040, -2147450848, -2147483616, -2146402272, -2146402304, Integer.MIN_VALUE, -2147450880, 0x100000, 32, -2146435040, 0x108000, 0x100020, -2147450848, 0, Integer.MIN_VALUE, 32768, 1081376, -2146435072, 0x100020, -2147483616, 0, 0x108000, 32800, -2146402304, -2146435072, 32800, 0, 1081376, -2146435040, 0x100000, -2147450848, -2146435072, -2146402304, 32768, -2146435072, -2147450880, 32, -2146402272, 1081376, 32, 32768, Integer.MIN_VALUE, 32800, -2146402304, 0x100000, -2147483616, 0x100020, -2147450848, -2147483616, 0x100020, 0x108000, 0, -2147450880, 32800, Integer.MIN_VALUE, -2146435040, -2146402272, 0x108000};
    private static final int[] SP3 = new int[]{520, 0x8020200, 0, 0x8020008, 0x8000200, 0, 131592, 0x8000200, 131080, 0x8000008, 0x8000008, 131072, 0x8020208, 131080, 0x8020000, 520, 0x8000000, 8, 0x8020200, 512, 131584, 0x8020000, 0x8020008, 131592, 0x8000208, 131584, 131072, 0x8000208, 8, 0x8020208, 512, 0x8000000, 0x8020200, 0x8000000, 131080, 520, 131072, 0x8020200, 0x8000200, 0, 512, 131080, 0x8020208, 0x8000200, 0x8000008, 512, 0, 0x8020008, 0x8000208, 131072, 0x8000000, 0x8020208, 8, 131592, 131584, 0x8000008, 0x8020000, 0x8000208, 520, 0x8020000, 131592, 8, 0x8020008, 131584};
    private static final int[] SP4 = new int[]{8396801, 8321, 8321, 128, 0x802080, 0x800081, 0x800001, 8193, 0, 0x802000, 0x802000, 8396929, 129, 0, 0x800080, 0x800001, 1, 8192, 0x800000, 8396801, 128, 0x800000, 8193, 8320, 0x800081, 1, 8320, 0x800080, 8192, 0x802080, 8396929, 129, 0x800080, 0x800001, 0x802000, 8396929, 129, 0, 0, 0x802000, 8320, 0x800080, 0x800081, 1, 8396801, 8321, 8321, 128, 8396929, 129, 1, 8192, 0x800001, 8193, 0x802080, 0x800081, 8193, 8320, 0x800000, 8396801, 128, 0x800000, 8192, 0x802080};
    private static final int[] SP5 = new int[]{256, 34078976, 0x2080000, 1107296512, 524288, 256, 0x40000000, 0x2080000, 1074266368, 524288, 0x2000100, 1074266368, 1107296512, 1107820544, 524544, 0x40000000, 0x2000000, 0x40080000, 0x40080000, 0, 0x40000100, 1107820800, 1107820800, 0x2000100, 1107820544, 0x40000100, 0, 0x42000000, 34078976, 0x2000000, 0x42000000, 524544, 524288, 1107296512, 256, 0x2000000, 0x40000000, 0x2080000, 1107296512, 1074266368, 0x2000100, 0x40000000, 1107820544, 34078976, 1074266368, 256, 0x2000000, 1107820544, 1107820800, 524544, 0x42000000, 1107820800, 0x2080000, 0, 0x40080000, 0x42000000, 524544, 0x2000100, 0x40000100, 524288, 0, 0x40080000, 34078976, 0x40000100};
    private static final int[] SP6 = new int[]{0x20000010, 0x20400000, 16384, 541081616, 0x20400000, 16, 541081616, 0x400000, 0x20004000, 0x404010, 0x400000, 0x20000010, 0x400010, 0x20004000, 0x20000000, 16400, 0, 0x400010, 536887312, 16384, 0x404000, 536887312, 16, 541065232, 541065232, 0, 0x404010, 0x20404000, 16400, 0x404000, 0x20404000, 0x20000000, 0x20004000, 16, 541065232, 0x404000, 541081616, 0x400000, 16400, 0x20000010, 0x400000, 0x20004000, 0x20000000, 16400, 0x20000010, 541081616, 0x404000, 0x20400000, 0x404010, 0x20404000, 0, 541065232, 16, 16384, 0x20400000, 0x404010, 16384, 0x400010, 536887312, 0, 0x20404000, 0x20000000, 0x400010, 536887312};
    private static final int[] SP7 = new int[]{0x200000, 0x4200002, 67110914, 0, 2048, 67110914, 0x200802, 69208064, 69208066, 0x200000, 0, 0x4000002, 2, 0x4000000, 0x4200002, 2050, 0x4000800, 0x200802, 0x200002, 0x4000800, 0x4000002, 0x4200000, 69208064, 0x200002, 0x4200000, 2048, 2050, 69208066, 0x200800, 2, 0x4000000, 0x200800, 0x4000000, 0x200800, 0x200000, 67110914, 67110914, 0x4200002, 0x4200002, 2, 0x200002, 0x4000000, 0x4000800, 0x200000, 69208064, 2050, 0x200802, 69208064, 2050, 0x4000002, 69208066, 0x4200000, 0x200800, 0, 2, 69208066, 0, 0x200802, 0x4200000, 2048, 0x4000002, 0x4000800, 2048, 0x200002};
    private static final int[] SP8 = new int[]{0x10001040, 4096, 262144, 0x10041040, 0x10000000, 0x10001040, 64, 0x10000000, 262208, 0x10040000, 0x10041040, 266240, 0x10041000, 266304, 4096, 64, 0x10040000, 0x10000040, 0x10001000, 4160, 266240, 262208, 0x10040040, 0x10041000, 4160, 0, 0, 0x10040040, 0x10000040, 0x10001000, 266304, 262144, 266304, 262144, 0x10041000, 4096, 64, 0x10040040, 4096, 266304, 0x10001000, 64, 0x10000040, 0x10040000, 0x10040040, 0x10000000, 262144, 0x10001040, 0, 0x10041040, 262208, 0x10000040, 0x10040000, 0x10001000, 0x10001040, 0, 0x10041040, 266240, 266240, 4160, 4160, 262208, 0x10000000, 0x10041000};
    private static final byte[] PARITY = new byte[]{8, 1, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 2, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 3, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 4, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 5, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 6, 8};
    private static final byte[] ROTARS = new byte[]{1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28};
    private static final byte[] PC1 = new byte[]{56, 48, 40, 32, 24, 16, 8, 0, 57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 60, 52, 44, 36, 28, 20, 12, 4, 27, 19, 11, 3};
    private static final byte[] PC2 = new byte[]{13, 16, 10, 23, 0, 4, 2, 27, 14, 5, 20, 9, 22, 18, 11, 3, 25, 7, 15, 6, 26, 19, 12, 1, 40, 51, 30, 36, 46, 54, 29, 39, 50, 44, 32, 47, 43, 48, 38, 55, 33, 52, 45, 41, 49, 35, 28, 31};
    public static final byte[][] WEAK_KEYS = new byte[][]{Util.toBytesFromString("0101010101010101"), Util.toBytesFromString("01010101FEFEFEFE"), Util.toBytesFromString("FEFEFEFE01010101"), Util.toBytesFromString("FEFEFEFEFEFEFEFE")};
    public static final byte[][] SEMIWEAK_KEYS = new byte[][]{Util.toBytesFromString("01FE01FE01FE01FE"), Util.toBytesFromString("FE01FE01FE01FE01"), Util.toBytesFromString("1FE01FE00EF10EF1"), Util.toBytesFromString("E01FE01FF10EF10E"), Util.toBytesFromString("01E001E001F101F1"), Util.toBytesFromString("E001E001F101F101"), Util.toBytesFromString("1FFE1FFE0EFE0EFE"), Util.toBytesFromString("FE1FFE1FFE0EFE0E"), Util.toBytesFromString("011F011F010E010E"), Util.toBytesFromString("1F011F010E010E01"), Util.toBytesFromString("E0FEE0FEF1FEF1FE"), Util.toBytesFromString("FEE0FEE0FEF1FEF1")};
    public static final byte[][] POSSIBLE_WEAK_KEYS = new byte[][]{Util.toBytesFromString("1F1F01010E0E0101"), Util.toBytesFromString("011F1F01010E0E01"), Util.toBytesFromString("1F01011F0E01010E"), Util.toBytesFromString("01011F1F01010E0E"), Util.toBytesFromString("E0E00101F1F10101"), Util.toBytesFromString("FEFE0101FEFE0101"), Util.toBytesFromString("FEE01F01FEF10E01"), Util.toBytesFromString("E0FE1F01F1FE0E01"), Util.toBytesFromString("FEE0011FFEF1010E"), Util.toBytesFromString("E0FE011FF1FE010E"), Util.toBytesFromString("E0E01F1FF1F10E0E"), Util.toBytesFromString("FEFE1F1FFEFE0E0E"), Util.toBytesFromString("1F1F01010E0E0101"), Util.toBytesFromString("011F1F01010E0E01"), Util.toBytesFromString("1F01011F0E01010E"), Util.toBytesFromString("01011F1F01010E0E"), Util.toBytesFromString("01E0E00101F1F101"), Util.toBytesFromString("1FFEE0010EFEF001"), Util.toBytesFromString("1FE0FE010EF1FE01"), Util.toBytesFromString("01FEFE0101FEFE01"), Util.toBytesFromString("1FE0E01F0EF1F10E"), Util.toBytesFromString("01FEE01F01FEF10E"), Util.toBytesFromString("01E0FE1F01F1FE0E"), Util.toBytesFromString("1FFEFE1F0EFEFE0E"), Util.toBytesFromString("E00101E0F10101F1"), Util.toBytesFromString("FE1F01E0FE0E0EF1"), Util.toBytesFromString("FE011FE0FE010EF1"), Util.toBytesFromString("E01F1FE0F10E0EF1"), Util.toBytesFromString("FE0101FEFE0101FE"), Util.toBytesFromString("E01F01FEF10E01FE"), Util.toBytesFromString("E0011FFEF1010EFE"), Util.toBytesFromString("FE1F1FFEFE0E0EFE"), Util.toBytesFromString("1FFE01E00EFE01F1"), Util.toBytesFromString("01FE1FE001FE0EF1"), Util.toBytesFromString("1FE001FE0EF101FE"), Util.toBytesFromString("01E01FFE01F10EFE"), Util.toBytesFromString("0101E0E00101F1F1"), Util.toBytesFromString("1F1FE0E00E0EF1F1"), Util.toBytesFromString("1F01FEE00E01FEF1"), Util.toBytesFromString("011FFEE0010EFEF1"), Util.toBytesFromString("1F01E0FE0E01F1FE"), Util.toBytesFromString("011FE0FE010EF1FE"), Util.toBytesFromString("0101FEFE0001FEFE"), Util.toBytesFromString("1F1FFEFE0E0EFEFE"), Util.toBytesFromString("FEFEE0E0FEFEF1F1"), Util.toBytesFromString("E0FEFEE0F1FEFEF1"), Util.toBytesFromString("FEE0E0FEFEF1F1FE"), Util.toBytesFromString("E0E0FEFEF1F1FEFE")};

    public DES() {
        super("des", 8, 8);
    }

    public static void adjustParity(byte[] byArray, int n) {
        for (int i = n; i < n + 8; ++i) {
            int n2 = i;
            byArray[n2] = byArray[n2] ^ (PARITY[byArray[i] & 0xFF] == 8 ? (byte)1 : 0);
        }
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) {
        int n2 = -2004318072;
        int n3 = PARITY[byArray[n + 0] & 0xFF];
        n3 <<= 4;
        n3 |= PARITY[byArray[n + 1] & 0xFF];
        n3 <<= 4;
        n3 |= PARITY[byArray[n + 2] & 0xFF];
        n3 <<= 4;
        n3 |= PARITY[byArray[n + 3] & 0xFF];
        n3 <<= 4;
        n3 |= PARITY[byArray[n + 4] & 0xFF];
        n3 <<= 4;
        n3 |= PARITY[byArray[n + 5] & 0xFF];
        n3 <<= 4;
        n3 |= PARITY[byArray[n + 6] & 0xFF];
        n3 <<= 4;
        return ((n3 |= PARITY[byArray[n + 7] & 0xFF]) & n2) == 0;
    }

    public static boolean isWeak(byte[] byArray) {
        for (int i = 0; i < WEAK_KEYS.length; ++i) {
            if (!Arrays.equals(WEAK_KEYS[i], byArray)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSemiWeak(byte[] byArray) {
        for (int i = 0; i < SEMIWEAK_KEYS.length; ++i) {
            if (!Arrays.equals(SEMIWEAK_KEYS[i], byArray)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPossibleWeak(byte[] byArray) {
        for (int i = 0; i < POSSIBLE_WEAK_KEYS.length; ++i) {
            if (!Arrays.equals(POSSIBLE_WEAK_KEYS[i], byArray)) continue;
            return true;
        }
        return false;
    }

    private static void desFunc(byte[] byArray, int n, byte[] byArray2, int n2, int[] nArray) {
        int n3 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n4 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        int n5 = (n3 >>> 4 ^ n4) & 0xF0F0F0F;
        n3 ^= n5 << 4;
        n4 ^= n5;
        n5 = (n3 >>> 16 ^ n4) & 0xFFFF;
        n3 ^= n5 << 16;
        n4 ^= n5;
        n5 = (n4 >>> 2 ^ n3) & 0x33333333;
        n4 ^= n5 << 2;
        n3 ^= n5;
        n5 = (n4 >>> 8 ^ n3) & 0xFF00FF;
        n4 ^= n5 << 8;
        n3 ^= n5;
        n4 = (n4 << 1 | n4 >>> 31 & 1) & 0xFFFFFFFF;
        n5 = (n3 ^ n4) & 0xAAAAAAAA;
        n3 ^= n5;
        n4 ^= n5;
        n3 = (n3 << 1 | n3 >>> 31 & 1) & 0xFFFFFFFF;
        int n6 = 0;
        for (int i = 0; i < 8; ++i) {
            n5 = n4 >>> 4 | n4 << 28;
            int n7 = SP7[(n5 ^= nArray[n6++]) & 0x3F];
            n7 |= SP5[(n5 >>>= 8) & 0x3F];
            n7 |= SP3[(n5 >>>= 8) & 0x3F];
            n7 |= SP1[(n5 >>>= 8) & 0x3F];
            n5 = n4 ^ nArray[n6++];
            n7 |= SP8[n5 & 0x3F];
            n7 |= SP6[(n5 >>>= 8) & 0x3F];
            n7 |= SP4[(n5 >>>= 8) & 0x3F];
            n5 = (n3 ^= (n7 |= SP2[(n5 >>>= 8) & 0x3F])) >>> 4 | n3 << 28;
            n7 = SP7[(n5 ^= nArray[n6++]) & 0x3F];
            n7 |= SP5[(n5 >>>= 8) & 0x3F];
            n7 |= SP3[(n5 >>>= 8) & 0x3F];
            n7 |= SP1[(n5 >>>= 8) & 0x3F];
            n5 = n3 ^ nArray[n6++];
            n7 |= SP8[n5 & 0x3F];
            n7 |= SP6[(n5 >>>= 8) & 0x3F];
            n7 |= SP4[(n5 >>>= 8) & 0x3F];
            n4 ^= (n7 |= SP2[(n5 >>>= 8) & 0x3F]);
        }
        n4 = n4 << 31 | n4 >>> 1;
        n5 = (n3 ^ n4) & 0xAAAAAAAA;
        n3 ^= n5;
        n4 ^= n5;
        n3 = n3 << 31 | n3 >>> 1;
        n5 = (n3 >>> 8 ^ n4) & 0xFF00FF;
        n3 ^= n5 << 8;
        n4 ^= n5;
        n5 = (n3 >>> 2 ^ n4) & 0x33333333;
        n3 ^= n5 << 2;
        n4 ^= n5;
        n5 = (n4 >>> 16 ^ n3) & 0xFFFF;
        n4 ^= n5 << 16;
        n3 ^= n5;
        n5 = (n4 >>> 4 ^ n3) & 0xF0F0F0F;
        byArray2[n2++] = (byte)((n4 ^= n5 << 4) >>> 24);
        byArray2[n2++] = (byte)(n4 >>> 16);
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)((n3 ^= n5) >>> 24);
        byArray2[n2++] = (byte)(n3 >>> 16);
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2] = (byte)n3;
    }

    public Object clone() {
        return new DES();
    }

    public Iterator blockSizes() {
        return Collections.singleton(8).iterator();
    }

    public Iterator keySizes() {
        return Collections.singleton(8).iterator();
    }

    public Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        int n2;
        int n3;
        if (byArray == null || byArray.length != 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        if (Properties.checkForWeakKeys() && (DES.isWeak(byArray) || DES.isSemiWeak(byArray) || DES.isPossibleWeak(byArray))) {
            throw new WeakKeyException();
        }
        long l = 0L;
        long l2 = 0L;
        for (n3 = 0; n3 < 56; ++n3) {
            n2 = PC1[n3];
            l |= (byArray[n2 >>> 3] & 128 >>> (n2 & 7)) != 0 ? 1L << (55 - n3 & 0x3F) : 0L;
        }
        Context context = new Context(this);
        for (n3 = 0; n3 < 16; ++n3) {
            int n4;
            l2 = 0L;
            int n5 = n3 << 1;
            int n6 = n5 + 1;
            for (n4 = 0; n4 < 28; ++n4) {
                n2 = n4 + ROTARS[n3];
                if (n2 < 28) {
                    l2 |= (l & 1L << (55 - n2 & 0x3F)) != 0L ? 1L << (55 - n4 & 0x3F) : 0L;
                    continue;
                }
                l2 |= (l & 1L << (55 - (n2 - 28) & 0x3F)) != 0L ? 1L << (55 - n4 & 0x3F) : 0L;
            }
            for (n4 = 28; n4 < 56; ++n4) {
                n2 = n4 + ROTARS[n3];
                if (n2 < 56) {
                    l2 |= (l & 1L << (55 - n2 & 0x3F)) != 0L ? 1L << (55 - n4 & 0x3F) : 0L;
                    continue;
                }
                l2 |= (l & 1L << (55 - (n2 - 28) & 0x3F)) != 0L ? 1L << (55 - n4 & 0x3F) : 0L;
            }
            for (n4 = 0; n4 < 24; ++n4) {
                if ((l2 & 1L << (55 - PC2[n4] & 0x3F)) != 0L) {
                    int n7 = n5;
                    context.ek[n7] = context.ek[n7] | 1 << (23 - n4 & 0x1F);
                }
                if ((l2 & 1L << (55 - PC2[n4 + 24] & 0x3F)) == 0L) continue;
                int n8 = n6;
                context.ek[n8] = context.ek[n8] | 1 << (23 - n4 & 0x1F);
            }
        }
        for (n3 = 0; n3 < Context.access$2(); n3 += 2) {
            context.dk[30 - n3] = context.ek[n3];
            context.dk[31 - n3] = context.ek[n3 + 1];
        }
        for (n3 = 0; n3 < 32; n3 += 2) {
            int n9 = context.ek[n3];
            int n10 = context.ek[n3 + 1];
            context.ek[n3] = (n9 & 0xFC0000) << 6 | (n9 & 0xFC0) << 10 | (n10 & 0xFC0000) >>> 10 | (n10 & 0xFC0) >>> 6;
            context.ek[n3 + 1] = (n9 & 0x3F000) << 12 | (n9 & 0x3F) << 16 | (n10 & 0x3F000) >>> 4 | n10 & 0x3F;
            n9 = context.dk[n3];
            n10 = context.dk[n3 + 1];
            context.dk[n3] = (n9 & 0xFC0000) << 6 | (n9 & 0xFC0) << 10 | (n10 & 0xFC0000) >>> 10 | (n10 & 0xFC0) >>> 6;
            context.dk[n3 + 1] = (n9 & 0x3F000) << 12 | (n9 & 0x3F) << 16 | (n10 & 0x3F000) >>> 4 | n10 & 0x3F;
        }
        return context;
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        DES.desFunc(byArray, n, byArray2, n2, ((Context)object).ek);
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        DES.desFunc(byArray, n, byArray2, n2, ((Context)object).dk);
    }

    final class Context {
        private /* synthetic */ DES this$0;
        private static final int EXPANDED_KEY_SIZE = 32;
        int[] ek = new int[32];
        int[] dk = new int[32];

        static /* synthetic */ int access$2() {
            return 32;
        }

        Context(DES dES) {
            this.this$0 = dES;
        }

        byte[] getEncryptionKeyBytes() {
            return this.toByteArray(this.ek);
        }

        byte[] getDecryptionKeyBytes() {
            return this.toByteArray(this.dk);
        }

        byte[] toByteArray(int[] nArray) {
            byte[] byArray = new byte[4 * nArray.length];
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                byArray[n++] = (byte)(nArray[i] >>> 24);
                byArray[n++] = (byte)(nArray[i] >>> 16);
                byArray[n++] = (byte)(nArray[i] >>> 8);
                byArray[n++] = (byte)nArray[i];
            }
            return byArray;
        }
    }
}

