/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.IIOImage;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public abstract class ImageWriter
implements ImageTranscoder {
    private boolean aborted;
    protected Locale[] availableLocales;
    protected Locale locale;
    protected ImageWriterSpi originatingProvider;
    protected Object output;
    protected List progressListeners;
    protected List warningListeners;
    protected List warningLocales;

    private /* synthetic */ void finit$() {
        this.availableLocales = null;
        this.locale = null;
        this.originatingProvider = null;
        this.output = null;
        this.progressListeners = null;
        this.warningListeners = null;
        this.warningLocales = null;
    }

    protected ImageWriter(ImageWriterSpi imageWriterSpi) {
        this.finit$();
        this.originatingProvider = imageWriterSpi;
    }

    private void checkOutputSet() {
        if (this.output == null) {
            throw new IllegalStateException("no output set");
        }
    }

    public void abort() {
        this.aborted = true;
    }

    protected boolean abortRequested() {
        return this.aborted;
    }

    public void addIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        if (iIOWriteProgressListener == null) {
            return;
        }
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList();
        }
        this.progressListeners.add(iIOWriteProgressListener);
    }

    public void addIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        if (iIOWriteWarningListener == null) {
            return;
        }
        if (this.warningListeners == null) {
            this.warningListeners = new ArrayList();
        }
        this.warningListeners.add(iIOWriteWarningListener);
    }

    public boolean canInsertEmpty(int n) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canInsertImage(int n) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canRemoveImage(int n) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canReplaceImageMetadata(int n) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canReplacePixels(int n) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canReplaceStreamMetadata() throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canWriteEmpty() throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canWriteRasters() {
        return false;
    }

    public boolean canWriteSequence() {
        return false;
    }

    protected void clearAbortRequest() {
        this.aborted = false;
    }

    public abstract IIOMetadata convertImageMetadata(IIOMetadata var1, ImageTypeSpecifier var2, ImageWriteParam var3);

    public abstract IIOMetadata convertStreamMetadata(IIOMetadata var1, ImageWriteParam var2);

    public void dispose() {
    }

    public Locale[] getAvailableLocales() {
        return this.availableLocales;
    }

    public abstract IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier var1, ImageWriteParam var2);

    public abstract IIOMetadata getDefaultStreamMetadata(ImageWriteParam var1);

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return 0;
    }

    public ImageWriterSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public Object getOutput() {
        return this.output;
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return null;
    }

    protected void processImageComplete() {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)iterator.next();
                iIOWriteProgressListener.imageComplete(this);
            }
        }
    }

    protected void processImageProgress(float f) {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)iterator.next();
                iIOWriteProgressListener.imageProgress(this, f);
            }
        }
    }

    protected void processImageStarted(int n) {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)iterator.next();
                iIOWriteProgressListener.imageStarted(this, n);
            }
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)iterator.next();
                iIOWriteProgressListener.thumbnailComplete(this);
            }
        }
    }

    protected void processThumbnailProgress(float f) {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)iterator.next();
                iIOWriteProgressListener.thumbnailProgress(this, f);
            }
        }
    }

    protected void processThumbnailStarted(int n, int n2) {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)iterator.next();
                iIOWriteProgressListener.thumbnailStarted(this, n, n2);
            }
        }
    }

    protected void processWarningOccurred(int n, String string) {
        if (this.warningListeners != null) {
            Iterator iterator = this.warningListeners.iterator();
            while (iterator.hasNext()) {
                IIOWriteWarningListener iIOWriteWarningListener = (IIOWriteWarningListener)iterator.next();
                iIOWriteWarningListener.warningOccurred(this, n, string);
            }
        }
    }

    protected void processWarningOccurred(int n, String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("null argument");
        }
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string, this.getLocale());
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("no resource bundle found");
        }
        Object object = null;
        try {
            object = resourceBundle.getObject(string2);
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("no results found for keyword");
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("retrieved object not a String");
        }
        String string3 = (String)object;
        if (this.warningListeners != null) {
            Iterator iterator = this.warningListeners.iterator();
            while (iterator.hasNext()) {
                IIOWriteWarningListener iIOWriteWarningListener = (IIOWriteWarningListener)iterator.next();
                iIOWriteWarningListener.warningOccurred(this, n, string3);
            }
        }
    }

    protected void processWriteAborted() {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)iterator.next();
                iIOWriteProgressListener.writeAborted(this);
            }
        }
    }

    public void removeAllIIOWriteProgressListeners() {
        if (this.progressListeners != null) {
            this.progressListeners.clear();
        }
    }

    public void removeAllIIOWriteWarningListeners() {
        if (this.progressListeners != null) {
            this.progressListeners.clear();
        }
    }

    public void removeIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        if (iIOWriteProgressListener == null) {
            return;
        }
        if (this.progressListeners != null) {
            this.progressListeners.remove(iIOWriteProgressListener);
        }
    }

    public void removeIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        if (iIOWriteWarningListener == null) {
            return;
        }
        if (this.warningListeners != null) {
            this.warningListeners.remove(iIOWriteWarningListener);
        }
    }

    public void reset() {
        this.setOutput(null);
        this.setLocale(null);
        this.removeAllIIOWriteWarningListeners();
        this.removeAllIIOWriteProgressListeners();
        this.clearAbortRequest();
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            boolean bl = false;
            if (this.availableLocales != null) {
                for (int i = this.availableLocales.length - 1; i >= 0; --i) {
                    if (!this.availableLocales[i].equals(locale)) continue;
                    bl = true;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("looale not available");
            }
        }
        this.locale = locale;
    }

    public void setOutput(Object object) {
        if (object != null) {
            boolean bl = false;
            Class[] classArray = null;
            if (this.originatingProvider != null) {
                classArray = this.originatingProvider.getOutputTypes();
            }
            if (classArray != null) {
                for (int i = classArray.length - 1; i >= 0; --i) {
                    if (!classArray[i].isInstance(object)) continue;
                    bl = true;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("output type not available");
            }
        }
        this.output = object;
    }

    public abstract void write(IIOMetadata var1, IIOImage var2, ImageWriteParam var3) throws IOException;

    public void endInsertEmpty() throws IOException {
        if (!this.canInsertEmpty(0)) {
            throw new UnsupportedOperationException();
        }
    }

    public void endReplacePixels() throws IOException {
        if (!this.canReplacePixels(0)) {
            throw new UnsupportedOperationException();
        }
    }

    public void endWriteEmpty() throws IOException {
        if (!this.canWriteEmpty()) {
            throw new UnsupportedOperationException();
        }
    }

    public void endWriteSequence() throws IOException {
        this.checkOutputSet();
        if (!this.canWriteSequence()) {
            throw new UnsupportedOperationException();
        }
    }

    public void prepareInsertEmpty(int n, ImageTypeSpecifier imageTypeSpecifier, int n2, int n3, IIOMetadata iIOMetadata, List list2, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.canInsertEmpty(n)) {
            throw new UnsupportedOperationException();
        }
    }

    public void prepareReplacePixels(int n, Rectangle rectangle) throws IOException {
        if (this.canReplacePixels(n)) {
            throw new UnsupportedOperationException();
        }
    }

    public void prepareWriteEmpty(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, int n, int n2, IIOMetadata iIOMetadata2, List list2, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.canWriteEmpty()) {
            throw new UnsupportedOperationException();
        }
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        this.checkOutputSet();
        if (!this.canWriteSequence()) {
            throw new UnsupportedOperationException();
        }
    }

    public void removeImage(int n) throws IOException {
        if (!this.canRemoveImage(n)) {
            throw new UnsupportedOperationException();
        }
    }

    public void replaceImageMetadata(int n, IIOMetadata iIOMetadata) throws IOException {
        if (!this.canReplaceImageMetadata(n)) {
            throw new UnsupportedOperationException();
        }
    }

    public void replacePixels(RenderedImage renderedImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.canReplacePixels(0)) {
            throw new UnsupportedOperationException();
        }
    }

    public void replacePixels(Raster raster, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.canReplacePixels(0)) {
            throw new UnsupportedOperationException();
        }
    }

    public void replaceStreamMetadata(IIOMetadata iIOMetadata) throws IOException {
        if (!this.canReplaceStreamMetadata()) {
            throw new UnsupportedOperationException();
        }
    }

    public void write(RenderedImage renderedImage) throws IOException {
        this.checkOutputSet();
        this.write(null, new IIOImage(renderedImage, null, null), null);
    }

    public void write(IIOImage iIOImage) throws IOException {
        this.checkOutputSet();
        this.write(null, iIOImage, null);
    }

    public void writeInsert(int n, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.canInsertImage(n)) {
            throw new UnsupportedOperationException();
        }
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.canWriteSequence()) {
            throw new UnsupportedOperationException();
        }
    }
}

