require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&PMAP_H)) {
    eval 'sub PMAP_H () {1;}' unless defined(&PMAP_H);
    if(defined(&_KERNEL)) {
	require 'machine/pte.ph';
	require 'machine/mtpr.ph';
	require 'machine/pcb.ph';
	eval 'sub LTOHPS () {( &PGSHIFT -  &VAX_PGSHIFT);}' unless defined(&LTOHPS);
	eval 'sub LTOHPN () {(1<<  &LTOHPS);}' unless defined(&LTOHPN);
	eval 'sub USRPTSIZE () {(( &MAXTSIZ + 40*1024*1024+  &MAXSSIZ) /  &VAX_NBPG);}' unless defined(&USRPTSIZE);
	eval 'sub NPTEPGS () {( &USRPTSIZE / ($sizeof{ &pt_entry_t} *  &LTOHPN));}' unless defined(&NPTEPGS);
	eval 'sub MAPVIRT {
	    my($ptr, $count) = @_;
    	    eval q(( &vaddr_t)$ptr =  &virtual_avail;  &virtual_avail += ($count) *  &VAX_NBPG;);
	}' unless defined(&MAPVIRT);
	eval 'sub MAPPHYS {
	    my($ptr, $count, $perm) = @_;
    	    eval q(( &paddr_t)$ptr =  &avail_start +  &KERNBASE;  &avail_start += ($count) *  &VAX_NBPG;);
	}' unless defined(&MAPPHYS);
	eval 'sub pmap_kernel () {
	    eval q(( &kernel_pmap_store));
	}' unless defined(&pmap_kernel);
	eval 'sub pmap_map_direct {
	    my($pg) = @_;
    	    eval q(( &VM_PAGE_TO_PHYS($pg) |  &KERNBASE));
	}' unless defined(&pmap_map_direct);
	eval 'sub pmap_unmap_direct {
	    my($va) = @_;
    	    eval q( &PHYS_TO_VM_PAGE(($va) & ~ &KERNBASE));
	}' unless defined(&pmap_unmap_direct);
	eval 'sub __HAVE_PMAP_DIRECT () {1;}' unless defined(&__HAVE_PMAP_DIRECT);
	eval 'sub PMAP_STEAL_MEMORY () {1;}' unless defined(&PMAP_STEAL_MEMORY);
	eval 'sub pmap_phys_address {
	    my($phys) = @_;
    	    eval q((($phys) <<  &PGSHIFT));
	}' unless defined(&pmap_phys_address);
	eval 'sub pmap_copy {
	    my($a,$b,$c,$d,$e) = @_;
    	    eval q();
	}' unless defined(&pmap_copy);
	eval 'sub pmap_update {
	    my($pm) = @_;
    	    eval q();
	}' unless defined(&pmap_update);
	eval 'sub pmap_collect {
	    my($pmap) = @_;
    	    eval q();
	}' unless defined(&pmap_collect);
	eval 'sub pmap_remove {
	    my($pmap, $start, $slut) = @_;
    	    eval q( &pmap_protect($pmap, $start, $slut, 0));
	}' unless defined(&pmap_remove);
	eval 'sub pmap_resident_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_deactivate {
	    my($p) = @_;
    	    eval q();
	}' unless defined(&pmap_deactivate);
	eval 'sub pmap_reference {
	    my($pmap) = @_;
    	    eval q(($pmap)-> &ref_count++);
	}' unless defined(&pmap_reference);
	eval 'sub pmap_copy_page {
	    my($srcpg, $dstpg) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&pmap_copy_page);
	eval 'sub pmap_zero_page {
	    my($pg) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&pmap_zero_page);
	eval 'sub pmap_proc_iflush {
	    my($p,$va,$len) = @_;
    	    eval q();
	}' unless defined(&pmap_proc_iflush);
	eval 'sub pmap_unuse_final {
	    my($p) = @_;
    	    eval q();
	}' unless defined(&pmap_unuse_final);
    }
}
1;
