require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_X86_MTRR_H_)) {
    eval 'sub _X86_MTRR_H_ () {1;}' unless defined(&_X86_MTRR_H_);
    eval 'sub MTRR_I686_FIXED_IDX64K () {0;}' unless defined(&MTRR_I686_FIXED_IDX64K);
    eval 'sub MTRR_I686_FIXED_IDX16K () {1;}' unless defined(&MTRR_I686_FIXED_IDX16K);
    eval 'sub MTRR_I686_FIXED_IDX4K () {3;}' unless defined(&MTRR_I686_FIXED_IDX4K);
    eval 'sub MTRR_I686_NVAR () {8;}' unless defined(&MTRR_I686_NVAR);
    eval 'sub MTRR_I686_64K_START () {0x;}' unless defined(&MTRR_I686_64K_START);
    eval 'sub MTRR_I686_16K_START () {0x80000;}' unless defined(&MTRR_I686_16K_START);
    eval 'sub MTRR_I686_4K_START () {0xc0000;}' unless defined(&MTRR_I686_4K_START);
    eval 'sub MTRR_I686_NFIXED_64K () {1;}' unless defined(&MTRR_I686_NFIXED_64K);
    eval 'sub MTRR_I686_NFIXED_16K () {2;}' unless defined(&MTRR_I686_NFIXED_16K);
    eval 'sub MTRR_I686_NFIXED_4K () {8;}' unless defined(&MTRR_I686_NFIXED_4K);
    eval 'sub MTRR_I686_NFIXED () {11;}' unless defined(&MTRR_I686_NFIXED);
    eval 'sub MTRR_I686_NFIXED_SOFT_64K () {( &MTRR_I686_NFIXED_64K * 8);}' unless defined(&MTRR_I686_NFIXED_SOFT_64K);
    eval 'sub MTRR_I686_NFIXED_SOFT_16K () {( &MTRR_I686_NFIXED_16K * 8);}' unless defined(&MTRR_I686_NFIXED_SOFT_16K);
    eval 'sub MTRR_I686_NFIXED_SOFT_4K () {( &MTRR_I686_NFIXED_4K * 8);}' unless defined(&MTRR_I686_NFIXED_SOFT_4K);
    eval 'sub MTRR_I686_NFIXED_SOFT () {( &MTRR_I686_NFIXED * 8);}' unless defined(&MTRR_I686_NFIXED_SOFT);
    eval 'sub MTRR_I686_ENABLE_MASK () {0x800;}' unless defined(&MTRR_I686_ENABLE_MASK);
    eval 'sub MTRR_I686_FIXED_ENABLE_MASK () {0x400;}' unless defined(&MTRR_I686_FIXED_ENABLE_MASK);
    eval 'sub MTRR_I686_CAP_VCNT_MASK () {0xff;}' unless defined(&MTRR_I686_CAP_VCNT_MASK);
    eval 'sub MTRR_I686_CAP_FIX_MASK () {0x100;}' unless defined(&MTRR_I686_CAP_FIX_MASK);
    eval 'sub MTRR_I686_CAP_WC_MASK () {0x400;}' unless defined(&MTRR_I686_CAP_WC_MASK);
    eval 'sub MTRR_TYPE_UC () {0;}' unless defined(&MTRR_TYPE_UC);
    eval 'sub MTRR_TYPE_WC () {1;}' unless defined(&MTRR_TYPE_WC);
    eval 'sub MTRR_TYPE_UNDEF1 () {2;}' unless defined(&MTRR_TYPE_UNDEF1);
    eval 'sub MTRR_TYPE_UNDEF2 () {3;}' unless defined(&MTRR_TYPE_UNDEF2);
    eval 'sub MTRR_TYPE_WT () {4;}' unless defined(&MTRR_TYPE_WT);
    eval 'sub MTRR_TYPE_WP () {5;}' unless defined(&MTRR_TYPE_WP);
    eval 'sub MTRR_TYPE_WB () {6;}' unless defined(&MTRR_TYPE_WB);
    eval 'sub MTRR_PRIVATE () {0x1;}' unless defined(&MTRR_PRIVATE);
    eval 'sub MTRR_FIXED () {0x2;}' unless defined(&MTRR_FIXED);
    eval 'sub MTRR_VALID () {0x4;}' unless defined(&MTRR_VALID);
    eval 'sub MTRR_CANTSET () { &MTRR_FIXED;}' unless defined(&MTRR_CANTSET);
    eval 'sub MTRR_I686_MASK_VALID () {(1<< 11);}' unless defined(&MTRR_I686_MASK_VALID);
    eval 'sub MTRR_K6_ADDR_SHIFT () {17;}' unless defined(&MTRR_K6_ADDR_SHIFT);
    eval 'sub MTRR_K6_ADDR () {(0x7fff <<  &MTRR_K6_ADDR_SHIFT);}' unless defined(&MTRR_K6_ADDR);
    eval 'sub MTRR_K6_MASK_SHIFT () {2;}' unless defined(&MTRR_K6_MASK_SHIFT);
    eval 'sub MTRR_K6_MASK () {(0x7fff <<  &MTRR_K6_MASK_SHIFT);}' unless defined(&MTRR_K6_MASK);
    eval 'sub MTRR_K6_WC () {(1 << 1);}' unless defined(&MTRR_K6_WC);
    eval 'sub MTRR_K6_UC () {(1 << 0);}' unless defined(&MTRR_K6_UC);
    eval 'sub MTRR_K6_NVAR () {2;}' unless defined(&MTRR_K6_NVAR);
    if(defined(&_KERNEL)) {
	eval 'sub mtrr_base_value {
	    my($mtrrp) = @_;
    	    eval q(((( &uint64_t)($mtrrp)-> &base) | (( &uint64_t)($mtrrp)-> &type)));
	}' unless defined(&mtrr_base_value);
	eval 'sub mtrr_mask_value {
	    my($mtrrp) = @_;
    	    eval q(((~(($mtrrp)-> &len - 1) & 0xffffff000)));
	}' unless defined(&mtrr_mask_value);
	eval 'sub mtrr_len {
	    my($val) = @_;
    	    eval q(((~(($val) & 0xffffff000)+1) & 0xffffff000));
	}' unless defined(&mtrr_len);
	eval 'sub mtrr_base {
	    my($val) = @_;
    	    eval q((($val) & 0xffffff000));
	}' unless defined(&mtrr_base);
	eval 'sub mtrr_type {
	    my($val) = @_;
    	    eval q((( &uint8_t)(($val) & 0xff)));
	}' unless defined(&mtrr_type);
	eval 'sub mtrr_valid {
	    my($val) = @_;
    	    eval q(((($val) &  &MTRR_I686_MASK_VALID) != 0));
	}' unless defined(&mtrr_valid);
	eval 'sub mtrr_init_cpu {
	    my($ci) = @_;
    	    eval q( ($mtrr_funcs->{init_cpu})($ci));
	}' unless defined(&mtrr_init_cpu);
	eval 'sub mtrr_reload_cpu {
	    my($ci) = @_;
    	    eval q( ($mtrr_funcs->{reload_cpu})($ci));
	}' unless defined(&mtrr_reload_cpu);
	eval 'sub mtrr_clean {
	    my($p) = @_;
    	    eval q( ($mtrr_funcs->{clean})($p));
	}' unless defined(&mtrr_clean);
	eval 'sub mtrr_set {
	    my($mp,$n,$p,$f) = @_;
    	    eval q( ($mtrr_funcs->{set})($mp,$n,$p,$f));
	}' unless defined(&mtrr_set);
	eval 'sub mtrr_get {
	    my($mp,$n,$p,$f) = @_;
    	    eval q( ($mtrr_funcs->{get})($mp,$n,$p,$f));
	}' unless defined(&mtrr_get);
	eval 'sub mtrr_dump {
	    my($s) = @_;
    	    eval q( ($mtrr_funcs->{dump})($s));
	}' unless defined(&mtrr_dump);
	eval 'sub mtrr_commit () {
	    eval q( ($mtrr_funcs->{commit})());
	}' unless defined(&mtrr_commit);
	eval 'sub MTRR_GETSET_USER () {0x1;}' unless defined(&MTRR_GETSET_USER);
	eval 'sub MTRR_GETSET_KERNEL () {0x2;}' unless defined(&MTRR_GETSET_KERNEL);
    }
}
1;
