require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_I386_PMAP_H_)) {
    eval 'sub _I386_PMAP_H_ () {1;}' unless defined(&_I386_PMAP_H_);
    require 'machine/cpufunc.ph';
    require 'machine/pte.ph';
    require 'machine/segments.ph';
    require 'uvm/uvm_pglist.ph';
    require 'uvm/uvm_object.ph';
    eval 'sub PDSLOT_PTE () {(( &KERNBASE/ &NBPD)-1);}' unless defined(&PDSLOT_PTE);
    eval 'sub PDSLOT_KERN () {( &KERNBASE/ &NBPD);}' unless defined(&PDSLOT_KERN);
    eval 'sub PDSLOT_APTE () {(1023);}' unless defined(&PDSLOT_APTE);
    eval 'sub PTE_BASE () {(( &pt_entry_t *) ( &PDSLOT_PTE *  &NBPD) );}' unless defined(&PTE_BASE);
    eval 'sub APTE_BASE () {(( &pt_entry_t *) ( &PDSLOT_APTE *  &NBPD) );}' unless defined(&APTE_BASE);
    eval 'sub PDP_BASE () {(( &pd_entry_t *)(( &PTE_BASE) + ( &PDSLOT_PTE *  &NBPG)));}' unless defined(&PDP_BASE);
    eval 'sub APDP_BASE () {(( &pd_entry_t *)(( &APTE_BASE) + ( &PDSLOT_APTE *  &NBPG)));}' unless defined(&APDP_BASE);
    eval 'sub PDP_PDE () {( &PDP_BASE +  &PDSLOT_PTE);}' unless defined(&PDP_PDE);
    eval 'sub APDP_PDE () {( &PDP_BASE +  &PDSLOT_APTE);}' unless defined(&APDP_PDE);
    unless(defined(&NKPTP)) {
	eval 'sub NKPTP () {4;}' unless defined(&NKPTP);
    }
    eval 'sub NKPTP_MIN () {4;}' unless defined(&NKPTP_MIN);
    eval 'sub NKPTP_MAX () {(1024- ( &KERNBASE/ &NBPD) - 1);}' unless defined(&NKPTP_MAX);
    eval 'sub vtopte {
        my($VA) = @_;
	    eval q(( &PTE_BASE +  &atop($VA)));
    }' unless defined(&vtopte);
    eval 'sub kvtopte {
        my($VA) = @_;
	    eval q( &vtopte($VA));
    }' unless defined(&kvtopte);
    eval 'sub ptetov {
        my($PT) = @_;
	    eval q(( &ptoa($PT -  &PTE_BASE)));
    }' unless defined(&ptetov);
    eval 'sub vtophys {
        my($VA) = @_;
	    eval q(((* &vtopte &  &PG_FRAME) | (($VA) & ~ &PG_FRAME)));
    }' unless defined(&vtophys);
    eval 'sub avtopte {
        my($VA) = @_;
	    eval q(( &APTE_BASE +  &atop($VA)));
    }' unless defined(&avtopte);
    eval 'sub ptetoav {
        my($PT) = @_;
	    eval q(( &ptoa($PT -  &APTE_BASE)));
    }' unless defined(&ptetoav);
    eval 'sub avtophys {
        my($VA) = @_;
	    eval q(((* &avtopte &  &PG_FRAME) | (($VA) & ~ &PG_FRAME)));
    }' unless defined(&avtophys);
    eval 'sub pdei {
        my($VA) = @_;
	    eval q(((($VA) &  &PD_MASK) >>  &PDSHIFT));
    }' unless defined(&pdei);
    eval 'sub ptei {
        my($VA) = @_;
	    eval q(((($VA) &  &PT_MASK) >>  &PGSHIFT));
    }' unless defined(&ptei);
    eval 'sub ptp_i2o {
        my($I) = @_;
	    eval q((($I) *  &NBPG));
    }' unless defined(&ptp_i2o);
    eval 'sub ptp_o2i {
        my($O) = @_;
	    eval q((($O) /  &NBPG));
    }' unless defined(&ptp_o2i);
    eval 'sub ptp_i2v {
        my($I) = @_;
	    eval q((($I) *  &NBPD));
    }' unless defined(&ptp_i2v);
    eval 'sub ptp_v2i {
        my($V) = @_;
	    eval q((($V) /  &NBPD));
    }' unless defined(&ptp_v2i);
    eval 'sub PG_W () { &PG_AVAIL1;}' unless defined(&PG_W);
    eval 'sub PG_PVLIST () { &PG_AVAIL2;}' unless defined(&PG_PVLIST);
    eval 'sub PG_X () { &PG_AVAIL3;}' unless defined(&PG_X);
    eval 'sub NPTECL () {8;}' unless defined(&NPTECL);
    if(defined(&_KERNEL)) {
	eval 'sub pm_lock () { ($pm_obj->{vmobjlock});}' unless defined(&pm_lock);
	eval 'sub PMF_USER_LDT () {0x1;}' unless defined(&PMF_USER_LDT);
	eval 'sub PMAP_PA_MASK () {~(( &paddr_t) &PAGE_MASK);}' unless defined(&PMAP_PA_MASK);
	eval 'sub PMAP_NOCACHE () {0x1;}' unless defined(&PMAP_NOCACHE);
	eval 'sub PMAP_WC () {0x2;}' unless defined(&PMAP_WC);
	eval 'sub PG_PMAP_MOD () { &PG_PMAP0;}' unless defined(&PG_PMAP_MOD);
	eval 'sub PG_PMAP_REF () { &PG_PMAP1;}' unless defined(&PG_PMAP_REF);
	eval 'sub PG_PMAP_WC () { &PG_PMAP2;}' unless defined(&PG_PMAP_WC);
	eval 'sub PVE_PER_PVPAGE () {(( &NBPG - $sizeof{\'struct pv_page_info\'}) / $sizeof{\'struct pv_entry\'});}' unless defined(&PVE_PER_PVPAGE);
	eval 'sub pmap_kernel () {
	    eval q(( &kernel_pmap_store));
	}' unless defined(&pmap_kernel);
	eval 'sub pmap_wired_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
	eval 'sub pmap_resident_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_update {
	    my($pm) = @_;
    	    eval q();
	}' unless defined(&pmap_update);
	eval 'sub pmap_clear_modify {
	    my($pg) = @_;
    	    eval q( &pmap_clear_attrs($pg,  &PG_M));
	}' unless defined(&pmap_clear_modify);
	eval 'sub pmap_clear_reference {
	    my($pg) = @_;
    	    eval q( &pmap_clear_attrs($pg,  &PG_U));
	}' unless defined(&pmap_clear_reference);
	eval 'sub pmap_copy {
	    my($DP,$SP,$D,$L,$S) = @_;
    	    eval q();
	}' unless defined(&pmap_copy);
	eval 'sub pmap_is_modified {
	    my($pg) = @_;
    	    eval q( &pmap_test_attrs($pg,  &PG_M));
	}' unless defined(&pmap_is_modified);
	eval 'sub pmap_is_referenced {
	    my($pg) = @_;
    	    eval q( &pmap_test_attrs($pg,  &PG_U));
	}' unless defined(&pmap_is_referenced);
	eval 'sub pmap_valid_entry {
	    my($E) = @_;
    	    eval q((($E) &  &PG_V));
	}' unless defined(&pmap_valid_entry);
	eval 'sub pmap_proc_iflush {
	    my($p,$va,$len) = @_;
    	    eval q();
	}' unless defined(&pmap_proc_iflush);
	eval 'sub pmap_unuse_final {
	    my($p) = @_;
    	    eval q();
	}' unless defined(&pmap_unuse_final);
	eval 'sub pmap_remove_holes {
	    my($map) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pmap_remove_holes);
	if(defined(&MULTIPROCESSOR)) {
	} else {
	    eval 'sub pmap_tlb_shootwait () {
	        eval q();
	    }' unless defined(&pmap_tlb_shootwait);
	}
	eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	eval 'sub PMAP_PAGEIDLEZERO {
	    my($pg) = @_;
    	    eval q( &pmap_zero_page_uncached( &VM_PAGE_TO_PHYS($pg)));
	}' unless defined(&PMAP_PAGEIDLEZERO);
	eval 'sub pmap_update_pg {
	    my($va) = @_;
    	    eval q( &invlpg(($va)));
	}' unless defined(&pmap_update_pg);
	eval 'sub pmap_update_2pg {
	    my($va, $vb) = @_;
    	    eval q({  &invlpg();  &invlpg(($vb)); });
	}' unless defined(&pmap_update_2pg);
	if(defined(&USER_LDT)) {
	    eval 'sub PMAP_FORK () {1;}' unless defined(&PMAP_FORK);
	}
    }
}
1;
