/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.tools.ant.taskdefs.optional.extension.Compatibility;
import org.apache.tools.ant.taskdefs.optional.extension.DeweyDecimal;
import org.apache.tools.ant.util.StringUtils;

public final class Specification {
    private static final String MISSING = "Missing ";
    public static final Attributes.Name SPECIFICATION_TITLE = Attributes.Name.SPECIFICATION_TITLE;
    public static final Attributes.Name SPECIFICATION_VERSION = Attributes.Name.SPECIFICATION_VERSION;
    public static final Attributes.Name SPECIFICATION_VENDOR = Attributes.Name.SPECIFICATION_VENDOR;
    public static final Attributes.Name IMPLEMENTATION_TITLE = Attributes.Name.IMPLEMENTATION_TITLE;
    public static final Attributes.Name IMPLEMENTATION_VERSION = Attributes.Name.IMPLEMENTATION_VERSION;
    public static final Attributes.Name IMPLEMENTATION_VENDOR = Attributes.Name.IMPLEMENTATION_VENDOR;
    public static final Compatibility COMPATIBLE = new Compatibility("COMPATIBLE");
    public static final Compatibility REQUIRE_SPECIFICATION_UPGRADE = new Compatibility("REQUIRE_SPECIFICATION_UPGRADE");
    public static final Compatibility REQUIRE_VENDOR_SWITCH = new Compatibility("REQUIRE_VENDOR_SWITCH");
    public static final Compatibility REQUIRE_IMPLEMENTATION_CHANGE = new Compatibility("REQUIRE_IMPLEMENTATION_CHANGE");
    public static final Compatibility INCOMPATIBLE = new Compatibility("INCOMPATIBLE");
    private String specificationTitle;
    private DeweyDecimal specificationVersion;
    private String specificationVendor;
    private String implementationTitle;
    private String implementationVendor;
    private String implementationVersion;
    private String[] sections;

    public static Specification[] getSpecifications(Manifest manifest) throws ParseException {
        if (null == manifest) {
            return new Specification[0];
        }
        ArrayList<Specification> results = new ArrayList<Specification>();
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<String> keys = entries.keySet().iterator();
        while (keys.hasNext()) {
            Attributes attributes;
            String key = keys.next();
            Specification specification = Specification.getSpecification(key, attributes = entries.get(key));
            if (null == specification) continue;
            results.add(specification);
        }
        ArrayList trimmedResults = Specification.removeDuplicates(results);
        return trimmedResults.toArray(new Specification[trimmedResults.size()]);
    }

    public Specification(String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor) {
        this(specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, null);
    }

    public Specification(String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, String[] sections) {
        this.specificationTitle = specificationTitle;
        this.specificationVendor = specificationVendor;
        if (null != specificationVersion) {
            try {
                this.specificationVersion = new DeweyDecimal(specificationVersion);
            }
            catch (NumberFormatException nfe) {
                String error = "Bad specification version format '" + specificationVersion + "' in '" + specificationTitle + "'. (Reason: " + nfe + ")";
                throw new IllegalArgumentException(error);
            }
        }
        this.implementationTitle = implementationTitle;
        this.implementationVendor = implementationVendor;
        this.implementationVersion = implementationVersion;
        if (null == this.specificationTitle) {
            throw new NullPointerException("specificationTitle");
        }
        String[] copy = null;
        if (null != sections) {
            copy = new String[sections.length];
            System.arraycopy(sections, 0, copy, 0, sections.length);
        }
        this.sections = copy;
    }

    public String getSpecificationTitle() {
        return this.specificationTitle;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public String getImplementationTitle() {
        return this.implementationTitle;
    }

    public DeweyDecimal getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String[] getSections() {
        if (null == this.sections) {
            return null;
        }
        String[] newSections = new String[this.sections.length];
        System.arraycopy(this.sections, 0, newSections, 0, this.sections.length);
        return newSections;
    }

    public Compatibility getCompatibilityWith(Specification other) {
        if (!this.specificationTitle.equals(other.getSpecificationTitle())) {
            return INCOMPATIBLE;
        }
        DeweyDecimal otherSpecificationVersion = other.getSpecificationVersion();
        if (!(null == this.specificationVersion || null != otherSpecificationVersion && this.isCompatible(this.specificationVersion, otherSpecificationVersion))) {
            return REQUIRE_SPECIFICATION_UPGRADE;
        }
        String otherImplementationVendor = other.getImplementationVendor();
        if (!(null == this.implementationVendor || null != otherImplementationVendor && this.implementationVendor.equals(otherImplementationVendor))) {
            return REQUIRE_VENDOR_SWITCH;
        }
        String otherImplementationVersion = other.getImplementationVersion();
        if (!(null == this.implementationVersion || null != otherImplementationVersion && this.implementationVersion.equals(otherImplementationVersion))) {
            return REQUIRE_IMPLEMENTATION_CHANGE;
        }
        return COMPATIBLE;
    }

    public boolean isCompatibleWith(Specification other) {
        return COMPATIBLE == this.getCompatibilityWith(other);
    }

    public String toString() {
        String brace = ": ";
        StringBuffer sb = new StringBuffer(SPECIFICATION_TITLE.toString());
        sb.append(": ");
        sb.append(this.specificationTitle);
        sb.append(StringUtils.LINE_SEP);
        if (null != this.specificationVersion) {
            sb.append(SPECIFICATION_VERSION);
            sb.append(": ");
            sb.append((Object)this.specificationVersion);
            sb.append(StringUtils.LINE_SEP);
        }
        if (null != this.specificationVendor) {
            sb.append(SPECIFICATION_VENDOR);
            sb.append(": ");
            sb.append(this.specificationVendor);
            sb.append(StringUtils.LINE_SEP);
        }
        if (null != this.implementationTitle) {
            sb.append(IMPLEMENTATION_TITLE);
            sb.append(": ");
            sb.append(this.implementationTitle);
            sb.append(StringUtils.LINE_SEP);
        }
        if (null != this.implementationVersion) {
            sb.append(IMPLEMENTATION_VERSION);
            sb.append(": ");
            sb.append(this.implementationVersion);
            sb.append(StringUtils.LINE_SEP);
        }
        if (null != this.implementationVendor) {
            sb.append(IMPLEMENTATION_VENDOR);
            sb.append(": ");
            sb.append(this.implementationVendor);
            sb.append(StringUtils.LINE_SEP);
        }
        return sb.toString();
    }

    private boolean isCompatible(DeweyDecimal first, DeweyDecimal second) {
        return first.isGreaterThanOrEqual(second);
    }

    private static ArrayList removeDuplicates(ArrayList list) {
        ArrayList<Specification> results = new ArrayList<Specification>();
        ArrayList<String> sections = new ArrayList<String>();
        while (list.size() > 0) {
            Specification specification = (Specification)list.remove(0);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Specification other = (Specification)iterator.next();
                if (!Specification.isEqual(specification, other)) continue;
                String[] otherSections = other.getSections();
                if (null != otherSections) {
                    sections.addAll(Arrays.asList(otherSections));
                }
                iterator.remove();
            }
            Specification merged = Specification.mergeInSections(specification, sections);
            results.add(merged);
            sections.clear();
        }
        return results;
    }

    private static boolean isEqual(Specification specification, Specification other) {
        return specification.getSpecificationTitle().equals(other.getSpecificationTitle()) && specification.getSpecificationVersion().isEqual(other.getSpecificationVersion()) && specification.getSpecificationVendor().equals(other.getSpecificationVendor()) && specification.getImplementationTitle().equals(other.getImplementationTitle()) && specification.getImplementationVersion().equals(other.getImplementationVersion()) && specification.getImplementationVendor().equals(other.getImplementationVendor());
    }

    private static Specification mergeInSections(Specification specification, ArrayList sectionsToAdd) {
        if (0 == sectionsToAdd.size()) {
            return specification;
        }
        sectionsToAdd.addAll(Arrays.asList(specification.getSections()));
        String[] sections = sectionsToAdd.toArray(new String[sectionsToAdd.size()]);
        return new Specification(specification.getSpecificationTitle(), specification.getSpecificationVersion().toString(), specification.getSpecificationVendor(), specification.getImplementationTitle(), specification.getImplementationVersion(), specification.getImplementationVendor(), sections);
    }

    private static String getTrimmedString(String value) {
        return value == null ? null : value.trim();
    }

    private static Specification getSpecification(String section, Attributes attributes) throws ParseException {
        String name = Specification.getTrimmedString(attributes.getValue(SPECIFICATION_TITLE));
        if (null == name) {
            return null;
        }
        String specVendor = Specification.getTrimmedString(attributes.getValue(SPECIFICATION_VENDOR));
        if (null == specVendor) {
            throw new ParseException(MISSING + SPECIFICATION_VENDOR, 0);
        }
        String specVersion = Specification.getTrimmedString(attributes.getValue(SPECIFICATION_VERSION));
        if (null == specVersion) {
            throw new ParseException(MISSING + SPECIFICATION_VERSION, 0);
        }
        String impTitle = Specification.getTrimmedString(attributes.getValue(IMPLEMENTATION_TITLE));
        if (null == impTitle) {
            throw new ParseException(MISSING + IMPLEMENTATION_TITLE, 0);
        }
        String impVersion = Specification.getTrimmedString(attributes.getValue(IMPLEMENTATION_VERSION));
        if (null == impVersion) {
            throw new ParseException(MISSING + IMPLEMENTATION_VERSION, 0);
        }
        String impVendor = Specification.getTrimmedString(attributes.getValue(IMPLEMENTATION_VENDOR));
        if (null == impVendor) {
            throw new ParseException(MISSING + IMPLEMENTATION_VENDOR, 0);
        }
        return new Specification(name, specVersion, specVendor, impTitle, impVersion, impVendor, new String[]{section});
    }
}

