/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.database.DataBaseException;
import com.darwinsys.sql.Configuration;
import com.darwinsys.sql.ConnectionUtil;
import com.darwinsys.sql.SimpleSQLConfiguration;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class ConnectionUtilTest
extends TestCase {
    static final String MOCK_JBDB_DRIVER = "mock.MockJdbcDriver";

    public void testGetConfigurationNames() throws Exception {
        System.out.println("ConnectionUtilTest.testList()");
        Set<String> configs = ConnectionUtil.getConfigurationNames();
        boolean hasConfigNames = false;
        for (String element : configs) {
            System.out.println(element);
            hasConfigNames = true;
        }
        ConnectionUtilTest.assertTrue((boolean)hasConfigNames);
    }

    public void testGetConnections() {
        System.out.println("ConnectionUtilTest.testList()");
        List<Configuration> configs = ConnectionUtil.getConfigurations();
        ConnectionUtilTest.assertTrue((configs.size() > 1 ? 1 : 0) != 0);
    }

    public void testHasPassword() throws Exception {
        Configuration c = ConnectionUtil.getConfigurations().get(0);
        c.setPassword(null);
        ConnectionUtilTest.assertFalse((boolean)c.hasPassword());
    }

    public void testGetConnectionBadDriver() throws Exception {
        try {
            Connection c = ConnectionUtil.getConnection("url", "mydriver", "operator", "secret");
            ConnectionUtilTest.fail((String)"getConnection w/ bad params Did not throw exception");
            System.out.println(c);
        }
        catch (ClassNotFoundException nfe) {
            String m = nfe.getMessage();
            ConnectionUtilTest.assertEquals((String)"failing driver class name", (String)"mydriver", (String)m);
            System.out.println("Caught expected ClassNotFoundException");
        }
        catch (DataBaseException e) {
            ConnectionUtilTest.fail((String)("Caught wrong exception " + e + "; check order of params"));
        }
    }

    public void testPackageGetConfiguration() {
        Properties p = new Properties();
        String DRIVERNAME = "someDriverName";
        p.setProperty("foo.DBDriver", "someDriverName");
        String DBURL = "a nice long dburl";
        p.setProperty("foo.DBURL", "a nice long dburl");
        String DBUSERNAME = "db2inst1";
        p.setProperty("foo.DBUser", "db2inst1");
        SimpleSQLConfiguration conf = ConnectionUtil.getConfiguration(p, "foo");
        ConnectionUtilTest.assertEquals((String)"someDriverName", (String)conf.getDriverName());
        ConnectionUtilTest.assertEquals((String)"a nice long dburl", (String)conf.getDbURL());
        ConnectionUtilTest.assertEquals((String)"db2inst1", (String)conf.getUserName());
    }

    public void testGetConnectionBadURL() throws Exception {
        try {
            Connection c = ConnectionUtil.getConnection("url", MOCK_JBDB_DRIVER, "operator", "secret");
            ConnectionUtilTest.fail((String)"getConnection w/ bad params did not throw exception");
            System.out.println(c);
        }
        catch (SQLException e) {
            System.out.println("Caught expected Exception " + e);
        }
    }
}

