/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Jpeg
extends Image
implements Element {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID;

    static {
        byte[] byArray = new byte[5];
        byArray[0] = 74;
        byArray[1] = 70;
        byArray[2] = 73;
        byArray[3] = 70;
        JFIF_ID = byArray;
    }

    Jpeg(Image image) {
        super(image);
    }

    public Jpeg(URL url) throws BadElementException, IOException {
        super(url);
        this.processParameters();
    }

    public Jpeg(URL url, float width, float height) throws BadElementException, IOException {
        this(url);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    public Jpeg(String filename) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(filename));
    }

    public Jpeg(String filename, float width, float height) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(filename), width, height);
    }

    public Jpeg(byte[] img) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = img;
        this.originalData = img;
        this.processParameters();
    }

    public Jpeg(byte[] img, float width, float height) throws BadElementException, IOException {
        this(img);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    private static final int getShort(InputStream is) throws IOException {
        return (is.read() << 8) + is.read();
    }

    private static final int marker(int marker) {
        int i = 0;
        while (i < VALID_MARKERS.length) {
            if (marker == VALID_MARKERS[i]) {
                return 0;
            }
            ++i;
        }
        i = 0;
        while (i < NOPARAM_MARKERS.length) {
            if (marker == NOPARAM_MARKERS[i]) {
                return 2;
            }
            ++i;
        }
        i = 0;
        while (i < UNSUPPORTED_MARKERS.length) {
            if (marker == UNSUPPORTED_MARKERS[i]) {
                return 1;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParameters() throws BadElementException, IOException {
        block23: {
            this.type = 32;
            this.originalType = 1;
            InputStream is = null;
            try {
                String errorID;
                if (this.rawData == null) {
                    is = this.url.openStream();
                    errorID = this.url.toString();
                } else {
                    is = new ByteArrayInputStream(this.rawData);
                    errorID = "Byte array";
                }
                if (is.read() != 255) throw new BadElementException(String.valueOf(errorID) + " is not a valid JPEG-file.");
                if (is.read() != 216) {
                    throw new BadElementException(String.valueOf(errorID) + " is not a valid JPEG-file.");
                }
                boolean firstPass = true;
                while (true) {
                    int markertype;
                    int marker;
                    block24: {
                        int len;
                        int v;
                        if ((v = is.read()) < 0) {
                            throw new IOException("Premature EOF while reading JPG.");
                        }
                        if (v != 255) continue;
                        marker = is.read();
                        if (firstPass && marker == 224) {
                            firstPass = false;
                            len = Jpeg.getShort(is);
                            if (len < 16) {
                                Jpeg.skip(is, len - 2);
                                continue;
                            }
                            byte[] bcomp = new byte[JFIF_ID.length];
                            int r = is.read(bcomp);
                            if (r != bcomp.length) {
                                throw new BadElementException(String.valueOf(errorID) + " corrupted JFIF marker.");
                            }
                            boolean found = true;
                            int k = 0;
                            while (k < bcomp.length) {
                                if (bcomp[k] != JFIF_ID[k]) {
                                    found = false;
                                    break;
                                }
                                ++k;
                            }
                            if (!found) {
                                Jpeg.skip(is, len - 2 - bcomp.length);
                                continue;
                            }
                            Jpeg.skip(is, 2);
                            int units = is.read();
                            int dx = Jpeg.getShort(is);
                            int dy = Jpeg.getShort(is);
                            if (units == 1) {
                                this.dpiX = dx;
                                this.dpiY = dy;
                            } else if (units == 2) {
                                this.dpiX = (int)((float)dx * 2.54f + 0.5f);
                                this.dpiY = (int)((float)dy * 2.54f + 0.5f);
                            }
                            Jpeg.skip(is, len - 2 - bcomp.length - 7);
                            continue;
                        }
                        if (marker == 238) {
                            len = Jpeg.getShort(is);
                            byte[] byteappe = new byte[len];
                            int k = 0;
                            while (true) {
                                if (k >= len) {
                                    String appe;
                                    if (byteappe.length <= 12 || !(appe = new String(byteappe, 0, 5, "ISO-8859-1")).equals("Adobe")) break;
                                    this.invert = true;
                                    break;
                                }
                                byteappe[k] = (byte)is.read();
                                ++k;
                            }
                        }
                        firstPass = false;
                        markertype = Jpeg.marker(marker);
                        if (markertype != 0) break block24;
                        Jpeg.skip(is, 2);
                        if (is.read() != 8) {
                            throw new BadElementException(String.valueOf(errorID) + " must have 8 bits per component.");
                        }
                        this.scaledHeight = Jpeg.getShort(is);
                        this.setTop(this.scaledHeight);
                        this.scaledWidth = Jpeg.getShort(is);
                        this.setRight(this.scaledWidth);
                        this.colorspace = is.read();
                        this.bpc = 8;
                        break;
                    }
                    if (markertype == 1) {
                        throw new BadElementException(String.valueOf(errorID) + ": unsupported JPEG marker: " + marker);
                    }
                    if (markertype == 2) continue;
                    Jpeg.skip(is, Jpeg.getShort(is) - 2);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (is != null) {
                    is.close();
                }
                this.plainWidth = this.width();
                this.plainHeight = this.height();
                throw throwable;
            }
            {
                Object var13_17 = null;
                if (is == null) break block23;
            }
            is.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }
}

