/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.DuplicateColumnException;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.SQLType;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLColumn
extends SQLObject
implements Serializable {
    private static Logger logger = Logger.getLogger(SQLColumn.class);
    protected SQLColumn sourceColumn;
    protected SQLObject parent;
    protected int type;
    private String sourceDataTypeName;
    protected int precision;
    protected int scale;
    protected int nullable;
    protected String remarks = "";
    protected String defaultValue;
    protected Integer primaryKeySeq;
    protected boolean autoIncrement;
    protected int referenceCount;

    public SQLColumn() {
        logger.debug((Object)("NEW COLUMN (noargs) @" + this.hashCode()));
        this.setName("new column");
        this.type = 4;
        this.precision = 10;
        this.nullable = 0;
        this.autoIncrement = false;
        logger.debug((Object)"SQLColumn() set ref count to 1");
        this.referenceCount = 1;
        this.children = Collections.EMPTY_LIST;
    }

    public SQLColumn(SQLTable parentTable, String colName, int dataType, String nativeType, int precision, int scale, int nullable, String remarks, String defaultValue, Integer primaryKeySeq, boolean isAutoIncrement) {
        if (parentTable != null) {
            logger.debug((Object)("NEW COLUMN " + colName + "@" + this.hashCode() + " parent " + parentTable.getName() + "@" + parentTable.hashCode()));
        } else {
            logger.debug((Object)("NEW COLUMN " + colName + "@" + this.hashCode() + " (null parent)"));
        }
        if (parentTable != null) {
            this.parent = parentTable.getColumnsFolder();
        }
        this.setName(colName);
        this.type = dataType;
        this.sourceDataTypeName = nativeType;
        this.scale = scale;
        this.precision = precision;
        this.nullable = nullable;
        this.remarks = remarks;
        this.defaultValue = defaultValue;
        this.primaryKeySeq = primaryKeySeq;
        this.autoIncrement = isAutoIncrement;
        this.children = Collections.EMPTY_LIST;
        logger.debug((Object)"SQLColumn(.....) set ref count to 1");
        this.referenceCount = 1;
    }

    public SQLColumn(SQLTable parent, String colName, int type, int precision, int scale) {
        this(parent, colName, type, null, precision, scale, 1, null, null, null, false);
    }

    public SQLColumn(SQLColumn col) {
        this.children = Collections.EMPTY_LIST;
        SQLColumn.copyProperties(this, col);
        logger.debug((Object)("SQLColumn(SQLColumn col [" + col + " " + col.hashCode() + "]) set ref count to 1"));
        this.referenceCount = 1;
    }

    public static SQLColumn getDerivedInstance(SQLColumn source, SQLTable addTo) {
        logger.debug((Object)"derived instance SQLColumn constructor invocation.");
        SQLColumn c = new SQLColumn();
        SQLColumn.copyProperties(c, source);
        c.sourceColumn = source;
        c.parent = addTo.getColumnsFolder();
        logger.debug((Object)"getDerivedInstance set ref count to 1");
        c.referenceCount = 1;
        return c;
    }

    private static final void copyProperties(SQLColumn target, SQLColumn source) {
        target.setName(source.getName());
        target.type = source.type;
        target.sourceDataTypeName = source.sourceDataTypeName;
        target.setPhysicalName(source.getPhysicalName());
        target.precision = source.precision;
        target.scale = source.scale;
        target.nullable = source.nullable;
        target.remarks = source.remarks;
        target.defaultValue = source.defaultValue;
        target.primaryKeySeq = source.primaryKeySeq;
        target.autoIncrement = source.autoIncrement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addColumnsToTable(SQLTable addTo, String catalog, String schema, String tableName) throws SQLException, DuplicateColumnException, ArchitectException {
        Connection con = null;
        ResultSet rs = null;
        try {
            con = addTo.getParentDatabase().getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            logger.debug((Object)("SQLColumn.addColumnsToTable: catalog=" + catalog + "; schema=" + schema + "; tableName=" + tableName));
            rs = dbmd.getColumns(catalog, schema, tableName, "%");
            while (rs.next()) {
                logger.debug((Object)"addColumnsToTable SQLColumn constructor invocation.");
                SQLColumn col = new SQLColumn(addTo, rs.getString(4), rs.getInt(5), rs.getString(6), rs.getInt(7), rs.getInt(9), rs.getInt(11), rs.getString(12) == null ? "" : rs.getString(12), rs.getString(13), null, false);
                String dbTableName = rs.getString(3);
                if (dbTableName != null) {
                    if (!dbTableName.equalsIgnoreCase(tableName)) {
                        logger.warn((Object)("Got column " + col.getName() + " from " + dbTableName + " in metadata for " + tableName + "; not adding this column."));
                        continue;
                    }
                } else {
                    logger.warn((Object)"Table name not specified in metadata.  Continuing anyway...");
                }
                logger.debug((Object)("Adding column " + col.getName()));
                if (addTo.getColumnByName(col.getName(), false, true) != null) {
                    throw new DuplicateColumnException(addTo, col.getName());
                }
                addTo.columnsFolder.children.add(col);
            }
            rs.close();
            rs = null;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close result set", (Throwable)ex);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close connection", (Throwable)ex);
            }
        }
    }

    public String toString() {
        return this.getShortDisplayName();
    }

    @Override
    public void populate() throws ArchitectException {
    }

    @Override
    public boolean isPopulated() {
        return true;
    }

    @Override
    public String getShortDisplayName() {
        if (this.sourceDataTypeName != null) {
            if (this.precision > 0 && this.scale > 0) {
                return this.getName() + ": " + this.sourceDataTypeName + "(" + this.precision + "," + this.scale + ")";
            }
            if (this.precision > 0) {
                return this.getName() + ": " + this.sourceDataTypeName + "(" + this.precision + ")";
            }
            return this.getName() + ": " + this.sourceDataTypeName;
        }
        return this.getName() + ": " + SQLType.getTypeName(this.type) + "(" + this.precision + ")";
    }

    @Override
    public boolean allowsChildren() {
        return false;
    }

    @Override
    public SQLObject getParent() {
        return this.parent;
    }

    public SQLColumn getSourceColumn() {
        return this.sourceColumn;
    }

    public void setSourceColumn(SQLColumn col) {
        SQLColumn oldCol = this.sourceColumn;
        this.sourceColumn = col;
        this.fireDbObjectChanged("sourceColumn", oldCol, col);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int argType) {
        int oldType = this.type;
        this.type = argType;
        this.startCompoundEdit("Type change");
        this.setSourceDataTypeName(null);
        this.fireDbObjectChanged("type", oldType, argType);
        this.endCompoundEdit("Type change");
    }

    public String getSourceDataTypeName() {
        return this.sourceDataTypeName;
    }

    public void setSourceDataTypeName(String n) {
        String oldSourceDataTypeName = this.sourceDataTypeName;
        this.sourceDataTypeName = n;
        this.fireDbObjectChanged("sourceDataTypeName", oldSourceDataTypeName, n);
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int argScale) {
        int oldScale = this.scale;
        logger.debug((Object)("scale changed from " + this.scale + " to " + argScale));
        this.scale = argScale;
        this.fireDbObjectChanged("scale", oldScale, argScale);
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int argPrecision) {
        int oldPrecision = this.precision;
        this.precision = argPrecision;
        this.fireDbObjectChanged("precision", oldPrecision, argPrecision);
    }

    public boolean isDefinitelyNullable() {
        return this.nullable == 1;
    }

    public boolean isPrimaryKey() {
        return this.primaryKeySeq != null;
    }

    public SQLTable getParentTable() {
        if (this.parent == null) {
            return null;
        }
        return (SQLTable)this.parent.getParent();
    }

    @Override
    protected void setParent(SQLObject argParent) {
        SQLObject oldParent = this.parent;
        this.parent = argParent;
        this.fireDbObjectChanged("parent", oldParent, argParent);
    }

    public int getNullable() {
        return this.nullable;
    }

    public void setNullable(int argNullable) {
        int oldNullable = this.nullable;
        logger.debug((Object)("Changing nullable " + oldNullable + " -> " + argNullable));
        this.nullable = argNullable;
        this.fireDbObjectChanged("nullable", oldNullable, argNullable);
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String argRemarks) {
        String oldRemarks = this.remarks;
        this.remarks = argRemarks;
        this.fireDbObjectChanged("remarks", oldRemarks, argRemarks);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String argDefaultValue) {
        String oldDefaultValue = this.defaultValue;
        this.defaultValue = argDefaultValue;
        this.fireDbObjectChanged("defaultValue", oldDefaultValue, argDefaultValue);
    }

    public Integer getPrimaryKeySeq() {
        return this.primaryKeySeq;
    }

    public void setPrimaryKeySeq(Integer argPrimaryKeySeq) {
        if (this.primaryKeySeq == null && argPrimaryKeySeq == null || this.primaryKeySeq != null && this.primaryKeySeq.equals(argPrimaryKeySeq)) {
            return;
        }
        Integer oldPrimaryKeySeq = this.primaryKeySeq;
        if (!this.isMagicEnabled()) {
            if (argPrimaryKeySeq != null && !this.autoIncrement) {
                this.setNullable(0);
            }
            this.primaryKeySeq = argPrimaryKeySeq;
            this.fireDbObjectChanged("primaryKeySeq", oldPrimaryKeySeq, argPrimaryKeySeq);
        } else {
            try {
                this.startCompoundEdit("Starting PrimaryKeySeq compound edit");
                if (argPrimaryKeySeq != null && !this.autoIncrement) {
                    this.setNullable(0);
                }
                this.primaryKeySeq = argPrimaryKeySeq;
                this.fireDbObjectChanged("primaryKeySeq", oldPrimaryKeySeq, argPrimaryKeySeq);
                SQLObject p = this.parent;
                if (p != null) {
                    p.removeChild(this);
                    int idx = 0;
                    int targetPKS = this.primaryKeySeq == null ? Integer.MAX_VALUE : this.primaryKeySeq;
                    logger.debug((Object)("Parent = " + p));
                    logger.debug((Object)("Parent.children = " + p.children));
                    for (SQLColumn col : p.children) {
                        if (col.getPrimaryKeySeq() == null || col.getPrimaryKeySeq() > targetPKS) {
                            logger.debug((Object)("idx is " + idx));
                            break;
                        }
                        ++idx;
                    }
                    p.addChild(idx, this);
                    this.getParentTable().normalizePrimaryKey();
                }
            }
            catch (ArchitectException e) {
                throw new ArchitectRuntimeException(e);
            }
            finally {
                this.endCompoundEdit("Ending PrimaryKeySeq compound edit");
            }
        }
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean argAutoIncrement) {
        boolean oldAutoIncrement = this.autoIncrement;
        this.autoIncrement = argAutoIncrement;
        this.fireDbObjectChanged("autoIncrement", oldAutoIncrement, argAutoIncrement);
    }

    public void addReference() {
        int oldReference = this.referenceCount++;
        logger.debug((Object)("incremented reference count to: " + this.referenceCount));
        this.fireDbObjectChanged("referenceCount", oldReference, this.referenceCount);
    }

    public void removeReference() {
        if (logger.isDebugEnabled()) {
            String parentName = "<no parent table>";
            if (this.getParent() != null && this.getParentTable() != null) {
                parentName = this.getParentTable().getName();
            }
            logger.debug((Object)("Trying to remove reference from " + parentName + "." + this.getName() + " " + this.hashCode()));
        }
        if (this.referenceCount == 0) {
            logger.debug((Object)("Reference count of " + this.getParentTable() + "." + this + " was already 0"));
            throw new IllegalStateException("Reference count of is already 0; can't remove any references!");
        }
        int oldReference = this.referenceCount--;
        logger.debug((Object)("decremented reference count to: " + this.referenceCount));
        if (this.referenceCount == 0) {
            if (this.getParent() != null) {
                logger.debug((Object)"reference count is 0, deleting column from parent.");
                this.getParent().removeChild(this);
            } else {
                logger.debug((Object)"Already removed from parent");
            }
        }
        this.fireDbObjectChanged("referenceCount", oldReference, this.referenceCount);
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    @Deprecated
    public void setReferenceCount(int referenceCount) {
        this.referenceCount = referenceCount;
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        return null;
    }

    public static class CompareByPKSeq
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SQLColumn c1 = (SQLColumn)o1;
            SQLColumn c2 = (SQLColumn)o2;
            if (c1.primaryKeySeq == null && c2.primaryKeySeq == null) {
                return 0;
            }
            if (c1.primaryKeySeq == null && c2.primaryKeySeq != null) {
                return 1;
            }
            if (c1.primaryKeySeq != null && c2.primaryKeySeq == null) {
                return -1;
            }
            return c1.primaryKeySeq - c2.primaryKeySeq;
        }
    }

    public static class ColumnNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return this.compare((SQLColumn)o1, (SQLColumn)o2);
        }

        public int compare(SQLColumn c1, SQLColumn c2) {
            return c1.getName().compareTo(c2.getName());
        }
    }
}

