/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.profile.AbstractProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.TableProfileResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnProfileResult
extends AbstractProfileResult<SQLColumn> {
    private static final Logger logger = Logger.getLogger(ColumnProfileResult.class);
    private int distinctValueCount;
    private Object minValue;
    private Object maxValue;
    private Object avgValue;
    private int minLength;
    private int maxLength;
    private double avgLength;
    private int nullCount;
    private List<ColumnValueCount> topTen = new ArrayList<ColumnValueCount>();
    private ProfileManager manager;
    private DDLGenerator ddlg;
    private final TableProfileResult parentResult;

    public ColumnProfileResult(SQLColumn profiledObject, ProfileManager manager, DDLGenerator ddlg, TableProfileResult parentResult) {
        super(profiledObject);
        this.manager = manager;
        this.ddlg = ddlg;
        this.parentResult = parentResult;
    }

    public ColumnProfileResult(SQLColumn profiledObject, TableProfileResult parentResult) {
        super(profiledObject);
        this.parentResult = parentResult;
    }

    public double getAvgLength() {
        return this.avgLength;
    }

    public void setAvgLength(double avgLength) {
        this.avgLength = avgLength;
    }

    public Object getAvgValue() {
        return this.avgValue;
    }

    public void setAvgValue(Object avgValue) {
        this.avgValue = avgValue;
    }

    public int getDistinctValueCount() {
        return this.distinctValueCount;
    }

    public void setDistinctValueCount(int distinctValueCount) {
        this.distinctValueCount = distinctValueCount;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Object minValue) {
        this.minValue = minValue;
    }

    public String toString() {
        return "[ColumnProfileResult:; distinctValues: " + this.distinctValueCount + "; minLength: " + this.minLength + "; maxLength: " + this.maxLength + "; avgLength: " + this.avgLength + "; minValue: " + this.getMinValue() + "; maxValue: " + this.getMaxValue() + "; avgValue: " + this.avgValue + "; nullCount: " + this.getNullCount() + "]";
    }

    public int getNullCount() {
        return this.nullCount;
    }

    public void setNullCount(int nullCount) {
        this.nullCount = nullCount;
    }

    public void addValueCount(Object value, int count) {
        this.topTen.add(new ColumnValueCount(value, count));
    }

    public void addValueCount(ColumnValueCount value) {
        this.topTen.add(value);
    }

    public List<ColumnValueCount> getValueCount() {
        return this.topTen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProfile() throws SQLException, ArchitectException {
        if (this.parentResult.isCancelled()) {
            return;
        }
        if (this.manager == null || this.ddlg == null) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String lastSQL = null;
        try {
            SQLColumn col = (SQLColumn)this.getProfiledObject();
            SQLDatabase db = col.getParentTable().getParentDatabase();
            conn = db.getConnection();
            stmt = conn.createStatement();
            stmt.setEscapeProcessing(false);
            ProfileFunctionDescriptor pfd = this.ddlg.getProfileFunctionMap().get(col.getSourceDataTypeName());
            long profileStartTime = System.currentTimeMillis();
            if (pfd == null) {
                logger.debug((Object)(col.getName() + " Unknown DataType:(" + col.getSourceDataTypeName() + ")."));
                pfd = this.discoverProfileFunctionDescriptor(col, this.ddlg, conn);
            }
            try {
                this.execProfileFunction(pfd, col, this.ddlg, conn);
            }
            catch (Exception ex) {
                this.setCreateStartTime(profileStartTime);
                this.setException(ex);
                this.setCreateEndTime(System.currentTimeMillis());
                logger.error((Object)("Error in Column Profiling: " + lastSQL), (Throwable)ex);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up result set", (Throwable)ex);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up statement", (Throwable)ex);
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private ProfileFunctionDescriptor discoverProfileFunctionDescriptor(SQLColumn col, DDLGenerator ddlg, Connection conn) {
        ProfileFunctionDescriptor pfd = new ProfileFunctionDescriptor(col.getSourceDataTypeName(), col.getType(), false, false, false, false, false, false, false, false);
        logger.debug((Object)("Discovering profile functions for column " + col));
        try {
            pfd.setCountDist(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"countDist worked");
        }
        catch (Exception e) {
            logger.debug((Object)"countDist failed", (Throwable)e);
            pfd.setCountDist(false);
        }
        try {
            pfd.setMaxValue(true);
            pfd.setMinValue(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"min/max worked");
        }
        catch (Exception e) {
            logger.debug((Object)"min/max failed", (Throwable)e);
            pfd.setMaxValue(false);
            pfd.setMinValue(false);
        }
        try {
            pfd.setAvgValue(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"avg worked");
        }
        catch (Exception e) {
            logger.debug((Object)"avg failed", (Throwable)e);
            pfd.setAvgValue(false);
        }
        try {
            pfd.setMaxLength(true);
            pfd.setMinLength(true);
            pfd.setAvgLength(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"min/max/avg length worked");
        }
        catch (Exception e) {
            logger.debug((Object)"min/max/avg length failed", (Throwable)e);
            pfd.setMaxLength(false);
            pfd.setMinLength(false);
            pfd.setAvgLength(false);
        }
        try {
            pfd.setSumDecode(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"sumDecode worked");
        }
        catch (Exception e) {
            logger.debug((Object)"sumDecode failed", (Throwable)e);
            pfd.setSumDecode(false);
        }
        return pfd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execProfileFunction(ProfileFunctionDescriptor pfd, SQLColumn col, DDLGenerator ddlg, Connection conn) throws SQLException {
        long createStartTime = System.currentTimeMillis();
        boolean i = false;
        StringBuffer sql = new StringBuffer();
        Statement stmt = null;
        ResultSet rs = null;
        String lastSQL = null;
        String columnName = null;
        String databaseIdentifierQuoteString = null;
        this.setCreateStartTime(createStartTime);
        SQLTable table = col.getParentTable();
        try {
            databaseIdentifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
            sql.append("SELECT 1");
            int tryCount = 0;
            if (this.manager.getProfileSettings().isFindingDistinctCount() && pfd.isCountDist()) {
                sql.append(",\n COUNT(DISTINCT ");
                sql.append(databaseIdentifierQuoteString);
                sql.append(col.getName());
                sql.append(databaseIdentifierQuoteString);
                sql.append(") AS DISTINCTCOUNT_0");
                ++tryCount;
            }
            if (this.manager.getProfileSettings().isFindingMin() && pfd.isMinValue()) {
                sql.append(",\n MIN(");
                sql.append(databaseIdentifierQuoteString);
                sql.append(col.getName());
                sql.append(databaseIdentifierQuoteString);
                sql.append(") AS MINVALUE_0");
                ++tryCount;
            }
            if (this.manager.getProfileSettings().isFindingMax() && pfd.isMaxValue()) {
                sql.append(",\n MAX(");
                sql.append(databaseIdentifierQuoteString);
                sql.append(col.getName());
                sql.append(databaseIdentifierQuoteString);
                sql.append(") AS MAXVALUE_0");
                ++tryCount;
            }
            if (this.manager.getProfileSettings().isFindingAvg() && pfd.isAvgValue()) {
                sql.append(",\n ");
                sql.append(ddlg.getAverageSQLFunctionName(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString));
                sql.append(" AS AVGVALUE_0");
                ++tryCount;
            }
            if (this.manager.getProfileSettings().isFindingMinLength() && pfd.isMinLength()) {
                sql.append(",\n MIN(");
                sql.append(ddlg.getStringLengthSQLFunctionName(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString));
                sql.append(") AS MINLENGTH_0");
                ++tryCount;
            }
            if (this.manager.getProfileSettings().isFindingMaxLength() && pfd.isMaxLength()) {
                sql.append(",\n MAX(");
                sql.append(ddlg.getStringLengthSQLFunctionName(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString));
                sql.append(") AS MAXLENGTH_0");
                ++tryCount;
            }
            if (this.manager.getProfileSettings().isFindingAvgLength() && pfd.isAvgLength()) {
                sql.append(",\n AVG(");
                sql.append(ddlg.getStringLengthSQLFunctionName(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString));
                sql.append(") AS AVGLENGTH_0");
                ++tryCount;
            }
            if (this.manager.getProfileSettings().isFindingNullCount() && pfd.isSumDecode()) {
                sql.append(",\n SUM(");
                sql.append(ddlg.caseWhenNull(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString, "1"));
                sql.append(") AS NULLCOUNT_0");
                ++tryCount;
            }
            if (tryCount > 0) {
                sql.append("\n FROM ");
                sql.append(DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName(), databaseIdentifierQuoteString, databaseIdentifierQuoteString));
                stmt = conn.createStatement();
                stmt.setEscapeProcessing(false);
                lastSQL = sql.toString();
                rs = stmt.executeQuery(lastSQL);
                if (rs.next()) {
                    if (this.manager.getProfileSettings().isFindingDistinctCount() && pfd.isCountDist()) {
                        columnName = "DISTINCTCOUNT_0";
                        this.setDistinctValueCount(rs.getInt(columnName));
                    }
                    if (this.manager.getProfileSettings().isFindingMin() && pfd.isMinValue()) {
                        columnName = "MINVALUE_0";
                        this.setMinValue(rs.getObject(columnName));
                    }
                    if (this.manager.getProfileSettings().isFindingMax() && pfd.isMaxValue()) {
                        columnName = "MAXVALUE_0";
                        this.setMaxValue(rs.getObject(columnName));
                    }
                    if (this.manager.getProfileSettings().isFindingAvg() && pfd.isAvgValue()) {
                        columnName = "AVGVALUE_0";
                        this.setAvgValue(rs.getObject(columnName));
                    }
                    if (this.manager.getProfileSettings().isFindingMinLength() && pfd.isMinLength()) {
                        columnName = "MINLENGTH_0";
                        this.setMinLength(rs.getInt(columnName));
                    }
                    if (this.manager.getProfileSettings().isFindingMaxLength() && pfd.isMaxLength()) {
                        columnName = "MAXLENGTH_0";
                        this.setMaxLength(rs.getInt(columnName));
                    }
                    if (this.manager.getProfileSettings().isFindingAvgLength() && pfd.isAvgLength()) {
                        columnName = "AVGLENGTH_0";
                        this.setAvgLength(rs.getDouble(columnName));
                    }
                    if (this.manager.getProfileSettings().isFindingNullCount() && pfd.isSumDecode()) {
                        columnName = "NULLCOUNT_0";
                        this.setNullCount(rs.getInt(columnName));
                    }
                } else {
                    throw new IllegalStateException("Query executed, but returns no rows:\n" + lastSQL + "\nColumn Name: " + columnName);
                }
                rs.close();
                rs = null;
            }
            if (this.manager.getProfileSettings().isFindingTopTen() && pfd.isCountDist()) {
                sql = new StringBuffer();
                sql.append("SELECT ").append(databaseIdentifierQuoteString);
                sql.append(col.getName()).append(databaseIdentifierQuoteString);
                sql.append(" AS MYVALUE, COUNT(*) AS COUNT1 FROM ");
                sql.append(DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName(), databaseIdentifierQuoteString, databaseIdentifierQuoteString));
                sql.append(" GROUP BY ").append(databaseIdentifierQuoteString);
                sql.append(col.getName()).append(databaseIdentifierQuoteString);
                sql.append(" ORDER BY COUNT1 DESC");
                lastSQL = sql.toString();
                rs = stmt.executeQuery(lastSQL);
                int topNCount = 10;
                for (int n = 0; rs.next() && n < topNCount; ++n) {
                    this.addValueCount(rs.getObject("MYVALUE"), rs.getInt("COUNT1"));
                }
                rs.close();
                rs = null;
            }
            this.setCreateEndTime(System.currentTimeMillis());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up result set", (Throwable)ex);
            }
        }
    }

    public TableProfileResult getParentResult() {
        return this.parentResult;
    }
}

