/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.SwingUIProject;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ProjectSettingsPanel
extends JPanel
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(ProjectSettingsPanel.class);
    private SwingUIProject proj;
    private JCheckBox saveEntireSource;
    private JCheckBox clearProfile;
    private JTextField numberOfFreqValue;

    public ProjectSettingsPanel(SwingUIProject proj) {
        this.proj = proj;
        this.setup();
        this.revertToProjectSettings();
    }

    public void setup() {
        this.setLayout(new FormLayout());
        this.add(new JLabel("Snapshot entire source database in project file?"));
        this.saveEntireSource = new JCheckBox();
        this.add(this.saveEntireSource);
        this.add(new JLabel("Don't save Profile results in the project?"));
        this.clearProfile = new JCheckBox();
        this.add(this.clearProfile);
        this.clearProfile.setToolTipText("Warning: this only removes current profiles");
        this.add(new JLabel("Number of Most Frequent Value in Profile:"));
        this.numberOfFreqValue = new JTextField(String.valueOf(this.proj.getProfileManager().getProfileSettings().getTopNCount()), 6);
        this.add(this.numberOfFreqValue);
    }

    protected void revertToProjectSettings() {
        logger.debug((Object)"Reverting project options");
        this.saveEntireSource.setSelected(this.proj.isSavingEntireSource());
    }

    public boolean applyChanges() {
        logger.debug((Object)("Setting snapshot option to:" + this.saveEntireSource.isSelected()));
        this.proj.setSavingEntireSource(this.saveEntireSource.isSelected());
        logger.debug((Object)("Project " + this.proj.getName() + " snapshot option is:" + this.proj.isSavingEntireSource()));
        if (this.clearProfile.isSelected()) {
            this.proj.getProfileManager().clear();
        }
        if (this.numberOfFreqValue.getText().length() > 0) {
            try {
                this.proj.getProfileManager().getProfileSettings().setTopNCount(Integer.valueOf(this.numberOfFreqValue.getText()));
            }
            catch (NumberFormatException e) {
                ASUtils.showExceptionDialogNoReport(this, "Number Format Error", e);
            }
        }
        return true;
    }

    public void discardChanges() {
    }

    public JPanel getPanel() {
        return this;
    }
}

