/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileCSVFormat;
import ca.sqlpower.architect.profile.ProfileFormat;
import ca.sqlpower.architect.profile.ProfileHTMLFormat;
import ca.sqlpower.architect.profile.ProfilePDFFormat;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileManager;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.table.ProfileJTable;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SaveProfileAction
extends AbstractAction {
    private JDialog parent;
    private ProfileJTable viewTable;

    public SaveProfileAction(JDialog parent, ProfileJTable viewTable, TableProfileManager pm) {
        super("Save...");
        this.parent = parent;
        this.viewTable = viewTable;
    }

    public void actionPerformed(ActionEvent e) {
        SaveableFileType type;
        int response;
        final ProfileResultsTree objectToSave = new ProfileResultsTree();
        if (this.viewTable.getSelectedRowCount() > 1) {
            int[] selectedRows = this.viewTable.getSelectedRows();
            HashSet<TableProfileResult> selectedTable = new HashSet<TableProfileResult>();
            HashSet<ColumnProfileResult> selectedColumn = new HashSet<ColumnProfileResult>();
            for (int i = 0; i < selectedRows.length; ++i) {
                int rowid = selectedRows[i];
                ColumnProfileResult result = this.viewTable.getColumnProfileResultForRow(rowid);
                selectedTable.add(result.getParentResult());
                selectedColumn.add(result);
            }
            boolean fullSelection = true;
            block3: for (TableProfileResult tpr : selectedTable) {
                for (ColumnProfileResult cpr : tpr.getColumnProfileResults()) {
                    if (selectedColumn.contains(cpr)) continue;
                    fullSelection = false;
                    continue block3;
                }
            }
            int response2 = 0;
            if (!fullSelection) {
                response2 = JOptionPane.showOptionDialog(this.parent, "You have selected only part of a table.\nDo you want to save only this portion?", "Your selection contains partial table(s)", 0, 3, null, new String[]{"Save Partial", "Save Entire Table"}, "Save Entire Table");
            }
            if (response2 == 1) {
                for (TableProfileResult tpr : selectedTable) {
                    for (ColumnProfileResult cpr : tpr.getColumnProfileResults()) {
                        objectToSave.addColumnProfileResult(cpr);
                    }
                }
            } else {
                for (int i = 0; i < selectedRows.length; ++i) {
                    int rowid = selectedRows[i];
                    ColumnProfileResult result = this.viewTable.getColumnProfileResultForRow(rowid);
                    objectToSave.addColumnProfileResult(result);
                }
            }
        } else {
            for (int i = 0; i < this.viewTable.getRowCount(); ++i) {
                ColumnProfileResult result = this.viewTable.getColumnProfileResultForRow(i);
                objectToSave.addColumnProfileResult(result);
            }
        }
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(ASUtils.HTML_FILE_FILTER);
        chooser.addChoosableFileFilter(ASUtils.PDF_FILE_FILTER);
        chooser.addChoosableFileFilter(ASUtils.CSV_FILE_FILTER);
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        File file = null;
        do {
            if ((response = chooser.showSaveDialog(this.parent)) != 0) {
                return;
            }
            file = chooser.getSelectedFile();
            FileFilter fileFilter = chooser.getFileFilter();
            String fileName = file.getName();
            int x = fileName.lastIndexOf(46);
            boolean gotType = false;
            SaveableFileType ntype = null;
            if (x != -1) {
                String ext = fileName.substring(x + 1);
                try {
                    ntype = SaveableFileType.valueOf(ext.toUpperCase());
                    gotType = true;
                }
                catch (IllegalArgumentException iex) {
                    gotType = false;
                }
            }
            if (gotType) {
                type = ntype;
                continue;
            }
            if (fileFilter == ASUtils.HTML_FILE_FILTER) {
                if (!fileName.endsWith(".html")) {
                    file = new File(file.getPath() + ".html");
                }
                type = SaveableFileType.HTML;
                continue;
            }
            if (fileFilter == ASUtils.PDF_FILE_FILTER) {
                if (!fileName.endsWith(".pdf")) {
                    file = new File(file.getPath() + ".pdf");
                }
                type = SaveableFileType.PDF;
                continue;
            }
            if (fileFilter == ASUtils.CSV_FILE_FILTER) {
                if (!fileName.endsWith(".csv")) {
                    file = new File(file.getPath() + ".csv");
                }
                type = SaveableFileType.CSV;
                continue;
            }
            throw new IllegalStateException("Unexpected file filter chosen");
        } while (file.exists() && (response = JOptionPane.showConfirmDialog(this.parent, "The file\n" + file.getPath() + "\nalready exists. Do you want to overwrite it?", "File Exists", 0)) == 1);
        final File file2 = new File(file.getPath());
        final SaveableFileType type2 = type;
        Runnable saveTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                OutputStream out = null;
                try {
                    ProfileFormat prf = null;
                    out = new BufferedOutputStream(new FileOutputStream(file2));
                    switch (type2) {
                        case HTML: {
                            String encoding = "utf-8";
                            prf = new ProfileHTMLFormat("utf-8");
                            break;
                        }
                        case PDF: {
                            prf = new ProfilePDFFormat();
                            break;
                        }
                        case CSV: {
                            prf = new ProfileCSVFormat();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown type");
                        }
                    }
                    prf.format(out, objectToSave.getDepthFirstList());
                }
                catch (Exception ex) {
                    ASUtils.showExceptionDialog(SaveProfileAction.this.parent, "Could not generate/save report file", ex, new ArchitectExceptionReportFactory());
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        }
                        catch (IOException ex) {
                            ASUtils.showExceptionDialog(SaveProfileAction.this.parent, "Could not close report file", ex, new ArchitectExceptionReportFactory());
                        }
                    }
                }
            }
        };
        new Thread(saveTask).start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SaveableFileType {
        HTML,
        PDF,
        CSV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProfileResultsTree {
        Map<TableProfileResult, Set<ColumnProfileResult>> resultTree = new TreeMap<TableProfileResult, Set<ColumnProfileResult>>();

        public void addTableProfileResult(TableProfileResult tpr) {
            if (!this.resultTree.containsKey(tpr)) {
                this.resultTree.put(tpr, new HashSet());
            }
        }

        public void addColumnProfileResult(ColumnProfileResult cpr) {
            TableProfileResult tpr = cpr.getParentResult();
            if (!this.resultTree.containsKey(tpr)) {
                this.resultTree.put(tpr, new TreeSet());
            }
            this.resultTree.get(tpr).add(cpr);
        }

        public List<ProfileResult> getDepthFirstList() {
            ArrayList<ProfileResult> depthFirstList = new ArrayList<ProfileResult>();
            for (TableProfileResult tpr : this.resultTree.keySet()) {
                depthFirstList.add(tpr);
                for (ColumnProfileResult cpr : this.resultTree.get(tpr)) {
                    depthFirstList.add(cpr);
                }
            }
            return depthFirstList;
        }
    }
}

